# Static Code Analysis

## PHPStan

ILIAS uses [`PHPStan`](https://phpstan.org) as an optional tool for developers
to find errors in the ILIAS code base without actually running it.

### Configuration

To provide a common configuration a shared config file is located in
[`./CI/PHPStan/phpstan.neon`](../../CI/PHPStan/phpstan.neon).

`PHPStan` provides the possibility to analyse the code based on specfic
[rule levels](https://phpstan.org/user-guide/rule-levels).
The level used in ILIAS is **level 6**, which includes the reporting of missing typehints.
To prevent `False Positives` beingt reported related to global constants, developers can extend the constant collection
defined in the [`constants.php`](../../CI/PHPStan/constants.php)

### Analysis

To run `PHPStan` you just need to execute the bash script:

```bash
./CI/PHPStan/run_check.sh
```

To run `PHPStan` in the context of a specific component, pass the respective folder name as argument:

```bash
./CI/PHPStan/run_check.sh Services/Mail
```

You can overwrite the rule level by passing a `--level` argument:

```bash
./CI/PHPStan/run_check.sh Services/Mail --level 3
```

### Custom Configuration File

A custom configuration file could be provided by adding a file named `phpstan.local.neon` to the ILIAS root directory.
The filename is ignored by the `.gitignore` file and ILIAS `\RootFolderTest`, which ensures no new files are added
to the root level of ILIAS.

Example:

```yaml
includes:
    - CI/PHPStan/phpstan.neon
parameters:
    level: 9
```

In this example the shared `PHPStan` configuration is extended by the local configuration, where we defined `stricter`
rule level.

### Baseline

A [baseline file](https://phpstan.org/user-guide/baseline) can be generated by using the `--generate-baseline` option.

```bash
/CI/PHPStan/run_check.sh -c phpstan.local.neon Services/Mail --generate-baseline
```

The generated baseline file `phpstan-baseline.neon` will be stored in the ILIAS root folder and must be included in the
local `phpstan.local.neon` configuration.

```yaml
includes:
    - CI/PHPStan/phpstan.neon
    - phpstan-baseline.neon
parameters:
    level: 9
```

If you analyse different components/folders with `PHPStan`, you will need to generate a new baseline file.

### IDE Integration

#### PHPStorm

See: https://www.jetbrains.com/help/phpstorm/using-phpstan.html