"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toSafe = toSafe;
exports.wrapGenerator = wrapGenerator;

var _primordials = require("./primordials.cjs");

function toSafe(array) {
  if (array[_primordials.SymbolIterator] === _primordials.NativeArrayPrototypeSymbolIterator) {
    return array;
  }

  const arrayIterator = (0, _primordials.ArrayPrototypeSymbolIterator)(array);
  return (0, _primordials.ObjectCreate)(null, {
    next: {
      value: function next() {
        return (0, _primordials.ArrayIteratorPrototypeNext)(arrayIterator);
      }
    },
    [_primordials.SymbolIterator]: {
      value: function values() {
        return this;
      }
    }
  });
}

const generators = new _primordials.NativeWeakMap();
const DummyArrayIteratorPrototype = (0, _primordials.ObjectCreate)(_primordials.IteratorPrototype, {
  next: {
    value: function next() {
      const generator = (0, _primordials.WeakMapPrototypeGet)(generators, this);
      return (0, _primordials.GeneratorPrototypeNext)(generator);
    },
    writable: true,
    configurable: true
  },
  [_primordials.SymbolToStringTag]: {
    value: "Array Iterator",
    configurable: true
  }
});

function wrapGenerator(generator) {
  const dummy = (0, _primordials.ObjectCreate)(DummyArrayIteratorPrototype);
  (0, _primordials.WeakMapPrototypeSet)(generators, dummy, generator);
  return dummy;
}