<?php

declare(strict_types=1);

/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 *
 *********************************************************************/

namespace ILIAS\UI\Component\Symbol\Avatar;

use ILIAS\UI\Component\Symbol\Symbol;

/**
 * This describes how a letter or a picture avatar could be modified during construction of UI.
 */
interface Avatar extends Symbol
{
    public function getUsername(): string;

    public function withLabel(string $text): Avatar;
}
