<?php

/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 *
 *********************************************************************/

use ILIAS\GlobalScreen\Scope\Notification\NotificationServices;
use ILIAS\GlobalScreen\Scope\Notification\Factory\NotificationFactory;
use PHPUnit\Framework\TestCase;

require_once('./vendor/composer/vendor/autoload.php');

/**
 * Class NotificationFactoryTest
 */
class NotificationServicesTest extends TestCase
{
    public function testFactory(): void
    {
        $factory = new NotificationServices();
        $this->assertInstanceOf(NotificationFactory::class, $factory->factory());
    }
}
