<?php

/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 *
 *********************************************************************/

/**
 * Exporter class for html learning modules
 * @author Alexander Killing <killing@leifos.de>
 */
class ilHTMLLearningModuleExporter extends ilXmlExporter
{
    private ilHTMLLearningModuleDataSet $ds;

    public function init(): void
    {
        $this->ds = new ilHTMLLearningModuleDataSet();
        $this->ds->initByExporter($this);
        $this->ds->setDSPrefix("ds");
    }

    public function getXmlExportTailDependencies(string $a_entity, string $a_target_release, array $a_ids): array
    {
        $deps = [];
        $md_ids = [];
        foreach ($a_ids as $id) {
            $md_ids[] = $id . ":0:htlm";
        }

        $deps[] = [
            "component" => "components/ILIAS/MetaData",
            "entity" => "md",
            "ids" => $md_ids
        ];

        // service settings
        $deps[] = [
            "component" => "components/ILIAS/ILIASObject",
            "entity" => "common",
            "ids" => $a_ids
        ];

        return $deps;
    }

    public function getXmlRepresentation(string $a_entity, string $a_schema_version, string $a_id): string
    {
        $this->ds->initByExporter($this);
        return $this->ds->getXmlRepresentation($a_entity, $a_schema_version, [$a_id], "", true, true);
    }

    public function getValidSchemaVersions(string $a_entity): array
    {
        return array(
            "4.1.0" => array(
                "namespace" => "https://www.ilias.de/Modules/HTMLLearningModule/htlm/4_1",
                "xsd_file" => "ilias_htlm_4_1.xsd",
                "uses_dataset" => true,
                "min" => "4.1.0",
                "max" => "")
        );
    }
}
