<?php

/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 *
 *********************************************************************/

declare(strict_types=1);

namespace ILIAS\StaticURL\Handler;

use ILIAS\StaticURL\Request\Request;
use ILIAS\StaticURL\Context;
use ILIAS\StaticURL\Response\Factory;
use ILIAS\StaticURL\Response\Response;

/**
 * @author      Fabian Schmid <fabian@sr.solutions>
 * @deprecated  since ILIAS 9. Use StaticURL service instead. Will be removed with ILIAS 11
 * @internal
 */
class LegacyGotoHandler implements Handler
{
    public function __construct()
    {
    }

    public const NAMESPACE = 'goto';
    public const TARGET = 'target';

    public function getNamespace(): string
    {
        return self::NAMESPACE;
    }

    public function canHandle(Request $request): bool
    {
        return true;
    }

    /**
     * @deprecated since ILIAS 9. Use StaticURL service instead. Will be removed with ILIAS 11
     *             This Method does not return a proper Repsonse to the Request, it just redirects like the original goto.php.
     */
    public function handle(Request $request, Context $context, Factory $response_factory): Response
    {
        global $DIC, $ilPluginAdmin;

        $orig_target = $requested_target = $request->getAdditionalParameters()[self::TARGET] ?? '';
        $context->ctrl()->setTargetScript('ilias.php');

        // THIS PARTS HAS BEEN MOVED FROM THE OLD goto.php
        // DO NOT CHANGE ANYTHING HERE, IF YOU NEED TO CHANGE SOMETHING, IMPLEMENT A NEW HANDLER!

        // user interface plugin slot hook
        if (is_object($ilPluginAdmin)) {
            // search
            foreach ($DIC["component.factory"]->getActivePluginsInSlot("uihk") as $ui_plugin) {
                $gui_class = $ui_plugin->getUIClassInstance();
                $gui_class->gotoHook();
            }
        }

        $r_pos = strpos($requested_target, "_");
        $rest = substr($requested_target, $r_pos + 1);
        $target_arr = explode("_", $requested_target);
        $target_type = $target_arr[0];
        $target_id = $target_arr[1] ?? ''; // optional for plugins
        $additional = $target_arr[2] ?? '';        // optional for pages

        // imprint has no ref id...
        if ($target_type === "impr") {
            $DIC->ctrl()->redirectToURL('ilias.php?baseClass=ilImprintGUI');
        }

        // goto is not granted?
        $user_id = $context->getUserId();
        if (php_sapi_name() !== 'cli' && !\ilStartUpGUI::_checkGoto(
            $requested_target
        )) { // we cannot perform this in UnitTest e.g.
            // if anonymous: go to login page
            if ($user_id === 0 || $user_id === \ANONYMOUS_USER_ID) {
                $url = "login.php?target="
                    . $orig_target . "&cmd=force_login&lang="
                    . $DIC->user()->getCurrentLanguage();
                if ($DIC->http()->wrapper()->query()->has('soap_pw')) {
                    $url = \ilUtil::appendUrlParameterString(
                        $url,
                        'soap_pw=' . $DIC->http()->wrapper()->query()->retrieve(
                            'soap_pw',
                            $DIC->refinery()->kindlyTo()->string()
                        )
                    );
                }
                if ($DIC->http()->wrapper()->query()->has('ext_uid')) {
                    $url = \ilUtil::appendUrlParameterString(
                        $url,
                        'ext_uid=' . $DIC->http()->wrapper()->query()->retrieve(
                            'ext_uid',
                            $DIC->refinery()->kindlyTo()->string()
                        )
                    );
                }
                $DIC->ctrl()->redirectToURL($url);
            } else {
                // message if target given but not accessible
                $tarr = explode("_", $requested_target);
                if ($tarr[0] !== "pg" && $tarr[0] !== "st" && isset($tarr[1]) && is_numeric($tarr[1]) && $tarr[1] > 0) {
                    $DIC->ui()->mainTemplate()->setOnScreenMessage(
                        'failure',
                        sprintf(
                            $DIC->language()->txt("msg_no_perm_read_item"),
                            \ilObject::_lookupTitle(\ilObject::_lookupObjId((int) $tarr[1]))
                        ),
                        true
                    );
                } else {
                    global $DIC;
                    $DIC->ui()->mainTemplate()->setOnScreenMessage(
                        'failure',
                        $DIC->language()->txt('permission_denied'),
                        true
                    );
                }
                $DIC->ctrl()->redirectToURL(\ilUserUtil::getStartingPointAsUrl());
            }
        }

        // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        //
        //               FOR NEW OBJECT TYPES:
        //       PLEASE USE DEFAULT IMPLEMENTATION ONLY
        //
        // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

        switch ($target_type) {
            // exception, must be kept for now
            case "pg":
                \ilLMPageObjectGUI::_goto($rest);
                break;

                // exception, must be kept for now
            case "st":
                \ilStructureObjectGUI::_goto($target_id, (int) $additional);
                break;

                // exception, must be kept for now
            case "git":
                $target_ref_id = $target_arr[2] ?? 0;
                \ilGlossaryTermGUI::_goto($target_id, (int) $target_ref_id);
                break;

                // please migrate to default branch implementation
            case "glo":
                \ilObjGlossaryGUI::_goto($target_id);
                break;

                // please migrate to default branch implementation
            case "lm":
                \ilObjContentObjectGUI::_goto($target_id);
                break;

                // please migrate to default branch implementation
            case "htlm":
                \ilObjFileBasedLMGUI::_goto($target_id);
                break;

                // please migrate to default branch implementation
            case "frm":
                $target_thread = $target_arr[2] ?? 0;
                $target_posting = $target_arr[3] ?? 0;
                \ilObjForumGUI::_goto($target_id, $target_thread, $target_posting);
                break;

                // please migrate to default branch implementation
            case "exc":
                \ilObjExerciseGUI::_goto($target_id, $rest);
                break;

                // please migrate to default branch implementation
            case "tst":
                \ilObjTestGUI::_goto($target_id);
                break;

                // please migrate to default branch implementation
            case "qpl":
                \ilObjQuestionPoolGUI::_goto($target_id);
                break;

                // please migrate to default branch implementation
            case "webr":
                \ilObjLinkResourceGUI::_goto($target_id, $rest);
                break;

                // please migrate to default branch implementation
            case "sahs":
                \ilObjSAHSLearningModuleGUI::_goto($target_id);
                break;

                // please migrate to default branch implementation
            case "crs":
                \ilObjCourseGUI::_goto($target_id, $additional);
                break;

                // please migrate to default branch implementation
            case "grp":
                \ilObjGroupGUI::_goto($target_id, $additional);
                break;

                // please migrate to default branch implementation
            case 'cert':
                \ilCertificate::_goto($target_id);
                break;

                //
                // default implementation (should be used by all new object types)
                //
            default:
                global $objDefinition;
                if (!$objDefinition->isPlugin($target_type)) {
                    $class_name = "ilObj" . $objDefinition->getClassName($target_type) . "GUI";
                    if(class_exists($class_name)) {
                        call_user_func([$class_name, "_goto"], $rest);
                    }
                } else {
                    $class_name = "ilObj" . $objDefinition->getClassName($target_type) . "GUI";
                    $location = $objDefinition->getLocation($target_type);
                    if (is_file($location . "/class." . $class_name . ".php")) {
                        call_user_func([$class_name, "_goto"], [$rest, $class_name]);
                    }
                }
                break;
        }

        return $response_factory->cannot();
    }
}
