<?php

/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 *
 *********************************************************************/

trait TestrailCaseIds
{
    protected static $CASEIDS = [

        'UIBASE' => [
            'open' => 'C25152',
            'prepare' => 'C36165'
        ],

        'Breadcrumbs/Breadcrumbs' => [
            'show' => 'C31824',
            'validate' => 'C42340',
        ],
        'Button/Bulky' => [
            'show' => 'C31821',
            'validate' => 'C42337',
        ],
        'Button/Close' => [
            'show' => 'C31817',
            'validate' => 'C42333',
        ],
        'Button/Month' => [
            'show' => 'C31819',
            'validate' => 'C42335',
        ],
        'Button/Primary' => [
            'show' => 'C31816',
            'validate' => 'C42332',
        ],
        'Button/Shy' => [
            'show' => 'C31818',
            'validate' => 'C42334',
        ],
        'Button/Standard' => [
            'show' => 'C31815',
            'validate' => 'C42331',
        ],
        'Button/Tag' => [
            'show' => 'C31820',
            'validate' => 'C42336',
        ],
        'Button/Toggle' => [
            'show' => 'C31822',
            'validate' => 'C42338',
        ],
        'Card/Repository Object' => [
            'show' => 'C31858',
            'validate' => 'C42365',
        ],
        'Card/Standard' => [
            'show' => 'C31857',
            'validate' => 'C42364',
        ],
        'Chart/ProgressMeter/Fixed Size' => [
            'show' => 'C31834',
            'validate' => 'C42347',
        ],
        'Chart/ProgressMeter/Mini' => [
            'show' => 'C31835',
            'validate' => 'C42348',
        ],
        'Chart/ProgressMeter/Standard' => [
            'show' => 'C31830',
            'validate' => 'C42346',
        ],
        'Chart/Scale Bar' => [
            'show' => 'C31829',
            'validate' => 'C42345',
        ],
        'Counter/Novelty' => [
            'show' => 'C25156',
            'validate' => 'C42284',
        ],
        'Counter/Status' => [
            'show' => 'C25155',
            'validate' => 'C42283',
        ],
        'Deck/Deck' => [
            'show' => 'C31859',
            'validate' => 'C42366',
        ],
        'Divider/Horizontal' => [
            'show' => 'C25160',
            'validate' => 'C42287',
        ],
        'Divider/Vertical' => [
            'show' => 'C25161',
            'validate' => 'C42288',
        ],
        'Dropdown/Standard' => [
            'show' => 'C31823',
            'validate' => 'C42339',
        ],
        'Dropzone/File/Standard' => [
            'show' => 'C49996',
            'validate' => 'C50020',
        ],
        'Dropzone/File/Wrapper' => [
            'show' => 'C49997',
            'validate' => 'C50021',
        ],
        'Symbol/Icon/Custom' => [
            'show' => 'C25154',
            'validate' => 'C42282',
        ],
        'Symbol/Icon/Standard' => [
            'show' => 'C25153',
            'validate' => 'C42281',
        ],
        'Image/Responsive' => [
            'show' => 'C25159',
            'validate' => 'C42286',
        ],
        'Image/Standard' => [
            'show' => 'C25158',
            'validate' => 'C42285',
        ],
        'Input/Container/Filter/Standard' => [
            'show' => 'C31856',
            'validate' => 'C42363',
        ],
        'Input/Container/Form/Standard' => [
            'show' => 'C31848',
            'validate' => 'C42362',
        ],
        'Input/Field/Checkbox' => [
            'show' => 'C31841',
            'validate' => 'C42355',
        ],
        'Input/Field/Date Time' => [
            'show' => 'C49196',
            'validate' => 'C49197',
        ],
        'Input/Field/Duration' => [
            'show' => 'C49198',
            'validate' => 'C49199',
        ],
        'Input/Field/File' => [
            'show' => 'C49200',
            'validate' => 'C49201',
        ],
        'Input/Field/Group' => [
            'show' => 'C31838',
            'validate' => 'C42351',
        ],
        'Input/Field/Hidden' => [
            'show' => 'C54147',
            'validate' => 'C54148',
        ],
        'Input/Field/Link' => [
            'show' => 'C54145',
            'validate' => 'C54146',
        ],
        'Input/Field/Multi Select' => [
            'show' => 'C31847',
            'validate' => 'C42361',
        ],
        'Input/Field/Numeric' => [
            'show' => 'C31837',
            'validate' => 'C42350',
        ],
        'Input/Field/Optional Group' => [
            'show' => 'C36075',
            'validate' => 'C42352',
        ],
        'Input/Field/Password' => [
            'show' => 'C31843',
            'validate' => 'C42357',
        ],
        'Input/Field/Radio' => [
            'show' => 'C31846',
            'validate' => 'C42360',
        ],
        'Input/Field/Section' => [
            'show' => 'C31839',
            'validate' => 'C42354',
        ],
        'Input/Field/Select' => [
            'show' => 'C31844',
            'validate' => 'C42358',
        ],
        'Input/Field/Switchable Group' => [
            'show' => 'C36076',
            'validate' => 'C42353',
        ],
        'Input/Field/Tag' => [
            'show' => 'C31842',
            'validate' => 'C42356',
        ],
        'Input/Field/Text' => [
            'show' => 'C31836',
            'validate' => 'C42349',
        ],
        'Input/Field/Textarea' => [
            'show' => 'C31845',
            'validate' => 'C42359',
        ],
        'Input/Field/Url' => [
            'show' => 'C52583',
            'validate' => 'C52584',
        ],
        'Item/Group' => [
            'show' => 'C31883',
            'validate' => 'C42379',
        ],
        'Item/Notification' => [
            'show' => 'C50084',
            'validate' => 'C49995',
        ],
        'Item/Shy' => [
            'show' => 'C49994',
            'validate' => 'C50019',
        ],
        'Item/Standard' => [
            'show' => 'C31882',
            'validate' => 'C42378',
        ],
        'Layout/Page/Standard' => [
            'show' => 'C50004',
            'validate' => 'C50028',
        ],
        'Legacy/Legacy' => [
            'show' => 'C49998',
            'validate' => 'C50022',
        ],
        'Link/Bulky' => [
            'show' => 'C36057',
            'validate' => 'C42290',
        ],
        'Link/Standard' => [
            'show' => 'C31729',
            'validate' => 'C42289',
        ],
        'Listing/CharacteristicValue/Text' => [
            'show' => 'C49993',
            'validate' => 'C50018',
        ],
        'Listing/Descriptive' => [
            'show' => 'C31862',
            'validate' => 'C42369',
        ],
        'Listing/Ordered' => [
            'show' => 'C31861',
            'validate' => 'C42368',
        ],
        'Listing/Unordered' => [
            'show' => 'C31860',
            'validate' => 'C42367',
        ],
        'Listing/Workflow/Linear' => [
            'show' => 'C31868',
            'validate' => 'C42371',
        ],
        'Listing/Workflow/Step' => [
            'show' => 'C31867',
            'validate' => 'C42370',
        ],
/*
        'Mainbar/MehrMenueinträge' => [
            '' => 'C32105',
        ],
*/
        'Menu/Drilldown' => [
            'show' => 'C50008',
            'validate' => 'C50032',
        ],
        'Menu/Sub' => [
            'show' => 'C50009',
            'validate' => 'C77485'
        ],
        'MessageBox/Confirmation' => [
            'show' => 'C50003',
            'validate' => 'C50027',
        ],
        'MessageBox/Failure' => [
            'show' => 'C50000',
            'validate' => 'C50024',
        ],
        'MessageBox/Info' => [
            'show' => 'C50002',
            'validate' => 'C50026',
        ],
        'MessageBox/Success' => [
            'show' => 'C50001',
            'validate' => 'C50025',
        ],
        'Modal/Lightbox Image Page' => [
            'show' => 'C31963',
            'validate' => 'C42384',
        ],
        'Modal/Lightbox Text Page' => [
            'show' => 'C31964',
            'validate' => 'C42385',
        ],
        'Modal/InterruptiveItem/Standard' => [
            'show' => 'C31960',
            'validate' => 'C42381',
        ],
        'Modal/Interruptive' => [
            'show' => 'C31884',
            'validate' => 'C42380',
        ],
        'Modal/Lightbox' => [
            'show' => 'C31962',
            'validate' => 'C42383',
        ],
        'Modal/Roundtrip' => [
            'show' => 'C31961',
            'validate' => 'C42382',
        ],
        'Panel/Listing/Standard' => [
            'show' => 'C31872',
            'validate' => 'C42375',
        ],
        'Panel/Report' => [
            'show' => 'C31871',
            'validate' => 'C42374',
        ],
        'Panel/Secondary/Legacy' => [
            'show' => 'C31874',
            'validate' => 'C42377',
        ],
        'Panel/Secondary/Listing' => [
            'show' => 'C31873',
            'validate' => 'C42376',
        ],
        'Panel/Standard' => [
            'show' => 'C31869',
            'validate' => 'C42372',
        ],
        'Panel/Sub' => [
            'show' => 'C31870',
            'validate' => 'C42373',
        ],
        'Player/Audio' => [
            'show' => 'C49989',
            'validate' => 'C50014',
        ],
        'Player/Video' => [
            'show' => 'C49990',
            'validate' => 'C50015',
        ],
        'Popover/Listing' => [
            'show' => 'C31966',
            'validate' => 'C42387',
        ],
        'Popover/Standard' => [
            'show' => 'C31965',
            'validate' => 'C42386',
        ],
        'Symbol/Avatar/Letter' => [
            'show' => 'C50038',
            'validate' => 'C50039',
        ],
        'Symbol/Avatar/Picture' => [
            'show' => 'C50012',
            'validate' => 'C50036',
        ],
        'Symbol/Glyph/Add' => [
            'show' => 'C31733',
            'validate' => 'C42294',
        ],
        'Symbol/Glyph/Angry' => [
            'show' => 'C31804',
            'validate' => 'C42315',
        ],
        'Symbol/Glyph/Apply' => [
            'show' => 'C31809',
            'validate' => 'C42320',
        ],
        'Symbol/Glyph/Astounded' => [
            'show' => 'C31802',
            'validate' => 'C42313',
        ],
        'Symbol/Glyph/Attachment' => [
            'show' => 'C31807',
            'validate' => 'C42318',
        ],
        'Symbol/Glyph/Back' => [
            'show' => 'C31737',
            'validate' => 'C42298',
        ],
        'Symbol/Glyph/Briefcase' => [
            'show' => 'C31741',
            'validate' => 'C42302',
        ],
        'Symbol/Glyph/Bulletlist' => [
            'show' => 'C49186',
            'validate' => 'C49187',
        ],
        'Symbol/Glyph/Calendar' => [
            'show' => 'C36063',
            'validate' => 'C42323',
        ],
        'Symbol/Glyph/Close' => [
            'show' => 'C36065',
            'validate' => 'C42325',
        ],
        'Symbol/Glyph/Collapse Horizontal' => [
            'show' => 'C50013',
            'validate' => 'C50037',
        ],
        'Symbol/Glyph/Collapse' => [
            'show' => 'C31731',
            'validate' => 'C42292',
        ],
        'Symbol/Glyph/Comment' => [
            'show' => 'C31747',
            'validate' => 'C42308',
        ],
        'Symbol/Glyph/Disclosure' => [
            'show' => 'C36067',
            'validate' => 'C42327',
        ],
        'Symbol/Glyph/Dislike' => [
            'show' => 'C31800',
            'validate' => 'C42311',
        ],
        'Symbol/Glyph/Down' => [
            'show' => 'C31736',
            'validate' => 'C42297',
        ],
        'Symbol/Glyph/Expand' => [
            'show' => 'C31732',
            'validate' => 'C42293',
        ],
        'Symbol/Glyph/Eyeclosed' => [
            'show' => 'C31805',
            'validate' => 'C42316',
        ],
        'Symbol/Glyph/Eyeopen' => [
            'show' => 'C31806',
            'validate' => 'C42317',
        ],
        'Symbol/Glyph/Filter' => [
            'show' => 'C49194',
            'validate' => 'C49195',
        ],
        'Symbol/Glyph/Help' => [
            'show' => 'C36062',
            'validate' => 'C42322',
        ],
        'Symbol/Glyph/Language' => [
            'show' => 'C36068',
            'validate' => 'C42328',
        ],
        'Symbol/Glyph/Laugh' => [
            'show' => 'C31801',
            'validate' => 'C42312',
        ],
        'Symbol/Glyph/Like' => [
            'show' => 'C31748',
            'validate' => 'C42309',
        ],
        'Symbol/Glyph/Listindent' => [
            'show' => 'C49190',
            'validate' => 'C49191',
        ],
        'Symbol/Glyph/Listoutdent' => [
            'show' => 'C49192',
            'validate' => 'C49193',
        ],
        'Symbol/Glyph/Login' => [
            'show' => 'C36069',
            'validate' => 'C42329',
        ],
        'Symbol/Glyph/Logout' => [
            'show' => 'C36070',
            'validate' => 'C42330',
        ],
        'Symbol/Glyph/Love' => [
            'show' => 'C31799',
            'validate' => 'C42310',
        ],
        'Symbol/Glyph/Mail' => [
            'show' => 'C31743',
            'validate' => 'C42304',
        ],
        'Symbol/Glyph/More' => [
            'show' => 'C36066',
            'validate' => 'C42326',
        ],
        'Symbol/Glyph/Next' => [
            'show' => 'C31738',
            'validate' => 'C42299',
        ],
        'Symbol/Glyph/Note' => [
            'show' => 'C31746',
            'validate' => 'C42307',
        ],
        'Symbol/Glyph/Notification' => [
            'show' => 'C31744',
            'validate' => 'C42305',
        ],
        'Symbol/Glyph/Numberedlist' => [
            'show' => 'C49188',
            'validate' => 'C49189',
        ],
        'Symbol/Glyph/Remove' => [
            'show' => 'C31734',
            'validate' => 'C42295',
        ],
        'Symbol/Glyph/Reset' => [
            'show' => 'C31808',
            'validate' => 'C42319',
        ],
        'Symbol/Glyph/Sad' => [
            'show' => 'C31803',
            'validate' => 'C42314',
        ],
        'Symbol/Glyph/Search' => [
            'show' => 'C36061',
            'validate' => 'C42321',
        ],
        'Symbol/Glyph/Settings' => [
            'show' => 'C31730',
            'validate' => 'C42291',
        ],
        'Symbol/Glyph/Sort Ascending' => [
            'show' => 'C31739',
            'validate' => 'C42300',
        ],
        'Symbol/Glyph/Sort Descending' => [
            'show' => 'C31740',
            'validate' => 'C42301',
        ],
        'Symbol/Glyph/Tag' => [
            'show' => 'C31745',
            'validate' => 'C42306',
        ],
        'Symbol/Glyph/Time' => [
            'show' => 'C36064',
            'validate' => 'C42324',
        ],
        'Symbol/Glyph/Up' => [
            'show' => 'C31735',
            'validate' => 'C42296',
        ],
        'Symbol/Glyph/User' => [
            'show' => 'C31742',
            'validate' => 'C42303',
        ],
        'Table/Presentation' => [
            'show' => 'C49999',
            'validate' => 'C50023',
        ],
        'Toast/Container' => [
            'show' => 'C50011',
            'validate' => 'C50035',
        ],
        'Toast/Standard' => [
            'show' => 'C50010',
            'validate' => 'C50034',
        ],
        'Tree/Expandable' => [
            'show' => 'C50007',
            'validate' => 'C50031',
        ],
        'Tree/Node/Key Value' => [
            'validate' => 'C49988',
            'show' => 'C49987',
        ],
        'Tree/Node/Simple' => [
            'show' => 'C50005',
            'validate' => 'C50029',
        ],
        'Tree/Node/Bylined' => [
            'show' => 'C50006',
            'validate' => 'C50030',
            //'validate' => 'C77562'
        ],
        'ViewControl/Mode' => [
            'show' => 'C31825',
            'validate' => 'C42341',
        ],
        'ViewControl/Pagination' => [
            'show' => 'C31828',
            'validate' => 'C42344',
        ],
        'ViewControl/Section' => [
            'show' => 'C31826',
            'validate' => 'C42342',
        ],
        'ViewControl/Sortation' => [
            'show' => 'C31827',
            'validate' => 'C42343',
        ],
        'Button/Minimize' => [
            'show' => 'C77429',
            'validate' => 'C77430'
        ],
        'Chart/Bar/Vertical' => [
            'show' => 'C77431',
            'validate' => 'C77432'
        ],
        'Chart/Bar/Horizontal' => [
            'show' => 'C77433',
            'validate' => 'C77434'
        ],
        'Entity/Standard' => [
            'show' => 'C77435',
            'validate' => 'C77436'
        ],
        'Input/Field/Color Picker' => [
            'show' => 'C77437',
            'validate' => 'C77438'
        ],
        'Input/Field/Markdown' => [
            'show' => 'C77439',
            'validate' => 'C77440'
        ],
        'Input/Field/Rating' => [
            'show' => 'C77441',
            'validate' => 'C77442'
        ],
        'Input/Container/ViewControl/Standard' => [
            'show' => 'C77443',
            'validate' => 'C77444'
        ],
        'Input/ViewControl/Field Selection' => [
            'show' => 'C77445',
            'validate' => 'C77446'
        ],
        'Input/ViewControl/Sortation' => [
            'show' => 'C77447',
            'validate' => 'C77448'
        ],
        'Input/ViewControl/Pagination' => [
            'show' => 'C77449',
            'validate' => 'C77450'
        ],
        'Input/ViewControl/Group' => [
            'show' => 'C77451',
            'validate' => 'C77452'
        ],
        'Input/ViewControl/Null Control' => [
            'show' => 'C77453',
            'validate' => 'C77454'
        ],
        'Launcher/Inline' => [
            'show' => 'C77455',
            'validate' => 'C77456'
        ],
        'Layout/Alignment/Vertical' => [
            'show' => 'C77457',
            'validate' => 'C77458'
        ],
        'Layout/Alignment/Horizontal/Evenly Distributed' => [
            'show' => 'C77459',
            'validate' => 'C77460'
        ],
        'Layout/Alignment/Horizontal/Dynamically Distributed' => [
            'show' => 'C77461',
            'validate' => 'C77462'
        ],
        'Listing/Property' => [
            'show' => 'C77463',
            'validate' => 'C77464'
        ],
        'Listing/Entity/Standard' => [
            'show' => 'C77465',
            'validate' => 'C77466'
        ],
        'MainControls/Meta Bar' => [
            'show' => 'C77467',
            'validate' => 'C77468'
        ],
        'MainControls/Main Bar' => [
            'show' => 'C77469',
            'validate' => 'C77470'
        ],
        'MainControls/Footer' => [
            'show' => 'C77471',
            'validate' => 'C77472'
        ],
        'MainControls/Mode Info' => [
            'show' => 'C77473',
            'validate' => 'C77474'
        ],
        'MainControls/System Info' => [
            'show' => 'C77475',
            'validate' => 'C77476'
        ],
        'MainControls/Slate/Legacy' => [
            'show' => 'C77477',
            'validate' => 'C77478'
        ],
        'MainControls/Slate/Combined' => [
            'show' => 'C77479',
            'validate' => 'C77480'
        ],
        'MainControls/Slate/Notification' => [
            'show' => 'C77481',
            'validate' => 'C77482'
        ],
        'MainControls/Slate/Drilldown' => [
            'show' => 'C77483',
            'validate' => 'C77484'
        ],
        'Modal/Lightbox Card Page' => [
            'show' => 'C77486',
            'validate' => 'C77487'
        ],
        'Modal/InterruptiveItem/Key Value' => [
            'show' => 'C77488',
            'validate' => 'C77489'
        ],
        'Progress/Bar' => [
            'show' => 'C77490',
            'validate' => 'C77491'
        ],
        'Progress/State/Bar/Indeterminate' => [
            'show' => 'C77492',
            'validate' => 'C77493'
        ],
        'Progress/State/Bar/Determinate' => [
            'show' => 'C77494',
            'validate' => 'C77495'
        ],
        'Progress/State/Bar/Success' => [
            'show' => 'C77496',
            'validate' => 'C77497'
        ],
        'Progress/State/Bar/Failure' => [
            'show' => 'C77498',
            'validate' => 'C77499'
        ],
        'Prompt/Standard' => [
            'show' => 'C77500',
            'validate' => 'C77501'
        ],
        'Prompt/State/Show' => [
            'show' => 'C77502',
            'validate' => 'C77503'
        ],
        'Prompt/State/Close' => [
            'show' => 'C77504',
            'validate' => 'C77505'
        ],
        'Prompt/State/Redirect' => [
            'show' => 'C77506',
            'validate' => 'C77507'
        ],
        'Symbol/Glyph/Header' => [
            'show' => 'C77508',
            'validate' => 'C77509'
        ],
        'Symbol/Glyph/Italic' => [
            'show' => 'C77510',
            'validate' => 'C77511'
        ],
        'Symbol/Glyph/Bold' => [
            'show' => 'C77512',
            'validate' => 'C77513'
        ],
        'Symbol/Glyph/Link' => [
            'show' => 'C77514',
            'validate' => 'C77515'
        ],
        'Symbol/Glyph/Launch' => [
            'show' => 'C77516',
            'validate' => 'C77517'
        ],
        'Symbol/Glyph/Enlarge' => [
            'show' => 'C77518',
            'validate' => 'C77519'
        ],
        'Symbol/Glyph/List View' => [
            'show' => 'C77520',
            'validate' => 'C77521'
        ],
        'Symbol/Glyph/Preview' => [
            'show' => 'C77522',
            'validate' => 'C77523'
        ],
        'Symbol/Glyph/Sort' => [
            'show' => 'C77524',
            'validate' => 'C77525'
        ],
        'Symbol/Glyph/Column Selection' => [
            'show' => 'C77526',
            'validate' => 'C77527'
        ],
        'Symbol/Glyph/Tile View' => [
            'show' => 'C77528',
            'validate' => 'C77529'
        ],
        'Table/Data' => [
            'show' => 'C77530',
            'validate' => 'C77531'
        ],
        'Table/Ordering' => [
            'show' => 'C77532',
            'validate' => 'C77533'
        ],
        'Table/Column/Text' => [
            'show' => 'C77534',
            'validate' => 'C77535'
        ],
        'Table/Column/Number' => [
            'show' => 'C77536',
            'validate' => 'C77537'
        ],
        'Table/Column/Date' => [
            'show' => 'C77538',
            'validate' => 'C77539'
        ],
        'Table/Column/Status' => [
            'show' => 'C77540',
            'validate' => 'C77541'
        ],
        'Table/Column/Status Icon' => [
            'show' => 'C77542',
            'validate' => 'C77543'
        ],
        'Table/Column/Boolean' => [
            'show' => 'C77544',
            'validate' => 'C77545'
        ],
        'Table/Column/EMail' => [
            'show' => 'C77546',
            'validate' => 'C77547'
        ],
        'Table/Column/Time Span' => [
            'show' => 'C77548',
            'validate' => 'C77549'
        ],
        'Table/Column/Link' => [
            'show' => 'C77550',
            'validate' => 'C77551'
        ],
        'Table/Column/Link Listing' => [
            'show' => 'C77552',
            'validate' => 'C77553'
        ],
        'Table/Action/Standard' => [
            'show' => 'C77554',
            'validate' => 'C77555'
        ],
        'Table/Action/Single' => [
            'show' => 'C77556',
            'validate' => 'C77557'
        ],
        'Table/Action/Multi' => [
            'show' => 'C77558',
            'validate' => 'C77559'
        ],
        'Topic/Help Topics' => [
            'show' => 'C77560',
            'validate' => 'C77561'
        ],

    ];
}
