# Resources
This document lists official resources for developing and maintaining the ILIAS software.

## ILIAS Repo at GitHub
The source code of the core version of ILIAS is available at the ILIAS repository of GitHub at https://github.com/ILIAS-eLearning/ILIAS. There are branches at least for trunk (actual development) and the currently maintained ILIAS versions (usually 2).
Additional repos at https://github.com/ILIAS-eLearning are offered for test objects, styles and images. All repositories are public.

## Mantis Bug Tracker
The central place to report and read about issues in ILIAS is the Mantis Bug Tracker at https://mantis.ilias.de. The project 'ILIAS Core' is offered for issues in the core versions of ILIAS while 'ILIAS Plugins' is reserved for those plugins of ILIAS where no separate bugtracking is provided by the related plugin developer.
Getting a Mantis account to report issues in ILIAS is easy and free for everyone. Just go to https://mantis.ilias.de/signup_page.php and create an account. You need a valid e-mail address to register.
A guideline ‘How to Write a Bug Report’ is offered here: https://docu.ilias.de/go/pg/64419_4793

## Docu Installation
The homepage for the ILIAS development is at https://docu.ilias.de. This ILIAS installation is offered and administrated by the ILIAS open source e-Learning e.V. 
The docu installation contains a lot of resources and information around the use and development of the ILIAS LMS. The registration is free for everybody. Just go to https://docu.ilias.de/go/usr/registration and fill out the registration form.

### Feature Wiki
The Feature Wiki at the docu installation is the central place where new features are suggested, discussed and documented. The Feature Wiki also contains the minutes of the by-weekly Jour Fixe, see [03.development-process.md](https://github.com/ILIAS-eLearning/ILIAS/blob/trunk/docs/development/devguide/tutorial/01-community/03-development-process.md).
Reading the Feature Wiki is possible for everybody. But you need an account on docu.ilias.de to add a new feature request or to edit or comment existing entries. 
In the Feature Wiki every feature has its proper wiki page. The pages are connected by links and described by metadata (e.g. related component or ILIAS version where it was published).
A guideline on ‘How to suggest a new feature’ at https://docu.ilias.de/go/wiki/wpage_788_1357

### Developer Forum
A forum for ‘ILIAS Developers’ is offered at https://docu.ilias.de/go/frm/5386. It is open for questions and information around the development of ILIAS. A lot of development related information exchange takes also place in the Discord channel of ILIAS (see below).

### Special Interest Groups
For some ILIAS components users and developers have organised themselves in so-called special interest groups (aka SIG), e.g. for the test&assessment, the portfolio or the calendar. There is also a SIG that takes care about the improvement of accessibility in ILIAS and another for the sustainability of plugins. A list of all SIGs is available here: https://docu.ilias.de/go/cat/2856
Usually, one have to apply for membership before becoming a SIG member. More information is provided on the ‘Info’ page of the related SIG.

## Discord
The ILIAS channels of Discord is an unofficial offer to chat about the development and usage of ILIAS. The 'Community' consists of several channels organised by topics like conceptual questions, testing, administration stuff or assessment support. Posts are made in English and German. To subscribe to the ILIAS community at Discord click on https://discord.gg/H9v2v2Ar2T

## Mailing list for Developers
The official mailing list for announcing important development related information is ilias-admin@lists.ilias.de . Subscription to the mailing list is open to everybody. Just [click here](https://lists.ilias.de/postorius/lists/developers.lists.ilias.de) and get member of the list. The mailing list is reserved for announcements. Discussion about topics should take place in the Development Forum (see above).

## Test Installations
The ILIAS open source e-Learning e.V. offers also test installations for all maintained versions. They are mainly used to test upcoming ILIAS versions (beta testing) or to reproduce issues of existing versions. Access to the test installations is free for everybody. A list of the available test installations is here: https://docu.ilias.de/go/webr/4134