/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 */

/**
 * Wraps the TagsInput
 *
 * @author Fabian Schmid <fs@studer-raimann.ch>
 * @author Nils Haagen <nils.haagen@concepts-and-training.de>
 */
var il = il || {};
il.UI = il.UI || {};
il.UI.Input = il.UI.Input || {};
(function ($) {
  il.UI.Input.tagInput = (function ($) {
    const instances = [];
    const init = function (raw_id, config, value) {
      let _CONFIG = {};
      const _getSettings = function () {
        return {
          whitelist: _CONFIG.options,
          enforceWhitelist: !_CONFIG.userInput,
          duplicates: _CONFIG.allowDuplicates,
          maxTags: _CONFIG.maxItems,
          originalInputValueFormat: (valuesArr) => valuesArr.map((item) => item.value),
          dropdown: {
            enabled: _CONFIG.dropdownSuggestionsStartAfter,
            maxItems: _CONFIG.dropdownMaxItems,
            closeOnSelect: _CONFIG.dropdownCloseOnSelect,
            highlightFirst: _CONFIG.highlight,
          },
          transformTag(tagData) {
            if (!tagData.display) {
              tagData.display = tagData.value;
              tagData.value = encodeURI(tagData.value);
            }
            tagData.display = tagData.display
              .replace(/</g, '&lt;')
              .replace(/>/g, '&gt;');
          },
        };
      };

      // Initialize ID and Configuration
      _CONFIG = $.extend(_CONFIG, config);
      _CONFIG.id = document.querySelector(`#${raw_id} .c-input__field .c-field-tag__wrapper input`)?.id;

      const settings = _getSettings();
      settings.delimiters = null;
      settings.templates = {};
      settings.templates.tag = function (tagData) {
        return `<tag contenteditable='false'
                            spellcheck="false" class='tagify__tag'
                            value="${tagData.value}"
                            tabindex="0">
                            <x title='remove tag' class='tagify__tag__removeBtn'></x>
                            <div>
                                <span class='tagify__tag-text'>${tagData.display}</span>
                            </div>
                    </tag>`;
      };
      settings.templates.dropdownItem = function (tagData) {
        return `<div class='tagify__dropdown__item' tagifySuggestionIdx="${tagData.tagifySuggestionIdx}" value="${tagData.value}">
                            <span>${tagData.display}</span>
                        </div>`;
      };

      const input = document.getElementById(_CONFIG.id);
      const tagify = new Tagify(input, settings);

      tagify.addTags(value);

      instances[raw_id] = tagify;
    };

    const getTagifyInstance = function (raw_id) {
      return instances[raw_id];
    };

    return {
      init,
      getTagifyInstance,
    };
  }($));
}($, il.UI.Input));
