# COPage (ILIAS Page Editor)

This component implements the ILIAS page editor as being used e.g. in learning modules, wikis, content pages in courses and other containers. This part of the documentation deals with concepts and business rules, for technical documentation see [README-technical.md](./README-technical.md).

## Browser Support

Since ILIAS 7 the editor makes extensive use of ES6 features. For ILIAS 7 the current maintainer accepts issues for the latest Firefox, Chrome, Safari and Edge versions. However, please note that issues that appear only on specific browsers may be fixed with lower priority.

## Text Editing

- Since ILIAS 7 the Return key created new text elements. The Backspace key at the beginning of a text element will merge the content of the current text element with the preceding one, if existing. The Delete key at the end of a text element will merge the content of the current text element with the succeeding one, if existing. See https://docu.ilias.de/goto_docu_wiki_wpage_6264_1357.html
- Empty Links: Empty internal or external links, which have no text between starting and ending tag will be removed when the page is saved.

## Footnotes

During editing footnotes are not replaced with the numbering scheme, since this would require server side rendering of the whole page, which we want to avoid due to performance reasons.

## Internal Links

- Not all contexts support internal links. If the "More > Link" menu does not offer the menu item "Internal Link" while editing text paragraphs, the context does not support internal links. If the internal link format is used anyway in a paragraph, e.g. by copying it from other sources, the outcome (both in editing and presentation) is currently undefined.
- If containers are copied and container page content links to sub-containers (e.g. folders), you need to use internal links and instance link areas for media objects to have them updated during the copy process.
- If containers are exported/imported, ILIAS will update the internal links to repository objects by searching for to repository objects having the target object id set as their import id. More than one object may have this ID (imported multiple times). ILIAS will choose the latest imported object and re-reference the link accordingly (ilPageObject->resolveIntLinks()).

## Anchors

- Up to ILIAS 7, anchor targets have been rendered as a-tag with a name attribute. Since this is deprecated in HTML ILIAS 8 uses a span with an id tag instead. Since we need to prevent conflicts with IDs of other DOM elements, the anchor/id gets a prefix "copganc_". See https://mantis.ilias.de/view.php?id=37382


## Slate Handling

- Starting with ILIAS 7 the editor and its components start to use a tool slate to provide forms and other control elements. The transition of the components to the new UI concepts will be done step by step with the upcoming major releases. During this phase, components not using the slate yet, will show a blank slate, instead of deactivating the slate completely, since this would result in unsteady layout changes. 


## Pasting Text

- Pasting text from external sources most probably will lose format information, since ILIAS reduces formats to a basic set and uses its own span classes for styling characters. E.g. it is not advisable to paste anything from MS Word directly into the editor, since the formats will not but compatible. Most times converting to plain text first will be the most efficient procedure.
- TinyMCE removed the "paste" plugin with version 7 from the opensource solution. ILIAS 10+ only provides a basic procedure that tries to preserve paragraphs. Other formatting will most probable get lost.

## Copying Content

- Media objects are referenced when pages are copied. This behaviour is relevant for almost all copy processes that include COPage content.
- For link behaviour during copy process see chapter "Internal Links".

## Media Editing

- The former decision to present instance properties and links areas, if at least two usages exist has been revised, see https://mantis.ilias.de/view.php?id=38582. The editor will always present instance and object properties in the advanced settings.

## Media Rendering
 
- See [MediaObjects/Readme](../MediaObjects/README.md)

## Accordions and Media

- Accordions currently to not interact with media when being closed. Players will continue to play, See [ROADMAP.md](ROADMAP.md)

## Editing: Save, Cancel, Finish

- The text editing in slate in ILIAS 7 contained a "Save and Return" and "Cancel" button. However, save actions have been performed during editing process e.g. due to auto-saving or the creation of new text paragraphs (hitting return) or creating surrounding sections. This made the semantics of both buttons weak, since the save button was not the only trigger for save actions and the cancel button did not tell which action is currently "cancelled". See https://mantis.ilias.de/view.php?id=31436
- Save should be used on form-like screens.
- Cancel buttons should be used if "one-way" workflows can be cancelled and an unambiguous return point (start of the workflow) exists, e.g. creation workflows using forms.
- Finish buttons should be used, if complex sub-screens ("underworlds") exist, that allow multiple different actions. Examples: text editing, the page editing itself or editing interactive images.

## History / Compare

The page history is acting on the XML content, so every component that stores its information in XML is tackled by the history. For example the whole layout and all text elements are part of the page history.

If page components only store IDs or references to external data which is added after the XSLT processing, actual data of the components is presented. Examples: Media object components will always show the current media object, page lists will always act on the current metadata, current courses or consultation hour elements will always present current data in the history.