<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!-- removed xmlns:str="http://exslt.org/strings" -->

<xsl:output method="xml" omit-xml-declaration="yes" />
<!-- <xsl:output method="html"/> -->

<xsl:preserve-space elements="Paragraph Footnote Strong Accent Emph Comment Important Quotation Keyw Code ExtLink IntLink Sub Sup"/>

<!-- changing the default template to output all unknown tags -->
<xsl:template match="*">
  <xsl:copy-of select="."/>
</xsl:template>

<!-- strip white spaces between tags -->
<xsl:strip-space elements="*"/>


<!-- dump MetaData -->
<xsl:template match="MetaData"/>

<!-- dummy node for output (this is necessary because all media
	objects follow in sequence to the page object, the page contains
	media aliases only (and their own layout information). the dummy
	node wraps the pageobject and the mediaobject tags. -->
<xsl:template match="dummy">
	<xsl:apply-templates/>
	<xsl:if test = "count(./PageObject) = 0">
		<xsl:call-template name="outputImageMaps" />
	</xsl:if>
</xsl:template>

<!-- PageObject -->
<xsl:param name="mode"/>
<xsl:param name="media_mode"/>
<xsl:param name="pg_title"/>
<xsl:param name="pg_title_class"/>
<xsl:param name="pg_id"/>
<xsl:param name="ref_id"/>
<xsl:param name="parent_id"/>
<xsl:param name="link_params"/>
<xsl:param name="download_script"/>
<xsl:param name="pg_frame"/>
<xsl:param name="webspace_path"/>
<xsl:param name="enlarge_path"/>
<xsl:param name="img_col"/>
<xsl:param name="img_row"/>
<xsl:param name="img_cell"/>
<xsl:param name="img_item"/>
<xsl:param name="img_path"/>
<xsl:param name="append_footnotes"/>
<xsl:param name="med_disabled_path"/>
<xsl:param name="map_item" />
<xsl:param name="map_mob_id" />
<xsl:param name="map_edit_mode" />
<xsl:param name="javascript" />
<xsl:param name="image_map_link" />
<xsl:param name="file_download_link" />
<xsl:param name="encoded_download_script"/>
<xsl:param name="fullscreen_link" />
<xsl:param name="enable_split_new"/>
<xsl:param name="enable_split_next"/>
<xsl:param name="paragraph_plugins"/>
<xsl:param name="compare_mode"/>
<xsl:param name="enable_rep_objects"/>
<xsl:param name="enable_map"/>
<xsl:param name="enable_tabs"/>
<xsl:param name="enable_file_list"/>
<xsl:param name="enable_sa_qst"/>
<xsl:param name="disable_auto_margins"/>
<xsl:param name="enable_content_includes"/>
<xsl:param name="enable_content_templates"/>
<xsl:param name="page_toc"/>
<xsl:param name="enable_profile"/>
<xsl:param name="enable_verification"/>
<xsl:param name="enable_blog"/>
<xsl:param name="enable_qover"/>
<xsl:param name="enable_skills"/>
<xsl:param name="enable_learning_history"/>
<xsl:param name="enable_placeholder"/>
<xsl:param name="enable_consultation_hours"/>
<xsl:param name="enable_my_courses"/>
<xsl:param name="enable_amd_page_list"/>
<xsl:param name="current_ts"/>
<xsl:param name="enable_html_mob"/>
<xsl:param name="enable_href"/>
<xsl:param name="page_perma_link"/>
<xsl:param name="activated_protection"/>
<xsl:param name="protection_text"/>
<xsl:param name="acc_save_url"/>

<xsl:template match="PageObject">
	<xsl:if test="$mode != 'edit'">
	<a class="small" id="ilPageShowAdvContent" style="display:none; text-align:right;" href="#"><span>{{{{{LV_show_adv}}}}}</span><span>{{{{{LV_hide_adv}}}}}</span></a>
	</xsl:if>
	<!-- <xsl:value-of select="@HierId"/> -->
	<xsl:if test="$pg_title != ''">
		<h1 class="ilc_page_title_PageTitle">
		<xsl:if test="$pg_title_class = ''">
			<xsl:attribute name="class">ilc_page_title_PageTitle</xsl:attribute>
		</xsl:if>
		<xsl:if test="$pg_title_class != ''">
			<xsl:attribute name="class"><xsl:value-of select="$pg_title_class" /></xsl:attribute>
		</xsl:if>
		<xsl:value-of select="$pg_title"/>
		</h1>
	</xsl:if>
	<xsl:comment>COPage-PageTop</xsl:comment>
	<xsl:if test="$page_toc = 'y' and $mode != 'edit'">{{{{{PageTOC}}}}}</xsl:if>
	<xsl:if test="$mode = 'edit'">
		<xsl:if test="$javascript = 'enable'">
			<div data-copg-ed-type="add-area">
				<xsl:attribute name="data-hierid"><xsl:value-of select="@HierId"/></xsl:attribute>
				<xsl:attribute name="data-pcid"><xsl:value-of select="@PCID"/></xsl:attribute>
				<xsl:attribute name="id">add<xsl:value-of select="@PCID"/></xsl:attribute>
				<xsl:comment>dummy</xsl:comment>
			</div>
		</xsl:if>
		<xsl:if test="@HierId != 'pg' or $javascript != 'enable'">
			<xsl:call-template name="EditMenu">
				<xsl:with-param name="hier_id" select="@HierId" />
				<xsl:with-param name="edit">n</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<!-- <br/> -->
	</xsl:if>
	<xsl:apply-templates/>

	<div style="clear:both;"><xsl:comment>Break</xsl:comment></div>

    <!-- Footnote List -->
	<xsl:if test="count(//Footnote) > 0 and $append_footnotes = 'y' and $mode != 'edit'">
		<hr />
		<xsl:for-each select="//Footnote">
			<xsl:choose>
			<xsl:when test="./ancestor::*[@Enabled = 'False']">
			</xsl:when>
			<xsl:otherwise>
				<div class="ilc_page_fn_Footnote">
				<a>
				<xsl:attribute name="name">fn<xsl:number count="Footnote" level="any"/></xsl:attribute>
				<span>[<xsl:number count="Footnote" level="any"/>] </span>
				</a>
				<xsl:comment>ParStart</xsl:comment>
				<xsl:apply-templates />
				<xsl:comment>ParEnd</xsl:comment>
				</div>
			</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:if>

	<!-- image map data -->
	<xsl:call-template name="outputImageMaps" />

</xsl:template>

<!-- output image maps -->
<xsl:template name="outputImageMaps">
	<xsl:for-each select="//MediaItem">
		<xsl:variable name="corig"><xsl:value-of select="../@Id"/></xsl:variable>
		<xsl:variable name="corigp"><xsl:value-of select="@Purpose"/></xsl:variable>

			<!-- Maps for alias items -->
			<xsl:for-each select="//MediaAlias[@OriginId = $corig]/../MediaAliasItem[@Purpose = $corigp]/MapArea[1]">
				<map>
					<xsl:attribute name="name">map_<xsl:value-of select="$corig"/>_<xsl:value-of select="$corigp"/>_<xsl:number count="MediaAliasItem" level="any" /></xsl:attribute>
					<xsl:if test="name(../..) = 'InteractiveImage'">
						<xsl:attribute name="class">iim</xsl:attribute>
					</xsl:if>
					<xsl:call-template name="outputImageMapAreas" />
					<xsl:comment>Break</xsl:comment>
				</map>
			</xsl:for-each>
			<!-- Default map -->
			<xsl:for-each select="./MapArea[1]">
				<map>
					<xsl:attribute name="name">map_<xsl:value-of select="$corig"/>_<xsl:value-of select="$corigp"/></xsl:attribute>
					<xsl:call-template name="outputImageMapAreas" />
					<xsl:comment>Break</xsl:comment>
				</map>
			</xsl:for-each>
	</xsl:for-each>
</xsl:template>

<!-- set area link attributes -->
<xsl:template name="setAreaLinkAttributes">
	<xsl:for-each select="./IntLink">
		<!-- determine link_href and link_target -->
		<xsl:variable name="target" select="@Target"/>
		<xsl:variable name="type" select="@Type"/>
		<xsl:variable name="anchor" select="@Anchor"/>
		<xsl:variable name="targetframe">
			<xsl:choose>
				<xsl:when test="@TargetFrame and @TargetFrame!=''">
					<xsl:value-of select="@TargetFrame"/>
				</xsl:when>
				<xsl:otherwise>None</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="link_href">
			<xsl:value-of select="//IntLinkInfos/IntLinkInfo[@Type=$type and @TargetFrame=$targetframe and @Target=$target and @Anchor=concat('',$anchor)]/@LinkHref"/>
		</xsl:variable>
		<xsl:variable name="link_target">
			<xsl:value-of select="//IntLinkInfos/IntLinkInfo[@Type=$type and @TargetFrame=$targetframe and @Target=$target and @Anchor=concat('',$anchor)]/@LinkTarget"/>
		</xsl:variable>

		<!-- set attributes -->
		<xsl:attribute name="href"><xsl:value-of select="$link_href"/></xsl:attribute>
		<xsl:if test="$link_target != ''">
			<xsl:attribute name="target"><xsl:value-of select="$link_target"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="//LinkTargets/LinkTarget[@TargetFrame=$targetframe]/@OnClick">
			<xsl:attribute name="onclick"><xsl:value-of select="//LinkTargets/LinkTarget[@TargetFrame=$targetframe]/@OnClick"/></xsl:attribute>
		</xsl:if>

		<xsl:if test=". != '' and . != ' '">
			<xsl:attribute name="title"><xsl:value-of select="."/></xsl:attribute>
			<xsl:attribute name="alt"><xsl:value-of select="."/></xsl:attribute>
		</xsl:if>
	</xsl:for-each>
	<xsl:for-each select="./ExtLink">
		<xsl:attribute name="href"><xsl:value-of select="@Href"/></xsl:attribute>
		<xsl:attribute name="title"><xsl:value-of select="."/></xsl:attribute>
		<xsl:attribute name="alt"><xsl:value-of select="."/></xsl:attribute>
		<xsl:attribute name="target">_blank</xsl:attribute>
		<xsl:if test="@Href = '' or not(@Href)">
			<xsl:attribute name="href">#</xsl:attribute>
			<xsl:attribute name="onclick">return false;</xsl:attribute>
		</xsl:if>
	</xsl:for-each>
</xsl:template>

<!-- output image map areas -->
<xsl:template name="outputImageMapAreas">
	<xsl:for-each select="../MapArea">

		<!-- highlight mode -->
		<xsl:variable name="hl_class">
			<xsl:choose>
				<xsl:when test="@HighlightClass = 'Dark'">"fillColor":"202020","strokeColor":"202020"</xsl:when>
				<xsl:when test="@HighlightClass = 'Light'">"fillColor":"F0F0F0","strokeColor":"F0F0F0"</xsl:when>
				<xsl:otherwise>"fillColor":"FF6633","strokeColor":"FF6633"</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="hl_mode">
			<xsl:choose>
				<xsl:when test="@HighlightMode = 'Hover'">,"fade":true</xsl:when>
				<xsl:otherwise>,"alwaysOn":true,"fade":false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:if test="@Shape != 'WholePicture' and $map_edit_mode = ''">
			<area>
				<xsl:if test="@HighlightMode != '' and $map_edit_mode = ''">
					<xsl:attribute name="data-maphilight">{"neverOn":false, "fillOpacity":0, "strokeWidth":2,<xsl:value-of select = "$hl_class"/><xsl:value-of select = "$hl_mode"/>}</xsl:attribute>
				</xsl:if>
				<xsl:attribute name="shape"><xsl:value-of select="@Shape"/></xsl:attribute>
				<xsl:attribute name="coords"><xsl:value-of select="@Coords"/></xsl:attribute>
				<xsl:attribute name="id">marea_<xsl:value-of select = "$pg_id"/>_<xsl:number count="MapArea" level="any" /></xsl:attribute>
				<xsl:call-template name="setAreaLinkAttributes">
				</xsl:call-template>
			</area>
		</xsl:if>
		<xsl:if test="name(../..) = 'InteractiveImage'">
			<xsl:if test="$map_edit_mode != 'get_coords'">
				<span style="display:none;">
					<xsl:attribute name="data-copg-iim-data-type">area</xsl:attribute>
					<xsl:attribute name="data-copg-iim-hl-mode"><xsl:value-of select="@HighlightMode"/></xsl:attribute>
					<xsl:attribute name="data-copg-iim-hl-class"><xsl:value-of select="@HighlightClass"/></xsl:attribute>
					<xsl:attribute name="data-copg-iim-area-id">marea_<xsl:value-of select = "$pg_id"/>_<xsl:number count="MapArea" level="any" /></xsl:attribute>
					<xsl:attribute name="data-copg-iim-id"><xsl:value-of select = "$pg_id"/>_<xsl:number count="InteractiveImage" level="any" /></xsl:attribute>
					<xsl:attribute name="data-copg-iim-tr-nr"><xsl:value-of select = "@Id" /></xsl:attribute>
					<xsl:attribute name="data-copg-iim-title"><xsl:value-of select = "ExtLink[1]"/></xsl:attribute>
					<xsl:comment>Break</xsl:comment>
				</span>
			</xsl:if>
		</xsl:if>
	</xsl:for-each>
</xsl:template>

<!-- Anchor -->
<xsl:template match="Anchor">
<span>
<xsl:attribute name="id">copganc_<xsl:value-of select="@Name"/></xsl:attribute>
<xsl:apply-templates/>
</span>
</xsl:template>

<!-- PageContent -->
<xsl:template match="PageContent">
	<xsl:apply-templates select="Anchor"/>
	<xsl:if test="$mode = 'edit'">
		<xsl:variable name="content_type" select="name(./*[1])"/>
		<div>
			<xsl:attribute name="id">pc<xsl:value-of select="@PCID"/></xsl:attribute>
			<xsl:if test="(./MediaObject/MediaAliasItem[@Purpose = 'Standard']/Layout/@HorizontalAlign = 'RightFloat') or
				(./Map/Layout/@HorizontalAlign = 'RightFloat') or
				(./Table/@HorizontalAlign = 'RightFloat')">
				<xsl:attribute name="style"><!--<xsl:if test="./Table/@Width">width:<xsl:value-of select="./Table/@Width"/>;</xsl:if>--> float:right; clear:both; position:relative; z-index:1;</xsl:attribute>
			</xsl:if>
			<xsl:if test="(./MediaObject/MediaAliasItem[@Purpose = 'Standard']/Layout/@HorizontalAlign = 'LeftFloat') or
				(./Map/Layout/@HorizontalAlign = 'LeftFloat') or
				(./Table/@HorizontalAlign = 'LeftFloat')">
				<xsl:attribute name="style"><!--<xsl:if test="./Table/@Width">width:<xsl:value-of select="./Table/@Width"/>;</xsl:if>--> float:left; clear:both; position:relative; z-index:1;</xsl:attribute>
			</xsl:if>
			<div>
				<xsl:if test="not(../../../@DataTable) or (../../../@DataTable = 'n')">
					<xsl:if test="$javascript='enable'">
						<xsl:attribute name="class">il_editarea</xsl:attribute>
						<xsl:attribute name="data-copg-ed-type">pc-area</xsl:attribute>
					</xsl:if>
					<xsl:if test="$javascript!='enable'">
						<xsl:attribute name="class">il_editarea_nojs</xsl:attribute>
					</xsl:if>
					<xsl:if test="@Enabled='False'">
						<xsl:attribute name="class">il_editarea_disabled</xsl:attribute>
					</xsl:if>
					<xsl:if test="$javascript = 'enable'">
					</xsl:if>
				</xsl:if>
				<xsl:attribute name="id">CONTENT<xsl:value-of select="@HierId"/>:<xsl:value-of select="@PCID"/></xsl:attribute>
				<xsl:attribute name="data-hierid"><xsl:value-of select="@HierId"/></xsl:attribute>
				<xsl:attribute name="data-pcid"><xsl:value-of select="@PCID"/></xsl:attribute>
				<xsl:if test="not(./*[1][@DataTable])">
					<xsl:attribute name="data-cname"><xsl:value-of select="$content_type"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="./*[1][@DataTable]">
					<xsl:attribute name="data-cname">DataTable</xsl:attribute>
				</xsl:if>
				<xsl:attribute name="data-characteristic"><xsl:value-of select="./*[1]/@Characteristic"/></xsl:attribute>
				<xsl:apply-templates>
					<xsl:with-param name="par_counter" select ="position()" />
				</xsl:apply-templates>
			</div>
		</div>
		<!-- drop area -->
		<xsl:if test="(not(../../../@DataTable) or (../../../@DataTable = 'n')) and ($javascript != 'disable')">
			<div data-copg-ed-type="add-area">
				<xsl:attribute name="data-hierid"><xsl:value-of select="@HierId"/></xsl:attribute>
				<xsl:attribute name="data-pcid"><xsl:value-of select="@PCID"/></xsl:attribute>
				<xsl:attribute name="id">add<xsl:value-of select="@PCID"/></xsl:attribute>
				<xsl:comment>dummy</xsl:comment>
			</div>
		</xsl:if>

	</xsl:if>
	<xsl:if test="$mode != 'edit' and (not(@Enabled) or @Enabled='True')">
		<xsl:if test="//PageObject/DivClass/@HierId = current()/@HierId">
			<div>
				<xsl:attribute name="class"><xsl:value-of select="//PageObject/DivClass[@HierId = current()/@HierId]/@Class" /></xsl:attribute>
				<xsl:apply-templates>
					<xsl:with-param name="par_counter" select ="position()" />
				</xsl:apply-templates>
			</div>
		</xsl:if>
		<xsl:if test="not(//PageObject/DivClass/@HierId = current()/@HierId)">
			<xsl:apply-templates>
				<xsl:with-param name="par_counter" select ="position()" />
			</xsl:apply-templates>
		</xsl:if>
	</xsl:if>
</xsl:template>

<!-- edit return anchors-->
<xsl:template name="EditReturnAnchors">
	<xsl:if test="$mode = 'edit'">
		<a>
		<xsl:choose>
			<xsl:when test="@HierId">
				<xsl:attribute name="name">jump<xsl:value-of select="@HierId"/>
				</xsl:attribute>
			</xsl:when>
			<xsl:when test="../@HierId">
				<xsl:attribute name="name">jump<xsl:value-of select="../@HierId"/>
				</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="name">jump<xsl:value-of select="../../@HierId"/>
				</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:comment>Break</xsl:comment>
		</a>
	</xsl:if>
</xsl:template>

<!-- Edit Label -->
<xsl:template name="EditLabel">
	<xsl:param name="text"/>
	<xsl:if test="$mode = 'edit'">
	<div class="ilEditLabel">
	<xsl:value-of select="$text"/><xsl:comment>Dummy</xsl:comment></div>
	</xsl:if>
</xsl:template>

<!-- Edit Menu -->
<xsl:template name="EditMenu">
	<xsl:param name="hier_id"/>
	<xsl:param name="pc_id"/>
	<xsl:param name="edit"/>
	<xsl:param name="droparea">n</xsl:param>
	<xsl:param name="type">default</xsl:param>
	<xsl:param name="prevent_deletion">n</xsl:param>

	<xsl:if test = "$javascript = 'enable'">
	<div class="ilOverlay il_editmenu ilNoDisplay">
		<xsl:if test = "$droparea = 'n'">
			<xsl:attribute name="id">contextmenu_<xsl:value-of select="$hier_id"/></xsl:attribute>
		</xsl:if>
		<xsl:if test = "$droparea = 'y'">
			<xsl:attribute name="id">dropareamenu_<xsl:value-of select="$hier_id"/></xsl:attribute>
		</xsl:if>
			<xsl:if test = "$droparea = 'n'">
				<xsl:choose>
					<xsl:when test="$type = 'filelist'">
						<xsl:call-template name="FileListMenu">
							<xsl:with-param name="edit"><xsl:value-of select="$edit"/></xsl:with-param>
							<xsl:with-param name="hier_id"><xsl:value-of select="$hier_id"/></xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="EditMenuItems">
							<xsl:with-param name="edit"><xsl:value-of select="$edit"/></xsl:with-param>
							<xsl:with-param name="hier_id"><xsl:value-of select="$hier_id"/></xsl:with-param>
							<xsl:with-param name="prevent_deletion"><xsl:value-of select="$prevent_deletion"/></xsl:with-param>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test = "$droparea = 'y'">
				<xsl:call-template name="EditMenuInsertItems"/>
			</xsl:if>
	</div>
	</xsl:if>

	<xsl:if test="$javascript = 'disable'">
		<select size="1" class="ilEditSelect">
			<xsl:attribute name="name">command<xsl:value-of select="$hier_id"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="$type = 'filelist'">
						<xsl:call-template name="FileListMenu">
							<xsl:with-param name="edit"><xsl:value-of select="$edit"/></xsl:with-param>
							<xsl:with-param name="hier_id"><xsl:value-of select="$hier_id"/></xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="EditMenuItems">
							<xsl:with-param name="edit"><xsl:value-of select="$edit"/></xsl:with-param>
							<xsl:with-param name="hier_id"><xsl:value-of select="$hier_id"/></xsl:with-param>
							<xsl:with-param name="prevent_deletion"><xsl:value-of select="$prevent_deletion"/></xsl:with-param>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
		</select>
		<input class="ilEditSubmit" type="submit">
			<xsl:attribute name="value"><xsl:value-of select="//LVs/LV[@name='ed_go']/@value"/></xsl:attribute>
			<xsl:attribute name="name">cmd[exec_<xsl:value-of select="$hier_id"/>:<xsl:value-of select="$pc_id"/>]</xsl:attribute>
		</input>
	</xsl:if>

</xsl:template>

<!-- Edit Menu Items -->
<xsl:template name="EditMenuItems">
	<xsl:param name="edit"/>
	<xsl:param name="hier_id"/>
	<xsl:param name="prevent_deletion">n</xsl:param>

	<xsl:if test="$edit = 'y'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">edit</xsl:with-param>
			<xsl:with-param name="langvar">ed_edit</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
	<xsl:if test="$edit = 'p'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">edit</xsl:with-param>
			<xsl:with-param name="langvar">ed_edit_prop</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- special case for edit multiple paragraphs -->
	<xsl:if test="name(.) = 'Paragraph'">
		<!-- <xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">editMultiple</xsl:with-param>
			<xsl:with-param name="langvar">ed_edit_multiple</xsl:with-param>
		</xsl:call-template> -->
	</xsl:if>

	<xsl:if test = "$javascript = 'disable'">
		<xsl:call-template name="EditMenuInsertItems"/>
	</xsl:if>

	<xsl:if test="$edit = 'y' or $edit = 'p' or $edit = 'd'">

		<!-- delete -->
		<xsl:if test="$prevent_deletion = 'n'">
			<xsl:call-template name="EditMenuItem">
				<xsl:with-param name="command">delete</xsl:with-param>
				<xsl:with-param name="langvar">ed_delete</xsl:with-param>
			</xsl:call-template>
			<xsl:call-template name="EditMenuItem">
				<xsl:with-param name="command">copy</xsl:with-param>
				<xsl:with-param name="langvar">ed_copy</xsl:with-param>
			</xsl:call-template>
			<xsl:call-template name="EditMenuItem">
				<xsl:with-param name="command">cut</xsl:with-param>
				<xsl:with-param name="langvar">ed_cut</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<xsl:if test = "$javascript = 'enable' and $prevent_deletion = 'n'">
			<xsl:call-template name="EditMenuItem">
				<xsl:with-param name="command">deactivate</xsl:with-param>
				<xsl:with-param name="langvar">de_activate</xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- move menu items -->
		<xsl:call-template name="MoveMenuItems"/>

		<!-- split page menu items -->
		<xsl:call-template name="SplitMenuItems">
			<xsl:with-param name="hier_id" select="$hier_id"/>
		</xsl:call-template>

	</xsl:if>
</xsl:template>

<!-- Split Menu Items -->
<xsl:template name="SplitMenuItems">
	<xsl:param name="hier_id"/>

	<!-- split page to new page -->
	<xsl:if test = "substring-after($hier_id,'_') = '' and $hier_id != '1' and $enable_split_new = 'y'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">splitPage</xsl:with-param>
			<xsl:with-param name="langvar">ed_split_page</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- split page to next page -->
	<xsl:if test = "substring-after($hier_id,'_') = '' and $hier_id != '1' and $enable_split_next = 'y'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">splitPageNext</xsl:with-param>
			<xsl:with-param name="langvar">ed_split_page_next</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

<!-- Move Menu Items -->
<xsl:template name="MoveMenuItems">
	<xsl:if test="$javascript = 'disable'">
		<!-- move after -->
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">moveAfter</xsl:with-param>
			<xsl:with-param name="langvar">ed_moveafter</xsl:with-param>
		</xsl:call-template>

		<!-- move before -->
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">moveBefore</xsl:with-param>
			<xsl:with-param name="langvar">ed_movebefore</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

<!-- Insert Menu Items -->
<xsl:template name="EditMenuInsertItems">

	<!-- paste actual clipboard content -->
	<xsl:if test = "$paste = 'y'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">paste</xsl:with-param>
			<xsl:with-param name="langvar">ed_paste</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- insert placeholder -->
	<xsl:if test = "$enable_placeholder = 'y'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">insert_plach</xsl:with-param>
			<xsl:with-param name="langvar">ed_insert_plach</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- insert paragraph -->
	<xsl:call-template name="EditMenuItem">
		<xsl:with-param name="command">insert_par</xsl:with-param>
		<xsl:with-param name="langvar">ed_insert_par</xsl:with-param>
	</xsl:call-template>

	<!-- insert repository objects -->
	<xsl:if test = "$enable_rep_objects = 'y'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">insert_repobj</xsl:with-param>
			<xsl:with-param name="langvar">ed_insert_repobj</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- insert login page element -->
	<xsl:if test = "$enable_login_page = 'y'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">insert_lpe</xsl:with-param>
			<xsl:with-param name="langvar">ed_insert_login_page_element</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- insert media object -->
	<xsl:call-template name="EditMenuItem">
		<xsl:with-param name="command">insert_mob</xsl:with-param>
		<xsl:with-param name="langvar">ed_insert_media</xsl:with-param>
	</xsl:call-template>

	<!-- insert question -->
	<xsl:if test = "$enable_sa_qst = 'y'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">insert_pcqst</xsl:with-param>
			<xsl:with-param name="langvar">ed_insert_pcqst</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- insert file list -->
	<xsl:if test = "$enable_file_list = 'y'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">insert_flst</xsl:with-param>
			<xsl:with-param name="langvar">ed_insert_filelist</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- insert data table -->
	<xsl:call-template name="EditMenuItem">
		<xsl:with-param name="command">insert_dtab</xsl:with-param>
		<xsl:with-param name="langvar">ed_insert_dtable</xsl:with-param>
	</xsl:call-template>

	<!-- insert advanced table -->
	<xsl:call-template name="EditMenuItem">
		<xsl:with-param name="command">insert_tab</xsl:with-param>
		<xsl:with-param name="langvar">ed_insert_atable</xsl:with-param>
	</xsl:call-template>

	<!-- insert list -->
	<xsl:call-template name="EditMenuItem">
		<xsl:with-param name="command">insert_list</xsl:with-param>
		<xsl:with-param name="langvar">ed_insert_list</xsl:with-param>
	</xsl:call-template>

	<!-- insert grid -->
	<xsl:call-template name="EditMenuItem">
		<xsl:with-param name="command">insert_grid</xsl:with-param>
		<xsl:with-param name="langvar">ed_insert_grid</xsl:with-param>
	</xsl:call-template>

	<!-- insert section -->
	<xsl:call-template name="EditMenuItem">
		<xsl:with-param name="command">insert_sec</xsl:with-param>
		<xsl:with-param name="langvar">ed_insert_section</xsl:with-param>
	</xsl:call-template>

	<!-- insert tabbed content -->
	<xsl:if test = "$enable_tabs = 'y'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">insert_tabs</xsl:with-param>
			<xsl:with-param name="langvar">ed_insert_tabs</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- insert interactive image -->
	<xsl:call-template name="EditMenuItem">
		<xsl:with-param name="command">insert_iim</xsl:with-param>
		<xsl:with-param name="langvar">ed_insert_iim</xsl:with-param>
	</xsl:call-template>

	<!-- insert map (geographical) -->
	<xsl:if test = "$enable_map = 'y'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">insert_map</xsl:with-param>
			<xsl:with-param name="langvar">ed_insert_map</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- insert code -->
	<xsl:call-template name="EditMenuItem">
		<xsl:with-param name="command">insert_src</xsl:with-param>
		<xsl:with-param name="langvar">ed_insert_code</xsl:with-param>
	</xsl:call-template>

	<!-- insert content templates -->
	<xsl:if test = "$enable_content_templates = 'y'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">insert_templ</xsl:with-param>
			<xsl:with-param name="langvar">ed_insert_templ</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- insert content snippets -->
	<xsl:if test = "$enable_content_includes = 'y'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">insert_incl</xsl:with-param>
			<xsl:with-param name="langvar">ed_insert_incl</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- insert plugged component -->
	<xsl:for-each select="//ComponentPlugins/ComponentPlugin">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">insert_plug_<xsl:value-of select="@Name" /></xsl:with-param>
			<xsl:with-param name="text"><xsl:value-of select="@InsertText" /></xsl:with-param>
		</xsl:call-template>
	</xsl:for-each>

	<!-- insert profile -->
	<xsl:if test = "$enable_profile = 'y'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">insert_prof</xsl:with-param>
			<xsl:with-param name="langvar">ed_insert_profile</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- insert verification -->
	<xsl:if test = "$enable_verification = 'y'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">insert_vrfc</xsl:with-param>
			<xsl:with-param name="langvar">ed_insert_verification</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- insert blog -->
	<xsl:if test = "$enable_blog = 'y'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">insert_blog</xsl:with-param>
			<xsl:with-param name="langvar">ed_insert_blog</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- question overview -->
	<xsl:if test = "$enable_qover = 'y'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">insert_qover</xsl:with-param>
			<xsl:with-param name="langvar">ed_insert_qover</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- insert skills -->
	<xsl:if test = "$enable_skills = 'y'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">insert_skills</xsl:with-param>
			<xsl:with-param name="langvar">ed_insert_skills</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- insert learning history -->
	<xsl:if test = "$enable_learning_history = 'y'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">insert_lhist</xsl:with-param>
			<xsl:with-param name="langvar">ed_insert_learning_history</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- insert consultation hours -->
	<xsl:if test = "$enable_consultation_hours = 'y'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">insert_cach</xsl:with-param>
			<xsl:with-param name="langvar">ed_insert_consultation_hours</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- insert my_courses -->
	<xsl:if test = "$enable_my_courses = 'y'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">insert_mcrs</xsl:with-param>
			<xsl:with-param name="langvar">ed_insert_my_courses</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- insert amd_page_list -->
	<xsl:if test = "$enable_amd_page_list = 'y'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">insert_amdpl</xsl:with-param>
			<xsl:with-param name="langvar">ed_insert_amd_page_list</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- paste from clipboard -->
	<xsl:call-template name="EditMenuItem"><xsl:with-param name="command">pasteFromClipboard</xsl:with-param>
	<xsl:with-param name="langvar">ed_paste_clip</xsl:with-param></xsl:call-template>

</xsl:template>

<!-- Align Menu Items -->
<xsl:template name="EditMenuAlignItems">

	<!-- left align -->
	<xsl:call-template name="EditMenuItem">
		<xsl:with-param name="command">leftAlign</xsl:with-param>
		<xsl:with-param name="langvar">ed_align_left</xsl:with-param>
	</xsl:call-template>

	<!-- right align -->
	<xsl:call-template name="EditMenuItem">
		<xsl:with-param name="command">rightAlign</xsl:with-param>
		<xsl:with-param name="langvar">ed_align_right</xsl:with-param>
	</xsl:call-template>

	<!-- center align -->
	<xsl:call-template name="EditMenuItem">
		<xsl:with-param name="command">centerAlign</xsl:with-param>
		<xsl:with-param name="langvar">ed_align_center</xsl:with-param>
	</xsl:call-template>

	<!-- left float align -->
	<xsl:call-template name="EditMenuItem">
		<xsl:with-param name="command">leftFloatAlign</xsl:with-param>
		<xsl:with-param name="langvar">ed_align_left_float</xsl:with-param>
	</xsl:call-template>

	<!-- right float align -->
	<xsl:call-template name="EditMenuItem">
		<xsl:with-param name="command">rightFloatAlign</xsl:with-param>
		<xsl:with-param name="langvar">ed_align_right_float</xsl:with-param>
	</xsl:call-template>

</xsl:template>


<!-- Edit Menu Item-->
<xsl:template name="EditMenuItem">
	<xsl:param name="command"/>
	<xsl:param name="langvar"/>
	<xsl:param name="text"/>

	<xsl:if test = "$javascript = 'disable'">
		<option>
			<xsl:attribute name="value"><xsl:value-of select="$command"/></xsl:attribute>
			<xsl:if test="$text = ''">
				<xsl:value-of select="//LVs/LV[@name=$langvar]/@value"/>
			</xsl:if>
			<xsl:if test="$text != ''">
				<xsl:value-of select="$text"/>
			</xsl:if>
		</option>
	</xsl:if>
	<xsl:if test = "$javascript = 'enable'">
		<a href="#" class="ilGroupedListLE" onMouseOver="M_in(this);" onMouseOut="M_out(this);">
		<xsl:attribute name="onClick">doActionForm('cmd[exec]', 'command', '<xsl:value-of select="$command"/>', '', '<xsl:value-of select="name(.)"/>', '<xsl:value-of select="@Characteristic"/>'); return false;</xsl:attribute>
		<xsl:if test="$text = ''">
			<xsl:value-of select="//LVs/LV[@name=$langvar]/@value"/>
		</xsl:if>
		<xsl:if test="$text != ''">
			<xsl:value-of select="$text"/>
		</xsl:if>
		</a>
	</xsl:if>
</xsl:template>

<!-- Icon -->
<xsl:template name="Icon">
	<xsl:param name="img_src"/>
	<xsl:param name="img_id"/>
	<xsl:param name="ed_type"/>
	<xsl:param name="float">n</xsl:param>

	<span>
		<xsl:if test="$float = 'y'">
			<xsl:attribute name="style"></xsl:attribute>
		</xsl:if>
		<xsl:attribute name="data-hierid"><xsl:value-of select="@HierId"/></xsl:attribute>
		<xsl:attribute name="data-pcid"><xsl:value-of select="@PCID"/></xsl:attribute>
		<xsl:attribute name="data-copg-ed-type"><xsl:value-of select="$ed_type"/></xsl:attribute>
		<img>
		<xsl:attribute name="src"><xsl:value-of select="$img_src"/></xsl:attribute>
		</img>
	</span>
</xsl:template>

<!-- Drop Area for Adding -->
<xsl:template name="DropArea">
	<xsl:param name="hier_id"/>
	<xsl:param name="pc_id"/>
<!-- <xsl:value-of select="$hier_id"/> -->
	<!-- Drop area -->
	<xsl:if test="$javascript != 'disable'">
		<div data-copg-ed-type="add-area">
			<xsl:attribute name="data-hierid"><xsl:value-of select="@HierId"/></xsl:attribute>
			<xsl:attribute name="data-pcid"><xsl:value-of select="@PCID"/></xsl:attribute>
			<xsl:attribute name="id">add<xsl:value-of select="@PCID"/></xsl:attribute>
			<xsl:comment>dummy</xsl:comment>
		</div>
	</xsl:if>
</xsl:template>

<!-- Paragraph -->
<xsl:template match="Paragraph">
	<xsl:param name="par_counter" select="-1" />
	<xsl:comment>ParStart</xsl:comment>
	<xsl:choose>
		<xsl:when test="@Characteristic = 'Headline1'">
			<xsl:variable name="char_name">
				<xsl:call-template name="CharacteristicName">
					<xsl:with-param name="pctype">headline1</xsl:with-param>
					<xsl:with-param name="characteristic"><xsl:value-of select="@Characteristic"/></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
		<!-- Label -->
		<xsl:call-template name="EditLabel"><xsl:with-param name="text"><xsl:value-of select="//LVs/LV[@name='pc_par']/@value"/> <xsl:value-of select="$char_name"/></xsl:with-param></xsl:call-template>
		<xsl:comment>ilPageTocH1<xsl:number count="Paragraph" level="any"/></xsl:comment>
		<h1><xsl:attribute name="id">ilPageTocA1<xsl:number count="Paragraph" level="any"/></xsl:attribute>
			<xsl:call-template name="ShowParagraph"/>
			<xsl:comment>Break</xsl:comment>
		</h1>
		</xsl:when>
		<xsl:when test="@Characteristic = 'Headline2'">
			<xsl:variable name="char_name">
				<xsl:call-template name="CharacteristicName">
					<xsl:with-param name="pctype">heading2</xsl:with-param>
					<xsl:with-param name="characteristic"><xsl:value-of select="@Characteristic"/></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<!-- Label -->
		<xsl:call-template name="EditLabel"><xsl:with-param name="text"><xsl:value-of select="//LVs/LV[@name='pc_par']/@value"/> <xsl:value-of select="$char_name"/></xsl:with-param></xsl:call-template>
		<xsl:comment>ilPageTocH2<xsl:number count="Paragraph" level="any"/></xsl:comment>
		<h2><xsl:attribute name="id">ilPageTocA2<xsl:number count="Paragraph" level="any"/></xsl:attribute>
			<xsl:call-template name="ShowParagraph"/>
			<xsl:comment>Break</xsl:comment>
		</h2>
		</xsl:when>
		<xsl:when test="@Characteristic = 'Headline3'">
			<xsl:variable name="char_name">
				<xsl:call-template name="CharacteristicName">
					<xsl:with-param name="pctype">heading3</xsl:with-param>
					<xsl:with-param name="characteristic"><xsl:value-of select="@Characteristic"/></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
		<!-- Label -->
		<xsl:call-template name="EditLabel"><xsl:with-param name="text"><xsl:value-of select="//LVs/LV[@name='pc_par']/@value"/> <xsl:value-of select="$char_name"/></xsl:with-param></xsl:call-template>
		<xsl:comment>ilPageTocH3<xsl:number count="Paragraph" level="any"/></xsl:comment>
		<h3><xsl:attribute name="id">ilPageTocA3<xsl:number count="Paragraph" level="any"/></xsl:attribute>
			<xsl:call-template name="ShowParagraph"/>
			<xsl:comment>Break</xsl:comment>
		</h3>
		</xsl:when>
		<xsl:when test="./SimpleBulletList or ./SimpleNumberedList">
			<xsl:variable name="char_name">
				<xsl:call-template name="CharacteristicName">
					<xsl:with-param name="pctype">heading3</xsl:with-param>
					<xsl:with-param name="characteristic"><xsl:value-of select="@Characteristic"/></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<!-- Label -->
			<xsl:call-template name="EditLabel"><xsl:with-param name="text"><xsl:value-of select="//LVs/LV[@name='pc_par']/@value"/>  <xsl:value-of select="$char_name"/></xsl:with-param></xsl:call-template>
			<div>
				<xsl:call-template name="ShowParagraph"/>
				<xsl:comment>Break</xsl:comment>
			</div>
		</xsl:when>
		<xsl:when test="not (@Characteristic) or @Characteristic != 'Code'">
			<xsl:variable name="char_name">
				<xsl:call-template name="CharacteristicName">
					<xsl:with-param name="pctype">text_block</xsl:with-param>
					<xsl:with-param name="characteristic"><xsl:value-of select="@Characteristic"/></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
		<!-- Label -->
		<xsl:call-template name="EditLabel"><xsl:with-param name="text"><xsl:value-of select="//LVs/LV[@name='pc_par']/@value"/>  <xsl:value-of select="$char_name"/></xsl:with-param></xsl:call-template>
		<p>
			<xsl:call-template name="ShowParagraph"/>
			<xsl:comment>Break</xsl:comment>
		</p>
		</xsl:when>
		<xsl:otherwise>
			<!-- Label -->
			<xsl:call-template name="EditLabel"><xsl:with-param name="text"><xsl:value-of select="//LVs/LV[@name='pc_code']/@value"/></xsl:with-param></xsl:call-template>
			<xsl:call-template name="ShowParagraph">
				<xsl:with-param name="p_id" select="$par_counter" />
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:comment>ParEnd</xsl:comment>
</xsl:template>

<xsl:template name="ShowParagraph">
	<xsl:param name="p_id" select = "-1"/>
	<xsl:if test="$mode = 'edit' and not (@Characteristic = 'Code')">
		<xsl:attribute name="style">position:static;</xsl:attribute>
	</xsl:if>
	<xsl:choose>
		<xsl:when test="not(@Characteristic)">
			<xsl:attribute name="class">ilc_Paragraph ilc_text_block_Standard</xsl:attribute>
		</xsl:when>
		<xsl:when test="@Characteristic = 'Headline1'">
			<xsl:attribute name="class">ilc_Paragraph ilc_heading1_Headline1</xsl:attribute>
			<xsl:comment>PageTocPH</xsl:comment>
		</xsl:when>
		<xsl:when test="@Characteristic = 'Headline2'">
			<xsl:attribute name="class">ilc_Paragraph ilc_heading2_Headline2</xsl:attribute>
			<xsl:comment>PageTocPH</xsl:comment>
		</xsl:when>
		<xsl:when test="@Characteristic = 'Headline3'">
			<xsl:attribute name="class">ilc_Paragraph ilc_heading3_Headline3</xsl:attribute>
			<xsl:comment>PageTocPH</xsl:comment>
		</xsl:when>
		<xsl:when test="not (@Characteristic = 'Code')">
			<xsl:attribute name="class">ilc_Paragraph ilc_text_block_<xsl:value-of select="@Characteristic"/></xsl:attribute>
		</xsl:when>
	</xsl:choose>
	<xsl:call-template name="EditReturnAnchors"/>
	<!-- content -->
	<xsl:choose>
		<xsl:when test="@Characteristic = 'Code'">
			<xsl:call-template name='Sourcecode'>
				<!-- <xsl:with-param name="p_id" select="$p_id" /> -->
			<xsl:with-param name="p_id"><xsl:number count="Paragraph" level="any"/></xsl:with-param>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
		<xsl:apply-templates/>
		</xsl:otherwise>
	</xsl:choose>

	<!-- command selectbox -->
	<!-- <xsl:if test="$mode = 'edit'">
		<br />
		<xsl:if test="((../../../../@DataTable != 'y' or not(../../../../@DataTable)))">
			<xsl:if test="$javascript='disable'">
			<br />
			<input type="checkbox" name="target[]">
				<xsl:attribute name="value"><xsl:value-of select="../@HierId"/>:<xsl:value-of select="../@PCID"/>
				</xsl:attribute>
			</input>
			</xsl:if>
			<xsl:call-template name="EditMenu">
				<xsl:with-param name="hier_id" select="../@HierId" />
				<xsl:with-param name="pc_id" select="../@PCID" />
				<xsl:with-param name="edit">y</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:if> -->
</xsl:template>

<xsl:template name="Sourcecode">
	<xsl:param name="p_id" select="-1"/>
	<div class="ilc_Code">
		<table class="ilc_Sourcecode" cellpadding="0" cellspacing="0" border="0">
		<!--- <xsl:value-of select="." /> -->
		[[[[[Code;<xsl:number count="Paragraph" level="any"/>]]]]]
		<xsl:if test="@DownloadTitle != ''" >
				<xsl:variable name="downloadtitle" select="@DownloadTitle"/>
				<xsl:choose>
					<xsl:when test="$mode = 'offline'" >
							<xsl:variable name="href" select="concat($webspace_path,'codefiles/',$pg_id,'/',$p_id,'/',$downloadtitle)"/>
							<xsl:call-template name="DownloadLink">
								<xsl:with-param name="p_id" select="$p_id"/>
								<xsl:with-param name="downloadtitle" select="$downloadtitle"/>
								<xsl:with-param name="href" select="$href"/>
								<xsl:with-param name="subchar" select="-1"/>
							</xsl:call-template>
					</xsl:when>
					<xsl:when test="$mode = '' or $mode = 'presentation' or $mode = 'preview' or $mode = 'edit'" >
						<xsl:variable name="href" select="concat($download_script,'&amp;cmd=download_paragraph&amp;downloadtitle=',$downloadtitle,'&amp;pg_id=',$pg_id,'&amp;par_id=',$p_id)"/>
						<xsl:call-template name="DownloadLink">
							<xsl:with-param name="p_id" select="$p_id"/>
							<xsl:with-param name="downloadtitle" select="$downloadtitle"/>
							<xsl:with-param name="href" select="$href"/>
							<xsl:with-param name="subchar" select="@SubCharacteristic"/>
						</xsl:call-template>
					</xsl:when >
				</xsl:choose>
		</xsl:if>
		</table>
	</div>
</xsl:template>

<xsl:template name="DownloadLink">
	<xsl:param name="p_id" select="-1"/>
	<xsl:param name="downloadtitle" select="-1"/>
	<xsl:param name="href" select="'-1'"/>
	<xsl:param name="subchar" select="'-1'"/>

	<xsl:if test="$href != '-1'">
		<tr><td colspan="2"><div>
		<a href="{$href}"><xsl:value-of select="//LVs/LV[@name='download']/@value"/></a>

		<xsl:if test="$paragraph_plugins != '-1' and $subchar != '-1'">
			<xsl:call-template name="plugins">
				<xsl:with-param name="pluginsString" select="$paragraph_plugins"/>
				<xsl:with-param name="subchar" select="@SubCharacteristic"/>
				<xsl:with-param name="par_vars" select="concat('&amp;download=',$encoded_download_script,'&amp;downloadtitle=',$downloadtitle,'&amp;pg_id=',$pg_id,'&amp;par_id=',$p_id)"/>
			</xsl:call-template>
		</xsl:if>

		</div></td></tr>
	</xsl:if>
</xsl:template>

<!-- plugins for code paragraphs -->
<xsl:template name="plugins">
		<xsl:param name="pluginsString" select="'-1'"/>
		<xsl:param name="subchar" select="'-1'"/>
		<xsl:param name="par_vars" select="''"/>
		<xsl:choose>
			<xsl:when test="string-length(substring-before($pluginsString,'|')) =0">
				<xsl:call-template name="plugin">
					<xsl:with-param name="pluginString" select="$pluginsString"/>
					<xsl:with-param name="subchar" select="$subchar"/>
					<xsl:with-param name="par_vars" select="$par_vars"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="plugin">
					<xsl:with-param name="pluginString" select="substring-before($pluginsString,'|')"/>
					<xsl:with-param name="subchar" select="$subchar"/>
					<xsl:with-param name="par_vars" select="$par_vars"/>
				</xsl:call-template>
				<xsl:variable name="restString" select="substring-after($pluginsString,'|')"/>
				<xsl:if test="string-length($restString)>0">
					<xsl:call-template name="plugins">
						<xsl:with-param name="pluginsString" select="$restString"/>
						<xsl:with-param name="subchar" select="$subchar"/>
					<xsl:with-param name="par_vars" select="$par_vars"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
</xsl:template>

<!-- defines content plugin -->
<xsl:template name="plugin">
		<xsl:param name="pluginString" select="'-1'"/>
		<xsl:param name="subchar" select="'-1'"/>
		<xsl:param name="par_vars" select="''"/>

		<xsl:variable name="filetype" select="substring-before($pluginString,'#')"/>
		<xsl:variable name="rest1" select="substring-after($pluginString,'#')"/>
		<xsl:variable name="title" select="substring-before($rest1,'#')"/>
		<xsl:variable name="rest2" select="substring-after($rest1,'#')"/>

		<xsl:variable name="linkNode" >
			<xsl:choose>
				<xsl:when test="substring-before($rest2,'#')=''">
					<xsl:value-of select="$rest2"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="substring-before($rest2,'#')"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="link" select="concat(string($linkNode),$par_vars)"/>
		<xsl:variable name="image" select="substring-after($rest2,'#')"/>


<!--		<filetype><xsl:value-of select="$filetype"/></filetype>
		<title><xsl:value-of select="$title"/></title>
		<link><xsl:value-of select="$link"/></link>
		 <image><xsl:value-of select="$image"/></image>
		<subchar><xsl:value-of select="$subchar"/></subchar> -->

		 <xsl:if test="$subchar = $filetype or $filetype='-1'">
			 <span style="margin-left: 5px"><a href="{$link}" ><img src="{$image}" alt="{$title}" border="0" /></a></span>
		 </xsl:if>
</xsl:template>

<!-- Emph, Strong, Comment, Quotation -->
<xsl:template match="Strong">
	<strong class="ilc_strong_Strong"><xsl:apply-templates/></strong>
</xsl:template>
<xsl:template match="Emph">
	<em class="ilc_em_Emph"><xsl:apply-templates/></em>
</xsl:template>
<xsl:template match="Comment|Quotation|Important|Accent">
	<xsl:variable name="Tagname" select="name()"/>
	<span class="ilc_text_inline_{$Tagname}"><xsl:apply-templates/></span>
</xsl:template>

<!-- Marked -->
<xsl:template match="Marked">
	<xsl:variable name="Class" select="@Class"/>
	<span class="ilc_text_inline_{$Class}"><xsl:apply-templates/></span>
</xsl:template>

	<!-- Code -->
<xsl:template match="Code">
	<code class="ilc_code_inline_CodeInline"><xsl:apply-templates/></code>
</xsl:template>

<!-- Sup -->
<xsl:template match="Sup">
	<sup class="ilc_sup_Sup"><xsl:apply-templates/></sup>
</xsl:template>

<!-- Sub -->
<xsl:template match="Sub">
	<sub class="ilc_sub_Sub"><xsl:apply-templates/></sub>
</xsl:template>

<!-- Footnote (Links) -->
	<xsl:template match="Footnote"><xsl:if test="$mode != 'edit' and $append_footnotes='y'"><a class="ilc_link_FootnoteLink"><xsl:attribute name="href">#fn<xsl:number count="Footnote" level="any"/></xsl:attribute>[<xsl:number count="Footnote" level="any"/>]</a></xsl:if><xsl:if test="$mode = 'edit' or $append_footnotes!='y'">[fn]<xsl:apply-templates/>[/fn]</xsl:if>
</xsl:template>


<!-- InitOpenedContent -->
<xsl:template match="InitOpenedContent">
<xsl:apply-templates select="IntLink"/>
</xsl:template>


<!-- IntLink -->
<xsl:template match="IntLink">
	<xsl:variable name="target" select="@Target"/>
	<xsl:variable name="type" select="@Type"/>
	<xsl:variable name="anchor" select="@Anchor"/>
	<xsl:variable name="targetframe">
		<xsl:choose>
			<xsl:when test="@TargetFrame">
				<xsl:value-of select="@TargetFrame"/>
			</xsl:when>
			<xsl:otherwise>None</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:choose>
		<xsl:when test="name(..) = 'Section'">
		</xsl:when>
		<!-- internal link to external resource (other installation) -->
		<xsl:when test="substring-after(@Target,'__') = ''">
			[could not resolve link target: <xsl:value-of select="@Target"/>]
		</xsl:when>
		<!-- initial opened content -->
		<xsl:when test="name(..) = 'InitOpenedContent'">
			<xsl:variable name="link_href">
				<xsl:value-of select="//IntLinkInfos/IntLinkInfo[@Type=$type and @TargetFrame=$targetframe and @Target=$target and @Anchor=concat('',$anchor)]/@LinkHref"/>
			</xsl:variable>
			<xsl:variable name="link_target">
				<xsl:value-of select="//IntLinkInfos/IntLinkInfo[@Type=$type and @TargetFrame=$targetframe and @Target=$target and @Anchor=concat('',$anchor)]/@LinkTarget"/>
			</xsl:variable>
			<xsl:if test="$mode != 'edit' and $mode != 'preview'">
			<script type="text/javascript">
				il.Util.addOnLoad(function() {il.LearningModule.initContentFrame('<xsl:value-of select='$link_href'/>', '<xsl:value-of select='$link_target'/>');});
			</script>
			</xsl:if>
		</xsl:when>
		<!-- all internal links except inline mob vris -->
		<xsl:when test="((@Type != 'MediaObject' or @TargetFrame) and @Type != 'User')">
			<xsl:if test="$mode != 'print'">
				<xsl:choose>
					<xsl:when test="//IntLinkInfos/IntLinkInfo[@Type=$type and @TargetFrame=$targetframe and @Target=$target and @Anchor=concat('',$anchor)]/@LinkHref">
						<a class="ilc_link_IntLink">
							<xsl:call-template name="SetIntLinkAttributes"><xsl:with-param name="targetframe"><xsl:value-of select="$targetframe"/></xsl:with-param></xsl:call-template>
							<xsl:if test="@Type = 'File'">
								<xsl:attribute name="class">ilc_link_FileLink</xsl:attribute>
							</xsl:if>
							<xsl:if test="@Type = 'GlossaryItem'">
								<xsl:attribute name="class">ilc_link_GlossaryLink</xsl:attribute>
							</xsl:if>
							<xsl:apply-templates/>
						</a>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="$mode = 'edit'">[Link Target Not Found] </xsl:if>
						<xsl:apply-templates/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="$mode = 'print'">
				<span class="ilc_Print_IntLink">
					<xsl:apply-templates/>
				</span>
			</xsl:if>

		</xsl:when>
		<!-- inline mob vri -->
		<xsl:when test="@Type = 'MediaObject' and not(@TargetFrame)">
			<xsl:variable name="cmobid" select="@Target"/>

			<!-- determine location type (LocalFile, Reference) -->
			<xsl:variable name="curType">
				<xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose = 'Standard']/Location/@Type"/>
			</xsl:variable>

			<!-- determine format (mime type) -->
			<xsl:variable name="mtype">
				<xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose = 'Standard']/Format"/>
			</xsl:variable>

			<!-- determine location -->
			<xsl:variable name="data">
				<xsl:if test="$curType = 'LocalFile'">
					<xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose = 'Standard']/Location"/>
				</xsl:if>
				<xsl:if test="$curType = 'Reference'">
					<xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose = 'Standard']/Location"/>
				</xsl:if>
			</xsl:variable>

			<!-- determine size mode (alias, mob or none) -->
			<xsl:variable name="sizemode">mob</xsl:variable>

			<!-- determine width -->
			<xsl:variable name="width">
				<xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose='Standard']/Layout[1]/@Width"/>
			</xsl:variable>

			<!-- determine height -->
			<xsl:variable name="height">
				<xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose='Standard']/Layout[1]/@Height"/>
			</xsl:variable>

			<xsl:call-template name="MOBTag">
				<xsl:with-param name="data" select="$data" />
				<xsl:with-param name="type" select="$mtype" />
				<xsl:with-param name="width" select="$width" />
				<xsl:with-param name="height" select="$height" />
				<xsl:with-param name="curPurpose" >Standard</xsl:with-param>
				<xsl:with-param name="cmobid" select="$cmobid" />
				<xsl:with-param name="location_mode">standard</xsl:with-param>
				<xsl:with-param name="curType" select="$curType" />
				<xsl:with-param name="inline">y</xsl:with-param>
			</xsl:call-template>

		</xsl:when>

		<!-- user -->
		<xsl:when test="@Type = 'User'">
			<xsl:variable name="href" select="//IntLinkInfos/IntLinkInfo[@Type='User' and @Target=$target]/@LinkHref"/>
			<xsl:variable name="link_target" select="//IntLinkInfos/IntLinkInfo[@Type='User' and @Target=$target]/@LinkTarget"/>
			<xsl:if test="$href != ''">
				<a class="ilc_link_IntLink">
					<xsl:if test="$enable_href">
						<xsl:attribute name="href"><xsl:value-of select="$href"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="$link_target != ''">
						<xsl:attribute name="target"><xsl:value-of select="$link_target"/></xsl:attribute>
					</xsl:if>
					<xsl:value-of select="//IntLinkInfos/IntLinkInfo[@Type='User' and @Target=$target]/@LinkContent"/>
				</a>
			</xsl:if>
			<xsl:if test="$href = ''">
				<xsl:value-of select="//IntLinkInfos/IntLinkInfo[@Type='User' and @Target=$target]/@LinkContent"/>
			</xsl:if>
		</xsl:when>

	</xsl:choose>
</xsl:template>

<xsl:template match="IntLinkInfos">
</xsl:template>

<xsl:template match="LinkTargets">
</xsl:template>

<xsl:template match="StyleTemplates">
</xsl:template>

<xsl:template name="SetIntLinkAttributes">
	<xsl:param name="targetframe"/>
	<xsl:variable name="target" select="@Target"/>
	<xsl:variable name="type" select="@Type"/>
	<xsl:variable name="anchor" select="@Anchor"/>
	<xsl:variable name="link_href">
		<xsl:value-of select="//IntLinkInfos/IntLinkInfo[@Type=$type and @TargetFrame=$targetframe and @Target=$target and @Anchor=concat('',$anchor)]/@LinkHref"/>
	</xsl:variable>
	<xsl:variable name="link_target">
		<xsl:value-of select="//IntLinkInfos/IntLinkInfo[@Type=$type and @TargetFrame=$targetframe and @Target=$target and @Anchor=concat('',$anchor)]/@LinkTarget"/>
	</xsl:variable>
	<xsl:variable name="on_click">
		<xsl:value-of select="//IntLinkInfos/IntLinkInfo[@Type=$type and @TargetFrame=$targetframe and @Target=$target and @Anchor=concat('',$anchor)]/@OnClick"/>
	</xsl:variable>
	<xsl:if test="$enable_href">
		<xsl:attribute name="href"><xsl:value-of select="$link_href"/></xsl:attribute>
	</xsl:if>
	<xsl:if test="$link_target != ''">
		<xsl:attribute name="target"><xsl:value-of select="$link_target"/></xsl:attribute>
	</xsl:if>
	<xsl:if test="//LinkTargets/LinkTarget[@TargetFrame=$targetframe]/@OnClick">
		<xsl:attribute name="onclick"><xsl:value-of select="//LinkTargets/LinkTarget[@TargetFrame=$targetframe]/@OnClick"/></xsl:attribute>
	</xsl:if>
	<xsl:if test="$on_click != ''">
		<xsl:attribute name="on_click"><xsl:value-of select="$on_click"/></xsl:attribute>
	</xsl:if>
	<xsl:attribute name="id"><xsl:value-of select="$target"/>_<xsl:value-of select="$pg_id"/>_<xsl:number count="IntLink" level="any"/></xsl:attribute>
</xsl:template>

<!-- ExtLink -->
<xsl:template match="ExtLink">
	<xsl:if test="not(name(..) = 'Section')">
	<a class="ilc_link_ExtLink" rel="noopener">
		<xsl:call-template name="SetExtLinkAttributes" />
		<xsl:apply-templates/>
	</a>
	</xsl:if>
</xsl:template>

<!-- SetExtLinkAttributes -->
<xsl:template name="SetExtLinkAttributes">
	<xsl:variable name="targetframe"><xsl:value-of select="@TargetFrame"/></xsl:variable>
	<xsl:variable name="link_target">
		<xsl:if test="$targetframe != ''"><xsl:value-of select="//LinkTargets/LinkTarget[@TargetFrame=$targetframe]/@LinkTarget"/></xsl:if>
		<xsl:if test="$targetframe = ''">_blank</xsl:if>
	</xsl:variable>
	<xsl:if test="//LinkTargets/LinkTarget[@TargetFrame=$targetframe]/@OnClick">
		<xsl:attribute name="onclick"><xsl:value-of select="//LinkTargets/LinkTarget[@TargetFrame=$targetframe]/@OnClick"/></xsl:attribute>
	</xsl:if>
	<xsl:attribute name="target"><xsl:value-of select="$link_target"/></xsl:attribute>
	<xsl:if test="$enable_href">
		<xsl:attribute name="href"><xsl:value-of select="@Href"/></xsl:attribute>
	</xsl:if>
</xsl:template>

	<!-- Tables -->
<xsl:template match="Table">
	<!-- Label -->
	<xsl:if test="@DataTable != 'y' or not(@DataTable)">
	<xsl:call-template name="EditLabel"><xsl:with-param name="text"><xsl:value-of select="//LVs/LV[@name='pc_tab']/@value"/> <xsl:if test="@Template"> (<xsl:value-of select="@Template"/>)</xsl:if></xsl:with-param></xsl:call-template>
	</xsl:if>
	<xsl:if test="@DataTable = 'y'">
	<xsl:call-template name="EditLabel"><xsl:with-param name="text"><xsl:value-of select="//LVs/LV[@name='pc_dtab']/@value"/> <xsl:if test="@Template"> (<xsl:value-of select="@Template"/>)</xsl:if></xsl:with-param></xsl:call-template>
	</xsl:if>

	<!-- <xsl:value-of select="@HierId"/> -->
	<xsl:if test="$mode = 'edit' and $javascript='disable'">
		<br/>
	</xsl:if>
	<xsl:call-template name="EditReturnAnchors"/>
	<xsl:call-template name="TableTag" />
</xsl:template>

<!-- Table Tag -->
<xsl:template name="TableTag">
	<table>
	<xsl:variable name="ttemp" select="@Template"/>
	<xsl:variable name = "headerrows" select = "@HeaderRows"/>
	<xsl:variable name = "footerrows" select = "@FooterRows"/>
	<xsl:variable name = "headercols" select = "@HeaderCols"/>
	<xsl:variable name = "footercols" select = "@FooterCols"/>
	<xsl:choose>
		<xsl:when test="@Template and //StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='table']/@Value">
			<xsl:attribute name = "class">ilc_table_<xsl:value-of select = "//StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='table']/@Value"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="@Class">
			<xsl:attribute name="class">ilc_table_<xsl:value-of select="@Class"/></xsl:attribute>
		</xsl:when>
		<xsl:otherwise>
			<xsl:attribute name="class">ilc_table_StandardTable</xsl:attribute>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:if test="$mode != 'edit' or not(@HorizontalAlign) or (@HorizontalAlign != 'RightFloat' and @HorizontalAlign != 'LeftFloat')">
		<xsl:attribute name="width"><xsl:value-of select="@Width"/></xsl:attribute>
	</xsl:if>
	<xsl:if test="$mode = 'edit' and (@HorizontalAlign = 'RightFloat' or @HorizontalAlign = 'LeftFloat')">
		<xsl:attribute name="width">100%</xsl:attribute><!-- old -->
		<xsl:attribute name="width"></xsl:attribute>
	</xsl:if>
	<!-- <xsl:attribute name="border"><xsl:value-of select="@Border"/></xsl:attribute>
	<xsl:attribute name="cellspacing"><xsl:value-of select="@CellSpacing"/></xsl:attribute>
	<xsl:attribute name="cellpadding"><xsl:value-of select="@CellPadding"/></xsl:attribute> -->
	<xsl:if test="$mode = 'edit'">
		<xsl:attribute name="style">
			<xsl:choose>
				<xsl:when test="@HorizontalAlign = 'RightFloat' and $disable_auto_margins != 'y'">margin-right: 0px;</xsl:when>
				<xsl:when test="@HorizontalAlign = 'LeftFloat' and $disable_auto_margins != 'y'">margin-left: 0px;</xsl:when>
				<xsl:when test="@HorizontalAlign = 'Center'">margin-left: auto; margin-right: auto;</xsl:when>
			</xsl:choose>
		</xsl:attribute>
	</xsl:if>
	<xsl:if test="$mode != 'edit'">
		<xsl:attribute name="style">
			<xsl:if	test="$disable_auto_margins != 'y'">
				<xsl:choose>
					<xsl:when test="@HorizontalAlign = 'RightFloat'">float:right; margin-right: 0px;</xsl:when>
					<xsl:when test="@HorizontalAlign = 'LeftFloat'">float:left; margin-left: 0px;</xsl:when>
					<xsl:when test="@HorizontalAlign = 'Center'">margin-left: auto; margin-right: auto;</xsl:when>
				</xsl:choose>
			</xsl:if>
			<xsl:if	test="$disable_auto_margins = 'y'">
				<xsl:choose>
					<xsl:when test="@HorizontalAlign = 'RightFloat'">float:right;</xsl:when>
					<xsl:when test="@HorizontalAlign = 'LeftFloat'">float:left;</xsl:when>
					<xsl:when test="@HorizontalAlign = 'Center'">margin-left: auto; margin-right: auto;</xsl:when>
				</xsl:choose>
			</xsl:if>
		</xsl:attribute>
	</xsl:if>
	<xsl:choose>
		<xsl:when test="@HorizontalAlign = 'Left'">
			<xsl:attribute name="style">margin-right:auto; margin-left:0;</xsl:attribute>
		</xsl:when>
		<xsl:when test="@HorizontalAlign = 'Right'">
			<xsl:attribute name="style">margin-right:0; margin-left:auto;</xsl:attribute>
		</xsl:when>
	</xsl:choose>
	<xsl:for-each select="Caption">
		<caption>
		<xsl:if test="../@Template and //StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='caption']/@Value">
			<xsl:attribute name = "class">ilc_table_caption_<xsl:value-of select = "//StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='caption']/@Value"/></xsl:attribute>
		</xsl:if>
		<xsl:attribute name="align"><xsl:value-of select="@Align"/></xsl:attribute>
		<xsl:value-of select="."/>
		</caption>
	</xsl:for-each>
	<xsl:variable name = "rows" select = "count(./TableRow)"/>
	<xsl:for-each select = "TableRow">
		<xsl:variable name = "rowpos" select = "position()"/>
		<tr style="vertical-align: top">
			<xsl:variable name = "cols" select = "count(./TableData)"/>
			<xsl:for-each select = "TableData">
				<xsl:if test="not(@Hidden) or @Hidden != 'Y'">
					<xsl:variable name = "colpos" select = "position()"/>
					<xsl:choose>
					<xsl:when test="../../@Template and
						(//StyleTemplates/StyleTemplate[@Name=$ttemp and $headerrows >= $rowpos] or
						//StyleTemplates/StyleTemplate[@Name=$ttemp and $headercols >= $colpos])">
						<th>
							<xsl:call-template name="TableDataContent">
								<xsl:with-param name="cols" select="$cols"/>
								<xsl:with-param name="rows" select="$rows"/>
								<xsl:with-param name="rowpos" select="$rowpos"/>
								<xsl:with-param name="ttemp" select="$ttemp"/>
								<xsl:with-param name="headerrows" select="$headerrows"/>
								<xsl:with-param name="headercols" select="$headercols"/>
								<xsl:with-param name="footerrows" select="$footerrows"/>
								<xsl:with-param name="footercols" select="$footercols"/>
							</xsl:call-template>
						</th>
					</xsl:when>
					<xsl:otherwise>
						<td>
							<xsl:call-template name="TableDataContent">
								<xsl:with-param name="cols" select="$cols"/>
								<xsl:with-param name="rows" select="$rows"/>
								<xsl:with-param name="rowpos" select="$rowpos"/>
								<xsl:with-param name="ttemp" select="$ttemp"/>
								<xsl:with-param name="headerrows" select="$headerrows"/>
								<xsl:with-param name="headercols" select="$headercols"/>
								<xsl:with-param name="footerrows" select="$footerrows"/>
								<xsl:with-param name="footercols" select="$footercols"/>
							</xsl:call-template>
						</td>
					</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:for-each>
		</tr>
	</xsl:for-each>
	</table>
</xsl:template>

<!-- Table Tag -->
<xsl:template name="TableDataContent">
	<xsl:param name="cols" />
	<xsl:param name="rows" />
	<xsl:param name="rowpos" />
	<xsl:param name="ttemp" />
	<xsl:param name="headerrows" />
	<xsl:param name="footerrows" />
	<xsl:param name="headercols" />
	<xsl:param name="footercols" />
	<xsl:if test="@HorizontalAlign and @HorizontalAlign != ''">
		<xsl:attribute name="align"><xsl:choose>
			<xsl:when test="@HorizontalAlign = 'Left'">left</xsl:when>
			<xsl:when test="@HorizontalAlign = 'Right'">right</xsl:when>
			<xsl:when test="@HorizontalAlign = 'Center'">center</xsl:when>
		</xsl:choose></xsl:attribute>
	</xsl:if>
	<xsl:if test="@ColSpan and number(@ColSpan) > 1">
		<xsl:attribute name="colspan"><xsl:value-of select = "@ColSpan"/></xsl:attribute>
	</xsl:if>
	<xsl:if test="@RowSpan and number(@RowSpan) > 1">
		<xsl:attribute name="rowspan"><xsl:value-of select = "@RowSpan"/></xsl:attribute>
	</xsl:if>
	<xsl:choose>
		<xsl:when test="substring(@Class, 1, 4) = 'ilc_'">
			<xsl:attribute name = "class">ilc_table_cell_<xsl:value-of select="substring-after(@Class, 'ilc_')"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="@Class and @Class != ''">
			<xsl:attribute name = "class">ilc_table_cell_<xsl:value-of select = "@Class"/></xsl:attribute>
		</xsl:when>
		<!-- header row -->
		<xsl:when test="../../@Template and //StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='row_head']/@Value and number($headerrows) >= number($rowpos)">
			<xsl:attribute name = "class">ilc_table_cell_<xsl:value-of select = "//StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='row_head']/@Value"/></xsl:attribute>
		</xsl:when>
		<!-- last row -->
		<xsl:when test="../../@Template and //StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='row_foot']/@Value and $rowpos > ($rows - number($footerrows))">
			<xsl:attribute name = "class">ilc_table_cell_<xsl:value-of select = "//StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='row_foot']/@Value"/></xsl:attribute>
		</xsl:when>
		<!-- first col -->
		<xsl:when test="../../@Template and //StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='col_head']/@Value and number($headercols) >= position()">
			<xsl:attribute name = "class">ilc_table_cell_<xsl:value-of select = "//StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='col_head']/@Value"/></xsl:attribute>
		</xsl:when>
		<!-- last col -->
		<xsl:when test="../../@Template and //StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='col_foot']/@Value and position() > ($cols - number($footercols))">
			<xsl:attribute name = "class">ilc_table_cell_<xsl:value-of select = "//StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='col_foot']/@Value"/></xsl:attribute>
		</xsl:when>
		<!-- even row -->
		<xsl:when test="../../@Template and //StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='even_row']/@Value and $rowpos mod 2 = 0">
			<xsl:attribute name = "class">ilc_table_cell_<xsl:value-of select = "//StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='even_row']/@Value"/></xsl:attribute>
		</xsl:when>
		<!-- odd row -->
		<xsl:when test="../../@Template and //StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='odd_row']/@Value and $rowpos mod 2 = 1">
			<xsl:attribute name = "class">ilc_table_cell_<xsl:value-of select = "//StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='odd_row']/@Value"/></xsl:attribute>
		</xsl:when>
		<!-- even col -->
		<xsl:when test="../../@Template and //StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='even_col']/@Value and position() mod 2 = 0">
			<xsl:attribute name = "class">ilc_table_cell_<xsl:value-of select = "//StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='even_col']/@Value"/></xsl:attribute>
		</xsl:when>
		<!-- odd col -->
		<xsl:when test="../../@Template and //StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='odd_col']/@Value and position() mod 2 = 1">
			<xsl:attribute name = "class">ilc_table_cell_<xsl:value-of select = "//StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='odd_col']/@Value"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="number($headerrows) >= number($rowpos)">
			<xsl:attribute name = "class">ilc_table_cell_StandardHeader</xsl:attribute>
		</xsl:when>
		<xsl:otherwise>
			<xsl:attribute name = "class">ilc_table_cell_StandardCell1</xsl:attribute>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:attribute name = "width"><xsl:value-of select = "@Width"/></xsl:attribute>

	<!--
	<xsl:attribute name = "style">
		<xsl:if test="../../@CellPadding">padding: <xsl:value-of select="../../@CellPadding"/>;</xsl:if>
		<xsl:if test="../../@Border">border: solid <xsl:value-of select="../../@Border"/>;</xsl:if>
	</xsl:attribute>
	-->

	<!-- insert commands -->
	<!-- <xsl:value-of select="@HierId"/> -->
	<xsl:call-template name="EditReturnAnchors"/>
	<xsl:if test="($mode = 'edit' and ((../../@DataTable != 'y' or not(../../@DataTable))) or $mode = 'table_edit')">
		<!-- checkbox -->
		<xsl:if test="$javascript = 'disable'">
			<input type="checkbox" name="target[]">
				<xsl:attribute name="value"><xsl:value-of select="@HierId"/>:<xsl:value-of select="@PCID"/>
				</xsl:attribute>
			</input>
		</xsl:if>
		<!-- insert select list -->
		<xsl:if test="$mode = 'edit'">
			<xsl:if test= "$javascript = 'enable'">
				<xsl:call-template name="DropArea">
					<xsl:with-param name="hier_id"><xsl:value-of select="@HierId"/></xsl:with-param>
					<xsl:with-param name="pc_id"><xsl:value-of select="@PCID"/></xsl:with-param>
				</xsl:call-template>
			</xsl:if>
		</xsl:if>
	</xsl:if>
	<!-- class and width output for table edit -->
	<xsl:if test="$mode = 'table_edit' and count(ancestor::Table) = 1">
		<div class="small" style="white-space:nowrap; padding:2px; margin:2px; background-color:#FFFFFF; border: solid 1px #C0C0C0; color:#000000;">
			{{{{{TableEdit;<xsl:value-of select="@HierId"/>:<xsl:value-of select="@PCID"/>}}}}}
			<!--  <xsl:value-of select="//LVs/LV[@name='ed_class']/@value"/>:
			<xsl:if test="@Class">
				<xsl:value-of select="substring(@Class, 5)"/>
			</xsl:if>
			<xsl:if test="not(@Class)">None</xsl:if>
			<input type="checkbox" value="1">
				<xsl:attribute name="name">target[<xsl:value-of select="@HierId"/>:<xsl:value-of select="@PCID"/>]</xsl:attribute>
			</input> -->
			<!--  <br />
			<xsl:value-of select="//LVs/LV[@name='ed_width']/@value"/>:
			<input class="small" type="text" size="5" maxlength="10">
				<xsl:attribute name="name">width[<xsl:value-of select="@HierId"/>:<xsl:value-of select="@PCID"/>]</xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="@Width"/></xsl:attribute>
			</input>-->
		</div>
	</xsl:if>
	<!-- content -->
	<xsl:apply-templates/>
	<!-- <xsl:value-of select = "$ttemp" /> -->
</xsl:template>



<!-- Lists -->
<xsl:template match="List">
	<!-- Label -->
	<xsl:call-template name="EditLabel"><xsl:with-param name="text"><xsl:value-of select="//LVs/LV[@name='pc_list']/@value"/> <xsl:if test="@Class != 'NumberedList' and @Class != 'BulletedList'"> (<xsl:value-of select="@Class"/>)</xsl:if></xsl:with-param></xsl:call-template>

	<!-- <xsl:value-of select="..@HierId"/> -->
	<xsl:call-template name="EditReturnAnchors"/>
	<xsl:if test="@Type = 'Ordered'">
		<ol class="ilc_list_o_NumberedList">
		<xsl:if test="@StartValue and number(@StartValue) > 1">
			<xsl:attribute name="start"><xsl:value-of select="@StartValue"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="@Class and @Class != 'NumberedList'">
			<xsl:attribute name="class">ilc_list_o_<xsl:value-of select="@Class"/></xsl:attribute>
		</xsl:if>
		<xsl:choose>
			<xsl:when test="@NumberingType = 'Roman'"><xsl:attribute name="style">list-style-type: upper-roman;</xsl:attribute></xsl:when>
			<xsl:when test="@NumberingType = 'roman'"><xsl:attribute name="style">list-style-type: lower-roman;</xsl:attribute></xsl:when>
			<xsl:when test="@NumberingType = 'Alphabetic'"><xsl:attribute name="style">list-style-type: upper-alpha;</xsl:attribute></xsl:when>
			<xsl:when test="@NumberingType = 'alphabetic'"><xsl:attribute name="style">list-style-type: lower-alpha;</xsl:attribute></xsl:when>
			<xsl:when test="@NumberingType = 'Decimal'"><xsl:attribute name="style">list-style-type: decimal;</xsl:attribute></xsl:when>
		</xsl:choose>
		<xsl:apply-templates/>
		</ol>
	</xsl:if>
	<xsl:if test="@Type = 'Unordered'">
		<ul class="ilc_list_u_BulletedList">
			<xsl:if test="@Class and @Class != 'BulletedList'">
				<xsl:attribute name="class">ilc_list_u_<xsl:value-of select="@Class"/></xsl:attribute>
			</xsl:if>
		<xsl:apply-templates/>
		</ul>
	</xsl:if>
	<!-- command selectbox -->
	<xsl:if test="$mode = 'edit'">
		<!-- <xsl:value-of select="../@HierId"/> -->
		<xsl:if test = "$javascript='disable'">
		<input type="checkbox" name="target[]">
			<xsl:attribute name="value"><xsl:value-of select="../@HierId"/>:<xsl:value-of select="../@PCID"/>
			</xsl:attribute>
		</input>
		</xsl:if>
		<xsl:call-template name="EditMenu">
			<xsl:with-param name="hier_id" select="../@HierId" />
			<xsl:with-param name="pc_id" select="../@PCID" />
			<xsl:with-param name="edit">p</xsl:with-param>
		</xsl:call-template>
		<xsl:if test = "$javascript='disable'">
			<br/>
		</xsl:if>
	</xsl:if>
</xsl:template>

<!-- List Item -->
<xsl:template match="ListItem">
	<li class="ilc_list_item_StandardListItem">
	<xsl:if test="../@ItemClass">
		<xsl:attribute name="class">ilc_list_item_<xsl:value-of select="../@ItemClass"/></xsl:attribute>
	</xsl:if>
	<xsl:call-template name="EditReturnAnchors"/>
	<!-- insert commands -->
	<!-- <xsl:value-of select="@HierId"/> -->
	<xsl:if test="$mode = 'edit'">
		<xsl:if test="$javascript='disable'">
			<!-- checkbox -->
			<input type="checkbox" name="target[]">
				<xsl:attribute name="value"><xsl:value-of select="@HierId"/>:<xsl:value-of select="@PCID"/>
				</xsl:attribute>
			</input>
			<select size="1" class="ilEditSelect">
				<xsl:attribute name="name">command<xsl:value-of select="@HierId"/>
				</xsl:attribute>
				<xsl:if test = "$javascript = 'disable'">
					<xsl:call-template name="EditMenuInsertItems"/>
				</xsl:if>
				<xsl:call-template name="ListItemMenu"/>
			</select>
			<input class="ilEditSubmit" type="submit">
				<xsl:attribute name="value"><xsl:value-of select="//LVs/LV[@name='ed_go']/@value"/></xsl:attribute>
				<xsl:attribute name="name">cmd[exec_<xsl:value-of select="@HierId"/>:<xsl:value-of select="@PCID"/>]</xsl:attribute>
			</input>
			<br/>
		</xsl:if>
		<xsl:if test="$javascript = 'enable'">
			<xsl:call-template name="Icon">
				<xsl:with-param name="img_id">CONTENTi<xsl:value-of select="@HierId"/>:<xsl:value-of select="@PCID"/></xsl:with-param>
				<xsl:with-param name="img_src"><xsl:value-of select="$img_item"/></xsl:with-param>
				<xsl:with-param name="ed_type">edit-list-item</xsl:with-param>
				<xsl:with-param name="float">y</xsl:with-param>
			</xsl:call-template>
			<xsl:call-template name="DropArea">
				<xsl:with-param name="hier_id"><xsl:value-of select="@HierId"/></xsl:with-param>
				<xsl:with-param name="pc_id"><xsl:value-of select="@PCID"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:if>

	<xsl:apply-templates/>
	</li>
</xsl:template>

<!-- List Item Menu -->
<xsl:template name="ListItemMenu">

	<xsl:call-template name="EditMenuItem"><xsl:with-param name="command">newItemAfter</xsl:with-param>
	<xsl:with-param name="langvar">ed_new_item_after</xsl:with-param></xsl:call-template>

	<xsl:call-template name="EditMenuItem"><xsl:with-param name="command">newItemBefore</xsl:with-param>
	<xsl:with-param name="langvar">ed_new_item_before</xsl:with-param></xsl:call-template>

	<xsl:call-template name="EditMenuItem"><xsl:with-param name="command">deleteItem</xsl:with-param>
	<xsl:with-param name="langvar">ed_delete_item</xsl:with-param></xsl:call-template>

	<xsl:variable name="ni"><xsl:number level="single" count="ListItem|FileItem"/></xsl:variable>
	<xsl:if test= "$ni != 1">
		<xsl:call-template name="EditMenuItem"><xsl:with-param name="command">moveItemUp</xsl:with-param>
		<xsl:with-param name="langvar">ed_item_up</xsl:with-param></xsl:call-template>
	</xsl:if>

	<xsl:if test= "../ListItem[number($ni + 1)] or ../FileItem[number($ni + 1)]">
		<xsl:call-template name="EditMenuItem"><xsl:with-param name="command">moveItemDown</xsl:with-param>
		<xsl:with-param name="langvar">ed_item_down</xsl:with-param></xsl:call-template>
	</xsl:if>

</xsl:template>

<!-- SimpleBulletList -->
<xsl:template match="SimpleBulletList">
	<ul class="ilc_list_u_BulletedList">
		<xsl:if test="@Class">
			<xsl:attribute name="class">ilc_list_u_<xsl:value-of select="@Class"/></xsl:attribute>
		</xsl:if>
		<xsl:apply-templates/>
	</ul>
</xsl:template>
<xsl:template match="SimpleNumberedList">
	<ol class="ilc_list_o_NumberedList">
		<xsl:if test="@Class">
			<xsl:attribute name="class">ilc_list_o_<xsl:value-of select="@Class"/></xsl:attribute>
		</xsl:if>
		<xsl:apply-templates/>
	</ol>
</xsl:template>
<xsl:template match="SimpleListItem">
	<li class="ilc_list_item_StandardListItem">
		<xsl:if test="@Class">
			<xsl:attribute name="class">ilc_list_item_<xsl:value-of select="@Class"/></xsl:attribute>
		</xsl:if>
		<xsl:apply-templates/>
	</li>
</xsl:template>

<!-- FileList -->
<xsl:template match="FileList">
	<!-- Label -->
	<xsl:call-template name="EditLabel"><xsl:with-param name="text"><xsl:value-of select="//LVs/LV[@name='pc_flist']/@value"/></xsl:with-param></xsl:call-template>
	<xsl:call-template name="EditReturnAnchors"/>
	<div class="ilc_flist_cont_FileListContainer">
		<xsl:if test = "./Title and ./Title != ''">
			<div class="ilc_flist_head_FileListHeading"><xsl:value-of select="./Title"/><xsl:comment>Comment to have separate embed ending tag</xsl:comment></div>
		</xsl:if>
		<ul class="ilc_flist_FileList">
		<xsl:apply-templates select="FileItem"/>
		</ul>
		<!-- <xsl:apply-templates select="FileItem"/> -->
	</div>
	<!-- command selectbox -->
	<xsl:if test="$mode = 'edit'">
		<!-- <xsl:value-of select="../@HierId"/> -->
		<xsl:if test = "$javascript='disable'">
		<input type="checkbox" name="target[]">
			<xsl:attribute name="value"><xsl:value-of select="../@HierId"/>:<xsl:value-of select="../@PCID"/>
			</xsl:attribute>
		</input>
		</xsl:if>
		<xsl:call-template name="EditMenu">
			<xsl:with-param name="hier_id" select="../@HierId" />
			<xsl:with-param name="pc_id" select="../@PCID" />
			<xsl:with-param name="type">filelist</xsl:with-param>
		</xsl:call-template>
		<xsl:if test = "$javascript='disable'">
			<br/>
		</xsl:if>
	</xsl:if>
</xsl:template>

<!-- File List Menu -->
<xsl:template name="FileListMenu">
	<xsl:param name="hier_id"/>

	<xsl:call-template name="EditMenuItem">
		<xsl:with-param name="command">editFiles</xsl:with-param>
		<xsl:with-param name="langvar">ed_edit_files</xsl:with-param>
	</xsl:call-template>

	<xsl:call-template name="EditMenuItem">
		<xsl:with-param name="command">edit</xsl:with-param>
		<xsl:with-param name="langvar">ed_edit_prop</xsl:with-param>
	</xsl:call-template>

	<xsl:if test = "$javascript = 'disable'">
		<xsl:call-template name="EditMenuInsertItems"/>
	</xsl:if>

	<!-- delete -->
	<xsl:call-template name="EditMenuItem">
		<xsl:with-param name="command">delete</xsl:with-param>
		<xsl:with-param name="langvar">ed_delete</xsl:with-param>
	</xsl:call-template>

	<!-- activate/deactivate -->
	<xsl:if test = "$javascript = 'enable'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">deactivate</xsl:with-param>
			<xsl:with-param name="langvar">de_activate</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- move menu items -->
	<xsl:call-template name="MoveMenuItems"/>

	<!-- split page menu items -->
	<xsl:call-template name="SplitMenuItems">
		<xsl:with-param name="hier_id" select="$hier_id"/>
	</xsl:call-template>

</xsl:template>

<!-- FileItem -->
<xsl:template match="FileItem">
	<li class="ilc_flist_li_FileListItem">
		<xsl:if test="@Class">
			<xsl:attribute name="class">ilc_flist_li_<xsl:value-of select="@Class"/></xsl:attribute>
		</xsl:if>
		<xsl:call-template name="EditReturnAnchors"/>
		<!-- <xsl:value-of select="@HierId"/> -->
		<xsl:if test="$mode = 'edit'">
			<xsl:if test="$javascript='disable'">
				<!-- checkbox -->
				<input type="checkbox" name="target[]">
					<xsl:attribute name="value"><xsl:value-of select="@HierId"/>:<xsl:value-of select="@PCID"/>
					</xsl:attribute>
				</input>
				<select size="1" class="ilEditSelect">
					<xsl:attribute name="name">command<xsl:value-of select="@HierId"/>
					</xsl:attribute>
					<xsl:call-template name="ListItemMenu"/>
				</select>
				<input class="ilEditSubmit" type="submit">
					<xsl:attribute name="value"><xsl:value-of select="//LVs/LV[@name='ed_go']/@value"/></xsl:attribute>
					<xsl:attribute name="name">cmd[exec_<xsl:value-of select="@HierId"/>:<xsl:value-of select="@PCID"/>]</xsl:attribute>
				</input>
				<br/>
			</xsl:if>
			<xsl:if test="$javascript = 'enable'">
				<xsl:call-template name="Icon">
					<xsl:with-param name="img_id">CONTENTi<xsl:value-of select="@HierId"/>:<xsl:value-of select="@PCID"/></xsl:with-param>
					<xsl:with-param name="img_src"><xsl:value-of select="$img_item"/></xsl:with-param>
					<xsl:with-param name="ed_type">edit-flist-item</xsl:with-param>
				</xsl:call-template>
				&amp;nbsp;
				<div class="ilOverlay il_editmenu ilNoDisplay">
					<xsl:attribute name="id">contextmenu_i<xsl:value-of select="@HierId"/></xsl:attribute>
					<xsl:call-template name="ListItemMenu"/>
				</div>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$mode != 'print'">
			<xsl:if test="$mode != 'offline'">
				<a class="ilc_flist_a_FileListItemLink" target="_blank">
					<xsl:if test="$enable_href">
						<xsl:attribute name="href"><xsl:value-of select="$file_download_link"/>&amp;file_id=<xsl:value-of select="./Identifier/@Entry"/></xsl:attribute>
					</xsl:if>
					<xsl:call-template name="FileItemText"/>
				</a>
			</xsl:if>
			<xsl:if test="$mode = 'offline'">
				<a class="ilc_flist_a_FileListItemLink" target="_blank">
					<xsl:attribute name="href">./files/file_<xsl:value-of select="substring-after(./Identifier/@Entry,'file_')"/>/<xsl:value-of select="./Location"/></xsl:attribute>
					<xsl:call-template name="FileItemText"/>
				</a>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$mode = 'print'">
			<xsl:if test="$page_perma_link = ''">
				<a class="ilc_flist_a_FileListItemLink" href="#">
					<xsl:call-template name="FileItemText"/>
				</a>
			</xsl:if>
			<xsl:if test="$page_perma_link != ''">
				<a class="ilc_flist_a_FileListItemLink" target="_blank">
					<xsl:attribute name="href"><xsl:value-of select="$page_perma_link"/></xsl:attribute>
					<xsl:call-template name="FileItemText"/>
				</a>
			</xsl:if>
		</xsl:if>
	</li>
</xsl:template>


<!-- FileItemText -->
<xsl:template name="FileItemText">
	<xsl:value-of select="./Location"/>
	<xsl:if test="./Size">
		<xsl:choose>
			<xsl:when test="./Size > 1000000">
				(<xsl:value-of select="format-number(round(./Size div 10000) div 100, '#.00')"/> MB)
			</xsl:when>
			<xsl:when test="./Size > 1000">
				(<xsl:value-of select="format-number(round(./Size div 10) div 100, '#.00')"/> KB)
			</xsl:when>
			<xsl:otherwise>
				(<xsl:value-of select="./Size"/> B)
			</xsl:otherwise>
		</xsl:choose>
	</xsl:if>
</xsl:template>

<!-- MediaAlias -->
<xsl:template match="MediaAlias">
	<xsl:call-template name="EditReturnAnchors"/>

	<!-- Alignment Part 1 (Left, Center, Right)-->
	<xsl:if test="../MediaAliasItem[@Purpose='Standard']/Layout[1]/@HorizontalAlign = 'Left'
		and $mode != 'fullscreen' and $mode != 'media'">
		<div style="clear:both;">
		<xsl:call-template name="MOBTable"/>
		</div>
	</xsl:if>
	<xsl:if test="../MediaAliasItem[@Purpose='Standard']/Layout[1]/@HorizontalAlign = 'Center'
		or $mode = 'fullscreen' or $mode = 'media'">
		<div style="clear:both;">
		<xsl:call-template name="MOBTable"/>
		</div>
	</xsl:if>
	<xsl:if test="../MediaAliasItem[@Purpose='Standard']/Layout[1]/@HorizontalAlign = 'Right'
		and $mode != 'fullscreen' and $mode != 'media'">
		<div style="clear:both;">
		<xsl:call-template name="MOBTable"/>
		</div>
	</xsl:if>
	<xsl:if test="../MediaAliasItem[@Purpose='Standard']/Layout[1]/@HorizontalAlign = 'RightFloat'
		and $mode != 'fullscreen' and $mode != 'media'">
		<xsl:choose>
			<xsl:when test="name(..) = 'InteractiveImage' and $mode = 'edit'">
			<div style="clear:both; margin-right:0; margin-left:auto; display: table;">
				<xsl:call-template name="MOBTable"/>
			</div>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="MOBTable"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:if>
	<xsl:if test="../MediaAliasItem[@Purpose='Standard']/Layout[1]/@HorizontalAlign = 'LeftFloat'
		and $mode != 'fullscreen' and $mode != 'media'">
		<xsl:call-template name="MOBTable"/>
	</xsl:if>
	<xsl:if test="count(../MediaAliasItem[@Purpose='Standard']/Layout[1]/@HorizontalAlign) = 0
		and $mode != 'fullscreen' and $mode != 'media'">
		<div style="clear:both; margin-right:auto; margin-left:0; display: table;">
		<xsl:call-template name="MOBTable"/>
		</div>
	</xsl:if>
</xsl:template>

<!-- MOBTable: display multimedia objects within a layout table> -->
<xsl:template name="MOBTable">
	<xsl:variable name="cmobid" select="@OriginId"/>

	<!-- determine purpose -->
	<xsl:variable name="curPurpose"><xsl:choose>
		<xsl:when test="$mode = 'fullscreen'">Fullscreen</xsl:when>
		<xsl:otherwise>Standard</xsl:otherwise>
	</xsl:choose></xsl:variable>

	<xsl:variable name="figureclass">
	<xsl:if test="@Class">ilc_media_cont_<xsl:value-of select="@Class"/></xsl:if>
	<xsl:if test="not(@Class)">ilc_media_cont_MediaContainer</xsl:if>
	</xsl:variable>
	<xsl:variable name="captionclass">
		<xsl:if test="@CaptionClass">ilc_media_caption_<xsl:value-of select="@CaptionClass"/></xsl:if>
		<xsl:if test="not(@CaptionClass)">ilc_media_caption_MediaCaption</xsl:if>
	</xsl:variable>

	<xsl:for-each select="../MediaAliasItem[@Purpose = $curPurpose]">


		<!-- data / Location -->
		<xsl:variable name="curItemNr"><xsl:number count="MediaItem" from="MediaAlias"/></xsl:variable>

		<!-- determine location mode (curpurpose, standard) -->
		<xsl:variable name="location_mode">
			<xsl:choose>
				<xsl:when test="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose = $curPurpose]/Location != ''">curpurpose</xsl:when>
				<xsl:otherwise>standard</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!-- determine location type (LocalFile, Reference) -->
		<xsl:variable name="curType">
			<xsl:choose>
				<xsl:when test="$location_mode = 'curpurpose'">
					<xsl:value-of select="//MediaObject[@Id=$cmobid]//MediaItem[@Purpose = $curPurpose]/Location/@Type"/>
				</xsl:when>
				<xsl:when test="$location_mode = 'standard'">
					<xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose = 'Standard']/Location/@Type"/>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>

		<!-- determine title -->
		<xsl:variable name="title">
			<xsl:choose>
				<xsl:when test="$location_mode = 'curpurpose'">
					<xsl:value-of select="//MediaObject[@Id=$cmobid]//MediaItem[@Purpose = $curPurpose]/Title"/>
				</xsl:when>
				<xsl:when test="$location_mode = 'standard'">
					<xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose = 'Standard']/Title"/>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>

		<!-- determine format (mime type) -->
		<xsl:variable name="type">
			<xsl:choose>
				<xsl:when test="$location_mode = 'curpurpose'">
					<xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose = $curPurpose]/Format"/>
				</xsl:when>
				<xsl:when test="$location_mode = 'standard'">
					<xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose = 'Standard']/Format"/>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>

		<!-- determine location -->
		<xsl:variable name="data">
			<xsl:choose>
				<xsl:when test="$location_mode = 'curpurpose'">
					<xsl:if test="$curType = 'LocalFile'">
						<xsl:if test="starts-with(//MediaObject[@Id=$cmobid]/MediaItem[@Purpose = $curPurpose]/Location, 'http')">
							<xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose = $curPurpose]/Location"/>
						</xsl:if>
						<xsl:if test="not(starts-with(//MediaObject[@Id=$cmobid]/MediaItem[@Purpose = $curPurpose]/Location, 'http'))">
							<xsl:value-of select="$webspace_path"/>mobs/mm_<xsl:value-of select="substring-after($cmobid,'mob_')"/>/<xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose = $curPurpose]/Location"/>
						</xsl:if>
					</xsl:if>
					<xsl:if test="$curType = 'Reference'">
						<xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose = $curPurpose]/Location"/>
					</xsl:if>
				</xsl:when>
				<xsl:when test="$location_mode = 'standard'">
					<xsl:if test="$curType = 'LocalFile'">
						<xsl:value-of select="$webspace_path"/>mobs/mm_<xsl:value-of select="substring-after($cmobid,'mob_')"/>/<xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose = 'Standard']/Location"/>
					</xsl:if>
					<xsl:if test="$curType = 'Reference'">
						<xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose = 'Standard']/Location"/>
					</xsl:if>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>

		<!-- determine size mode (alias, mob or none) -->
		<xsl:variable name="sizemode">
			<xsl:choose>
				<xsl:when test="../MediaAliasItem[@Purpose=$curPurpose]/Layout[1]/@Width != '' or
					../MediaAliasItem[@Purpose=$curPurpose]/Layout[1]/@Height != ''">alias</xsl:when>
				<xsl:when test="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose=$curPurpose]/Layout[1]/@Width != '' or
					//MediaObject[@Id=$cmobid]/MediaItem[@Purpose=$curPurpose]/Layout[1]/@Height != ''">mob</xsl:when>
				<xsl:otherwise>none</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!-- determine width -->
		<xsl:variable name="width">
			<xsl:choose>
				<xsl:when test="$sizemode = 'alias'"><xsl:value-of select="../MediaAliasItem[@Purpose=$curPurpose]/Layout[1]/@Width"/></xsl:when>
				<xsl:when test="$sizemode = 'mob'"><xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose=$curPurpose]/Layout[1]/@Width"/></xsl:when>
				<xsl:otherwise></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>


		<!-- determine height -->
		<xsl:variable name="height">
			<xsl:choose>
				<xsl:when test="$sizemode = 'alias'"><xsl:value-of select="../MediaAliasItem[@Purpose=$curPurpose]/Layout[1]/@Height"/></xsl:when>
				<xsl:when test="$sizemode = 'mob'"><xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose=$curPurpose]/Layout[1]/@Height"/></xsl:when>
				<xsl:otherwise></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="figuredisplay">
			position: relative;
			<xsl:choose>
				<!-- all images use table as container since they expand the table even without width/height -->
				<!-- do same for svg, see 34557 -->
				<xsl:when test="substring($type, 1, 5) = 'image' and not(substring($type, 1, 9) = 'image/xxxsvg')">display:table;</xsl:when>
				<!-- if we have width/height, we also use table as container, since we will expand it -->
				<xsl:when test="$width != '' and $height != ''">display:table;</xsl:when>
				<xsl:otherwise>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="captiondisplay">
			<xsl:choose>
				<xsl:when test="contains($figuredisplay, 'display:table;')">
					display: table-caption; caption-side: bottom;
				</xsl:when>
				<xsl:otherwise>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<figure>

			<xsl:attribute name="class"><xsl:value-of select="$figureclass"/></xsl:attribute>
			<xsl:attribute name="style"><xsl:value-of select="$figuredisplay"/></xsl:attribute>

			<!-- Alignment Part 2 (LeftFloat, RightFloat) -->
			<xsl:if test="../MediaAliasItem[@Purpose='Standard']/Layout[1]/@HorizontalAlign = 'LeftFloat'
				and $mode != 'fullscreen' and $mode != 'media'">
				<xsl:attribute name="style"><xsl:value-of select="$figuredisplay"/><xsl:if test="$mode != 'edit'">float:left; clear:both; </xsl:if><xsl:if test="$disable_auto_margins != 'y'">margin-left: 0px;</xsl:if></xsl:attribute>
			</xsl:if>
			<xsl:if test="../MediaAliasItem[@Purpose='Standard']/Layout[1]/@HorizontalAlign = 'RightFloat'
				and $mode != 'fullscreen' and $mode != 'media'">
				<xsl:attribute name="style"><xsl:value-of select="$figuredisplay"/><xsl:if test="$mode != 'edit'">float:right; clear:both; </xsl:if><xsl:if test="$disable_auto_margins != 'y'">margin-right: 0px;</xsl:if></xsl:attribute>
			</xsl:if>
			<xsl:if test="../MediaAliasItem[@Purpose='Standard']/Layout[1]/@HorizontalAlign = 'Left'
				and $mode != 'fullscreen' and $mode != 'media'">
				<xsl:attribute name="style"><xsl:value-of select="$figuredisplay"/>margin-right:auto; margin-left:0; </xsl:attribute>
			</xsl:if>
			<xsl:if test="../MediaAliasItem[@Purpose='Standard']/Layout[1]/@HorizontalAlign = 'Right'
				and $mode != 'fullscreen' and $mode != 'media'">
				<xsl:attribute name="style"><xsl:value-of select="$figuredisplay"/>margin-right:0; margin-left:auto; </xsl:attribute>
			</xsl:if>
			<xsl:if test="../MediaAliasItem[@Purpose='Standard']/Layout[1]/@HorizontalAlign = 'Center'
				and $mode != 'fullscreen' and $mode != 'media'">
				<xsl:attribute name="style"><xsl:value-of select="$figuredisplay"/>margin-right:auto; margin-left:auto;</xsl:attribute>
			</xsl:if>

			<!-- build object tag -->
			<div class="ilc_Mob" style="height:100%">

				<!-- set width of td, see bug #10911 and #19464 -->
				<xsl:if test="$width != ''">
					<xsl:attribute name="style">width:<xsl:value-of select="$width" />px;</xsl:attribute>
				</xsl:if>


				<xsl:call-template name="MOBTag">
					<xsl:with-param name="data" select="$data" />
					<xsl:with-param name="type" select="$type" />
					<xsl:with-param name="width" select="$width" />
					<xsl:with-param name="height" select="$height" />
					<xsl:with-param name="curPurpose" select="$curPurpose" />
					<xsl:with-param name="cmobid" select="$cmobid" />
					<xsl:with-param name="location_mode" select="$location_mode" />
					<xsl:with-param name="curType" select="$curType" />
					<xsl:with-param name="title" select="$title" />
				</xsl:call-template>

				<!-- parameter -->
				<!--
				<xsl:for-each select="../MediaAliasItem[@Purpose = $curPurpose]/Parameter">
					<param>
					<xsl:attribute name="name"><xsl:value-of select="@Name"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="@Value"/></xsl:attribute>
					</param>
				</xsl:for-each>-->

			</div>
			<!-- mob caption -->
			<xsl:choose>			<!-- derive -->
				<xsl:when test="count(../MediaAliasItem[@Purpose=$curPurpose]/Caption[1]) != 0 and ../MediaAliasItem[@Purpose=$curPurpose]/Caption[1] != ''">
					<figcaption><xsl:attribute name="style"><xsl:value-of select="$captiondisplay"/></xsl:attribute><div>
						<xsl:attribute name="class"><xsl:value-of select="$captionclass"/></xsl:attribute>
					<xsl:call-template name="FullscreenLink">
						<xsl:with-param name="cmobid" select="$cmobid"/>
					</xsl:call-template>
					<xsl:value-of select="../MediaAliasItem[@Purpose=$curPurpose]/Caption[1]"/>
					</div></figcaption>
				</xsl:when>
				<xsl:when test="count(//MediaObject[@Id=$cmobid]/MediaItem[@Purpose=$curPurpose]/Caption[1]) != 0">
					<figcaption><xsl:attribute name="style"><xsl:value-of select="$captiondisplay"/></xsl:attribute><div>
						<xsl:attribute name="class"><xsl:value-of select="$captionclass"/></xsl:attribute>
					<xsl:call-template name="FullscreenLink">
						<xsl:with-param name="cmobid" select="$cmobid"/>
					</xsl:call-template>
					<xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose=$curPurpose]/Caption[1]"/>
					</div></figcaption>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="count(../MediaAliasItem[@Purpose='Fullscreen']) = 1">
						<figcaption><xsl:attribute name="style"><xsl:value-of select="$captiondisplay"/></xsl:attribute><div>
							<xsl:attribute name="class"><xsl:value-of select="$captionclass"/></xsl:attribute>
						<xsl:call-template name="FullscreenLink">
							<xsl:with-param name="cmobid" select="$cmobid"/>
						</xsl:call-template>
						</div></figcaption>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="$mode = 'edit'">
				<div class="il-copg-media-cover" data-copg-ed-type="media-cover"></div>
			</xsl:if>

			<!-- command selectbox -->
			<xsl:if test="$mode = 'edit' and $javascript='disable'">
				<div>
					<!-- <xsl:value-of select="../../@HierId"/> -->
					<input type="checkbox" name="target[]">
						<xsl:attribute name="value"><xsl:value-of select="../../@HierId"/>:<xsl:value-of select="../../@PCID"/>
						</xsl:attribute>
					</input>
					<select size="1" class="ilEditSelect">
						<xsl:attribute name="name">command<xsl:value-of select="../../@HierId"/>
						</xsl:attribute>
						<xsl:call-template name="MOBEditMenu">
							<xsl:with-param name="hier_id" select="../../@HierId"/>
						</xsl:call-template>
					</select>
					<input class="ilEditSubmit" type="submit">
						<xsl:attribute name="value"><xsl:value-of select="//LVs/LV[@name='ed_go']/@value"/></xsl:attribute>
						<xsl:attribute name="name">cmd[exec_<xsl:value-of select="../../@HierId"/>:<xsl:value-of select="../../@PCID"/>]</xsl:attribute>
					</input>
				</div>
			</xsl:if>
		</figure>
	</xsl:for-each>

	<!-- menu -->
	<xsl:if test="$mode = 'edit' and $javascript='enable'">
		<div class="ilOverlay il_editmenu ilNoDisplay">
			<xsl:attribute name="id">contextmenu_<xsl:value-of select="../../@HierId"/></xsl:attribute>
			<xsl:call-template name="MOBEditMenu">
				<xsl:with-param name="hier_id" select="../../@HierId"/>
			</xsl:call-template>
		</div>
	</xsl:if>
</xsl:template>


<!-- MOB edit menu -->
<xsl:template name="MOBEditMenu">
	<xsl:param name="hier_id"/>

	<xsl:if test="(../../MediaObject)">
		<xsl:call-template name="EditMenuItem"><xsl:with-param name="command">editAlias</xsl:with-param>
		<xsl:with-param name="langvar">ed_edit_prop</xsl:with-param></xsl:call-template>
	</xsl:if>

	<xsl:if test="(../../InteractiveImage)">
		<xsl:call-template name="EditMenuItem"><xsl:with-param name="command">edit</xsl:with-param>
		<xsl:with-param name="langvar">ed_edit_prop</xsl:with-param></xsl:call-template>
	</xsl:if>

	<xsl:if test = "$javascript = 'disable'">
		<xsl:call-template name="EditMenuInsertItems"/>
	</xsl:if>

	<xsl:call-template name="EditMenuItem"><xsl:with-param name="command">delete</xsl:with-param>
	<xsl:with-param name="langvar">ed_delete</xsl:with-param></xsl:call-template>

	<xsl:if test = "$javascript = 'enable'">
		<xsl:call-template name="EditMenuItem">
			<xsl:with-param name="command">deactivate</xsl:with-param>
			<xsl:with-param name="langvar">de_activate</xsl:with-param>
		</xsl:call-template>
	</xsl:if>

	<!-- move menu items -->
	<xsl:call-template name="MoveMenuItems"/>

	<!-- split page menu items -->
	<xsl:call-template name="SplitMenuItems">
		<xsl:with-param name="hier_id" select="$hier_id"/>
	</xsl:call-template>

	<xsl:call-template name="EditMenuAlignItems"/>

	<xsl:if test="(../../MediaObject)">
		<xsl:call-template name="EditMenuItem"><xsl:with-param name="command">copyToClipboard</xsl:with-param>
		<xsl:with-param name="langvar">ed_copy_clip</xsl:with-param></xsl:call-template>
	</xsl:if>

</xsl:template>

<!-- MOBs: Images -->
<xsl:template name="MOBImage">
	<xsl:param name="cmobid"/>
	<xsl:param name="width"/>
	<xsl:param name="height"/>
	<xsl:param name="curPurpose"/>
	<xsl:param name="data"/>
	<xsl:param name="inline"/>
	<img border="0">
		<!-- see 0020796 -->
		<xsl:if test = "count(ancestor-or-self::Paragraph) = 0 and name(..) != 'InteractiveImage'">
			<xsl:attribute name="style">width:100%</xsl:attribute>
		</xsl:if>
		<xsl:if test = "name(..) = 'InteractiveImage'">
			<xsl:attribute name="style">max-width:none</xsl:attribute>
		</xsl:if>
		<xsl:if test = "$map_item = '' or $cmobid != concat('il__mob_',$map_mob_id)">
			<xsl:attribute name="src"><xsl:value-of select="$data"/></xsl:attribute>
		</xsl:if>
		<xsl:if test = "$map_item != '' and $cmobid = concat('il__mob_',$map_mob_id)">
			<xsl:attribute name="src"><xsl:value-of select="$image_map_link"/>&amp;item_id=<xsl:value-of select="$map_item"/>&amp;<xsl:value-of select="$link_params"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$width != ''">
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="$height != ''">
			<xsl:attribute name="height"><xsl:value-of select="$height"/></xsl:attribute>
		</xsl:if>
		<xsl:if test = "(//MediaObject[@Id=$cmobid]/MediaItem[@Purpose = $curPurpose]/MapArea[@Shape != 'WholePicture'][1] and not(./MapArea[1]))
			or ./MapArea[@Shape != 'WholePicture'][1]">
			<xsl:if test="name(..) != 'InteractiveImage' or $mode != 'edit'">
				<xsl:attribute name="usemap">#map_<xsl:value-of select="$cmobid"/>_<xsl:value-of select="$curPurpose"/></xsl:attribute>
				<!-- If we got an alias item map, add counter for item to the map id -->
				<xsl:if test="./MapArea[1]">
					<xsl:attribute name="usemap">#map_<xsl:value-of select="$cmobid"/>_<xsl:value-of select="$curPurpose"/>_<xsl:number count="MediaAliasItem" level="any" /></xsl:attribute>
				</xsl:if>
			</xsl:if>
		</xsl:if>
		<xsl:if test="name(..) = 'InteractiveImage'">
			<xsl:attribute name="class">ilIim</xsl:attribute>
		</xsl:if>
		<xsl:if test = "$inline = 'y'">
			<xsl:attribute name="align">middle</xsl:attribute>
		</xsl:if>
		<xsl:if test = "name(..) = 'InteractiveImage'">
			<xsl:attribute name="id">base_img_<xsl:value-of select = "$pg_id"/>_<xsl:number count="InteractiveImage" level="any" /></xsl:attribute>
		</xsl:if>

		<!-- text representation (alt attribute) -->
		<xsl:choose>			<!-- derive -->
			<xsl:when test="count(../MediaAliasItem[@Purpose=$curPurpose]/TextRepresentation[1]) != 0">
				<xsl:attribute name="alt"><xsl:value-of select="../MediaAliasItem[@Purpose=$curPurpose]/TextRepresentation[1]"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="count(//MediaObject[@Id=$cmobid]/MediaItem[@Purpose=$curPurpose]/TextRepresentation[1]) != 0">
				<xsl:attribute name="alt"><xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose=$curPurpose]/TextRepresentation[1]"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
			</xsl:otherwise>
		</xsl:choose>
	</img>
</xsl:template>

<!-- MOBTag: display media object tag -->
<xsl:template name="MOBTag">
	<xsl:param name="data"/>
	<xsl:param name="type"/>
	<xsl:param name="width"/>
	<xsl:param name="height"/>
	<xsl:param name="cmobid"/>
	<xsl:param name="curPurpose"/>
	<xsl:param name="location_mode"/>
	<xsl:param name="curType"/>
	<xsl:param name="title"/>
	<xsl:param name="inline">n</xsl:param>
	<xsl:variable name="httpprefix"><xsl:if test="$mode = 'offline'">http:</xsl:if></xsl:variable>
	<xsl:choose>
		<xsl:when test="$media_mode = 'disable'">
			<div class="ilCOPGMediaDisabled">
				<xsl:attribute name="style">width:<xsl:value-of select="$width"/>px; height:<xsl:value-of select="$height"/>px;</xsl:attribute>
				Media Disabled
			</div>
		</xsl:when>

		<!-- all image mime types, except svg -->
		<!-- image/svgxxx, see bug #15857 (reverted due to example clock.svg in the report)-->
		<xsl:when test="substring($type, 1, 5) = 'image' and not(substring($type, 1, 9) = 'image/svg')">
			<xsl:if test="$map_edit_mode != 'get_coords'">
				<xsl:choose>
					<xsl:when test = "(//MediaObject[@Id=$cmobid]/MediaItem[@Purpose = $curPurpose]/MapArea[@Shape = 'WholePicture'] and not(./MapArea[1])) or ./MapArea[@Shape = 'WholePicture']">
						<a>
							<!-- if default map has whole picture area and custom one does not define a map area -->
							<xsl:if test = "(//MediaObject[@Id=$cmobid]/MediaItem[@Purpose = $curPurpose]/MapArea[@Shape = 'WholePicture'] and not(./MapArea[1]))">
								<xsl:for-each select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose = $curPurpose]/MapArea[@Shape = 'WholePicture']">
									<xsl:call-template name="setAreaLinkAttributes" />
								</xsl:for-each>
							</xsl:if>
							<!-- if custom map has whole picture area -->
							<xsl:if test = "./MapArea[@Shape = 'WholePicture']">
								<xsl:for-each select="./MapArea[@Shape = 'WholePicture']">
									<xsl:call-template name="setAreaLinkAttributes" />
								</xsl:for-each>
							</xsl:if>
							<xsl:call-template name="MOBImage">
								<xsl:with-param name="data" select="$data" />
								<xsl:with-param name="width" select="$width" />
								<xsl:with-param name="height" select="$height" />
								<xsl:with-param name="curPurpose" select="$curPurpose" />
								<xsl:with-param name="cmobid" select="$cmobid" />
								<xsl:with-param name="inline" select="$inline" />
							</xsl:call-template>
						</a>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="MOBImage">
							<xsl:with-param name="data" select="$data" />
							<xsl:with-param name="width" select="$width" />
							<xsl:with-param name="height" select="$height" />
							<xsl:with-param name="curPurpose" select="$curPurpose" />
							<xsl:with-param name="cmobid" select="$cmobid" />
							<xsl:with-param name="inline" select="$inline" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test = "$map_edit_mode = 'get_coords'">
				<input type="image" name="editImagemapForward" value="editImagemapForward">
					<xsl:attribute name="src"><xsl:value-of select="$image_map_link"/>&amp;item_id=<xsl:value-of select="$map_item"/>&amp;<xsl:value-of select="$link_params"/></xsl:attribute>
					<xsl:if test = "$width != ''">
						<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
					</xsl:if>
					<xsl:if test = "$height != ''">
						<xsl:attribute name="height"><xsl:value-of select="$height"/></xsl:attribute>
					</xsl:if>
				</input>
			</xsl:if>
		</xsl:when>

		<!-- text/html -->
		<xsl:when test="$type = 'text/html'">
			<xsl:if test = "$enable_html_mob = 'y'">
				<xsl:variable name="style_val" >
					<xsl:if test="$width != ''">
						width:<xsl:value-of select="$width"/>px;
					</xsl:if>
					<xsl:if test="$width = ''">
						width:100%;
					</xsl:if>
					<xsl:if test="$height != ''">
						height:<xsl:value-of select="$height"/>px;
					</xsl:if>
					<xsl:if test="$height = ''">
						height:100%;
					</xsl:if>
				</xsl:variable>
				<iframe frameborder="0">
					<xsl:attribute name="style"><xsl:value-of select="$style_val"/></xsl:attribute>
					<xsl:attribute name="src"><xsl:value-of select="$data"/></xsl:attribute>
					<xsl:if test="$width != ''">
						<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="$height != ''">
						<xsl:attribute name="height"><xsl:value-of select="$height"/></xsl:attribute>
					</xsl:if>
					<xsl:call-template name="MOBParams">
						<xsl:with-param name="curPurpose" select="$curPurpose" />
						<xsl:with-param name="mode">attributes</xsl:with-param>
						<xsl:with-param name="cmobid" select="$cmobid" />
					</xsl:call-template>
					<xsl:comment>Comment to have separate iframe ending tag</xsl:comment>
				</iframe>
			</xsl:if>
		</xsl:when>

		<!-- application/pdf -->
		<xsl:when test="$type = 'application/pdf'">
			<xsl:variable name="style_val" >
				<xsl:if test="$width != ''">
					width:<xsl:value-of select="$width"/>px;
				</xsl:if>
				<xsl:if test="$width = ''">
					width:100%;
				</xsl:if>
				<xsl:if test="$height != ''">
					height:<xsl:value-of select="$height"/>px;
				</xsl:if>
				<xsl:if test="$height = ''">
					height:100%;
				</xsl:if>
			</xsl:variable>
			<iframe frameborder="0">
				<xsl:attribute name="src"><xsl:value-of select="$data"/></xsl:attribute>
				<xsl:attribute name="style"><xsl:value-of select="$style_val"/></xsl:attribute>
				<xsl:call-template name="MOBParams">
					<xsl:with-param name="curPurpose" select="$curPurpose" />
					<xsl:with-param name="mode">attributes</xsl:with-param>
					<xsl:with-param name="cmobid" select="$cmobid" />
				</xsl:call-template>
				<xsl:comment>Comment to have separate iframe ending tag</xsl:comment>
			</iframe>
		</xsl:when>
		<!-- print placeholder !! All media types that can be printed should be listed above this one -->
		<xsl:when test="$mode = 'print'">
			<div class="ilCOPGMediaPrint">
				<xsl:attribute name="style">width:<xsl:value-of select="$width"/>px; height:<xsl:value-of select="$height"/>px; max-width: 100%;</xsl:attribute>
				<xsl:if test="$page_perma_link = ''">
					<xsl:value-of select="$title"/>
				</xsl:if>
				<xsl:if test="$page_perma_link != ''">
					<a>
						<xsl:attribute name="href"><xsl:value-of select="$page_perma_link"/></xsl:attribute>
						<xsl:value-of select="$title"/>
					</a>
				</xsl:if>
			</div>
		</xsl:when>


		<!-- mp4 -->

		<!-- YouTube -->
		<xsl:when test = "substring-after($data,'youtube.com') != '' or substring-after($data,'youtu.be') != ''">
			<!-- info on video preload attribute: http://www.stevesouders.com/blog/2013/04/12/html5-video-preload/ -->
			<!-- see #bug12622 -->
			<div class="il-video-container">
				<xsl:if test="$width != ''">
					<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="$height != ''">
					<xsl:attribute name="height"><xsl:value-of select="$height"/></xsl:attribute>
				</xsl:if>
				<iframe allow="fullscreen; autoplay; picture-in-picture;" referrerpolicy="strict-origin-when-cross-origin">
					<!-- see #bug22632 -->
					<xsl:attribute name="src"><xsl:value-of select="$httpprefix"/>//www.youtube.com/embed/<xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose=$curPurpose]/Parameter[@Name='v']/@Value" /></xsl:attribute>
				</iframe>
			</div>
		</xsl:when>
		<!--
		<xsl:when test = "substring-after($data,'youtube.com') != '' or substring-after($data,'youtu.be') != ''">
			<xsl:if test="$width = '' and $height = ''">
				<xsl:attribute name="class">embed-responsive embed-responsive-16by9</xsl:attribute>
			</xsl:if>
			<iframe frameborder="0" allowfullscreen="1">
				<xsl:if test="$width != ''">
					<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="$height != ''">
					<xsl:attribute name="height"><xsl:value-of select="$height"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="$width = '' and $height = ''">
					<xsl:attribute name="class">embed-responsive-item</xsl:attribute>
				</xsl:if>
				<xsl:attribute name="src">
					<xsl:value-of select="$httpprefix"/>//www.youtube.com/embed/<xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose=$curPurpose]/Parameter[@Name='v']/@Value" />
				</xsl:attribute>
				<xsl:comment>Comment to have separate iframe ending tag</xsl:comment>
			</iframe>
		</xsl:when>-->
		<xsl:when test = "substring-after($data,'xxxyoutube.com') != ''">
			<object>
				<xsl:if test="$width != ''">
					<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="$height != ''">
					<xsl:attribute name="height"><xsl:value-of select="$height"/></xsl:attribute>
				</xsl:if>
				<param name="movie">
					<xsl:attribute name="value"><xsl:value-of select="$httpprefix"/>//www.youtube.com/v/<xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose=$curPurpose]/Parameter[@Name='v']/@Value" />&amp;hl=en&amp;fs=1&amp;rel=0</xsl:attribute>
				</param>
				<param name="allowFullScreen" value="true"></param>
				<embed type="application/x-shockwave-flash"
					allowfullscreen="true">
					<xsl:if test="$width != ''">
						<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="$height != ''">
						<xsl:attribute name="height"><xsl:value-of select="$height"/></xsl:attribute>
					</xsl:if>
					<xsl:attribute name="src"><xsl:value-of select="$httpprefix"/>//www.youtube.com/v/<xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose=$curPurpose]/Parameter[@Name='v']/@Value" />&amp;hl=en&amp;fs=1&amp;rel=0</xsl:attribute>
					<xsl:comment>Comment to have separate embed ending tag</xsl:comment>
				</embed>
			</object>
		</xsl:when>


		<!-- mp3 (mediaelement.js) -->
		<xsl:when test = "$type='audio/mpeg' and (substring-before($data,'.mp3') != '' or substring-before($data,'.MP3') != '')">
			<div class="il-audio-container">
				<xsl:if test="$width != ''">
					<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
					<xsl:attribute name="height">40</xsl:attribute>
				</xsl:if>
				<xsl:if test="$width = '' and $height = ''">
					<xsl:attribute name="style">max-width: 100%; width: 100%; max-height: 100%;</xsl:attribute>
				</xsl:if>
			<audio controls="controls" class="il-audio-player" id="" preload="metadata">
				<xsl:attribute name="src"><xsl:value-of select="$data"/></xsl:attribute>
				<xsl:if test="$mode != 'edit' and
					(../MediaAliasItem[@Purpose = $curPurpose]/Parameter[@Name = 'autostart']/@Value = 'true' or
					( not(../MediaAliasItem[@Purpose = $curPurpose]/Parameter) and
					//MediaObject[@Id=$cmobid]/MediaItem[@Purpose=$curPurpose]/Parameter[@Name = 'autostart']/@Value = 'true'))">
					<!-- <xsl:attribute name="autoplay">true</xsl:attribute> -->
				</xsl:if>
			</audio>
			</div>
		</xsl:when>

		<!-- flv, mp4 (mediaelement.js) -->
		<xsl:when test = "$type = 'video/mp4' or $type = 'video/webm'">
			<!-- info on video preload attribute: http://www.stevesouders.com/blog/2013/04/12/html5-video-preload/ -->
			<!-- see #bug12622 -->

			<div class="il-video-container">
			<video class="il-video-player ilPageVideo" controls="controls" preload="metadata">
				<xsl:if test="$width != ''">
					<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="$height != ''">
					<xsl:attribute name="height"><xsl:value-of select="$height"/></xsl:attribute>
				</xsl:if>
				<!-- see #bug22632 -->
				<xsl:if test="$width = '' and $height = ''">
					<xsl:attribute name="style">max-width: 100%; width: 100%; max-height: 100%;</xsl:attribute>
				</xsl:if>
				<xsl:if test="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose=$curPurpose]/PreviewPic/@File != ''">
					<xsl:attribute name="poster"><xsl:value-of select="$webspace_path"/>mobs/mm_<xsl:value-of select="substring-after($cmobid,'mob_')"/>/<xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose=$curPurpose]/PreviewPic/@File"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="$mode != 'edit' and
					(../MediaAliasItem[@Purpose = $curPurpose]/Parameter[@Name = 'autostart']/@Value = 'true' or
					( not(../MediaAliasItem[@Purpose = $curPurpose]/Parameter) and
					//MediaObject[@Id=$cmobid]/MediaItem[@Purpose=$curPurpose]/Parameter[@Name = 'autostart']/@Value = 'true'))">
					<!-- <xsl:attribute name="autoplay">true</xsl:attribute> -->
				</xsl:if>
				<xsl:choose>
					<xsl:when test = "$type = 'video/mp4'">
						<source type="video/mp4">
							<xsl:attribute name="src"><xsl:value-of select="$data"/></xsl:attribute>
						</source>
					</xsl:when>
					<xsl:when test = "$type = 'video/webm'">
						<source type="video/webm">
							<xsl:attribute name="src"><xsl:value-of select="$data"/></xsl:attribute>
						</source>
					</xsl:when>
					<xsl:otherwise>
						<source type="video/x-flv">
							<xsl:attribute name="src"><xsl:value-of select="$data"/></xsl:attribute>
						</source>
					</xsl:otherwise>
				</xsl:choose>
				<!-- subtitle tracks -->
				<xsl:for-each select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose=$curPurpose]/Subtitle">
					<track kind="subtitles">
						<xsl:attribute name="src"><xsl:value-of select="@File"/></xsl:attribute>
						<xsl:attribute name="srclang"><xsl:value-of select="@Language"/></xsl:attribute>
						<xsl:attribute name="label"><xsl:value-of select="@Language"/></xsl:attribute>
						<xsl:if test = "@Default = 'true'">
							<xsl:attribute name="default">default</xsl:attribute>
						</xsl:if>
					</track>
				</xsl:for-each>
			</video>
			</div>
			<!-- subtitle workaround -->
			<xsl:if test="$mode = 'offline'" >
				<xsl:for-each select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose=$curPurpose]/Subtitle">
					<xsl:if test = "@Default = 'true'">
						<div class="ilMobSubtitleText" style="display:none;"><xsl:attribute name="name"><xsl:value-of select="$cmobid"/>_<xsl:value-of select="$curPurpose"/></xsl:attribute>[[[[[mobsubtitle;<xsl:value-of select="$cmobid"/>_<xsl:value-of select="$curPurpose"/>]]]]]</div>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:when>

		<xsl:when test = "$type = 'video/vimeo'">
			<!-- info on video preload attribute: http://www.stevesouders.com/blog/2013/04/12/html5-video-preload/ -->
			<!-- see #bug12622 -->
			<div class="il-video-container">
				<xsl:if test="$width != ''">
					<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="$height != ''">
					<xsl:attribute name="height"><xsl:value-of select="$height"/></xsl:attribute>
				</xsl:if>
			<iframe allow="fullscreen; autoplay; picture-in-picture;" referrerpolicy="strict-origin-when-cross-origin">
				<!-- see #bug22632 -->
				<xsl:attribute name="src">//player.vimeo.com/video/<xsl:value-of select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose=$curPurpose]/Parameter[@Name='id']/@Value" /></xsl:attribute>
			</iframe>
			</div>
		</xsl:when>

		<!-- svg -->
		<xsl:when test="substring($type, 1, 9) = 'image/svg'">
			<embed style="width:100%; display:block;">
				<xsl:attribute name="src"><xsl:value-of select="$data"/></xsl:attribute>
				<xsl:attribute name="type"><xsl:value-of select="$type"/></xsl:attribute>
				<xsl:if test="$width != ''">
					<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
				</xsl:if>
				<xsl:if test="$height != ''">
					<xsl:attribute name="height"><xsl:value-of select="$height"/></xsl:attribute>
				</xsl:if>
				<xsl:call-template name="MOBParams">
					<xsl:with-param name="curPurpose" select="$curPurpose" />
					<xsl:with-param name="mode">attributes</xsl:with-param>
					<xsl:with-param name="cmobid" select="$cmobid" />
				</xsl:call-template>
				<xsl:comment>Comment to have separate embed ending tag</xsl:comment>
			</embed>
		</xsl:when>


		<xsl:when test = "$type=''">
			{{{{{No Media Type}}}}}
		</xsl:when>

		<!-- 36216 -->
		<!-- all other mime types: output standard object/embed tag -->
		<xsl:otherwise>
			{{{{{Unsupported Media Type}}}}}
		</xsl:otherwise>

	</xsl:choose>
</xsl:template>

<!-- MOB Parameters -->
<xsl:template name="MOBParams">
	<xsl:param name="curPurpose"/>
	<xsl:param name="cmobid"/>
	<xsl:param name="mode"/>		<!-- 'attributes' | 'elements' -->

	<xsl:choose>
		<!-- output parameters as attributes -->
		<xsl:when test="$mode = 'attributes'">
			<xsl:choose>
				<!-- take parameters from alias -->
				<xsl:when test = "../MediaAliasItem[@Purpose = $curPurpose]/Parameter">
					<xsl:for-each select="../MediaAliasItem[@Purpose = $curPurpose]/Parameter">
						<xsl:attribute name="{@Name}"><xsl:value-of select="@Value"/></xsl:attribute>
					</xsl:for-each>
				</xsl:when>
				<!-- take parameters from object -->
				<xsl:otherwise>
					<xsl:for-each select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose=$curPurpose]/Parameter">
						<xsl:attribute name="{@Name}"><xsl:value-of select="@Value"/></xsl:attribute>
					</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<!-- output parameters as param elements -->
		<xsl:otherwise>
			<xsl:choose>
				<!-- take parameters from alias -->
				<xsl:when test = "../MediaAliasItem[@Purpose = $curPurpose]/Parameter">
					<xsl:for-each select="../MediaAliasItem[@Purpose = $curPurpose]/Parameter">
						<param>
						<xsl:attribute name="name"><xsl:value-of select="@Name"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="@Value"/></xsl:attribute>
						</param>
					</xsl:for-each>
				</xsl:when>
				<!-- take parameters from object -->
				<xsl:otherwise>
					<xsl:for-each select="//MediaObject[@Id=$cmobid]/MediaItem[@Purpose=$curPurpose]/Parameter">
						<param>
						<xsl:attribute name="name"><xsl:value-of select="@Name"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="@Value"/></xsl:attribute>
						</param>
					</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:otherwise>
	</xsl:choose>

</xsl:template>

<!-- Fullscreen Link -->
<xsl:template name="FullscreenLink">
	<xsl:param name="cmobid"/>
	<xsl:if test="count(../MediaAliasItem[@Purpose='Fullscreen']) = 1 and
		count(//MediaObject[@Id=$cmobid]/MediaItem[@Purpose='Fullscreen']) = 1 and
		$mode != 'fullscreen' and $mode != 'print'">

		<xsl:choose>
		<xsl:when test="$fullscreen_link = 'fullscreen.html'">
			<a target="_blank">
			<xsl:attribute name="href">fullscreen_<xsl:value-of select="substring-after($cmobid,'mob_')"/>.html</xsl:attribute>
			<img style="float: right; width: auto;">
			<xsl:attribute name="src"><xsl:value-of select="$enlarge_path"/></xsl:attribute>
			</img>
			</a>
		</xsl:when>
		<xsl:otherwise>
			<a target="_blank">
			<xsl:attribute name="onclick">il.COPagePres.openFullScreenModal('<xsl:value-of select="$fullscreen_link"/>&amp;mob_id=<xsl:value-of select="substring-after($cmobid,'mob_')"/>&amp;pg_id=<xsl:value-of select="$pg_id"/>'); return false;</xsl:attribute>
			<img style="float: right; width: auto;">
			<xsl:attribute name="src"><xsl:value-of select="$enlarge_path"/></xsl:attribute>
			</img>
			</a>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:if>
</xsl:template>


<!-- MediaObject -->
<xsl:template match="MediaObject">
	<!-- Label -->
	<xsl:if test="./MediaAlias">
	<xsl:call-template name="EditLabel"><xsl:with-param name="text"><xsl:value-of select="//LVs/LV[@name='pc_mob']/@value"/> <xsl:if test="./MediaAlias/@Class"> (<xsl:value-of select="./MediaAlias/@Class"/>)</xsl:if></xsl:with-param></xsl:call-template>
	</xsl:if>
	<xsl:apply-templates select="MediaAlias"/>
</xsl:template>

<!-- InteractiveImage -->
<xsl:template match="InteractiveImage">
	<!-- Label -->
	<xsl:if test="./MediaAlias">
	<xsl:call-template name="EditLabel"><xsl:with-param name="text"><xsl:value-of select="//LVs/LV[@name='pc_iim']/@value"/></xsl:with-param></xsl:call-template>
	</xsl:if>
	<div>
		<xsl:if test="$mode = 'edit'">
			<xsl:attribute name="style">border: 2px solid #000000; padding: 20px;</xsl:attribute>
		</xsl:if>
		<xsl:if test="$mode != 'edit'">
			<xsl:if test="./MediaAliasItem[@Purpose='Standard']/Layout[1]/@HorizontalAlign = 'LeftFloat'">
				<xsl:attribute name="style">float:left; clear:both;</xsl:attribute>
			</xsl:if>
			<xsl:if test="./MediaAliasItem[@Purpose='Standard']/Layout[1]/@HorizontalAlign = 'RightFloat'">
				<xsl:attribute name="style">float:right; clear:both;</xsl:attribute>
			</xsl:if>
		</xsl:if>
		<xsl:apply-templates select="MediaAlias"/>
		<xsl:apply-templates select="Trigger"/>
		<xsl:for-each select="./Trigger">
			<xsl:call-template name="Marker" />
		</xsl:for-each>
		<xsl:apply-templates select="ContentPopup"/>
		<div style="clear:both;"><xsl:comment>Break</xsl:comment></div>
	</div>
</xsl:template>

<!-- ContentPopup -->
<xsl:template match="ContentPopup">
	<!-- TabContainer -->
	{{{{{InteractiveImage;PopupStart;<xsl:value-of select = "$pg_id"/>;<xsl:number count="InteractiveImage" level="any" />;<xsl:value-of select = "@Nr"/>}}}}}
	<div class="ilc_iim_ContentPopup">
	<xsl:attribute name="id">iim_popup_<xsl:value-of select = "$pg_id"/>_<xsl:number count="InteractiveImage" level="any" />_<xsl:value-of select = "@Nr"/></xsl:attribute>
	<xsl:if test="$mode != 'edit'">
		<xsl:attribute name="data-copg-iim-data-type">popup</xsl:attribute>
		<xsl:attribute name="data-copg-iim-id"><xsl:value-of select = "$pg_id"/>_<xsl:number count="InteractiveImage" level="any" /></xsl:attribute>
		<xsl:attribute name="data-copg-iim-pop-id"><xsl:value-of select = "$pg_id"/>_<xsl:number count="ContentPopup" level="any" /></xsl:attribute>
		<xsl:attribute name="data-copg-iim-div-id">iim_popup_<xsl:value-of select = "$pg_id"/>_<xsl:number count="ContentPopup" level="any" /></xsl:attribute>
		<xsl:attribute name="data-copg-iim-nr"><xsl:value-of select="@Nr"/></xsl:attribute>
		<xsl:attribute name="data-copg-iim-title"><xsl:value-of select="@Title"/></xsl:attribute>
	</xsl:if>
	<xsl:if test="$mode = 'edit'">
		<xsl:attribute name="style">border: 1px solid #000000; padding: 20px; margin-bottom:10px;</xsl:attribute>
		<div style="margin-bottom:20px;">
			<i><strong><xsl:value-of select="@Title" /></strong></i>
			<xsl:comment>Break</xsl:comment>
		</div>
	</xsl:if>

	<!-- Content -->
	<div>
		<div>
			<xsl:call-template name="EditReturnAnchors"/>
			<!-- <xsl:value-of select="@HierId"/> -->
			<xsl:if test="$mode = 'edit'">
				<xsl:if test="$javascript = 'enable'">
					<xsl:call-template name="DropArea">
						<xsl:with-param name="hier_id"><xsl:value-of select="@HierId"/></xsl:with-param>
						<xsl:with-param name="pc_id"><xsl:value-of select="@PCID"/></xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</xsl:if>
			<xsl:apply-templates select="PageContent"/>
			<div style="clear:both;"><xsl:comment>Break</xsl:comment></div>
		</div>
		<div style="clear:both;"><xsl:comment>Break</xsl:comment></div>
	</div>
	<div style="clear:both;"><xsl:comment>Break</xsl:comment></div>
	</div>
	{{{{{InteractiveImage;PopupEnd;<xsl:value-of select = "$pg_id"/>;<xsl:number count="InteractiveImage" level="any" />;<xsl:value-of select = "@Nr"/>}}}}}
</xsl:template>

<!-- Trigger -->
<xsl:template match="Trigger">
	<xsl:if test="@Overlay != ''">
		<xsl:variable name="cur_nr" select="@Nr" />
		<xsl:variable name="mobid" select="../MediaAlias/@OriginId" />
		<img style="display:none;">
		<xsl:attribute name="src"><xsl:value-of select="//MediaObject[@Id=$mobid]/MediaItem[@Purpose = 'Standard']/Url/@Base"/>/overlays/<xsl:value-of select="@Overlay"/></xsl:attribute>
		<xsl:attribute name="id">iim_ov_<xsl:value-of select = "$pg_id"/>_<xsl:number count="Trigger" level="any" /></xsl:attribute>
		<xsl:if test="$mode != 'edit'">
			<xsl:attribute name="usemap">#iim_ov_map_<xsl:value-of select = "$pg_id"/>_<xsl:number count="Trigger" level="any" /></xsl:attribute>
		</xsl:if>
		</img>
		<xsl:if test="@Type = 'Area'">
			<map>
			<xsl:attribute name="id">iim_ov_map_<xsl:value-of select = "$pg_id"/>_<xsl:number count="Trigger" level="any" /></xsl:attribute>
			<xsl:attribute name="name">iim_ov_map_<xsl:value-of select = "$pg_id"/>_<xsl:number count="Trigger" level="any" /></xsl:attribute>
				<area href="#" coords="10,10,100,100">
					<xsl:attribute name="id">iim_ov_area_<xsl:value-of select = "$pg_id"/>_<xsl:number count="Trigger" level="any" /></xsl:attribute>
					<xsl:attribute name="shape"><xsl:value-of select="../MediaAliasItem/MapArea[@Id = $cur_nr]/@Shape"/></xsl:attribute>
				</area>
			</map>
		</xsl:if>
	</xsl:if>
	<xsl:if test="$map_edit_mode != 'get_coords'">
		<span style="display:none;">
			<xsl:attribute name="data-copg-iim-data-type">trigger</xsl:attribute>
			<xsl:attribute name="data-copg-iim-id"><xsl:value-of select = "$pg_id"/>_<xsl:number count="InteractiveImage" level="any" /></xsl:attribute>
			<xsl:attribute name="data-copg-iim-type"><xsl:value-of select="@Type"/></xsl:attribute>
			<xsl:attribute name="data-copg-iim-title"><xsl:value-of select="@Title"/></xsl:attribute>
			<xsl:attribute name="data-copg-iim-ovx"><xsl:value-of select="@OverlayX"/></xsl:attribute>
			<xsl:attribute name="data-copg-iim-ovy"><xsl:value-of select="@OverlayY"/></xsl:attribute>
			<xsl:attribute name="data-copg-iim-markx"><xsl:value-of select="@MarkerX"/></xsl:attribute>
			<xsl:attribute name="data-copg-iim-marky"><xsl:value-of select="@MarkerY"/></xsl:attribute>
			<xsl:attribute name="data-copg-iim-popup-nr"><xsl:value-of select="@PopupNr"/></xsl:attribute>
			<xsl:attribute name="data-copg-iim-popup-size"><xsl:value-of select="@PopupSize"/></xsl:attribute>
			<xsl:attribute name="data-copg-iim-nr"><xsl:value-of select="@Nr"/></xsl:attribute>
			<xsl:attribute name="data-copg-iim-popx"><xsl:value-of select="@PopupX"/></xsl:attribute>
			<xsl:attribute name="data-copg-iim-popy"><xsl:value-of select="@PopupY"/></xsl:attribute>
			<xsl:attribute name="data-copg-iim-popwidth"><xsl:value-of select="@PopupWidth"/></xsl:attribute>
			<xsl:attribute name="data-copg-iim-popheight"><xsl:value-of select="@PopupHeight"/></xsl:attribute>
			<xsl:attribute name="data-copg-iim-tr-id"><xsl:value-of select = "$pg_id"/>_<xsl:number count="Trigger" level="any" /></xsl:attribute>
			<xsl:comment>Break</xsl:comment>
		</span>
	</xsl:if>
</xsl:template>

<!-- Marker -->
<xsl:template name="Marker">
	<xsl:if test="@Type = 'Marker'">
		<a class="ilc_marker_Marker" style="display:none;">
			<xsl:attribute name="data-copg-iim-data-type">marker</xsl:attribute>
			<xsl:attribute name="data-copg-iim-id"><xsl:value-of select = "$pg_id"/>_<xsl:number count="InteractiveImage" level="any" /></xsl:attribute>
			<xsl:attribute name="data-copg-iim-m-id">iim_mark_<xsl:value-of select = "$pg_id"/>_<xsl:number count="Trigger" level="any" /></xsl:attribute>
			<xsl:attribute name="data-copg-iim-markx"><xsl:value-of select="@MarkerX"/></xsl:attribute>
			<xsl:attribute name="data-copg-iim-marky"><xsl:value-of select="@MarkerY"/></xsl:attribute>
			<xsl:attribute name="data-copg-iim-tr-nr"><xsl:value-of select="@Nr"/></xsl:attribute>
			<xsl:attribute name="data-copg-iim-tr-id"><xsl:value-of select = "$pg_id"/>_<xsl:number count="Trigger" level="any" /></xsl:attribute>
			<xsl:attribute name="data-copg-iim-edit-mode"><xsl:if test="$mode = 'edit'">1</xsl:if></xsl:attribute>
			<xsl:attribute name="id">iim_mark_<xsl:value-of select = "$pg_id"/>_<xsl:number count="Trigger" level="any" /></xsl:attribute>
			<xsl:comment>Break</xsl:comment>
		</a>
	</xsl:if>
</xsl:template>

<!-- QuestionOverview -->
<xsl:template match="QuestionOverview">
	<!-- Label -->
	<xsl:call-template name="EditLabel"><xsl:with-param name="text"><xsl:value-of select="//LVs/LV[@name='pc_qover']/@value"/></xsl:with-param></xsl:call-template>
	<div>
		<div class="ilc_qover_QuestionOverview">
			<xsl:attribute name="id">qover_<xsl:value-of select = "$pg_id"/>_<xsl:number count="QuestionOverview" level="any" /></xsl:attribute>
			<xsl:comment>Break</xsl:comment>
		</div>
		<xsl:if test="$mode = 'edit'">
			<!-- <xsl:value-of select="../@HierId"/> -->
			<xsl:if test="$javascript='disable'">
				<br />
				<input type="checkbox" name="target[]">
					<xsl:attribute name="value"><xsl:value-of select="../@HierId"/>:<xsl:value-of select="../@PCID"/>
					</xsl:attribute>
				</input>
			</xsl:if>
			<xsl:call-template name="EditMenu">
				<xsl:with-param name="hier_id" select="../@HierId" />
				<xsl:with-param name="pc_id" select="../@PCID" />
				<xsl:with-param name="edit">y</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</div>
	<script type="text/javascript">
	il.COPagePres.addQuestionOverview(
		{div_id: 'qover_<xsl:value-of select = "$pg_id"/>_<xsl:number count="QuestionOverview" level="any" />',
		id: '<xsl:value-of select = "$pg_id"/>_<xsl:number count="QuestionOverview" level="any" />',
		short_message: '<xsl:value-of select = "@ShortMessage" />',
		list_wrong_questions: '<xsl:value-of select = "@ListWrongQuestions" />'
	});
	</script>
</xsl:template>

<!-- CharacteristicName -->
<xsl:template name="CharacteristicName">
	<xsl:param name="pctype"/>
	<xsl:param name="characteristic"/>
	<xsl:variable name="key">char_<xsl:value-of select="$pctype"/>_<xsl:value-of select="$characteristic"/></xsl:variable>
	<xsl:if test="$characteristic">
		<xsl:choose>
			<xsl:when test="//LVs/LV[@name=$key]/@value">
				(<xsl:value-of select="//LVs/LV[@name=$key]/@value"/>)
			</xsl:when>
			<xsl:otherwise>
				(<xsl:value-of select="$characteristic"/>)
			</xsl:otherwise>
		</xsl:choose>
	</xsl:if>
</xsl:template>

<!-- Section -->
	<xsl:template match="Section">
		<xsl:variable name="char_name">
			<xsl:call-template name="CharacteristicName">
				<xsl:with-param name="pctype">section</xsl:with-param>
				<xsl:with-param name="characteristic"><xsl:value-of select="@Characteristic"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<!-- Label -->
		<xsl:call-template name="EditLabel"><xsl:with-param name="text"><xsl:value-of select="//LVs/LV[@name='pc_sec']/@value"/> <xsl:value-of select="$char_name"/></xsl:with-param></xsl:call-template>
		<xsl:if test="($mode = 'edit') or ((not(@ActiveFrom) or (@ActiveFrom &lt; $current_ts)) and (not(@ActiveTo) or (@ActiveTo &gt; $current_ts)))">
			<xsl:if test="@PermissionRefId">
				{{{{{Section;Access;PermissionRefId;<xsl:value-of select="@PermissionRefId"/>;Permission;<xsl:value-of select="@Permission"/>;<xsl:number count="Section" level="any" />}}}}}
			</xsl:if>
			<xsl:if test="(./ExtLink or ./IntLink) and not($mode = 'edit')">
				<a style="display:block;">
					<xsl:for-each select="./ExtLink">
						<xsl:call-template name="SetExtLinkAttributes" />
					</xsl:for-each>
					<xsl:for-each select="./IntLink">
						<xsl:variable name="targetframe">
							<xsl:choose>
								<xsl:when test="@TargetFrame">
									<xsl:value-of select="@TargetFrame"/>
								</xsl:when>
								<xsl:otherwise>None</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:call-template name="SetIntLinkAttributes"><xsl:with-param name="targetframe"><xsl:value-of select="$targetframe"/></xsl:with-param></xsl:call-template>
					</xsl:for-each>
					<xsl:call-template name="SectionContent" />
				</a>
			</xsl:if>
			<xsl:if test="(not(./ExtLink) and not(./IntLink)) or $mode = 'edit'">
				<xsl:if test="$mode = 'edit' and $activated_protection = 'y' and @Protected = '1'">
					<div class="small"><xsl:value-of select="$protection_text"/></div>
				</xsl:if>
				<div>
					<xsl:if test="$activated_protection = 'y' and @Protected = '1'">
						<xsl:attribute name="data-protected">1</xsl:attribute>
					</xsl:if>
					<xsl:call-template name="SectionContent" />
				</div>
			</xsl:if>
			<xsl:if test="@PermissionRefId">
				{{{{{Section;AccessEnd;<xsl:number count="Section" level="any" />}}}}}
			</xsl:if>
		</xsl:if>
	</xsl:template>


<!-- Section Div -->
<xsl:template name="SectionContent">
		<xsl:if test="@Characteristic">
			<xsl:if test="substring(@Characteristic, 1, 4) = 'ilc_'">
				<xsl:attribute name="class">ilc_section_<xsl:value-of select="substring-after(@Characteristic, 'ilc_')"/> ilCOPageSection</xsl:attribute>
			</xsl:if>
			<xsl:if test="substring(@Characteristic, 1, 4) != 'ilc_'">
				<xsl:attribute name="class">ilc_section_<xsl:value-of select="@Characteristic"/> ilCOPageSection</xsl:attribute>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$mode = 'edit'">
			<xsl:attribute name="style">min-height: 60px; height: auto !important; height: 60px; position:static; display: block; margin:0;</xsl:attribute>
		</xsl:if>
		<xsl:call-template name="EditReturnAnchors"/>
		<!-- command selectbox -->
		<xsl:if test="$mode = 'edit'">
			<xsl:if test="@ActiveFrom or @ActiveTo">
				<div style="text-align:right;" class="small">{{{{{Section;ActiveFrom;<xsl:value-of select="@ActiveFrom"/>;ActiveTo;<xsl:value-of select="@ActiveTo"/>}}}}}</div>
			</xsl:if>
			<div class="copg-edit-container">
				<xsl:call-template name="DropArea">
					<xsl:with-param name="hier_id"><xsl:value-of select="@HierId"/></xsl:with-param>
					<xsl:with-param name="pc_id"><xsl:value-of select="@PCID"/></xsl:with-param>
				</xsl:call-template>
				<xsl:apply-templates/>
			</div>
		</xsl:if>
		<xsl:if test="$mode != 'edit'">
			<xsl:apply-templates/>
		</xsl:if>
		<xsl:if test="$mode = 'edit'">
			<!-- <xsl:value-of select="../@HierId"/> -->
			<xsl:if test="$javascript='disable'">
				<br />
				<input type="checkbox" name="target[]">
					<xsl:attribute name="value"><xsl:value-of select="../@HierId"/>:<xsl:value-of select="../@PCID"/>
					</xsl:attribute>
				</input>
			</xsl:if>
			<xsl:call-template name="EditMenu">
				<xsl:with-param name="hier_id" select="../@HierId" />
				<xsl:with-param name="pc_id" select="../@PCID" />
				<xsl:with-param name="edit">y</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="$mode = 'edit'">
			<br />
		</xsl:if>
		<xsl:comment>Break</xsl:comment>
</xsl:template>

	<!-- Resources -->
<xsl:template match="Resources">
	<xsl:call-template name="EditLabel"><xsl:with-param name="text"><xsl:value-of select="//LVs/LV[@name='pc_res']/@value"/> <xsl:if test="@Template"> (<xsl:value-of select="@Template"/>)</xsl:if></xsl:with-param></xsl:call-template>
	<div>
		<xsl:if test="./ResourceList">
			[list-<xsl:value-of select="./ResourceList/@Type"/>]
		</xsl:if>
		<xsl:if test="./ItemGroup">
			[item-group-<xsl:value-of select="./ItemGroup/@RefId"/>]
		</xsl:if>
		<xsl:call-template name="EditReturnAnchors"/>
		<xsl:if test="$mode = 'edit'">
			<!-- <xsl:value-of select="../@HierId"/> -->
			<xsl:if test="$javascript='disable'">
				<br />
				<input type="checkbox" name="target[]">
					<xsl:attribute name="value"><xsl:value-of select="../@HierId"/>:<xsl:value-of select="../@PCID"/>
					</xsl:attribute>
				</input>
			</xsl:if>
			<xsl:call-template name="EditMenu">
				<xsl:with-param name="hier_id" select="../@HierId" />
				<xsl:with-param name="pc_id" select="../@PCID" />
				<xsl:with-param name="edit">y</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</div>
</xsl:template>

<!-- Login Page -->
<xsl:template match="LoginPageElement">
	<div>
		<xsl:choose>
			<xsl:when test="@HorizontalAlign = 'Left'">
				<xsl:attribute name="align">left</xsl:attribute>
			</xsl:when>
			<xsl:when test="@HorizontalAlign = 'Right'">
				<xsl:attribute name="align">right</xsl:attribute>
			</xsl:when>
			<xsl:when test="@HorizontalAlign = 'LeftFloat'">
				<xsl:attribute name="style">clear: both; float: left</xsl:attribute>
			</xsl:when>
			<xsl:when test="@HorizontalAlign = 'RightFloat'">
				<xsl:attribute name="style">clear: both; float: right</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="align">center</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
		[list-<xsl:value-of select="./@Type"/>]
		<xsl:call-template name="EditReturnAnchors"/>
		<xsl:if test="$mode = 'edit'">
			<!-- <xsl:value-of select="../@HierId"/> -->
			<xsl:if test="$javascript='disable'">
				<br />
				<input type="checkbox" name="target[]">
					<xsl:attribute name="value"><xsl:value-of select="../@HierId"/>:<xsl:value-of select="../@PCID"/>
					</xsl:attribute>
				</input>
			</xsl:if>
			<xsl:call-template name="EditMenu">
				<xsl:with-param name="hier_id" select="../@HierId" />
				<xsl:with-param name="pc_id" select="../@PCID" />
				<xsl:with-param name="edit">y</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</div>
</xsl:template>

<!-- Map -->
<xsl:template match="Map">
	<div style="clear:both;">
		<xsl:if test="./Layout[1]/@HorizontalAlign = 'Left'">
			<xsl:attribute name="align">left</xsl:attribute>
		</xsl:if>
		<xsl:if test="./Layout[1]/@HorizontalAlign = 'Center'">
			<xsl:attribute name="align">center</xsl:attribute>
		</xsl:if>
		<xsl:if test="./Layout[1]/@HorizontalAlign = 'Right'">
			<xsl:attribute name="align">right</xsl:attribute>
		</xsl:if>
		<xsl:if test="./Layout[1]/@HorizontalAlign = 'LeftFloat'">
			<xsl:if test="$mode != 'edit'">
				<xsl:attribute name="style">clear:both; float:left;</xsl:attribute>
			</xsl:if>
		</xsl:if>
		<xsl:if test="./Layout[1]/@HorizontalAlign = 'RightFloat'">
			<xsl:if test="$mode != 'edit'">
				<xsl:attribute name="style">clear:both; float:right;</xsl:attribute>
			</xsl:if>
		</xsl:if>
		<div class="ilc_media_cont_MediaContainer">
			<xsl:if test="(./Layout[1]/@HorizontalAlign = 'LeftFloat')">
				<xsl:attribute name="style">margin-left: 0px; style="float:left;"</xsl:attribute>
			</xsl:if>
			<xsl:if test="./Layout[1]/@HorizontalAlign = 'RightFloat'">
				<xsl:attribute name="style">margin-right: 0px; style="float:right;</xsl:attribute>
			</xsl:if>
			<figure>
				<xsl:attribute name="style">width: <xsl:value-of select="./Layout[1]/@Width"/>px</xsl:attribute>
				<div class="ilc_Mob">
					[[[[[Map;<xsl:value-of select="@Latitude"/>;<xsl:value-of select="@Longitude"/>;<xsl:value-of select="@Zoom"/>;<xsl:value-of select="./Layout[1]/@Width"/>;<xsl:value-of select="./Layout[1]/@Height"/>]]]]]
					<xsl:call-template name="EditReturnAnchors"/>
				</div>
			<xsl:if test="count(./MapCaption[1]) != 0">
				<figcaption class="ilc_media_caption_MediaCaption">
				<xsl:value-of select="./MapCaption[1]"/>
				</figcaption>
			</xsl:if>
			</figure>
		</div>
		<xsl:if test="$mode = 'edit'">
			<!-- <xsl:value-of select="../@HierId"/> -->
			<xsl:if test="$javascript='disable'">
				<br />
				<input type="checkbox" name="target[]">
					<xsl:attribute name="value"><xsl:value-of select="../@HierId"/>:<xsl:value-of select="../@PCID"/>
					</xsl:attribute>
				</input>
			</xsl:if>
			<xsl:call-template name="EditMenu">
				<xsl:with-param name="hier_id" select="../@HierId" />
				<xsl:with-param name="pc_id" select="../@PCID" />
				<xsl:with-param name="edit">y</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</div>
</xsl:template>

<!-- Tabs -->
<xsl:template match="Tabs">
	<!-- Label -->
	<xsl:if test="@Type = 'VerticalAccordion' or @Type = 'HorizontalAccordion'">
	<xsl:call-template name="EditLabel"><xsl:with-param name="text"><xsl:value-of select="//LVs/LV[@name='pc_vacc']/@value"/> <xsl:if test="@Template != 'VerticalAccordion' and @Template != 'HorizontalAccordion'"> (<xsl:value-of select="@Template"/>)</xsl:if></xsl:with-param></xsl:call-template>
	</xsl:if>
	<xsl:if test="@Type = 'Carousel'">
		<xsl:call-template name="EditLabel"><xsl:with-param name="text"><xsl:value-of select="//LVs/LV[@name='pc_carousel']/@value"/><xsl:if test="@Template != 'Carousel'"> (<xsl:value-of select="@Template"/>)</xsl:if></xsl:with-param></xsl:call-template>
	</xsl:if>
	<xsl:variable name="ttemp" select="@Template"/>
	<xsl:call-template name="EditReturnAnchors"/>
	<xsl:variable name="halign"><xsl:choose>
		<xsl:when test="@HorizontalAlign = 'Center'">margin-left: auto; margin-right: auto;</xsl:when>
		<xsl:when test="@HorizontalAlign = 'Right'">margin-left: auto; <xsl:if test="$disable_auto_margins != 'y'">margin-right: 0px;</xsl:if></xsl:when>
		<xsl:when test="@HorizontalAlign = 'LeftFloat'">float:left; <xsl:if test="$disable_auto_margins != 'y'">margin-left: 0px;</xsl:if></xsl:when>
		<xsl:when test="@HorizontalAlign = 'RightFloat'">float:right; <xsl:if test="$disable_auto_margins != 'y'">margin-right:0px;</xsl:if></xsl:when>
		<xsl:otherwise></xsl:otherwise>
	</xsl:choose></xsl:variable>
	<xsl:variable name="aheadclass">
		<xsl:choose>
			<xsl:when test="@Template and //StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='va_iheada']/@Value">ilc_va_iheada_<xsl:value-of select = "//StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='va_iheada']/@Value"/></xsl:when>
			<xsl:otherwise>ilc_va_iheada_AccordIHeadActive</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<div>
		<xsl:variable name="cwidth">
			<xsl:choose>
			<xsl:when test="@ContentWidth and number(@ContentWidth) > 0"><xsl:value-of select="@ContentWidth" /></xsl:when>
			<xsl:otherwise>null</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!--
		<xsl:if test="@Type = 'VerticalAccordion' and $cwidth != 'null'">
			<xsl:attribute name="style">width: <xsl:value-of select="$cwidth" />px; <xsl:value-of select="$halign" /><xsl:if test="$mode='edit'"> background-color:white;</xsl:if></xsl:attribute>
		</xsl:if>-->
		<xsl:if test="@Type = 'Carousel'">
			<!-- <xsl:choose>
				<xsl:when test="$cwidth != 'null'">
					<xsl:attribute name="style">display: grid; width: <xsl:value-of select="$cwidth" />px; <xsl:value-of select="$halign" /></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="style">display: grid;</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose> -->
		</xsl:if>
		<xsl:variable name="cheight">null</xsl:variable>
		<div>
		<xsl:attribute name="id">ilc_accordion_<xsl:value-of select = "$pg_id"/>_<xsl:number count="Tabs" level="any" /></xsl:attribute>
		<xsl:attribute name="data-copg-tabs-type"><xsl:value-of select="@Type" /></xsl:attribute>
		<xsl:choose>
		<xsl:when test="$mode = 'edit' or $mode = 'print' or $compare_mode = 'y'">
			<xsl:attribute name="class">ilc_va_cntr_AccordCntr</xsl:attribute>
		</xsl:when>
		<xsl:when test="@Type = 'VerticalAccordion' or @Type = 'HorizontalAccordion'">
			<xsl:variable name="beh">
				<xsl:choose>
					<xsl:when test="$mode = 'print'">ForceAllOpen</xsl:when>
					<xsl:when test="$compare_mode = 'y'">ForceAllOpen</xsl:when>
					<xsl:otherwise><xsl:value-of select="@Behavior"/></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="class">ilc_va_cntr_AccordCntr</xsl:attribute>
			<xsl:if test="@Template and //StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='va_cntr']/@Value">
				<xsl:attribute name = "class">ilc_va_cntr_<xsl:value-of select = "//StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='va_cntr']/@Value"/></xsl:attribute>
			</xsl:if>
			<xsl:attribute name="data-copg-tabs-toggle-class">il_VAccordionToggleDef</xsl:attribute>
			<xsl:attribute name="data-copg-tabs-toggle-act-class">il_VAccordionToggleActiveDef</xsl:attribute>
			<xsl:attribute name="data-copg-tabs-content-class">il_VAccordionContentDef</xsl:attribute>
			<xsl:attribute name="data-copg-tabs-behaviour"><xsl:value-of select = "$beh"/></xsl:attribute>
			<xsl:attribute name="data-copg-tabs-save-url"><xsl:value-of select = "$acc_save_url"/></xsl:attribute>
			<xsl:attribute name="data-copg-tabs-active-head-class"><xsl:value-of select = "$aheadclass"/></xsl:attribute>
		</xsl:when>
		<xsl:when test="@Type = 'Carousel'">
			<xsl:attribute name="class">ilc_ca_cntr_CarouselCntr</xsl:attribute>
			<xsl:attribute name="data-copg-tabs-auto-anim-wait"><xsl:value-of select = "number(@AutoAnimWait)"/></xsl:attribute>
			<xsl:attribute name="data-copg-tabs-random-start"><xsl:value-of select = "number(@RandomStart)"/></xsl:attribute>
			<xsl:if test="@Template and //StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='ca_cntr']/@Value">
				<xsl:attribute name = "class">ilc_ca_cntr_<xsl:value-of select = "//StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='ca_cntr']/@Value"/> owl-carousel</xsl:attribute>
			</xsl:if>
		</xsl:when>
		</xsl:choose>
			<xsl:apply-templates select="Tab">
				<xsl:with-param name="cwidth" select="$cwidth" />
				<xsl:with-param name="cheight" select="$cheight" />
				<xsl:with-param name="ttemp" select="$ttemp" />
				<xsl:with-param name="aheadclass" select="$aheadclass" />
			</xsl:apply-templates>
			<xsl:if test="@Type != 'Carousel'">
				<div style="clear:both;"><xsl:comment>Break</xsl:comment></div>
			</xsl:if>
		</div>
		<!-- command selectbox -->
		<xsl:if test="$mode = 'edit'">
			<!-- <xsl:value-of select="../@HierId"/> -->
			<xsl:if test = "$javascript='disable'">
			<input type="checkbox" name="target[]">
				<xsl:attribute name="value"><xsl:value-of select="../@HierId"/>:<xsl:value-of select="../@PCID"/>
				</xsl:attribute>
			</input>
			</xsl:if>
			<xsl:call-template name="EditMenu">
				<xsl:with-param name="hier_id" select="../@HierId" />
				<xsl:with-param name="pc_id" select="../@PCID" />
				<xsl:with-param name="edit">y</xsl:with-param>
			</xsl:call-template>
			<xsl:if test = "$javascript='disable'">
				<br/>
			</xsl:if>
		</xsl:if>
		<xsl:if test="$mode != 'edit'">
			<xsl:variable name="beh">
				<xsl:choose>
					<xsl:when test="$mode = 'print'">ForceAllOpen</xsl:when>
					<xsl:when test="$compare_mode = 'y'">ForceAllOpen</xsl:when>
					<xsl:otherwise><xsl:value-of select="@Behavior"/></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:if test="(@Type = 'VerticalAccordion' or @Type = 'HorizonalAccordion') and $mode != 'print' and $compare_mode = 'n'">
			</xsl:if>
		</xsl:if>
	</div>
</xsl:template>

<!-- Tab -->
<xsl:template match="Tab">
	<xsl:param name="cwidth"/>
	<xsl:param name="cheight"/>
	<xsl:param name="ttemp"/>
	<xsl:param name="aheadclass"/>
	<xsl:variable name="cstyle"><xsl:if test="$cheight != 'null' and $mode != 'edit' and $mode != 'print' and $compare_mode = 'n'">height: <xsl:value-of select="$cheight" />px;</xsl:if></xsl:variable>

	<!-- TabContainer -->
	<div>
	<xsl:choose>
	<xsl:when test="$mode = 'edit' or $mode = 'print' or $compare_mode = 'y'">
		<xsl:attribute name="class">ilc_va_icntr_AccordICntr</xsl:attribute>
	</xsl:when>
	<xsl:when test="../@Type = 'VerticalAccordion' or ../@Type = 'HorizontalAccordion'">
		<xsl:attribute name="class">ilc_va_icntr_AccordICntr</xsl:attribute>
		<xsl:if test="../@Template and //StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='va_icntr']/@Value">
			<xsl:attribute name = "class">ilc_va_icntr_<xsl:value-of select = "//StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='va_icntr']/@Value"/></xsl:attribute>
		</xsl:if>
	</xsl:when>
		<xsl:when test="../@Type = 'Carousel'">
			<xsl:attribute name="class">ilc_ca_icntr_CarouselICntr</xsl:attribute>
			<xsl:if test="../@Template and //StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='ca_icntr']/@Value">
				<xsl:attribute name = "class">ilc_ca_icntr_<xsl:value-of select = "//StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='ca_icntr']/@Value"/></xsl:attribute>
			</xsl:if>
		</xsl:when>
	</xsl:choose>

	<!-- Caption -->
	<div>
	<xsl:choose>
	<xsl:when test="(../@Type = 'VerticalAccordion' or ../@Type = 'HorizontalAccordion') or $mode = 'edit' or $mode = 'print' or $compare_mode = 'y'">
		<xsl:attribute name="class">il_VAccordionToggleDef</xsl:attribute>
	</xsl:when>
	</xsl:choose>

		<div tabindex="0" role="button" aria-expanded="false">
		<xsl:choose>
		<xsl:when test="$mode = 'edit' or $mode = 'print' or $compare_mode = 'y'">
			<xsl:attribute name="class">ilc_va_ihead_AccordIHead ilc_va_iheada_AccordIHeadActive</xsl:attribute>
		</xsl:when>
		<xsl:when test="../@Type = 'VerticalAccordion' or ../@Type = 'HorizontalAccordion'">
			<xsl:attribute name="class">ilc_va_ihead_AccordIHead
				<xsl:if test="../@Behavior = 'ForceAllOpen'"><xsl:text> </xsl:text><xsl:value-of select="$aheadclass"/></xsl:if>
			</xsl:attribute>
			<xsl:if test="../@Template and //StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='va_ihead']/@Value">
				<xsl:attribute name = "class">ilc_va_ihead_<xsl:value-of select = "//StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='va_ihead']/@Value"/>
					<xsl:if test="../@Behavior = 'ForceAllOpen'"><xsl:text> </xsl:text><xsl:value-of select="$aheadclass"/></xsl:if>
				</xsl:attribute>
			</xsl:if>
		</xsl:when>
		<xsl:when test="../@Type = 'Carousel'">
			<xsl:attribute name="class">ilc_ca_ihead_CarouselIHead</xsl:attribute>
			<xsl:if test="../@Template and //StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='ca_ihead']/@Value">
				<xsl:attribute name = "class">ilc_ca_ihead_<xsl:value-of select = "//StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='ca_ihead']/@Value"/></xsl:attribute>
			</xsl:if>
		</xsl:when>
		</xsl:choose>
		<div>
			<xsl:choose>
			<xsl:when test="$mode = 'edit' or $mode = 'print' or $compare_mode = 'y'">
				<xsl:attribute name="class">ilc_va_ihcap_AccordIHeadCap</xsl:attribute>
			</xsl:when>
			<xsl:when test="../@Type = 'VerticalAccordion' or ../@Type = 'HorizontalAccordion'">
				<xsl:attribute name="class">ilc_va_ihcap_AccordIHeadCap</xsl:attribute>
				<xsl:if test="../@Template and //StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='va_ihcap']/@Value">
					<xsl:attribute name = "class">ilc_va_ihead_<xsl:value-of select = "//StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='va_ihcap']/@Value"/></xsl:attribute>
				</xsl:if>
			</xsl:when>
			</xsl:choose>
			<xsl:value-of select="./TabCaption" />
			<xsl:comment>Break</xsl:comment>
		</div>
		<xsl:comment>Break</xsl:comment>
		</div>
	</div>

	<!-- Content -->
	<div>
		<xsl:choose>
		<xsl:when test="(../@Type = 'VerticalAccordion' or ../@Type = 'HorizontalAccordion') or $mode = 'edit' or $mode = 'print' or $compare_mode = 'y'">
			<xsl:attribute name="class">il_VAccordionContentDef <xsl:if test="$mode != 'edit' and $mode != 'print' and ../@Behavior != 'ForceAllOpen' and $compare_mode = 'n'">ilAccHideContent</xsl:if></xsl:attribute>
		</xsl:when>
		</xsl:choose>
		<div>
			<xsl:choose>
			<xsl:when test="$mode = 'edit' or $mode = 'print' or $compare_mode = 'y'">
				<xsl:attribute name="class">ilEditVAccordICont</xsl:attribute>
			</xsl:when>
			<xsl:when test="../@Type = 'VerticalAccordion' or ../@Type = 'HorizontalAccordion'">
				<xsl:attribute name="class">ilc_va_icont_AccordICont</xsl:attribute>
				<xsl:if test="../@Template and //StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='va_icont']/@Value">
					<xsl:attribute name = "class">ilc_va_icont_<xsl:value-of select = "//StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='va_icont']/@Value"/></xsl:attribute>
				</xsl:if>
			</xsl:when>
			<xsl:when test="../@Type = 'Carousel'">
				<xsl:attribute name="class">ilc_ca_icont_CarouselICont</xsl:attribute>
				<xsl:if test="../@Template and //StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='ca_icont']/@Value">
					<xsl:attribute name = "class">ilc_ca_icont_<xsl:value-of select = "//StyleTemplates/StyleTemplate[@Name=$ttemp]/StyleClass[@Type='ca_icont']/@Value"/></xsl:attribute>
				</xsl:if>
			</xsl:when>
			</xsl:choose>
			<xsl:attribute name="style"><xsl:value-of select="$cstyle" /><xsl:if test="$mode = 'edit'"> overflow:visible;</xsl:if></xsl:attribute>
			<xsl:if test="$mode != 'edit'">
				<!-- <xsl:attribute name="id">tab<xsl:number count="Tab" level="any"/></xsl:attribute> -->
			</xsl:if>
			<xsl:if test="$mode = 'edit'">
				<!-- <xsl:attribute name="class">il_edit_pc_tab</xsl:attribute> -->
			</xsl:if>
			<xsl:call-template name="EditReturnAnchors"/>
			<!-- insert commands -->
			<!-- <xsl:value-of select="@HierId"/> -->
			<xsl:if test="$mode = 'edit'">
				<!-- drop area (js) -->
				<xsl:if test="$javascript = 'enable'">
					<xsl:call-template name="DropArea">
						<xsl:with-param name="hier_id"><xsl:value-of select="@HierId"/></xsl:with-param>
						<xsl:with-param name="pc_id"><xsl:value-of select="@PCID"/></xsl:with-param>
					</xsl:call-template>
				</xsl:if>
				<!-- insert dropdown (no js) -->
				<xsl:if test= "$javascript = 'disable'">
					<select size="1" class="ilEditSelect">
						<xsl:attribute name="name">command<xsl:value-of select="@HierId"/>
						</xsl:attribute>
						<xsl:call-template name="EditMenuInsertItems"/>
					</select>
					<input class="ilEditSubmit" type="submit">
						<xsl:attribute name="value"><xsl:value-of select="//LVs/LV[@name='ed_go']/@value"/></xsl:attribute>
						<xsl:attribute name="name">cmd[exec_<xsl:value-of select="@HierId"/>:<xsl:value-of select="@PCID"/>]</xsl:attribute>
					</input>
					<br/>
				</xsl:if>
			</xsl:if>
			<xsl:apply-templates select="PageContent"/>
			<div style="clear:both;"><xsl:comment>Break</xsl:comment></div>
		</div>
		<div style="clear:both;"><xsl:comment>Break</xsl:comment></div>
	</div>
	<div style="clear:both;"><xsl:comment>Break</xsl:comment></div>
	</div>
</xsl:template>


<!-- Grid -->
<xsl:template match="Grid">
	<xsl:call-template name="EditLabel"><xsl:with-param name="text"><xsl:value-of select="//LVs/LV[@name='pc_grid']/@value"/></xsl:with-param></xsl:call-template>
	<xsl:call-template name="EditReturnAnchors"/>
	<div class="row row-flex row-flex-wrap">
		<xsl:apply-templates select="GridCell"/>
		<xsl:if test="$mode = 'edit'">
			<!-- <xsl:value-of select="../@HierId"/> -->
			<xsl:if test = "$javascript='disable'">
				<input type="checkbox" name="target[]">
					<xsl:attribute name="value"><xsl:value-of select="../@HierId"/>:<xsl:value-of select="../@PCID"/>
					</xsl:attribute>
				</input>
			</xsl:if>
			<xsl:call-template name="EditMenu">
				<xsl:with-param name="hier_id" select="../@HierId" />
				<xsl:with-param name="pc_id" select="../@PCID" />
				<xsl:with-param name="edit">y</xsl:with-param>
			</xsl:call-template>
			<xsl:if test = "$javascript='disable'">
				<br/>
			</xsl:if>
		</xsl:if>
		<xsl:comment>Break</xsl:comment>
	</div>
</xsl:template>

<!-- GridCell -->
<xsl:template match="GridCell">
	<xsl:variable name="container_edit_class"><xsl:if test="$mode = 'edit'"> copg-edit-container</xsl:if></xsl:variable>
	<div style="position: relative;">
		<xsl:attribute name="class">
			<xsl:if test="@WIDTH_S != ''"> col-sm-<xsl:value-of select="@WIDTH_S"/></xsl:if>
			<xsl:if test="@WIDTH_M != ''"> col-md-<xsl:value-of select="@WIDTH_M"/></xsl:if>
			<xsl:if test="@WIDTH_L != ''"> col-lg-<xsl:value-of select="@WIDTH_L"/></xsl:if>
			<xsl:if test="@WIDTH_XL != ''"> col-xl-<xsl:value-of select="@WIDTH_XL"/></xsl:if>
			<xsl:if test="@WIDTH_S = '' and @WIDTH_M = '' and @WIDTH_L = '' and @WIDTH_XL = ''">col-sm-12</xsl:if>
			<xsl:value-of select="$container_edit_class"/>
		</xsl:attribute>
		<!-- we had a div height=100% here, this div enforced margin collapsing, see bug 31536, for height see 32067, removed due to 45294, cols are different in 9 now -->
			<xsl:if test="$mode = 'edit'">
				<xsl:call-template name="EditReturnAnchors"/>
			</xsl:if>
			<!-- insert commands -->
			<!-- <xsl:value-of select="@HierId"/> -->
			<xsl:if test="$mode = 'edit'">
				<!-- drop area (js) -->
				<xsl:if test="$javascript = 'enable'">
					<xsl:call-template name="DropArea">
						<xsl:with-param name="hier_id"><xsl:value-of select="@HierId"/></xsl:with-param>
						<xsl:with-param name="pc_id"><xsl:value-of select="@PCID"/></xsl:with-param>
					</xsl:call-template>
				</xsl:if>
				<!-- insert dropdown (no js) -->
				<xsl:if test= "$javascript = 'disable'">
					<select size="1" class="ilEditSelect">
						<xsl:attribute name="name">command<xsl:value-of select="@HierId"/>
						</xsl:attribute>
						<xsl:call-template name="EditMenuInsertItems"/>
					</select>
					<input class="ilEditSubmit" type="submit">
						<xsl:attribute name="value"><xsl:value-of select="//LVs/LV[@name='ed_go']/@value"/></xsl:attribute>
						<xsl:attribute name="name">cmd[exec_<xsl:value-of select="@HierId"/>:<xsl:value-of select="@PCID"/>]</xsl:attribute>
					</input>
					<br/>
				</xsl:if>
			</xsl:if>
			<xsl:apply-templates select="PageContent"/>
			<xsl:comment>End of Grid Cell</xsl:comment>
	</div>
</xsl:template>

<!-- GridCellMenu -->
<xsl:template name="GridCellMenu">
	<xsl:variable name="ni"><xsl:number from="Grid" level="single" count="GridCell"/></xsl:variable>
	<xsl:if test= "$ni != 1">
		<xsl:call-template name="EditMenuItem"><xsl:with-param name="command">moveCellLeft</xsl:with-param>
			<xsl:with-param name="langvar">ed_cell_left</xsl:with-param></xsl:call-template>
	</xsl:if>

	<xsl:if test= "../GridCell[number($ni + 1)]">
		<xsl:call-template name="EditMenuItem"><xsl:with-param name="command">moveCellRight</xsl:with-param>
			<xsl:with-param name="langvar">ed_cell_right</xsl:with-param></xsl:call-template>
	</xsl:if>

	<xsl:call-template name="EditMenuItem"><xsl:with-param name="command">deleteCell</xsl:with-param>
		<xsl:with-param name="langvar">ed_delete_cell</xsl:with-param></xsl:call-template>
</xsl:template>

<!-- Plugged -->
<xsl:template match="Plugged">
	<xsl:call-template name="EditReturnAnchors"/>
		{{{{{Plugged<pl/><xsl:value-of select="@PluginName"/><pl/><xsl:value-of select="@PluginVersion"/><xsl:for-each select="./PluggedProperty"><pl/><xsl:value-of select="@Name"/><pl/><xsl:value-of select="."/></xsl:for-each>}}}}}
		<xsl:if test="$mode = 'edit'">
			<!-- <xsl:value-of select="../@HierId"/> -->
			<xsl:if test="$javascript='disable'">
				<br />
				<input type="checkbox" name="target[]">
					<xsl:attribute name="value"><xsl:value-of select="../@HierId"/>:<xsl:value-of select="../@PCID"/>
					</xsl:attribute>
				</input>
			</xsl:if>
			<xsl:call-template name="EditMenu">
				<xsl:with-param name="hier_id" select="../@HierId" />
				<xsl:with-param name="pc_id" select="../@PCID" />
				<xsl:with-param name="edit">y</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
</xsl:template>

<!-- Content Includes -->
<xsl:template match="ContentInclude">
	<xsl:call-template name="EditLabel"><xsl:with-param name="text"><xsl:value-of select="//LVs/LV[@name='pc_incl']/@value"/></xsl:with-param></xsl:call-template>
	<div>
		{{{{{ContentInclude;<xsl:value-of select="@ContentType"/>;<xsl:value-of select="@ContentId"/>;<xsl:value-of select="@InstId"/>}}}}}
		<xsl:call-template name="EditReturnAnchors"/>
		<xsl:if test="$mode = 'edit'">
			<!-- <xsl:value-of select="../@HierId"/> -->
			<xsl:if test="$javascript='disable'">
				<br />
				<input type="checkbox" name="target[]">
					<xsl:attribute name="value"><xsl:value-of select="../@HierId"/>:<xsl:value-of select="../@PCID"/>
					</xsl:attribute>
				</input>
			</xsl:if>
			<xsl:call-template name="EditMenu">
				<xsl:with-param name="hier_id" select="../@HierId" />
				<xsl:with-param name="pc_id" select="../@PCID" />
				<xsl:with-param name="edit">d</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</div>
</xsl:template>

<!-- Question -->
<xsl:template match="Question">
	<xsl:call-template name="EditLabel"><xsl:with-param name="text"><xsl:value-of select="//LVs/LV[@name='pc_qst']/@value"/></xsl:with-param></xsl:call-template>
	<div class="ilc_question_Standard">
	<xsl:call-template name="EditReturnAnchors"/>


	<xsl:if test = "@QRef != ''">
	{{{{{Question;<xsl:value-of select="@QRef"/>}}}}}
	</xsl:if>
	<xsl:if test = "@QRef = ''">
	<i><xsl:value-of select="//LVs/LV[@name='empty_question']/@value"/></i>
	</xsl:if>
	<!-- <xsl:apply-templates/> -->

	<!-- command selectbox -->
	<xsl:if test="$mode = 'edit'">
		<br />
		<!-- <xsl:value-of select="../@HierId"/> -->
		<xsl:if test = "$javascript='disable'">
		<input type="checkbox" name="target[]">
			<xsl:attribute name="value"><xsl:value-of select="../@HierId"/>:<xsl:value-of select="../@PCID"/>
			</xsl:attribute>
		</input>
		</xsl:if>
		<xsl:variable name="prev_del"><xsl:if test = "$enable_sa_qst != 'y'">y</xsl:if><xsl:if test = "$enable_sa_qst = 'y'">n</xsl:if></xsl:variable>
		<xsl:call-template name="EditMenu">
			<xsl:with-param name="hier_id" select="../@HierId" />
			<xsl:with-param name="pc_id" select="../@PCID" />
			<xsl:with-param name="edit">y</xsl:with-param>
			<xsl:with-param name="prevent_deletion" select="$prev_del" />
		</xsl:call-template>
	</xsl:if>
	</div>
</xsl:template>

<!-- PlaceHolder -->
<xsl:template match="PlaceHolder">
	  <xsl:if test="@ContentClass='Media'">
		<div class="ilc_MediaPlaceHolder">
			<xsl:attribute name="style">
				<xsl:if test = "@Height != ''">
					height:<xsl:value-of select="@Height"/>;
				</xsl:if>
				<xsl:if test = "@Width != ''">
					width:<xsl:value-of select="@Width"/>;
				</xsl:if>
			</xsl:attribute>
			<xsl:if test = "$enable_placeholder != 'y'">
				{{{{{PlaceHolder#<xsl:value-of select="../@PCID"/>#<xsl:value-of select="../@HierId"/>#<xsl:value-of select="@ContentClass"/>}}}}}
			</xsl:if>
			<xsl:if test = "$enable_placeholder = 'y'">
				<xsl:value-of select="//LVs/LV[@name='media_placehl']/@value"/>
			</xsl:if>
		</div>
	</xsl:if>

	<xsl:if test="@ContentClass='Text'">
		<div class="ilc_TextPlaceHolder">
			<xsl:attribute name="style">
				<xsl:if test = "@Height != ''">
					height:<xsl:value-of select="@Height"/>;
				</xsl:if>
				<xsl:if test = "@Width != ''">
					width:<xsl:value-of select="@Width"/>;
				</xsl:if>
			</xsl:attribute>
			<xsl:if test = "$enable_placeholder != 'y'">
				{{{{{PlaceHolder#<xsl:value-of select="../@PCID"/>#<xsl:value-of select="../@HierId"/>#<xsl:value-of select="@ContentClass"/>}}}}}
			</xsl:if>
			<xsl:if test = "$enable_placeholder = 'y'">
				<xsl:value-of select="//LVs/LV[@name='text_placehl']/@value"/>
			</xsl:if>
		</div>
	</xsl:if>

	<xsl:if test="@ContentClass='Question'">
		<div class="ilc_QuestionPlaceHolder">
				<xsl:attribute name="style">
				<xsl:if test = "@Height != ''">
					height:<xsl:value-of select="@Height"/>;
				</xsl:if>
				<xsl:if test = "@Width != ''">
					width:<xsl:value-of select="@Width"/>;
				</xsl:if>
				</xsl:attribute>
			<xsl:if test = "$enable_placeholder != 'y'">
				{{{{{PlaceHolder#<xsl:value-of select="../@PCID"/>#<xsl:value-of select="../@HierId"/>#<xsl:value-of select="@ContentClass"/>}}}}}
			</xsl:if>
			<xsl:if test = "$enable_placeholder = 'y'">
				<xsl:value-of select="//LVs/LV[@name='question_placehl']/@value"/>
			</xsl:if>

		</div>
	</xsl:if>

	<xsl:if test="@ContentClass='Verification'">
		<div class="ilc_VerificationPlaceHolder">
			<xsl:attribute name="style">
				<xsl:if test = "@Height != ''">
					height:<xsl:value-of select="@Height"/>;
				</xsl:if>
				<xsl:if test = "@Width != ''">
					width:<xsl:value-of select="@Width"/>;
				</xsl:if>
			</xsl:attribute>
			<xsl:if test = "$enable_placeholder != 'y'">
				{{{{{PlaceHolder#<xsl:value-of select="../@PCID"/>#<xsl:value-of select="../@HierId"/>#<xsl:value-of select="@ContentClass"/>}}}}}
			</xsl:if>
			<xsl:if test = "$enable_placeholder = 'y'">
				<xsl:value-of select="//LVs/LV[@name='verification_placehl']/@value"/>
			</xsl:if>
		</div>
	</xsl:if>

	<!-- command selectbox -->
	<xsl:if test="$mode = 'edit'">
		<br />
		<!-- <xsl:value-of select="../@HierId"/> -->
		<xsl:if test = "$javascript='disable'">
		<input type="checkbox" name="target[]">
			<xsl:attribute name="value"><xsl:value-of select="../@HierId"/>:<xsl:value-of select="../@PCID"/>
			</xsl:attribute>
		</input>
		</xsl:if>
		<xsl:call-template name="EditMenu">
			<xsl:with-param name="hier_id" select="../@HierId" />
			<xsl:with-param name="pc_id" select="../@PCID" />
			<xsl:with-param name="edit">y</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

<!-- ShowQuestion-->
<xsl:template name="ShowQuestion">
	<xsl:for-each select="//questestinterop/item/presentation/flow">
		<xsl:apply-templates/>
	</xsl:for-each>
</xsl:template>

<!-- dump language variable data -->
<xsl:template match="LV"/>
<xsl:template match="LVs"/>

<!-- Personal/Public profile data -->
<xsl:template match="Profile">
	{{{{{Profile#<xsl:value-of select="@User"/>#<xsl:value-of select="@Mode"/>#
		<xsl:for-each select="ProfileField">
			<xsl:value-of select="@Name"/>;
		</xsl:for-each>
	}}}}}
	<xsl:if test="$mode = 'edit'">
		<!-- <xsl:value-of select="../@HierId"/> -->
		<xsl:if test="$javascript='disable'">
			<br />
			<input type="checkbox" name="target[]">
				<xsl:attribute name="value"><xsl:value-of select="../@HierId"/>:<xsl:value-of select="../@PCID"/>
				</xsl:attribute>
			</input>
		</xsl:if>
		<xsl:call-template name="EditMenu">
			<xsl:with-param name="hier_id" select="../@HierId" />
			<xsl:with-param name="pc_id" select="../@PCID" />
			<xsl:with-param name="edit">y</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

<!-- Verification data -->
<xsl:template match="Verification">
	{{{{{Verification#<xsl:value-of select="@User"/>#<xsl:value-of select="@Type"/>#<xsl:value-of select="@Id"/>}}}}}
	<xsl:if test="$mode = 'edit'">
		<!-- <xsl:value-of select="../@HierId"/> -->
		<xsl:if test="$javascript='disable'">
			<br />
			<input type="checkbox" name="target[]">
				<xsl:attribute name="value"><xsl:value-of select="../@HierId"/>:<xsl:value-of select="../@PCID"/>
				</xsl:attribute>
			</input>
		</xsl:if>
		<xsl:call-template name="EditMenu">
			<xsl:with-param name="hier_id" select="../@HierId" />
			<xsl:with-param name="pc_id" select="../@PCID" />
			<xsl:with-param name="edit">y</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

<!-- Blog data -->
<xsl:template match="Blog">
	{{{{{Blog<xsl:if test="$mode = 'edit'">Teaser</xsl:if>#<xsl:value-of select="@User"/>#<xsl:value-of select="@Id"/>#
		<xsl:for-each select="BlogPosting">
			<xsl:value-of select="@Id"/>;
		</xsl:for-each>
	}}}}}
	<xsl:if test="$mode = 'edit'">
		<!-- <xsl:value-of select="../@HierId"/> -->
		<xsl:if test="$javascript='disable'">
			<br />
			<input type="checkbox" name="target[]">
				<xsl:attribute name="value"><xsl:value-of select="../@HierId"/>:<xsl:value-of select="../@PCID"/>
				</xsl:attribute>
			</input>
		</xsl:if>
		<xsl:call-template name="EditMenu">
			<xsl:with-param name="hier_id" select="../@HierId" />
			<xsl:with-param name="pc_id" select="../@PCID" />
			<xsl:with-param name="edit">y</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

<!-- Skills data -->
<xsl:template match="Skills">
	{{{{{Skills<xsl:if test="$mode = 'edit'">Teaser</xsl:if>#<xsl:value-of select="@User"/>#<xsl:value-of select="@Id"/>}}}}}
	<xsl:if test="$mode = 'edit'">
		<!-- <xsl:value-of select="../@HierId"/> -->
		<xsl:if test="$javascript='disable'">
			<br />
			<input type="checkbox" name="target[]">
				<xsl:attribute name="value"><xsl:value-of select="../@HierId"/>:<xsl:value-of select="../@PCID"/>
				</xsl:attribute>
			</input>
		</xsl:if>
		<xsl:call-template name="EditMenu">
			<xsl:with-param name="hier_id" select="../@HierId" />
			<xsl:with-param name="pc_id" select="../@PCID" />
			<xsl:with-param name="edit">y</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

<!-- Learning History -->
<xsl:template match="LearningHistory">
	{{{{{LearningHistory#<xsl:value-of select="@From"/>#<xsl:value-of select="@To"/>#<xsl:for-each select="LearningHistoryProvider">
		<xsl:value-of select="@Name"/>;
	</xsl:for-each>}}}}}
	<xsl:if test="$mode = 'edit'">
		<!-- <xsl:value-of select="../@HierId"/> -->
		<xsl:if test="$javascript='disable'">
			<br />
			<input type="checkbox" name="target[]">
				<xsl:attribute name="value"><xsl:value-of select="../@HierId"/>:<xsl:value-of select="../@PCID"/>
				</xsl:attribute>
			</input>
		</xsl:if>
		<xsl:call-template name="EditMenu">
			<xsl:with-param name="hier_id" select="../@HierId" />
			<xsl:with-param name="pc_id" select="../@PCID" />
			<xsl:with-param name="edit">y</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

<!-- Consultation hours data -->
<xsl:template match="ConsultationHours">
	{{{{{ConsultationHours<xsl:if test="$mode = 'edit'">Teaser</xsl:if>#<xsl:value-of select="@User"/>#<xsl:value-of select="@Mode"/>#
		<xsl:for-each select="ConsultationHoursGroup">
			<xsl:value-of select="@Id"/>;
		</xsl:for-each>
	}}}}}
	<xsl:if test="$mode = 'edit'">
		<!-- <xsl:value-of select="../@HierId"/> -->
		<xsl:if test="$javascript='disable'">
			<br />
			<input type="checkbox" name="target[]">
				<xsl:attribute name="value"><xsl:value-of select="../@HierId"/>:<xsl:value-of select="../@PCID"/>
				</xsl:attribute>
			</input>
		</xsl:if>
		<xsl:call-template name="EditMenu">
			<xsl:with-param name="hier_id" select="../@HierId" />
			<xsl:with-param name="pc_id" select="../@PCID" />
			<xsl:with-param name="edit">y</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

<!-- My courses data -->
<xsl:template match="MyCourses">
	{{{{{MyCourses<xsl:if test="$mode = 'edit'">Teaser</xsl:if>#<xsl:value-of select="@User"/>#<xsl:value-of select="@Sort"/>}}}}}
	<xsl:if test="$mode = 'edit'">
		<!-- <xsl:value-of select="../@HierId"/> -->
		<xsl:if test="$javascript='disable'">
			<br />
			<input type="checkbox" name="target[]">
				<xsl:attribute name="value"><xsl:value-of select="../@HierId"/>:<xsl:value-of select="../@PCID"/>
				</xsl:attribute>
			</input>
		</xsl:if>
		<xsl:call-template name="EditMenu">
			<xsl:with-param name="hier_id" select="../@HierId" />
			<xsl:with-param name="pc_id" select="../@PCID" />
			<xsl:with-param name="edit">y</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

<!-- Advanced MD Page List -->
<xsl:template match="AMDPageList">
	<xsl:call-template name="EditLabel"><xsl:with-param name="text"><xsl:value-of select="//LVs/LV[@name='pc_amdpl']/@value"/></xsl:with-param></xsl:call-template>
	[[[[[AMDPageList;<xsl:value-of select="@Id"/>;<xsl:value-of select="@Mode"/>]]]]]
	<xsl:if test="$mode = 'edit'">
		<!-- <xsl:value-of select="../@HierId"/> -->
		<xsl:if test="$javascript='disable'">
			<br />
			<input type="checkbox" name="target[]">
				<xsl:attribute name="value"><xsl:value-of select="../@HierId"/>:<xsl:value-of select="../@PCID"/>
				</xsl:attribute>
			</input>
		</xsl:if>
		<xsl:call-template name="EditMenu">
			<xsl:with-param name="hier_id" select="../@HierId" />
			<xsl:with-param name="pc_id" select="../@PCID" />
			<xsl:with-param name="edit">y</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

<!-- Advanced MD Page List -->
<xsl:template match="AMDForm">
	[[[[[AMDForm;<xsl:value-of select="@RecordIds"/>]]]]]
</xsl:template>

<!-- (LSO) Curriculum -->
<xsl:template match="Curriculum">
	<xsl:if test="$mode = 'edit'">
		<div class="copg-content-placeholder-lso-curriculum">
			<img class="icon pewl medium" src="./assets/images/page_editor/icon_pewl.svg" alt="curriculum" />
			<div>Curriculum</div>
		</div>
	</xsl:if>
	<xsl:if test="$mode != 'edit'">
		<Curriculum>
			[[[CURRICULUM]]]
		</Curriculum>
	</xsl:if>
</xsl:template>

<!-- (LSO) Launcher -->
<xsl:template match="Launcher">
	<xsl:if test="$mode = 'edit'">
		<div class="copg-content-placeholder-lso-startbutton il-lso-startbutton-container">
			<button class="btn btn-primary">Start Learning Sequence</button>
		</div>
	</xsl:if>
	<xsl:if test="$mode != 'edit'">
		<div class="il-lso-startbutton-container">
			<Launcher>
				[[[LAUNCHER]]]
			</Launcher>
		</div>
	</xsl:if>
</xsl:template>

<!-- PRGStatusInfo -->
<xsl:template match="PRGStatusInfo">
	[[[PRG_STATUS_INFO]]]
</xsl:template>

<!-- PRGActionNote -->
<xsl:template match="PRGActionNote">
	[[[PRG_ACTION_NOTE]]]
</xsl:template>

<!-- helper functions -->

<xsl:template name="substring-before-last">
	<xsl:param name="originalString" select="''" />
	<xsl:param name="stringToSearchFor" select="''" />

	<xsl:if test="$originalString != '' and $stringToSearchFor != ''">
		<xsl:variable name="head" select="substring-before($originalString, $stringToSearchFor)" />
		<xsl:variable name="tail" select="substring-after($originalString, $stringToSearchFor)" />
		<xsl:value-of select="$head" />
		<xsl:if test="contains($tail, $stringToSearchFor)">
			<xsl:value-of select="$stringToSearchFor" />
			<xsl:call-template name="substring-before-last">
				<xsl:with-param name="originalString" select="$tail" />
				<xsl:with-param name="stringToSearchFor" select="$stringToSearchFor" />
			</xsl:call-template>
		</xsl:if>
	</xsl:if>
</xsl:template>

<xsl:template match="script">
</xsl:template>

</xsl:stylesheet>
