<?php

/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 *
 *********************************************************************/

declare(strict_types=1);

namespace ILIAS\Component\Resource;

/**
 * An public asset is a file or folder that should be served via the web.
 */
interface PublicAsset
{
    /** The path of asset relative to the ILIAS base directory. */
    public function getSource(): string;
    /** The new path of relative to the ILIAS public directory. */
    public function getTarget(): string;
}
