<?php

/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 *
 *********************************************************************/

declare(strict_types=1);

class ilDclDatatype
{
    public const INPUTFORMAT_NONE = 0;
    public const INPUTFORMAT_NUMBER = 1;
    public const INPUTFORMAT_TEXT = 2;
    public const INPUTFORMAT_REFERENCE = 3;
    public const INPUTFORMAT_BOOLEAN = 4;
    public const INPUTFORMAT_DATE = 5;
    public const INPUTFORMAT_FILEUPLOAD = 6;
    public const INPUTFORMAT_RATING = 7;
    public const INPUTFORMAT_ILIAS_REF = 8;
    public const INPUTFORMAT_MOB = 9;
    public const INPUTFORMAT_REFERENCELIST = 10;
    public const INPUTFORMAT_FORMULA = 11;
    public const INPUTFORMAT_TEXT_SELECTION = 14;
    public const INPUTFORMAT_DATE_SELECTION = 15;
    public const INPUTFORMAT_FILE = 16;
    public const INPUTFORMAT_COPY = 17;

    protected int $id = 0;
    protected string $title = "unknown";
    protected int $storageLocation = 0;
    /**
     * @var ilDclDatatype[]
     */
    public static array $datatype_cache = [];

    /**
     * Constructor
     * @access public
     */
    public function __construct(int $a_id = 0)
    {
        if ($a_id != 0) {
            $this->id = $a_id;
            $this->doRead();
        }
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setTitle(string $a_title): void
    {
        $this->title = $a_title;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * Set Storage Location
     */
    public function setStorageLocation(int $a_id): void
    {
        $this->storageLocation = $a_id;
    }

    /**
     * Get Storage Location
     */
    public function getStorageLocation(): int
    {
        return $this->storageLocation;
    }

    /**
     * Read Datatype
     */
    public function doRead(): void
    {
        global $DIC;
        $ilDB = $DIC['ilDB'];

        $query = "SELECT * FROM il_dcl_datatype WHERE id = " . $ilDB->quote(
            $this->getId(),
            "integer"
        ) . " ORDER BY sort";
        $set = $ilDB->query($query);
        $rec = $ilDB->fetchAssoc($set);

        $this->loadDatatype($rec);
    }

    /**
     * Get all possible Datatypes
     */
    public static function getAllDatatype(bool $force = false): array
    {
        global $DIC;
        $ilDB = $DIC['ilDB'];

        if (self::$datatype_cache == null) {
            self::$datatype_cache = [];

            $query = "SELECT * FROM il_dcl_datatype ORDER BY sort";
            $set = $ilDB->query($query);

            while ($rec = $ilDB->fetchAssoc($set)) {
                $instance = new ilDclDatatype();
                $instance->loadDatatype($rec);

                if (
                    $force ||
                    !ilDclFieldTypePlugin::isPluginDatatype($instance->getTitle()) ||
                    $DIC['component.repository']->hasActivatedPlugin(ilDclFieldTypePlugin::getPluginId($instance->getTitle()))
                ) {
                    self::$datatype_cache[$rec['id']] = $instance;
                }

            }
        }

        return self::$datatype_cache;
    }

    protected function loadDatatype(array $rec): void
    {
        $this->id = $rec['id'];

        $this->setTitle($rec["title"]);
        $this->setStorageLocation($rec["storage_location"]);
    }
}
