<?php
/**
 * Class CookieJarWrapperTest
 *
 * @author  Nicolas Schäfli <ns@studer-raimann.ch>
 */

namespace ILIAS\HTTP\Cookies;

use PHPUnit\Framework\TestCase;

/******************************************************************************
 *
 * This file is part of ILIAS, a powerful learning management system.
 *
 * ILIAS is licensed with the GPL-3.0, you should have received a copy
 * of said license along with the source code.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 *      https://www.ilias.de
 *      https://github.com/ILIAS-eLearning
 *
 *****************************************************************************/
/**
 * Class CookieWrapperTest
 *
 * @author                 Nicolas Schäfli <ns@studer-raimann.ch>
 *
 * @runInSeparateProcess
 * @preserveGlobalState    disabled
 * @backupGlobals          disabled
 * @backupStaticAttributes disabled
 */
class CookieJarWrapperTest extends TestCase
{
    /**
     * @var CookieFactory $cookieFactory
     */
    private static $cookieFactory;
    /**
     * @var CookieJarFactory $cookieJarFactory
     */
    private static $cookieJarFactory;


    public static function setUpBeforeClass(): void
    {
        parent::setUpBeforeClass(); // TODO: Change the autogenerated stub
        self::$cookieFactory = new CookieFactoryImpl();
        self::$cookieJarFactory = new CookieJarFactoryImpl();
    }


    /**
     * @Test
     */
    public function testWithDoesNotChangeTheCurrentObject()
    {
        $cookieName = "YummyCookie";
        $cookieValue = "MilkAndChocolate";
        $cookie = self::$cookieFactory->create($cookieName, $cookieValue);
        $cookieJar = self::$cookieJarFactory->fromCookieStrings([]);

        $newCookieJar = $cookieJar->with($cookie);

        $this->assertFalse($cookieJar->has($cookieName));
        $this->assertTrue($newCookieJar->has($cookieName));

        $this->assertNotEquals($cookieJar, $newCookieJar);
    }


    /**
     * @Test
     */
    public function testWithoutDoesNotChangeTheCurrentObject()
    {
        $cookieName = "YummyCookie";
        $cookieValue = "MilkAndChocolate";

        //create a new jar with one cookie
        $cookieJar = self::$cookieJarFactory->fromCookieStrings([ $cookieName . '=' . $cookieValue . ';' ]);

        //remove cookie
        $newCookieJar = $cookieJar->without($cookieName);

        //old jar should hold the cookie
        $this->assertTrue($cookieJar->has($cookieName));

        //new jar should no longer hold the cookie
        $this->assertFalse($newCookieJar->has($cookieName));

        //check that both are not equal (checked because the has function could fail due to a change in the future)
        $this->assertNotEquals($cookieJar, $newCookieJar);
    }
}
