export { linkifyElement as default };
/**
 * Recursively traverse the given DOM node, find all links in the text and
 * convert them to anchor tags.
 *
 * @param {HTMLElement} element A DOM node to linkify
 * @param {import('linkifyjs').Opts} [opts] linkify options
 * @param {Document} [doc] (optional) window.document implementation, if differs from global
 * @returns {HTMLElement}
 */
declare function linkifyElement(element: HTMLElement, opts?: import('linkifyjs').Opts, doc?: Document): HTMLElement;
declare namespace linkifyElement {
    export { linkifyElementHelper as helper };
    export { getDefaultRender };
    /**
     * @param {import('linkifyjs').Opts | import('linkifyjs').Options} opts
     * @param {Document} doc
     */
    export function normalize(opts: import("linkifyjs").Opts | Options, doc: Document): Options;
}
/**
 * Requires document.createElement
 * @param {HTMLElement | ChildNode} element
 * @param {import('linkifyjs').Options} options
 * @param {Document} doc
 * @returns {HTMLElement}
 */
declare function linkifyElementHelper(element: HTMLElement | ChildNode, options: import('linkifyjs').Options, doc: Document): HTMLElement;
/**
 * @param {Document} doc The document implementaiton
 */
declare function getDefaultRender(doc: Document): (_ref: any) => any;
import { Options } from 'linkifyjs';
