/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 *
 *********************************************************************/

/*globals longMenuQuestionGapBuilder, alert, performance, JSON */
var longMenuQuestion = (function () {
	'use strict';

	let scrollable_page_element_class = 'il-layout-page-content';

	var pub = {},
	    pro = {},
	    pri = {};
	var temp_answers = [];
	pub.questionParts = [];
	pub.answers = [];
	pub.gap_modal_id = 'ilGapModal';
	pri.ignoreCallbackItemOnRedraw = true;
	pri.gapTypeText = 1;

	pro.buildAndInitGapBuilder = function()
	{
		var gap_builder = longMenuQuestionGapBuilder;
		gap_builder.textarea			= 'longmenu_text';
		gap_builder.trigger			= 'gaptrigger';
		gap_builder.replacement_word	= pub.questionParts.gap_placeholder;
		gap_builder.gap_regexp			= '\\[' + pub.questionParts.gap_placeholder + '\\s?[\\d]*?\\]';

		pub.questionParts.replacement_word = gap_builder.replacement_word;
		gap_builder.callbackClickedInGap 	= function ()
		{
			var gap         = gap_builder.active_gap - 1;
			pro.scrollToPageObject('title_' + gap);
		};
		gap_builder.callbackNewGap = function (gap_id)
		{
			pro.sliceInNewQuestionPart(gap_id);
		};
		gap_builder.checkDataConsistencyAfterGapRemoval = function ( existing_gaps )
		{
			pro.checkDataConsistency(existing_gaps);
		};

		gap_builder.Init();
	};

	pro.checkDataConsistency = function (existing_gaps)
	{
		pub.questionParts.list  = $().ensureNoArrayIsAnObjectRecursive(pub.questionParts.list);
		pub.answers             = $().ensureNoArrayIsAnObjectRecursive(pub.answers);
		if(existing_gaps.length === 0 )
		{
			pub.answers = [];
			pub.questionParts.list = [];
		}
		else
		{
			var answers = [];
			var list    = [];
			var t0 = pro.benchmarkCallsDummyNotForUsage('checkDataConsistency');
			$.each(pub.questionParts.list , function( index ) {
				if($.inArray(index + 1, existing_gaps) !== -1)
				{
					answers.push(pub.answers[index]);
					list.push(pub.questionParts.list[index]);
				}
			});
			pro.benchmarkCallsDummyNotForUsage('checkDataConsistency', t0);
			pub.answers = answers;
			pub.questionParts.list = list;
		}
		pro.redrawFormParts();
		pro.syncWithHiddenTextField();
	};

	pro.appendFormParts = function()  {
		var footer_class 	= $('.ilFormFooter').last();
		var new_title 		= $('.gap_title').find('.ilFormHeader').clone().addClass('longmenu_head longmenu');
		var title 			= 0;
		var t0 = pro.benchmarkCallsDummyNotForUsage('appendFormParts');
		$.each(pub.questionParts.list , function( index ) {
			footer_class.parent().append(new_title.clone());
			title = parseInt(index, 10) + 1;
			$(document).find('.longmenu_head').last().find('.ilHeader')
				.attr('id', 'title_' + index)
				.html(pub.questionParts.replacement_word + ' ' + title);
			pro.appendSelectBox(footer_class, index);
			pro.appendAnswersOverview(footer_class, index);
			pro.buildCorrectAnswersFormInPage(index);
		});
		pro.benchmarkCallsDummyNotForUsage('appendFormParts', t0);
		footer_class.appendTo( '#form_assLongMenu');
		pro.addEditListeners();
		pro.addPointsListener();
		pro.addSelectsListener();
		pro.addAutocompleteListener();
	};

	pro.appendSelectBox = function (footer_class, index)  {
		var id = 'select_type_' + index;
		footer_class.parent().append($('#layout_dummy_select').clone().attr({'id': id}).addClass('longmenu'));
		var selector = $('#' + id);
		selector.find('label').html(pub.language.type);
		selector.find('.form-control').attr('name', 'long_menu_type[]').attr({'data-id': index}).val(pub.questionParts.list[index][2]);
	};

	pro.appendAnswersOverview = function(footer_class, index)  {
		var id = 'answer_overview_' + index;
		footer_class.parent().append($('#layout_dummy_answers').clone().attr({'id': id}).addClass('longmenu'));
		var selector = $('#' + id);
		selector.find('label').html(pub.language.answers + ' <span class="asterisk">*</span>');
		var html = pro.buildAnswerOverview(index);
		selector.find('.form-inline').html(html);
		pro.appendPointsField(footer_class, index);
	};

	pro.appendPointsField = function (footer_class, index)  {
		var id = 'points_' + index;
		var name = 'points[' + index + ']';
		footer_class.parent().append($('#layout_dummy_points').clone().attr({'id': id}).addClass('longmenu'));
		$('#' + id).find('input').attr({'n.il-layout-page-contentame' : name, 'data-id' : index}).addClass('points').val(pub.questionParts.list[index][1]);
		pro.appendErrorHandlerHtml(footer_class, index);
	};

	pro.buildAnswerOverview = function (question_id)  {
		var length 	= pub.answers[question_id].length;
		var html 	= '';
		if( length > 0 )
		{
			html =	'<p>' + pub.language.answer_options + ' ' + pub.answers[question_id].length;
			html += ' <a data-id="' + question_id +
					'" class="answer_options"> ' +
					pub.language.edit + '</a></p>';
			html += '<p>' + pub.language.correct_answers;
			html += '<span data-id="' + question_id + '" class="correct_answers"></span></p>';
		}
		else
		{
			html = 	' <a data-id="' + question_id +
					'" class="answer_options">' +
					pub.language.add_answers + '</a></p>';
		}
		return html;
	};

    pro.addPointsListener = () => {
        let point_fields = document.getElementsByClassName('points');
        let event = (e) => {
            var question_id = parseInt(e.target.getAttribute('data-id'), 10);
            pub.questionParts.list[question_id][1] = e.target.value;
            pro.syncWithHiddenTextField();
            pro.displayErrors(question_id);
        };
        for (let i = 0; i < point_fields.length; i++) {
            point_fields[i].onblur = event;
            point_fields[i].onkeydown = (e) => {
                if (e.key === 'Enter') {
                    event(e);
                }
            };
        }
    };

	pro.addEditListeners = function()  {
		$( '.answer_options' ).on( 'click', function() {
			pro.answerOptionsClickFunction($(this));
		});
	};

	pro.addSelectsListener = function()  {
		$( '.type_selection' ).on( 'change', function() {
			pro.selectChangeFunction($(this));
			pro.ensureAutoCompleteIsPossibleWithTextInput();
		});
	};

	pro.addAutocompleteListener = function()  {
		$( '#min_auto_complete' ).on( 'blur', function()
		{
			pro.ensureAutoCompleteIsPossibleWithTextInput();
		});
	};

	pro.ensureAutoCompleteIsPossibleWithTextInput = function()
	{
		$('.autocomplete_error').addClass('prototype_long_menu');
		$.each(pub.questionParts.list , function( index ) {
			if(pub.questionParts.list[index][2] == pri.gapTypeText)
			{
				pro.ensureAutoCompleteIsPossibleWithAllValues(index);
			}
		});
	};

	pro.ensureAutoCompleteIsPossibleWithAllValues = function(gap_index)
	{
		var min_length_autocomplete = $('#min_auto_complete').val();
		var constraint_violation = false;

		$.each(pub.answers[gap_index], function(index, value) {
			if(value.length < min_length_autocomplete)
			{
				constraint_violation = true;
				return false;
			}
		});

		if(constraint_violation)
		{
			$('#' +'error_answer_' + gap_index).find('.autocomplete_error').removeClass('prototype_long_menu');
		}
	};

	pro.selectChangeFunction = function (that)
	{
		var question_id = parseInt(that.attr('data-id'), 10);
		pub.questionParts.list[question_id][2] = that.val();
	};

	pro.answerOptionsClickFunction = function (that)
	{
		var gap_id = that.attr('data-id');
		var modal_body = $('#' + pub.gap_modal_id + ' .modal-body');
		var modal_footer = $('#' + pub.gap_modal_id + ' .modal-footer');
		temp_answers = pub.answers[gap_id];
		pro.appendModalTitle(pub.language.answer_options, gap_id);
		modal_body.html(pro.appendUpload());
		modal_body.find('.upload').attr('id', 'fileinput');
		modal_footer.html(pro.appendUploadButtons());
		document.getElementById('fileinput').addEventListener('change', pro.readSingleFile, false);
		pro.savePossibleChangedPoints();
		pro.redrawAnswerList(gap_id);
		pro.appendModalCloseListener();
		il.UI.modal.showModal(document.getElementById(pub.gap_modal_id), {}, { id: pub.gap_modal_id });
	};

	pro.savePossibleChangedPoints = function ()
	{
		$.each($('.points') , function( index) {
			pub.questionParts.list[index][1] = $(this).val();
		});
	};
	pro.buildCorrectAnswersFormInPage = function()
	{
		$('.correct_answers').each(function() {
			var question_id = $(this).attr('data-id');
			var dom_object = $('#taggable').clone().attr({
															'id' : 'tagsinput_' + question_id,
															'class' : 'correct_answers',
															'data-id' : question_id
															});
			$(this).parent().html(dom_object);
			$('#' +'tagsinput_' + question_id).parent().prepend(pub.language.correct_answers);
			ilBootstrapTaggingOnLoad.appendId('#tagsinput_' + question_id);
			ilBootstrapTaggingOnLoad.appendTerms(question_id, pub.answers[question_id]);
			pri.ignoreCallbackItemOnRedraw = true;
			ilBootstrapTaggingOnLoad.callbackItemAdded = function ()
			{
				pri.saveTagInputsToHiddenFieldsOnCallback();
			};
			ilBootstrapTaggingOnLoad.callbackItemRemoved = function ()
			{
				pri.saveTagInputsToHiddenFieldsOnCallback();
			};
			ilBootstrapTaggingOnLoad.Init();
			$.each(pub.questionParts.list[question_id][0], function (index) {
				$('#tagsinput_' + question_id).tagsinput('add', pub.questionParts.list[question_id][0][index]);
			});
			pri.ignoreCallbackItemOnRedraw = false;
		});
	};

	pro.appendErrorHandlerHtml = function(footer_class, index)
	{
		footer_class.parent().append($('#error_answer').clone().attr({'id': 'error_answer_' + index}).addClass('longmenu'));
		pro.displayErrors(index);
	};

	pro.displayErrors = function(index)
	{
		var value_error = false;
    let points = parseFloat(pub.questionParts.list[index][1]);
		if( isNaN(points) || points <= 0)
		{
			$('#' +'error_answer_' + index).find('.points_error').removeClass('prototype_long_menu');
		}
		else
		{
			$('#' +'error_answer_' + index).find('.points_error').addClass('prototype_long_menu');
		}
		if(pub.questionParts.list[index][0].length === 0)
		{
			$('#' +'error_answer_' + index).find('.value_error').removeClass('prototype_long_menu');
			value_error = true;
		}
		else
		{
			$('#' +'error_answer_' + index).find('.value_error').addClass('prototype_long_menu');
		}
		if( pub.answers[index].length === 0)
		{
			$('#' +'error_answer_' + index).find('.value_error').removeClass('prototype_long_menu');
		}
		else if(!value_error)
		{
			$('#' +'error_answer_' + index).find('.value_error').addClass('prototype_long_menu');
		}
	};

	pri.saveTagInputsToHiddenFieldsOnCallback = function()
	{
		if(pri.ignoreCallbackItemOnRedraw === false)
		{
			$('.correct_answers').each(function() {
				var question_id = parseInt($(this).attr('id').split('_')[1], 10);
				pro.saveCorrectAnswersToHiddenField(question_id);
				pro.displayErrors(question_id);
			});
		}
	};

	pro.saveCorrectAnswersToHiddenField = function(question_id)
	{
		var elements    =   $('#tagsinput_' + question_id).tagsinput('items');
		if(elements === null)
		{
			elements = [];
		}
		pub.questionParts.list[question_id][0] = elements;
		pro.syncWithCorrectAnswers(question_id);
		pro.syncWithHiddenTextField();
	};

	pro.appendUpload = function()
	{
		return $('#layout_dummy_upload').clone().html() + pub.language.manual_editing + '<div class="modal_answer_options"></div>';
	};

	pro.appendUploadButtons = function()
	{
		return $('#layout_dummy_buttons').clone().attr('id', '').html();
	};

	pro.appendModalTitle = function(text, question_id)
	{
		var modal_title = $('#' + pub.gap_modal_id + ' .modal-title');
		var modal_header = $('#' + pub.gap_modal_id + ' .modal-header');
		var view_id = parseInt(question_id,10) + 1;
		modal_header.find('.help-block').remove();
		modal_header.append($('.layout_dummy_help-block').html());
		modal_header.find('.help-block').html(pub.language.info_text_gap);
		modal_title.attr('data-id', question_id)
			.html(pub.questionParts.replacement_word + ' ' + view_id + ' ' + text );
	};

	pro.appendModalCloseListener = function()
	{
		var modal_object = $('#' + pub.gap_modal_id + '');
		modal_object.off('hidden.bs.modal');
		modal_object.on('hidden.bs.modal', pro.redrawFormParts);
	};

	pro.redrawFormParts = function()
	{
		$('.longmenu').remove();
		pro.appendFormParts();
		pro.ensureAutoCompleteIsPossibleWithTextInput();
	};

	pro.redrawAnswerList = function(question_id)
	{
		pro.checkAnswersArray(question_id);
		var buttons = $('.layout_dummy_add_remove_buttons').html();
		var html = '';
		if(pro.inputFieldsStillPossible(question_id))
		{
			var t0 = pro.benchmarkCallsDummyNotForUsage('redrawAnswerList');
			$.each(pub.answers[question_id] , function( index, value ) {
				html += '<input type="text" class="col-sm-10 answerlist" size="5" value="' +
						value + '" data-id="' + index + '">' + buttons;
			});
			if(html === '')
			{
				html += '<input type="text" class="col-sm-10 answerlist" size="5" value="" data-id="0">' + buttons;
			}
			pro.benchmarkCallsDummyNotForUsage('redrawAnswerList only html build', t0);
			$('#' + pub.gap_modal_id + ' .modal_answer_options').html(html);
			pro.benchmarkCallsDummyNotForUsage('redrawAnswerList', t0);
		}
		else
		{
			html += '<textarea rows="25" cols="70" class="input-large">';
			$.each(pub.answers[question_id] , function( index, value ) {
				html += value + '\n';
			});
			html += '</textarea>';
			$('#' + pub.gap_modal_id + ' .modal_answer_options').html(html);
		}
		pro.appendAnswerCloneButtonEvents();
		pro.redrawFormParts();
	};

	pro.redrawAnswerListFast = function(gap_id, answer_id, addRow)
	{
		var answerList_object = $('.answerlist');
		pro.checkAnswersArray(gap_id);
		if(pro.inputFieldsStillPossible(gap_id))
		{
			if(addRow)
			{
				var buttons = $('.layout_dummy_add_remove_buttons').html();
				var input_string = 'type="text" class="col-sm-10 answerlist" size="5" value=""';
				answerList_object.eq(answer_id).next().after('<input ' + input_string + '>' + buttons);
			}
			else
			{
				answerList_object.eq(answer_id).next().remove();
				answerList_object.eq(answer_id).remove();
			}
			pro.appendAnswerCloneButtonEvents();
			pro.recalculateAnswerListDataIds();
		}
		pro.redrawFormParts();
	};

	pro.recalculateAnswerListDataIds = function()
	{
		var t0 = pro.benchmarkCallsDummyNotForUsage('recalculateAnswerListDataIds');
		$.each($('.answerlist') , function( index) {
			$(this).attr('data-id', index);
		});
		pro.benchmarkCallsDummyNotForUsage('recalculateAnswerListDataIds', t0);
	};

	pro.appendAnswerCloneButtonEvents = function()
	{
		var t0 = pro.benchmarkCallsDummyNotForUsage('appendAnswerCloneButtonEvents');
		pro.appendAddButtonEvent();
		pro.appendRemoveButtonEvent();
		pro.appendSaveModalButtonEventAnswers();
		pro.appendCancelModalButtonEvent();
		pro.benchmarkCallsDummyNotForUsage('appendAnswerCloneButtonEvents', t0);
	};

	pro.appendAddButtonEvent = function()
	{
		pro.appendAbstractCloneButtonEvent( '.clone_fields_add' , function (gap_id, question_id )
		{
			temp_answers.splice(gap_id,0,[]);
			pro.redrawAnswerListFast(question_id, gap_id, true);
		});
	};

	pro.appendRemoveButtonEvent = function()
	{
		pro.appendAbstractCloneButtonEvent( '.clone_fields_remove' , function (gap_id, question_id )
		{
			if(temp_answers.length > 1)
			{
				temp_answers.splice(gap_id,1);
				pro.redrawAnswerListFast(question_id, gap_id, false);
			}
		});
	};
	pro.appendAbstractCloneButtonEvent = function(classElement, eventCallback)
	{
		var button 	= $(classElement + ' a');
		button.off( 'click');
		button.on( 'click', function() {
			var gap_id = $(this).parent().parent().prev().attr('data-id');
			let question_id = $('#' + pub.gap_modal_id + ' .modal-title').attr('data-id');
			if (typeof eventCallback === 'function') {
				eventCallback(gap_id, question_id);
			}
			return false;
		});
	};

	pro.appendSaveModalButtonEventAnswers = function()
	{
		pro.appendAbstractModalButtonEvent( '.save-modal' , pro.saveModalEventAnswers);
	};

	pro.saveModalEventAnswers = function()
	{
		var gap_id = $('#' + pub.gap_modal_id + ' .modal-title').attr('data-id');
		var answers		= [];
		if(pro.inputFieldsStillPossible(gap_id))
		{
			var t0 = pro.benchmarkCallsDummyNotForUsage('protect.appendSaveModalButtonEventAnswers');
			$.each($('#' + pub.gap_modal_id + ' .answerlist') , function() {
				answers.push($(this).val());
			});
			pro.benchmarkCallsDummyNotForUsage('protect.appendSaveModalButtonEventAnswers', t0);
		}
		else
		{
			answers  = $('.input-large').val().split('\n');
		}
		pub.answers[gap_id] = answers;
		pro.checkAnswersArray(gap_id);
		pro.savePossibleChangedPoints();
		pro.redrawAnswerList(gap_id);
	};

	pro.appendCancelModalButtonEvent = function()
	{
		pro.appendAbstractModalButtonEvent( '.close' , function (){});
		pro.appendAbstractModalButtonEvent( '.cancel-modal' , function (){});
	};

	pro.appendAbstractModalButtonEvent = function(classElement, eventCallback)
	{
		var button 	= $(classElement);
		button.off( 'click');
		button.on( 'click', function() {
			if (typeof eventCallback === 'function') {
				eventCallback();
			}
			document.getElementById(pub.gap_modal_id).close()
			return false;
		});
	};

	pro.inputFieldsStillPossible = function(gap_id)
	{
		return pub.answers[gap_id].length < pub.questionParts.max_input_fields;
	};

	pro.syncWithCorrectAnswers = function (question_id)
	{
		var to_remove = [];
		var t0 = pro.benchmarkCallsDummyNotForUsage('syncWithCorrectAnswers');
		if(longMenuQuestion.questionParts.list[question_id][0].length > 0)
		{
			$.each(pub.questionParts.list[question_id][0] , function( index, value ) {
				if ($.inArray(value, pub.answers[question_id]) === -1 )
				{
					to_remove.push(index);
				}
			});
		}
		pro.removeNonExistingCorrectAnswersByKey(question_id, to_remove);
		pro.benchmarkCallsDummyNotForUsage('syncWithCorrectAnswers', t0);
	};

	pro.removeNonExistingCorrectAnswersByKey = function(question_id, to_remove)
	{
		to_remove.sort(function(a, b){ return b - a; } );
		$.each(to_remove , function( index, position ) {
			pub.questionParts.list[question_id][0].splice(position, 1);
		});
	};

	pro.checkAnswersArray = function (question_id)
	{
		var result = [];
		var t0 = pro.benchmarkCallsDummyNotForUsage('checkAnswersArray');
		$.each(pub.answers[question_id], function(index, value) {
			value = value.toString().replace(/"/g,'');
			if ($.inArray(value, result) === -1 )
			{
				if( value !== '' )
				{
					result.push(value);
				}
			}
		});
		pro.benchmarkCallsDummyNotForUsage('checkAnswersArray', t0);
		var removed = pub.answers[question_id].length - result.length;
		pub.answers[question_id] = result.sort();
		pro.syncWithCorrectAnswers(question_id);
		pro.syncWithHiddenTextField();
	};

	pro.syncWithHiddenTextField = function()
	{
		$('#hidden_text_files').val(JSON.stringify(pub.answers));
		$('#hidden_correct_answers').val(JSON.stringify(pub.questionParts.list));
	};

	pro.sliceInNewQuestionPart = function (gap_id)
	{
		pub.questionParts.list.splice(gap_id, 0,  [[], '0', '1']);
		pub.answers.splice(gap_id,0,[]);
		pro.redrawFormParts();
		pro.syncWithHiddenTextField();
	};

	pro.readSingleFile = function (evt){
		if ( pub.filereader_usable )
		{
			var file = evt.target.files[0];
			if (file)
			{
				var reader = new FileReader();
				var textType = /text.*/;
				if (file.type.match(textType))
				{
					reader.onload = function(e)
					{
						var contents 	= e.target.result;
						var gap_id	= $('#' + pub.gap_modal_id + ' .modal-title').attr('data-id');
						pub.answers[gap_id] = contents.split('\n');
						pub.answers[gap_id] = pub.answers[gap_id].sort();
						pro.redrawAnswerList(gap_id);
					};
					reader.readAsText(file);
				}
				else
				{
					alert('Filetype not supported');
				}
			}
			else
			{
				alert('Failed to load file');
			}
		}
		else
		{
			alert('The File APIs are not fully supported by your browser.');
		}
	};

	pro.scrollToPageObject = function(object)
	{
		let scrollable_page_element;
		let html = document.getElementsByTagName('html')[0];
		if (window.getComputedStyle(document.body).overflow === 'visible') {
			scrollable_page_element = html;
		} else {
		 	scrollable_page_element = (document.getElementsByClassName(scrollable_page_element_class))[0];
		}
		let target = document.getElementById(object);
		if (target) {
			let scroll_position = target.getBoundingClientRect().y - scrollable_page_element.getBoundingClientRect().y;
			scrollable_page_element.scrollTo({
				top: scroll_position,
				behavior: 'smooth'
			});
		}
	};

	pro.benchmarkCallsDummyNotForUsage = function(function_caller, t0)
	{
		if(t0 === undefined)
		{
			return performance.now();
		}
		else
		{
			var t1 = performance.now();
		}
	};

	pro.ensureCorrectAnswersArrayExistAndIsEmpty = function(gap_id)
	{
		if(pub.questionParts.list === undefined)
		{
			pub.questionParts.list = [];
		}
		pub.questionParts.list[gap_id] = [[], '0', '1'];
	};

	//Public property

	pub.Init = function(language, questionParts, answers, gap_modal_id = 'ilGapModal')
	{
		pub.language = language;
		pub.questionParts = questionParts;
		pub.answers = answers;
		pub.gap_modal_id = gap_modal_id
		pro.buildAndInitGapBuilder();
		pro.appendFormParts();
		pro.syncWithHiddenTextField();
		pub.questionParts.list = $().ensureNoArrayIsAnObjectRecursive(pub.questionParts.list);
		pub.answers = $().ensureNoArrayIsAnObjectRecursive(pub.answers);
		if (window.File && window.FileReader && window.FileList && window.Blob)
		{
			pub.filereader_usable = true;
		}
		else
		{
			//Todo: implement workaround
			alert('FileReader not usable, implement workaround.');
		}
		pro.ensureAutoCompleteIsPossibleWithTextInput();
	};

	//Return just the public parts
	pub.protect = pro;
	return pub;
}());

(function ( $ ) {
	'use strict';
	$.fn.ensureNoArrayIsAnObjectRecursive = function( obj ) {
		if ($.type(obj) === 'object' || $.type(obj) === 'array'){
			Object.keys(obj).forEach(function(key) { obj[key] = jQuery().ensureNoArrayIsAnObjectRecursive(obj[key]); });
			obj = $.map(obj, function(value) { return [value];	});
		}
		return obj;
	};}( jQuery ));
