<?php
/**
 * @property \modelContent $model
 */
class actionContentItemBind extends cmsAction {

    public function run(){

        $user = cmsUser::getInstance();

        $ctype_name       = $this->request->get('ctype_name', '');
        $child_ctype_name = $this->request->get('child_ctype_name', '');
        $item_id          = $this->request->get('id', 0);
        $selected_ids     = explode(',', $this->request->get('selected_ids', ''));

        if (!$ctype_name || !$child_ctype_name || !$item_id || !$selected_ids){
            return cmsCore::error404();
        }

        if (!cmsUser::isAllowed($child_ctype_name, 'bind_to_parent')) {
            return cmsCore::error404();
        }

        $ctype = $this->model->getContentTypeByName($ctype_name);
        if (!$ctype) { return cmsCore::error404(); }

        $parent_item = $this->model->getContentItem($ctype_name, $item_id);
        if (!$parent_item) { return cmsCore::error404(); }

        $child_ctype = $this->model->getContentTypeByName($child_ctype_name);
        if (!$child_ctype) { return cmsCore::error404(); }

        $relation = $this->model->getContentRelationByTypes($ctype['id'], $child_ctype['id']);
        if (!$relation) { return cmsCore::error404(); }

        $perm = cmsUser::getPermissionValue($child_ctype_name, 'bind_to_parent');

        foreach($selected_ids as $child_item_id){

            $child_item_id = intval(trim($child_item_id));
            if (!$child_item_id){ continue;}

            $child_item = $this->model->getContentItem($child_ctype_name, $child_item_id);
            if (!$child_item) { continue; }

            $is_allowed_to_bind = $perm && (
                                ($perm == 'all_to_all') ||
                                ($perm == 'all_to_own' && $parent_item['user_id'] == $user->id) ||
                                ($perm == 'all_to_other' && $parent_item['user_id'] != $user->id) ||
                                ($perm == 'own_to_own' && $parent_item['user_id'] == $user->id && $child_item['user_id'] == $user->id) ||
                                ($perm == 'own_to_other' && $parent_item['user_id'] != $user->id && $child_item['user_id'] == $user->id) ||
                                ($perm == 'own_to_all' && $child_item['user_id'] == $user->id) ||
                                ($perm == 'other_to_own' && $parent_item['user_id'] == $user->id && $child_item['user_id'] != $user->id) ||
                                ($perm == 'other_to_other' && $parent_item['user_id'] != $user->id && $child_item['user_id'] != $user->id) ||
                                ($perm == 'other_to_all' && $child_item['user_id'] != $user->id)
                            ) || $user->is_admin;

            if (!$is_allowed_to_bind) { continue; }

            $this->model->bindContentItemRelation([
                'parent_ctype_name' => $ctype['name'],
                'parent_ctype_id'   => $ctype['id'],
                'parent_item_id'    => $parent_item['id'],
                'child_ctype_name'  => $child_ctype['name'],
                'child_ctype_id'    => $child_ctype['id'],
                'child_item_id'     => $child_item['id']
            ]);

        }

        return $this->redirectBack();
    }

}
