<?php if ($do=='add') { ?><h1><?php echo LANG_CP_WIDGETS_ADD_PAGE; ?></span></h1><?php } ?>
<?php if ($do=='edit') { ?><h1><?php echo LANG_CP_WIDGETS_PAGE; ?>: <span><?php echo $page['title']; ?></span></h1><?php } ?>

<?php

    if ($do=='add') { $this->setPageTitle(LANG_CP_WIDGETS_ADD_PAGE); }
    if ($do=='edit') { $this->setPageTitle(LANG_CP_WIDGETS_PAGE.': '.$page['title']); }

    $this->addBreadcrumb(LANG_CP_SECTION_WIDGETS, $this->href_to('widgets'));

    if ($do=='add'){
        $this->addBreadcrumb(LANG_CP_WIDGETS_ADD_PAGE);
    }

    if ($do=='edit'){
        $this->addBreadcrumb($page['title']);
    }

    $this->addToolButton(array(
        'class' => 'save',
        'title' => LANG_SAVE,
        'href'  => "javascript:icms.forms.submit()"
    ));

    $this->addToolButton(array(
        'class' => 'cancel',
        'title' => LANG_CANCEL,
        'href'  => $this->href_to('widgets')
    ));

	$this->addToolButton(array(
		'class' => 'help',
		'title' => LANG_HELP,
		'target' => '_blank',
		'href'  => LANG_HELP_URL_WIDGETS_PAGES
	));

    $this->renderForm($form, $page, array(
        'action' => '',
        'method' => 'post'
    ), $errors);

    $this->addTplJSNameFromContext('jquery-ui');
    $this->addTplCSSNameFromContext('jquery-ui');
?>
<script>
    $(document).ready(function(){
        $('<div class="inline_button"><input id="fast_add_submit" class="button" value="<?php echo LANG_CP_WIDGETS_FA_ADD; ?>" type="button"></div>').insertAfter('#f_fast_add_into');
        $('#fast_add_ctype').triggerHandler('change');
        $('#fast_add_ctype').change(function(){
            $('#fast_add_item').triggerHandler('input');
        });

        var madd = function(value){
            var into = $('#fast_add_into').val();
            var now = $('#url_mask'+into).val();
            var add = now ? now+"\n" : '';
            add += value;
            $('#url_mask'+into).val(add);
        };
        $('#fast_add_submit').click(function(){
            var type = $('#fast_add_type').val();
            if(type === 'items'){
                madd($('#fast_add_item').val());
                $('#fast_add_item').val('');
            }else
            if(type === 'cats'){
                madd($('#fast_add_cat').val());
            }
        });

        var cache = {};
        $('#fast_add_item').autocomplete({
            minLength: 2,
            delay: 500,
            source: function( request, response ){
                var ctype = $('#fast_add_ctype').val();
                var term = ctype+'_'+request.term;
                request['ctype'] = ctype;
                if(term in cache){
                    response(cache[term]);
                    return;
                }
                $.getJSON('<?php echo href_to('admin', 'widgets', 'page_autocomplete'); ?>', request, function(data, status, xhr){
                    cache[term] = data;
                    response(data);
                });
            },
            select: function(event, ui){
                icms.events.run('autocomplete_select', ui);
            }
        });

    });
</script>
