tinymce.PluginManager.add('smiles', function (editor, url) {

    let smiles_url = editor.getParam('smiles_url', false);

    if(!smiles_url){
        return false;
    }

    let smiles = [];
    let smiles_list = [];

    let load = function (callback) {
        if(smiles.length > 0){
            return callback();
        }
        $.ajax({
            url: smiles_url,
            type: "POST",
            async: false,
            success: function(result){
                if(!result.smiles){ return; }
                for(let s in result.smiles){
                    let tag = '<img class="smile_image" title="'+s+'" src="'+result.smiles[s]+'" />';
                    smiles.push({
                        text: s,
                        value: s,
                        icon: tag
                    });
                    smiles_list[s] = tag;
                }
            },
            dataType: 'json'
        });
        return callback();
    };

    let openDialog = function () {
        return editor.windowManager.open({
            title: 'Insert smiles',
            body: {
                type: 'panel',
                items: [{
                    type: 'collection',
                    columns: 'auto',
                    name: 'results'
                }]
            },
            initialData: {
                results: smiles
            },
            onAction: function (api, details) {
                if (details.name === 'results') {
                    editor.insertContent(smiles_list[details.value]);
                    api.close();
                }
            },
            buttons: [
                {
                    type: 'cancel',
                    text: 'Close',
                    primary: true
                }
            ]
        });
    };

    editor.ui.registry.addButton('smiles', {
        tooltip: 'Insert smiles',
        icon: 'emoji',
        onAction: function () {
            load(openDialog);
        }
    });

    return {
        getMetadata: function () {
            return  {
                name: "Smiles",
                url: "https://instantcms.ru/"
            };
        }
    };
});