/**
 * Share a timeline item to your timeline
 * @param mod string
 * @param id int
 */
function jrAction_share(mod, id)
{
    if ($('#share_modal').length === 0) {
        $('body').append('<div id="share_modal"></div>');
    }
    var u = core_system_url + '/' + jrAction_url + '/share_msg/' + mod + '/' + Number(id) + '/__ajax=1';
    jrCore_set_csrf_cookie(u);
    $.get(u, function(r)
    {
        $('#share_modal').html(r).modal();
        $("#share_update").focus()
    });
    return false;
}

/**
 * Save a new share
 * @returns {boolean}
 */
function jrAction_share_save()
{
    $('#share_submit').attr('disabled', 'disabled').addClass('form_button_disabled');
    $('#share_submit_indicator').show(300, function()
    {
        $('#share_form').submit()
    });
}

/**
 * Load a Quick Share form
 * @param t object This
 * @param m string Module
 * @param f string Function
 */
var __ds_title = '';
function jrAction_quick_share(t, m, f)
{
    $('.quick_action_tab_active').removeClass('quick_action_tab_active').children('span').removeClass('sprite_icon_hilighted');
    $(t).addClass('quick_action_tab_active').children('span').addClass('sprite_icon_hilighted');
    $('#jrAction_function').val(f);
    var d = $('#quick_action_default_form');
    var c = $('#timeline_text_counter');
    if (f == 'jrAction_quick_share_status_update') {
        if (d.is(':hidden')) {
            var q = $('#quick_action_form');
            q.fadeOut(100, function()
            {
                d.fadeIn(100, function()
                {
                    c.show();
                    $('#action_update').focus();
                });
            });
            $('#quick_action_title').text(__ds_title);
        }
    }
    else {
        c.hide();
        if (__ds_title.length === 0) {
            __ds_title = $('#quick_action_title').text();
        }
        var u = core_system_url + '/' + jrAction_url + '/quick_share_form/__ajax=1';
        $.ajax({
            type: 'POST',
            data: {m: m, function: f},
            cache: false,
            dataType: 'json',
            url: u,
            success: function(r)
            {
                var a = $('#quick_action_form input');
                var q = $('#quick_action_form');
                if (d.is(':visible')) {
                    d.fadeOut(100, function()
                    {
                        q.html(r.html).fadeIn(100, function()
                        {
                            a.first().focus();
                        });
                    });
                }
                else {
                    q.fadeOut(100, function()
                    {
                        q.html(r.html).fadeIn(100, function()
                        {
                            a.first().focus();
                        });
                    });
                }
                $('#quick_action_title').text(r.title);
            }
        });
    }
}

/**
 * Submit new action from timeline form
 */
function jrAction_submit()
{
    if ($('#quick_action_default_form').is(':visible')) {
        var e = $('#action_text_editor_contents');
        if (e.length) {
            // Editor is enabled
            if (tinyMCE.get('eaction_text').getContent().length < 1) {
                return false;
            }
            e.val(tinyMCE.get('eaction_text').getContent());
        }
        else if ($('#action_update').val().length < 1) {
            return false;
        }
    }
    $('#quick_action_form').find('input').removeClass('field-hilight');
    $('#action_submit').attr('disabled', 'disabled').addClass('form_button_disabled');
    var a = $('#asi');
    a.show(300, function()
    {
        setTimeout(function()
        {
            var f = $('#action_form');
            $.post(f.attr('action'), f.serializeArray(), function(r)
            {
                if (typeof r.field !== "undefined") {
                    a.hide(300, function()
                    {
                        $('#action_submit').removeAttr('disabled').removeClass('form_button_disabled');
                        $('#quick_action_form').find('#' + r.field).addClass('field-hilight');
                    });
                }
                else if (typeof r.error !== "undefined") {
                    a.hide(300, function()
                    {
                        $('#action_submit').removeAttr('disabled').removeClass('form_button_disabled');
                        jrCore_alert(r.error);
                    });
                }
                else {
                    if (typeof r.url !== "undefined") {
                        window.location.href = r.url;
                    }
                    else {
                        window.location.reload();
                    }
                }
            }, 'json');
        }, 200);
    });
}

/**
 * copy and alteration of the character count plugin
 * Character Count Plugin - jQuery plugin
 * Dynamic character count for text areas and input fields
 * written by Alen Grakalic
 * http://cssglobe.com/post/7161/jquery-plugin-simplest-twitterlike-dynamic-character-count-for-textareas
 * Copyright (c) 2009 Alen Grakalic (http://cssglobe.com)
 * Dual licensed under the MIT (MIT-LICENSE.txt)
 * and GPL (GPL-LICENSE.txt) licenses.
 * Built for jQuery library
 * http://jquery.com
 * @modified for JR5 by the Jamroom Network.
 */
(function($)
{
    $.fn.charCount = function(options)
    {
        // default configuration properties
        var defaults = {
            text_id: '#share_text_counter',
            count_id: '#share_text_num',
            allowed: 140,
            warning: 20,
            cssWarning: 'share_warning',
            cssExceeded: 'share_exceeded'
        };
        options = $.extend(defaults, options);

        function calculate(obj)
        {
            var c = $(obj).val().length;
            var a = options.allowed - c;
            if (a <= options.warning && a >= 0) {
                $(options.text_id).addClass(options.cssWarning);
            }
            else {
                $(options.text_id).removeClass(options.cssWarning);
            }
            if (a < 0) {
                $(options.text_id).addClass(options.cssExceeded);
            }
            else {
                $(options.text_id).removeClass(options.cssExceeded);
            }
            $(options.count_id).html(a);
        };
        this.each(function()
        {
            calculate(this);
            $(this).keyup(function()
            {
                calculate(this)
            });
            $(this).change(function()
            {
                calculate(this)
            });
        });
    };
})(jQuery);

/**
 /**
 * Load detail modal template
 * @param id int item_id of timeline entry
 * @param module string Module
 * @param purl string Profile URL
 * @param action_item_id int user when original item is present
 * @param page int page of gallery item
 * */
function jrAction_detail_modal(id, module, purl, action_item_id,  page) {

    var open = false;
    if (page == null) {
        page = 1;
        open = true;
    }

    var url = core_system_url + '/' + jrAction_url + '/detail_modal/item_id=' + id + '/action_module=' + module + '/purl=' + purl + '/page=' + page + '/action_item_id=' + action_item_id;
    var modal = $('#action_modal');
    $.ajax({
        type: 'GET',
        url: url,
        cache: false,
        dataType: 'json',
        success: function(r)
        {
            modal.removeClass('media');
            if (module === 'jrAudio' || module === 'jrVideo' || module === 'jrGallery' || module === 'jrPlaylist') {
                modal.addClass("media");
                if (module === 'jrGallery' && open === true) {
                    setTimeout(function(){
                        $('#comment_box').removeClass('closed');
                    }, 1000)
                }
            }
            if (typeof r.error !== "undefined") {
                jrCore_alert(r.error);
                return;
            }
            modal.html(r.html).modal();
        },
        error: function(e) {
            jrCore_alert(e);
        }
    });
}

/**
 * Gallery Pager (stub)
 * @param page int
 * @param title_url string
 * @param profile_id int
 */
function jrAction_gallery_pager(page, title_url, profile_id) {
    var url = core_system_url + '/' + jrAction_url + '/gallery_pager/page=' + page + '/title_url=' + title_url + '/profile_id=' + profile_id;
    var modal = $('#gallery_modal');
    $.ajax({
        type: 'GET',
        url: url,
        cache: false,
        dataType: 'json',
        success: function(r)
        {
            if (typeof r.error !== "undefined") {
                jrCore_alert(r.error);
                return;
            }
            modal.html(r.html);
        }
    });
}

/**
 * Toggle Comments (stub)
 */
function jrAction_toggle_comments() {
    $('#comment_box').toggleClass('closed');
}

/**
 * Close Modal Comments a div (stub)
 */
function jrAction_close_modal() {
    $.modal.close();
}

/**
 * Open a div (stub)
 * @param div string
 * @param f string focus id
 */
function jrAction_open_div(div, f)
{
    if (typeof f !== "undefined" && f !== null) {
        $(div).show(200, function()
        {
            $(f).focus();
        });
    }
    else {
        $(div).show();
    }
}