<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: form_designer
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_form_designer($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    if (!isset($_post['m']) || !isset($_mods["{$_post['m']}"])) {
        jrCore_notice_page('error', 'invalid module');
    }
    if (!isset($_post['v']) || strlen($_post['v']) === 0) {
        jrCore_notice_page('error', 'invalid view');
    }
    $_fields = jrCore_get_designer_form_fields($_post['m'], $_post['v']);
    if (!$_fields || !is_array($_fields)) {
        $_tmp = jrCore_get_registered_module_features('jrCore', 'designer_form');
        if (!isset($_tmp["{$_post['m']}"]) || !isset($_tmp["{$_post['m']}"]["{$_post['v']}"])) {
            jrCore_notice_page('error', 'This form has not been setup properly to work with the custom form designer (1)');
        }
    }

    $mod = $_post['m'];
    $opt = $_post['v'];
    $url = jrCore_get_module_url('jrCore');

    $_lang = jrUser_load_lang_strings();

    // Show our table of options
    $btn = '';
    $tbl = jrCore_db_table_name('jrCore', 'form');
    $req = "SELECT `view` FROM {$tbl} WHERE `module` = '" . jrCore_db_escape($mod) . "' GROUP BY `view` ORDER by `view` ASC";
    $_rt = jrCore_db_query($req, 'view', false, 'view');
    if ($_rt && is_array($_rt)) {
        $btn = jrCore_page_button('reset', 'Reset This Form', "jrCore_confirm('Reset this form?', 'After resetting you will be redirected to the form so it is re-initialized.', function(){ jrCore_window_location('{$_conf['jrCore_base_url']}/{$url}/form_designer_reset/m={$_post['m']}/v={$_post['v']}') })");
        if (count($_rt) > 1) {
            $jump_url = "{$_conf['jrCore_base_url']}/{$_post['module_url']}/form_designer/m={$_post['module']}/v=";
            // Create a Quick Jump list for custom forms for this module
            $btn .= '<select name="designer_form" class="form_select form_select_item_jumper" onchange="jrCore_window_location(\'' . $jump_url . "'+ $(this).val())\">\n";
            foreach ($_rt as $option) {
                if ($option == $_post['v']) {
                    $btn .= '<option value="' . $option . '" selected="selected"> ' . $_post['module_url'] . '/' . $option . "</option>\n";
                }
                else {
                    $btn .= '<option value="' . $option . '"> ' . $_post['module_url'] . '/' . $option . "</option>\n";
                }
            }
            $btn .= '</select>';
        }
        else {
            $btn = "{$_post['module_url']}/{$_post['v']}";
        }
    }

    // Check for additional views that have been registered by this module, but have
    // not been setup for customization yet...
    $_tmp = jrCore_get_registered_module_features('jrCore', 'designer_form');
    foreach ($_rt as $option) {
        unset($_tmp[$mod][$option]);
    }
    if (isset($_tmp[$mod]) && count($_tmp[$mod]) > 0) {
        $text = "The following designer forms have not been setup yet for this module:<br><br>";
        foreach ($_tmp[$mod] as $view => $prefix) {
            $text .= "{$_post['module_url']}/{$view}<br>";
        }
        $text .= "<br>These forms will be initialized the first time they are viewed.  It is recommended that you view all forms for this module before using the Form Designer.";
        jrCore_set_form_notice('notice', $text, false);
    }

    // See if our module has a DS prefix, or has registered a designer prefix
    $pfx = jrCore_db_get_prefix($mod);
    if (!$pfx) {
        // Check for registered prefix
        $_tmp = jrCore_get_registered_module_features('jrCore', 'designer_form_prefix');
        if (isset($_tmp[$mod]) && is_array($_tmp[$mod])) {
            $pfx = array_keys($_tmp[$mod]);
            $pfx = reset($pfx);
        }
        else {
            jrCore_notice_page('error', 'This module is not setup with a DataStore prefix - unable to use form designer', 'referrer');
        }
    }

    jrCore_page_banner('form designer', $btn);
    jrCore_get_form_notice();

    $dat             = array();
    $dat[1]['title'] = 'order';
    $dat[1]['width'] = '2%;';
    $dat[2]['title'] = 'label';
    $dat[2]['width'] = '26%;';
    $dat[3]['title'] = 'name';
    $dat[3]['width'] = '12%;';
    $dat[4]['title'] = 'type';
    $dat[4]['width'] = '12%;';
    $dat[5]['title'] = 'active';
    $dat[5]['width'] = '8%;';
    $dat[6]['title'] = 'required';
    $dat[6]['width'] = '8%;';
    $dat[7]['title'] = 'groups';
    $dat[7]['width'] = '24%;';
    $dat[8]['title'] = 'modify';
    $dat[8]['width'] = '5%;';
    $dat[9]['title'] = 'delete';
    $dat[9]['width'] = '5%;';
    jrCore_page_table_header($dat);

    if (is_array($_fields) && count($_fields) > 0) {

        $_quotas = jrProfile_get_quotas();
        foreach ($_fields as $_fld) {

            $dat = array();
            if ($_fld['order'] > 1) {
                $dat[1]['title'] = jrCore_page_button("o{$_fld['name']}", '&#8679;', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$url}/form_field_order/m={$mod}/v={$opt}/n={$_fld['name']}/o={$_fld['order']}')");
            }
            else {
                $dat[1]['title'] = '';
            }
            $dat[2]['title'] = (is_numeric($_fld['label']) && isset($_lang[$mod]["{$_fld['label']}"])) ? '&nbsp;' . $_lang[$mod]["{$_fld['label']}"] : '&nbsp;' . $_fld['label'];
            $dat[3]['title'] = $_fld['name'];
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = $_fld['type'];
            $dat[4]['class'] = 'center';
            $dat[5]['title'] = (isset($_fld['active']) && $_fld['active'] == '1') ? 'yes' : '<strong>no</strong>';
            $dat[5]['class'] = 'center';
            $dat[6]['title'] = (isset($_fld['required']) && $_fld['required'] == '1') ? 'yes' : 'no';
            $dat[6]['class'] = 'center';
            $_in             = array();
            foreach (explode(',', $_fld['group']) as $g) {
                if (is_numeric($g)) {
                    $_in[] = "(quota) {$_quotas[$g]}";
                }
                else {
                    switch ($g) {
                        case 'all':
                            $g = 'All Users (including logged out)';
                            break;
                        case 'user':
                            $g = 'All Users (logged in)';
                            break;
                        case 'master':
                            $g = 'Master Admins';
                            break;
                        case 'admin':
                            $g = 'Profile Admins';
                            break;
                        case 'power':
                            $g = 'Power Users (multiple profiles)';
                            break;
                    }
                    $_in[] = "(group) {$g}";
                }
            }
            $dat[7]['title'] = implode('<br>', $_in);
            $dat[7]['class'] = 'center capital';
            $dat[8]['title'] = jrCore_page_button("m{$_fld['name']}", 'modify', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/form_field_update/m={$mod}/v={$opt}/n={$_fld['name']}')");
            if ((isset($_fld['locked']) && $_fld['locked'] == '1') || count($_fields) === 1) {
                $dat[9]['title'] = jrCore_page_button("d{$_fld['name']}", 'delete', 'disabled');
            }
            else {
                $dat[9]['title'] = jrCore_page_button("d{$_fld['name']}", 'delete', "jrCore_confirm('Delete this form field?', '', function(){ jrCore_window_location('{$_conf['jrCore_base_url']}/{$url}/form_field_delete/m={$mod}/v={$opt}/n={$_fld['name']}')} )");
            }
            jrCore_page_table_row($dat, null, $_fld);
        }
    }
    else {
        $dat             = array();
        $dat[1]['title'] = 'no custom fields have been created for this form yet';
        $dat[1]['class'] = 'p10 center';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();

    $_tmp = array(
        'submit_value'  => 'create new field',
        'cancel'        => 'referrer',
        'cancel_detect' => false
    );
    jrCore_form_create($_tmp);

    // Module
    $_tmp = array(
        'name'     => 'field_module',
        'type'     => 'hidden',
        'value'    => $mod,
        'validate' => 'core_string'
    );
    jrCore_form_field_create($_tmp);

    // View
    $_tmp = array(
        'name'     => 'field_view',
        'type'     => 'hidden',
        'value'    => $opt,
        'validate' => 'core_string'
    );
    jrCore_form_field_create($_tmp);

    // New Form Field
    $_tmp = array(
        'name'      => 'new_name',
        'label'     => 'new field name',
        'help'      => "If you would like to create a new field in this form, enter the field name here.<br><br>Note that the new field name must begin with <strong>{$pfx}_</strong> and be all lowercase",
        'type'      => 'text',
        'value'     => "{$pfx}_",
        'validate'  => 'core_string',
        'onkeydown' => "if (event && event.keyCode == 13) return false;"
    );
    jrCore_form_field_create($_tmp);

    if (isset($_post['v']) && ($_post['v'] == 'create' || $_post['v'] == 'update')) {
        $opp = ($_post['v'] == 'create') ? 'update' : 'create';
        if (jrCore_load_view_function($mod, $opp)) {
            if (isset($_rt[$opp])) {
                // Link to Update/Create
                $_tmp = array(
                    'name'     => "linked_form_field",
                    'label'    => "add to {$opp} form",
                    'help'     => "If you would like the same field name created for the &quot;{$opp}&quot; form view, check this option",
                    'type'     => 'checkbox',
                    'value'    => 'on',
                    'validate' => 'onoff'
                );
                jrCore_form_field_create($_tmp);
            }
        }
    }
    jrCore_page_display();
}
