<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: form_field_delete
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_form_field_delete($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_validate_location_url();

    if (!isset($_post['m']) || !isset($_mods["{$_post['m']}"])) {
        jrCore_set_form_notice('error', 'Invalid module');
        jrCore_form_result();
    }
    if (!isset($_post['v']) || strlen($_post['v']) === 0) {
        jrCore_set_form_notice('error', 'Invalid view');
        jrCore_form_result();
    }
    if (!isset($_post['n']) || strlen($_post['n']) === 0) {
        jrCore_set_form_notice('error', 'Invalid name');
        jrCore_form_result();
    }
    $mod = jrCore_db_escape($_post['m']);
    $opt = jrCore_db_escape($_post['v']);
    $nam = jrCore_db_escape($_post['n']);
    $tbl = jrCore_db_table_name('jrCore', 'form');
    $req = "SELECT * FROM {$tbl} WHERE `module` = '{$mod}' AND `view` = '{$opt}' and `name` = '{$nam}' LIMIT 1";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (!$_rt || !is_array($_rt)) {
        jrCore_set_form_notice('error', 'Invalid Field - not found in custom forms table');
        jrCore_form_result();
    }
    // Delete field
    $req = "DELETE FROM {$tbl} WHERE `module` = '{$mod}' AND `view` = '{$opt}' and `name` = '{$nam}' LIMIT 1";
    $cnt = jrCore_db_query($req, 'COUNT');
    if ($cnt === 1) {

        // We need to remove any language strings for this custom field
        $_fnd = array();
        $_rem = array('label', 'sublabel', 'help');
        foreach ($_rem as $k) {
            if (isset($_rt[$k]) && jrCore_checktype($_rt[$k], 'number_nz')) {
                $_fnd[] = (int) $_rt[$k];
            }
        }
        if (count($_fnd) > 0) {
            $tbl = jrCore_db_table_name('jrUser', 'language');
            $req = "DELETE FROM {$tbl} WHERE lang_module = '{$mod}' AND lang_key IN(" . implode(',', $_fnd) . ")";
            jrCore_db_query($req);
        }

        // We need to reset any existing Form Sessions for this view
        jrCore_form_delete_session_view($_post['m'], $_post['v']);
        jrCore_set_form_notice('success', 'The form field was successfully deleted');
    }
    else {
        jrCore_set_form_notice('error', 'An error was encountered trying to delete the form field - please try again');
    }
    jrCore_form_result();
}
