<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: template_modify
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_template_modify($_post, $_user, $_conf)
{
    jrUser_master_only();

    // Setup Code Mirror
    $_tmp = array('source' => jrCore_get_base_url() . "/modules/jrCore/contrib/codemirror/lib/codemirror.css");
    jrCore_create_page_element('css_href', $_tmp);
    $_tmp = array('source' => jrCore_get_base_url() . "/modules/jrCore/contrib/codemirror/lib/codemirror.js");
    jrCore_create_page_element('javascript_href', $_tmp);
    $_tmp = array('source' => jrCore_get_base_url() . "/modules/jrCore/contrib/codemirror/mode/smarty/smarty.js");
    jrCore_create_page_element('javascript_href', $_tmp);
    $_tmp = array('var editor = CodeMirror.fromTextArea(document.getElementById("template_body"), { lineNumbers: true, matchBrackets: true, mode: \'smarty\' });');
    jrCore_create_page_element('javascript_ready_function', $_tmp);

    if (isset($_post['skin'])) {
        jrCore_page_skin_tabs($_post['skin'], 'templates');
        $cancel_url = "{$_conf['jrCore_base_url']}/{$_post['module_url']}/skin_admin/templates/skin={$_post['skin']}";
        $t_type     = 'skin';
    }
    else {
        jrCore_page_admin_tabs($_post['module'], 'templates');
        $cancel_url = "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/templates";
        $t_type     = 'module';
    }

    // our page banner
    $_tp = array();
    $tpl = '';
    $btn = null;
    if (!empty($_post['template']) && jrCore_checktype($_post['template'], 'printable')) {
        if (!empty($_post['skin'])) {
            $tpl_file = APP_DIR . "/skins/{$_post['skin']}/{$_post['template']}";
        }
        else {
            $tpl_file = APP_DIR . "/modules/{$_post['module']}/templates/{$_post['template']}";
        }
        $tpl = str_replace(APP_DIR . '/', '', $tpl_file);
    }
    elseif (isset($_post['id']) && jrCore_checktype($_post['id'], 'number_nz')) {
        // Database template
        $tbl = jrCore_db_table_name('jrCore', 'template');
        $req = "SELECT * FROM {$tbl} WHERE template_id = '{$_post['id']}'";
        $_tp = jrCore_db_query($req, 'SINGLE');
        if (!$_tp || !is_array($_tp)) {
            jrCore_set_form_notice('error', 'Invalid template_id - please try again');
            jrCore_location($cancel_url);
        }
        $tpl = $_tp['template_name'];
        $url = jrCore_get_module_url('jrCore');
        $btn = jrCore_page_button("r{$_tp['template_name']}", 'reset', "jrCore_confirm('Reset Template?', 'Reset this template to the default provided by the {$t_type}?', function() { jrCore_window_location('{$_conf['jrCore_base_url']}/{$url}/template_reset_save/{$t_type}={$_tp['template_module']}/id=" . $_tp['template_id'] . "')})");
    }

    jrCore_page_banner('Template Editor: <span style="text-transform:none">' . $tpl . '</span>', $btn);

    $_tmp = array(
        'submit_value'     => 'save changes',
        'cancel'           => 'referrer',
        'form_ajax_submit' => false
    );
    jrCore_form_create($_tmp);

    // Template ID
    $_tmp = array(
        'name'  => 'template_type',
        'type'  => 'hidden',
        'value' => $t_type
    );
    jrCore_form_field_create($_tmp);

    if (!empty($_post['skin'])) {
        $_tmp = array(
            'name'  => 'skin',
            'type'  => 'hidden',
            'value' => $_post['skin']
        );
        jrCore_form_field_create($_tmp);
    }

    // Get info about this template...
    $tpl_body = '';
    if (isset($_post['id']) && jrCore_checktype($_post['id'], 'number_nz')) {

        $tpl_body = $_tp['template_body'];

        // Template ID
        $_tmp = array(
            'name'  => 'template_id',
            'type'  => 'hidden',
            'value' => $_post['id']
        );
        jrCore_form_field_create($_tmp);
    }

    // From file
    elseif (!empty($_post['template']) && jrCore_checktype($_post['template'], 'printable')) {

        // Make sure this is a good file
        $_post['template'] = basename($_post['template']);
        if (!empty($_post['skin'])) {
            $tpl_file = APP_DIR . "/skins/{$_post['skin']}/{$_post['template']}";
        }
        else {
            $tpl_file = APP_DIR . "/modules/{$_post['module']}/templates/{$_post['template']}";
        }
        if (!is_file($tpl_file)) {
            jrCore_set_form_notice('error', 'Template file not found - please try again');
            jrCore_location($cancel_url);
        }
        $tpl_body = jrCore_file_get_contents($tpl_file);

        $_tmp = array(
            'name'  => 'template_name',
            'type'  => 'hidden',
            'value' => $_post['template']
        );
        jrCore_form_field_create($_tmp);
    }
    else {
        jrCore_set_form_notice('error', 'Invalid template - please try again');
        jrCore_location($cancel_url);
    }

    // Show template
    if ($temp = jrCore_get_user_session_key('template_body_save')) {
        $tpl_body = $temp;
        jrCore_delete_user_session_key('template_body_save');
    }
    $html = '<div class="form_template"><textarea id="template_body" name="template_body" class="form_template_editor">' . htmlspecialchars($tpl_body) . '</textarea></div>';
    jrCore_page_custom($html);
    jrCore_page_display();
}
