<?php
 /**
 * Jamroom Geo Location module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2014 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * schema
 */
function jrGeo_db_schema()
{
    // IP Cache
    $_tmp = array(
        "ip_id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY",
        "ip_address VARCHAR(16) NOT NULL DEFAULT ''",
        "ip_time INT(11) UNSIGNED NOT NULL DEFAULT '0'",
        "ip_info TEXT NOT NULL",
        "UNIQUE ip_address (ip_address)"
    );
    jrCore_db_verify_table('jrGeo', 'ip_cache', $_tmp);

    // ZIP Code
    $_tmp = array(
        "zip_country CHAR(2) NOT NULL DEFAULT ''",
        "zip_code VARCHAR(20) NOT NULL DEFAULT ''",
        "zip_place VARCHAR(255) NOT NULL DEFAULT ''",
        "zip_lat VARCHAR(12) NOT NULL DEFAULT ''",
        "zip_lon VARCHAR(12) NOT NULL DEFAULT ''",
        "INDEX zip_country (zip_country)",
        "INDEX zip_code (zip_code)",
        "INDEX zip_lat (zip_lat)",
        "INDEX zip_lon (zip_lon)"
    );
    jrCore_db_verify_table('jrGeo', 'zip_code', $_tmp);

    // ZIP Cache
    $_tmp = array(
        "zip_hash CHAR(32) CHARACTER SET latin1 NOT NULL DEFAULT ''",
        "zip_info VARCHAR(32768) CHARACTER SET latin1 NOT NULL DEFAULT ''",
        "UNIQUE zip_hash (zip_hash)"
    );
    jrCore_db_verify_table('jrGeo', 'zip_cache', $_tmp);

    return true;
}
