<?php
 /**
 * Jamroom Marketplace module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: systems
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrMarket_systems($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrMarket');
    jrCore_page_banner('Marketplaces');
    jrCore_get_form_notice();

    $dat             = array();
    $dat[1]['title'] = 'marketplace system';
    $dat[1]['width'] = '50%';
    $dat[2]['title'] = 'credentials';
    $dat[2]['width'] = '35%';
    $dat[3]['title'] = 'active';
    $dat[3]['width'] = '5%';
    $dat[4]['title'] = 'modify';
    $dat[4]['width'] = '5%';
    $dat[5]['title'] = 'delete';
    $dat[5]['width'] = '5%';
    jrCore_page_table_header($dat);

    $pass = jrCore_get_option_image('pass');
    $fail = jrCore_get_option_image('fail');

    $tbl = jrCore_db_table_name('jrMarket', 'system');
    $req = "SELECT * FROM {$tbl} ORDER BY system_id ASC";
    $_rt = jrCore_db_query($req, 'NUMERIC');
    if (isset($_rt) && is_array($_rt)) {
        foreach ($_rt as $k => $_sys) {
            $dat             = array();
            $dat[1]['title'] = "{$_sys['system_name']}<br>{$_sys['system_url']}";
            $dat[1]['class'] = 'center';
            $dat[2]['title'] = "{$_sys['system_email']}<br>{$_sys['system_code']}";
            $dat[2]['class'] = 'center';
            if ($_sys['system_active'] == 'on') {
                $dat[3]['title'] = $pass;
            }
            else {
                $dat[3]['title'] = $fail;
            }
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = jrCore_page_button("m{$k}", 'modify', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/release_system_update/id={$_sys['system_id']}')");
            if ($_sys['system_id'] > 1) {
                $dat[5]['title'] = jrCore_page_button("d{$k}", 'delete', "jrCore_confirm('Delete this Marketplace System?', '', function() { jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/system_delete_save/id={$_sys['system_id']}') } )");
            }
            else {
                $dat[5]['title'] = jrCore_page_button("d{$k}", 'delete', 'disabled');
            }
            jrCore_page_table_row($dat);
        }
    }
    else {
        $dat             = array();
        $dat[1]['title'] = '<p>No Marketplace systems found - add a new System below</p>';
        $dat[1]['class'] = 'center';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();

    // Form init
    $_tmp = array(
        'submit_value'     => 'add marketplace system',
        'cancel'           => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools",
        'form_ajax_submit' => false
    );
    jrCore_form_create($_tmp);

    // System Name
    $_tmp = array(
        'name'     => 'system_name',
        'label'    => 'Marketplace Name',
        'help'     => 'Enter a unique Marketplace Name for this new Marketplace system',
        'type'     => 'text',
        'validate' => 'not_empty',
        'required' => true,
        'section'  => 'add a new marketplace'
    );
    jrCore_form_field_create($_tmp);

    // System URL
    $_tmp = array(
        'name'     => 'system_url',
        'label'    => 'Marketplace URL',
        'help'     => 'Enter the Marketplace URL for this new Marketplace system',
        'type'     => 'text',
        'validate' => 'url',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // System Email
    $_tmp = array(
        'name'     => 'system_email',
        'label'    => 'Marketplace Email',
        'help'     => 'Enter the Email Address used for your Account on this new Marketplace system',
        'type'     => 'text',
        'validate' => 'email',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // System Code
    $_tmp = array(
        'name'     => 'system_code',
        'label'    => 'Marketplace System ID',
        'help'     => 'Enter the Unique System ID from your Account on this new Marketplace system',
        'type'     => 'text',
        'validate' => 'md5',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    jrCore_page_display();
}
