<?php
 /**
 * Jamroom Search module
 *
 * copyright 2022 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: item_display_order
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrSearch_item_display_order($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();

    // First - find modules we are going to be searching
    $_rm = jrCore_get_registered_module_features('jrSearch', 'search_fields');

    // Allow other modules to inject into search
    $_rm = jrCore_trigger_event('jrSearch', 'search_fields', $_rm);

    if (isset($_conf['jrSearch_display_order']) && strlen($_conf['jrSearch_display_order']) > 3) {
        $_order     = explode(',', $_conf['jrSearch_display_order']);
        $_new_order = array();
        if (is_array($_order) && !empty($_order)) {
            foreach ($_order as $mod) {
                $_new_order[$mod] = $_mods[$mod]['module_name'];
                unset($_rm[$mod]);
            }
        }
        if (!empty($_rm)) {
            foreach ($_rm as $mod => $_inf) {
                $_new_order[$mod] = $_mods[$mod]['module_name'];
            }
        }
    }
    else {
        foreach ($_rm as $mod => $_inf) {
            $_rm[$mod] = $_mods[$mod]['module_name'];
        }
        $_new_order = $_rm;
    }

    jrCore_page_banner('Set Search Result Order', 'set the order module results appear in');

    $tmp = '<ul class="item_sortable list">';
    foreach ($_new_order as $mod => $title) {
        if (jrCore_is_datastore_module($mod) && !jrSearch_is_excluded_module($mod)) {
            $tmp .= "<li class='jrsearch_reorder_item' data-id=\"{$mod}\">{$title}</li>\n";
        }
    }
    $tmp .= '</ul>';
    jrCore_page_custom($tmp, 'Search Modules', 'drag and drop entries to set order');

    $url = "{$_conf['jrCore_base_url']}/" . jrCore_get_module_url('jrSearch') . "/item_display_order_update/__ajax=1";

    $tmp = array('$(function() {
           $(\'.item_sortable\').sortable().bind(\'sortupdate\', function(event,ui) {
               var o = $(\'ul.item_sortable li\').map(function(){ return $(this).data("id"); }).get();
               $.post(\'' . $url . '\', { iid: o });
           });
       });');
    jrCore_create_page_element('javascript_footer_function', $tmp);
    jrCore_page_cancel_button("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/global/section=display+options", 'save order');
    return jrCore_page_display(true);
}
