<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: activity_log_delete
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_activity_log_delete($_post, $_user, $_conf)
{
    @ini_set('max_execution_time', 180);
    jrUser_master_only();
    jrCore_validate_location_url();
    if (!empty($_post['search_string'])) {
        $str = jrCore_strip_non_ascii(trim(urldecode($_post['search_string'])));
        $tb1 = jrCore_db_table_name('jrCore', 'log');
        if (!empty($_post['archive'])) {
            $tb1 = jrCore_db_table_name('jrCore', 'log_' . $_post['archive']);
        }
        $req = "SELECT log_id FROM {$tb1} WHERE ";

        // @note: If we are searching for a PARTIAL IP address
        $partial = (preg_match('/[0-9]./', $str) && substr_count($str, '.') < 3);
        if (jrCore_checktype($str, 'ip_address')) {
            $str = jrCore_db_escape($str);
            if (substr_count($str, '.') === 3) {
                $req .= "log_ip = '{$str}' ";
            }
            else {
                $req .= "log_ip LIKE '{$str}%' ";
            }
        }
        elseif (strlen($str) < 4) {
            $str = jrCore_db_escape($str);
            if ($partial) {
                $req .= "(log_text LIKE '%{$str}%' OR log_ip LIKE '{$str}%') ";
            }
            else {
                $req .= "log_text LIKE '%{$str}%' ";
            }
        }
        else {
            $str = jrCore_db_escape($str);
            if ($partial) {
                $req .= "(MATCH(log_text) AGAINST('{$str}' IN NATURAL LANGUAGE MODE) AND log_text LIKE '%{$str}%' OR log_ip LIKE '{$str}%') ";
            }
            else {
                $req .= "MATCH(log_text) AGAINST('{$str}' IN NATURAL LANGUAGE MODE) AND log_text LIKE '%{$str}%' ";
            }
        }
        $_id = jrCore_db_query($req, 'log_id', false, 'log_id');
        if (!empty($_id)) {
            $ids = implode(',', $_id);
            $tbl = jrCore_db_table_name('jrCore', 'log_debug');
            $_rq = array(
                "DELETE FROM {$tb1} WHERE log_id IN({$ids})",
                "DELETE FROM {$tbl} WHERE log_log_id IN({$ids})",
            );
            jrCore_db_multi_query($_rq, false, true, null, false);
            jrCore_location('referrer');
        }
        jrCore_set_form_notice('error', 'An error was encountered deleting the matching activity logs');
        jrCore_location('referrer');
    }
    else {
        if (empty($_post['id'])) {
            jrCore_json_response(array('msg' => 'invalid log id'));
        }
        if (strpos($_post['id'], ',')) {
            if ($_ids = explode(',', $_post['id'])) {
                foreach ($_ids as $i) {
                    if (!jrCore_checktype($i, 'number_nz')) {
                        jrCore_json_response(array('msg' => 'invalid log id'));
                    }
                }
            }
        }
        else {
            if (!jrCore_checktype($_post['id'], 'number_nz')) {
                jrCore_json_response(array('msg' => 'invalid log id'));
            }
            $_ids = array($_post['id']);
        }

        $ids = implode(',', $_ids);
        $tbl = jrCore_db_table_name('jrCore', 'log_debug');
        $req = "DELETE FROM {$tbl} WHERE log_log_id IN({$ids})";
        jrCore_db_query($req);

        $uid = reset($_ids);
        $tbl = jrCore_db_get_archive_table_for_unique_id('jrCore', 'log', $uid);
        $req = "DELETE FROM {$tbl} WHERE log_id IN({$ids})";
        $cnt = jrCore_db_query($req, 'COUNT');
        if ($cnt && $cnt > 0) {
            jrCore_json_response(array('msg' => 'ok'));
        }
    }
    jrCore_json_response(array('msg' => 'error encountered deleting log entries - please try again'));
}
