<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: pending_item_approve
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_pending_item_approve($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_admin_only();
    jrCore_validate_location_url();
    if (empty($_post['id'])) {
        jrCore_set_form_notice('error', 'Invalid item id');
        jrCore_location('referrer');
    }

    // See if we are doing ONE or multiple
    $mod = false;
    $tbl = jrCore_db_table_name('jrCore', 'pending');
    if (isset($_post['id']) && jrCore_checktype($_post['id'], 'number_nz')) {

        // We are only doing ONE item - this will be the _item_id for the ITEM
        $single = true;
        $title  = 'item has';
        $mod    = $_post['_1'];
        $req    = "SELECT * FROM {$tbl} WHERE pending_module = '" . jrCore_db_escape($mod) . "' AND pending_item_id = " . intval($_post['id']) . " LIMIT 1";

    }
    else {

        // We are doing MULTIPLE - this will be the pending_id from the pending table!
        $_id = explode(',', trim(trim($_post['id']), ','));
        foreach ($_id as $v) {
            if (!jrCore_checktype($v, 'number_nz')) {
                jrCore_notice_page('error', 'invalid pending id received');
            }
        }
        $single = false;
        $title  = 'items have';
        $req    = "SELECT * FROM {$tbl} WHERE pending_id IN(" . implode(',', $_id) . ')';
    }

    $_lg = array();
    $_dl = array();
    $_rt = jrCore_db_query($req, 'NUMERIC');
    if ($_rt && is_array($_rt)) {

        $_it = array();
        foreach ($_rt as $p) {
            if (!$mod) {
                $mod = $p['pending_module'];
            }
            $_it[] = (int) $p['pending_item_id'];
        }
        $_it = array(
            'search'                       => array(
                '_item_id in ' . implode(',', $_it)
            ),
            'exclude_jrProfile_quota_keys' => true,
            'ignore_pending'               => true,
            'privacy_check'                => false,
            'quota_check'                  => false,
            'index_key'                    => '_item_id',
            'limit'                        => count($_it)
        );
        $_it = jrCore_db_search_items($mod, $_it);
        if ($_it && is_array($_it) && isset($_it['_items']) && is_array($_it['_items'])) {
            $_it = $_it['_items'];
        }
        foreach ($_rt as $p) {

            $pid = (int) $p['pending_item_id'];
            // @note: We update here to handle the case where the entry was removed from the PENDING table
            // but the update in the DS failed for whatever reason - this ensures the item is always correct
            $pfx = jrCore_db_get_prefix($p['pending_module']);
            $_dt = array("{$pfx}_pending" => '0');
            jrCore_db_update_item($mod, $pid, $_dt, null, false);
            jrCore_db_delete_item_key($mod, $pid, "{$pfx}_pending_reason", false, false, false);

            // Trigger approve pending event
            $_args = array(
                'module'   => $mod,
                '_item_id' => $pid,
                '_item'    => $_it[$pid]
            );
            jrCore_trigger_event('jrCore', 'approve_pending_item', $p, $_args);

            // Remove pending entry
            $_dl[] = intval($p['pending_id']);

            // Check for any LINKED items that also need to be approved
            $req = "SELECT * FROM {$tbl} WHERE pending_linked_item_module = '" . jrCore_db_escape($p['pending_module']) . "' AND pending_linked_item_id = {$pid}";
            $_pa = jrCore_db_query($req, 'NUMERIC');
            if ($_pa && is_array($_pa)) {
                foreach ($_pa as $lp) {
                    // We've found a linked action - approve
                    $pf2 = jrCore_db_get_prefix($lp['pending_module']);
                    jrCore_db_update_item($lp['pending_module'], $lp['pending_item_id'], array("{$pf2}_pending" => 0));
                    $_dl[] = (int) $lp['pending_id'];
                    if (!empty($_it[$pid]['_profile_id'])) {
                        jrProfile_reset_cache($_it[$pid]['_profile_id'], $lp['pending_module']);
                    }
                }
            }

            // Notify user that pending item has been approved
            if ($_it[$pid]['_user_id'] != $_user['_user_id']) {
                if (!$ttl = jrCore_get_item_title($p['pending_module'], $_it[$pid])) {
                    $ttl = ' no title';
                }
                $_rp = array(
                    'item'             => $_it[$pid],
                    'item_module_url'  => jrCore_get_base_url() . "/{$_it[$pid]['profile_url']}/" . jrCore_get_module_url($p['pending_module']) . "/" . $_it[$pid]['_item_id'],
                    'item_module_name' => $_mods["{$p['pending_module']}"]['module_name'],
                    'item_title'       => $ttl
                );
                list($sub, $msg) = jrCore_parse_email_templates('jrCore', 'pending_approve', $_rp);
                jrUser_notify($_it[$pid]['_user_id'], 0, 'jrCore', 'pending_approve', $sub, $msg);
            }

            if (!empty($_it[$pid]['_profile_id'])) {
                jrProfile_reset_cache($_it[$pid]['_profile_id'], $mod);
            }
            if (!$title = jrCore_get_item_title($p['pending_module'], $_it[$pid])) {
                $title = '(no title)';
            }
            if ($single) {
                jrCore_logger('INF', "core: pending item " . $_mods["{$p['pending_module']}"]['module_name'] . ": " . $title . " has been approved");
            }
            else {
                $_lg[] = $_mods["{$p['pending_module']}"]['module_name'] . ': ' . $title;
            }
        }
    }
    else {
        // We have been removed from the Pending table
        // make sure keys are removed from the DS item
        if ($mod) {
            if ($pfx = jrCore_db_get_prefix($mod)) {
                $iid = intval($_post['id']);
                $_dt = array("{$pfx}_pending" => '0');
                jrCore_db_update_item($mod, $iid, $_dt, null, false);
                jrCore_db_delete_item_key($mod, $iid, "{$pfx}_pending_reason", false, false, false);
            }
        }
    }

    if (count($_dl) > 0) {
        $tbl = jrCore_db_table_name('jrCore', 'pending');
        $req = "DELETE FROM {$tbl} WHERE pending_id IN(" . implode(',', $_dl) . ')';
        jrCore_db_query($req);
    }

    if (!$single) {
        jrCore_logger('INF', "core: multiple pending items have been approved", $_lg);
    }

    jrUser_reset_cache($_user['_user_id'], $mod);
    jrCore_db_delete_pending_item_ids_cache($mod);
    jrCore_set_form_notice('success', "The pending {$title} been approved");
    jrCore_location('referrer');
}
