<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: stream_file
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_stream($_post, $_user, $_conf)
{
    // When a stream request comes in, it will look like:
    // http://www.site.com/song/stream/audio_file/5
    // so we have URL / module / option / _1 / _2
    if (!isset($_post['_2']) || !is_numeric($_post['_2'])) {
        jrCore_set_custom_header('HTTP/1.0 404 Not Found', 'status_404');
        jrCore_notice('Error', 'invalid media id', false);
    }
    // Make sure this is a DataStore module
    if (!jrCore_db_get_prefix($_post['module'])) {
        jrCore_set_custom_header('HTTP/1.0 404 Not Found', 'status_404');
        jrCore_notice('Error', 'invalid module - no datastore', false);
    }

    // Must have a valid media location cookie
    if (!jrUser_is_admin() && !jrCore_get_media_location_cookie()) {
        if (!jrCore_module_is_active('jrCustomDomain')) {
            // There is no reliable way to tell a play from a custom domain,
            // so we just don't error out if we are running custom domains
            jrCore_set_custom_header('HTTP/1.0 403 Forbidden', 'status_403');
            jrCore_notice('Error', 'invalid media play token', false);
        }
    }

    // Get DS item
    // @note: jrListParams has been deprecated
    if (!$_rt = jrCore_db_get_item($_post['module'], $_post['_2'])) {
        jrCore_set_custom_header('HTTP/1.0 404 Not Found', 'status_404');
        jrCore_notice('Error', 'invalid media id - item not found', false);
    }

    $fld = $_post['_1'];
    if (strpos($fld, '_mobile')) {
        $fld = str_replace('_mobile', '', $fld);
    }
    // Check that file exists
    $ext = $_rt["{$fld}_extension"];
    if (isset($_post['_3']) && strpos($_post['_3'], '.')) {
        $ext = jrCore_file_extension($_post['_3']);
    }
    $nam = "{$_post['module']}_{$_post['_2']}_{$fld}.{$ext}";
    // See if we have a SAMPLE for streaming - always overrides full stream
    if (isset($_rt["{$fld}_item_price"]) && $_rt["{$fld}_item_price"] > 0 && jrCore_media_file_exists($_rt['_profile_id'], "{$nam}.sample.{$ext}")) {
        $nam = "{$nam}.sample.{$ext}";
    }

    // "stream_file" event trigger
    $_args = array(
        'module'      => $_post['module'],
        'stream_file' => $nam,
        'file_name'   => $fld,
        'item_id'     => $_post['_2']
    );
    $_rt   = jrCore_trigger_event('jrCore', 'stream_file', $_rt, $_args);
    if (isset($_rt['stream_block']) && jrCore_checktype($_rt['stream_block'], 'is_true')) {
        // We have been blocked by the listener
        jrCore_set_custom_header('HTTP/1.0 403 Forbidden', 'status_403');
        jrCore_set_custom_header('Connection: close');
        jrCore_notice('Error', 'you do not have permission to stream this file', false);
    }

    // Privacy Checking for this profile
    if (!jrUser_is_admin() && isset($_rt['profile_private']) && $_rt['profile_private'] != '1') {
        // Privacy Check (Sub Select) - non admin users
        // 0 = Private
        // 1 = Global
        // 2 = Shared
        if (!jrProfile_is_profile_owner($_rt['_profile_id'])) {
            if ($_rt['profile_private'] == '0') {
                // We have a private profile and this is not the owner
                jrCore_set_custom_header('HTTP/1.0 403 Forbidden', 'status_403');
                jrCore_set_custom_header('Connection: close');
                jrCore_notice('Error', 'you do not have permission to stream this file', false);
            }
            // We're shared - viewer must be a follower of the profile
            elseif (jrCore_module_is_active('jrFollower')) {
                if (jrFollower_is_follower($_user['_user_id'], $_rt['_profile_id']) === false) {
                    // We are not a follower of this profile - not allowed
                    jrCore_set_custom_header('HTTP/1.0 403 Forbidden', 'status_403');
                    jrCore_set_custom_header('Connection: close');
                    jrCore_notice('Error', 'you do not have permission to stream this file', false);
                }
            }
            else {
                // Shared by followers not enabled
                jrCore_set_custom_header('HTTP/1.0 403 Forbidden', 'status_403');
                jrCore_set_custom_header('Connection: close');
                jrCore_notice('Error', 'you do not have permission to stream this file', false);
            }
        }
    }

    $fname = $nam;
    if (isset($_rt["{$fld}_original_name"]) && strlen($_rt["{$fld}_original_name"]) > 0) {
        $fname = $_rt["{$fld}_original_name"];
    }
    elseif (isset($_rt["{$fld}_name"]) && strlen($_rt["{$fld}_name"]) > 0) {
        $fname = $_rt["{$fld}_name"];
    }

    if (!empty($_rt['stream_file']) && $_rt['stream_file'] != $nam) {
        $nam = $_rt['stream_file'];
    }
    if (!empty($_rt['stream_file_name'])) {
        $fname = $_rt['stream_file_name'];
    }

    if (!jrCore_media_file_exists($_rt['_profile_id'], $nam)) {
        jrCore_set_custom_header('HTTP/1.0 404 Not Found', 'status_404');
        jrCore_notice('Error', 'invalid media id - no file found', false);
    }

    // Watch for browser scans
    if (!isset($_rt['skip_stream_count'])) {
        jrCore_counter($_post['module'], $_post['_2'], "{$fld}_stream");
    }

    // Stream the file to the client
    jrCore_media_file_stream($_rt['_profile_id'], $nam, $fname);
    jrCore_exit();
}
