<?php
 /**
 * Jamroom Profiles module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: user_link_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrProfile_user_link_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);

    // Our link_user_id and link_profile_id could come in as a STRING (user_name) or a NUMBER (_user_id)
    $uid = 0;
    if (isset($_post['link_user_id']) && jrCore_checktype($_post['link_user_id'], 'number_nz')) {
        // We're good - they selected from the live search
        $uid = (int) $_post['link_user_id'];
        // Make sure user exists
        if (!$_us = jrCore_db_get_item('jrUser', $uid, true)) {
            jrCore_set_form_notice('error', 'invalid user name - data not found');
            jrCore_form_result();
        }
    }
    else {
        $_us = jrCore_db_get_item_by_key('jrUser', 'user_name', $_post['link_user_id'], true);
        if ($_us && is_array($_us)) {
            $uid = (int) $_us['_user_id'];
        }
        else {
            jrCore_set_form_notice('error', 'invalid user name - please select a valid user name');
            jrCore_form_result();
        }
    }

    $pid = 0;
    if (isset($_post['link_profile_id']) && jrCore_checktype($_post['link_profile_id'], 'number_nz')) {
        // We're good - they selected from the live search
        $pid = (int) $_post['link_profile_id'];
        // Make sure profile exists
        if (!$_pr = jrCore_db_get_item('jrProfile', $pid, true)) {
            jrCore_set_form_notice('error', 'invalid profile name - data not found');
            jrCore_form_result();
        }
    }
    else {
        $_pr = jrCore_db_get_item_by_key('jrProfile', 'profile_name', $_post['link_profile_id'], true);
        if ($_pr && is_array($_pr)) {
            $pid = (int) $_pr['_profile_id'];
        }
        else {
            jrCore_set_form_notice('error', 'invalid profile name - please select a valid user account');
            jrCore_form_result();
        }
    }

    // are we forcing this User Account to be the new Profile Owner?
    if (!empty($_post['link_replace']) && $_post['link_replace'] == 'on') {

        // First - remove any existing User ID -> Profile ID connections
        $tbl = jrCore_db_table_name('jrProfile', 'profile_link');
        $req = "DELETE FROM {$tbl} WHERE profile_id = {$pid}";
        jrCore_db_query($req);

        // Update User Account to set new Profile ID
        $_dt = array('user_name' => $_us['user_name']);
        $_cr = array('_profile_id' => $pid);
        jrCore_db_update_item('jrUser', $uid, $_dt, $_cr);

        // Update Profile with new User ID
        $_dt = array('profile_name' => $_pr['profile_name']);
        $_cr = array('_user_id' => $uid);
        jrCore_db_update_item('jrProfile', $pid, $_dt, $_cr);

    }
    // Create the link
    jrProfile_create_user_link($uid, $pid);

    // Reset caches and force session reload for user
    jrUser_reset_cache($uid);
    jrProfile_reset_cache($pid);
    jrUser_set_session_sync_for_user_id($uid, 'on');

    jrCore_form_delete_session();
    jrCore_set_form_notice('success', 'The User Account has been successfully linked with the Profile');
    jrCore_form_result();
}
