<?php
 /**
 * Jamroom 2 Factor Authentication module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: resend_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrTwoFactor_resend_save($_post, $_user, $_conf)
{
    jrCore_validate_location_url();
    // We should get the user_id as $_1
    if (!isset($_post['_1']) || !jrCore_checktype($_post['_1'], 'number_nz')) {
        jrCore_set_form_notice('error', 6); // invalid user_id received - please try again
        jrCore_location('referrer');
    }
    $uid = (int) $_post['_1'];
    $tbl = jrCore_db_table_name('jrTwoFactor', 'session');
    $req = "SELECT factor_code, factor_session FROM {$tbl} WHERE factor_user_id = {$uid}";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (!is_array($_rt)) {
        jrCore_set_form_notice('error', 6); // invalid user_id received - please try again
        jrCore_location('referrer');
    }
    $_rt['factor_session'] = json_decode($_rt['factor_session'], true);
    // Send off
    $_rp = array(
        'factor_code'         => $_rt['factor_code'],
        'factor_login_url'    => jrCore_get_base_url() . "/{$_post['module_url']}/login/{$uid}",
        'factor_continue_url' => jrCore_get_base_url() . "/{$_post['module_url']}/login/{$uid}/{$_rt['factor_code']}"
    );
    list($sub, $msg) = jrCore_parse_email_templates('jrTwoFactor', 'code', $_rp);
    jrCore_send_email($_rt['factor_session']['user_email'], $sub, $msg);
    jrCore_set_form_notice('success', 7); // The authentication code has been resent to your email address
    jrCore_location('referrer');
}
