{jrCore_module_url module="jrImage" assign="murl"}
{jrCore_module_url module="jrUpimg" assign="uimurl"}
<style type="text/css">
    .qq-upload-spinner {
        background: url("{$jamroom_url}/{$murl}/img/module/jrCore/loading.gif");
    }
</style>

<script type="text/javascript">
    function jrUpimage_upload_image(filename)
    {
        $.ajax({
            type: 'POST',
            data: { upload_token: '{$upload_token}' },
            cache: false,
            dataType: 'json',
            url: core_system_url + '/{$uimurl}/create_save',
            success: function(r) {
                if (typeof r.error !== "undefined") {
                    jrCore_alert(r.error);
                }
                else {
                    var ed = top.tinymce.activeEditor, dom = ed.dom;
                    var s = $('#image-size').val();
                    var p = $('#imgpos').val();
                    var m = $('#imgmar').val();
                    switch (p) {
                        case 'stretch':
                            p = 'width:100%;';
                            break;
                        case 'left':
                            p = 'float:left;';
                            break;
                        case 'right':
                            p = 'float:right;';
                            break;
                        case 'normal':
                            p = '';
                            break;
                    }
                    switch (m) {
                        case 0:
                            m = '';
                            break;
                        default:
                            m = 'margin:' + m + 'px;';
                            break;
                    }
                    var alt = filename.replace(/[^a-zA-Z0-9_. ]+/g, '');
                    ed.insertContent(dom.createHTML('img', {
                        src: r.image_url + '/' + s,
                        style: p + m,
                        alt: alt
                    }));
                    ed.windowManager.close();
                }
            }
        });
    }

    {jrCore_module_url module="jrCore" assign="curl"}
    {$max_size = $_user.quota_jrCore_max_upload_size}
    {if jrCore_is_heic_supported()}
        {$extensions = '.png,.jpg,.gif,.jpeg,.heic,.heif'}
    {else}
        {$extensions = '.png,.jpg,.gif,.jpeg'}
    {/if}
    {$access_key = "`$_conf.jrCore_unique_string``$extensions``$max_size`"}
    {$resize = ''}
    {$max_width = jrCore_get_config_value('jrImage', 'maximum_width', 0)}
    {if $max_width > 0}
        {$resize = "resize: { width: `$max_width`, height: `$max_width` },"}
    {/if}
    $(document).ready(function() {
        var pm_active_uploads = {ldelim}{rdelim};
        var pm_upimg_file = new qq.FileUploader({
            element: document.getElementById('pm_upimg_file'),
            action: '{$jamroom_url}/{$curl}/upload_file',
            inputName: 'pm_upimg_file',
            acceptFiles: '{$extensions}',
            sizeLimit: {$max_size|intval},
            multiple: false,{$resize}
            debug: false,
            params: {
                upload_name: 'upimg_file',
                field_name: 'pm_upimg_file',
                upload_token: '{$upload_token}',
                extensions: '{$extensions}',
                multiple: 'false',
                max_size: {$max_size|intval},
                access_key: '{$access_key|md5}'
            },
            uploadButtonText: '{jrCore_lang module="jrUpimg" id="2" default="Select an image to upload and insert"}',
            cancelButtonText: '{jrCore_lang module="jrCore" id="2" default="cancel"}',
            failUploadText: 'upload failed',
            onUpload: function(id, filename) {
                pm_active_uploads[filename] = 1;
                $('.form_submit_section input').attr("disabled", "disabled").addClass('form_button_disabled');
            },
            onComplete: function(id, filename, response) {
                delete pm_active_uploads[filename];
                var count = 0;
                for (var i in pm_active_uploads) {
                    if (pm_active_uploads.hasOwnProperty(i)) {
                        count++;
                    }
                }
                if (count === 0) {
                    $('.form_submit_section input').removeAttr("disabled", "disabled").removeClass('form_button_disabled');
                }
                jrUpimage_upload_image(filename);
            }
        });
        return true;
    })
    ;
</script>

<div class="container">

    <div class="row page_table_row">
        <div class="col3">
            <div class="page_table_header">{jrCore_lang module="jrUpimg" id=4 default="size"}</div>
            <div class="page_table_cell center">

                {$imgsize = jrCore_get_cookie('imgsizg')}
                {if $imgsize == false}
                    {$imgsize = 256}
                {/if}

                <select id="image-size" class="form_select" style="width:auto" onchange="jrSetCookie('imgsizg', $(this).val());">
                    {foreach $image_sizes as $pixels}
                        {if strlen($image_names[$pixels]) > 2}
                            {$name = " - `$image_names[$pixels]`"}
                        {else}
                            {$name = ''}
                        {/if}

                        {if isset($imgsize) && $imgsize == $pixels}
                            <option value="{$pixels}" selected="selected">{$pixels}px {$name}</option>
                        {else}
                            <option value="{$pixels}">{$pixels}px {$name}</option>
                        {/if}
                    {/foreach}
                    {if !isset($_conf.jrImage_block_original_size) || $_conf.jrImage_block_original_size == "off"}
                        <option value="original">original</option>
                    {/if}
                </select>

            </div>

        </div>
        <div class="col2">
            <div class="page_table_header">{jrCore_lang module="jrUpimg" id=6 default="position"}</div>
            <div class="page_table_cell center">

                {$imgposg = jrCore_get_cookie('imgposg')}
                {if $imgposg == false}
                    {$imgposg = 'normal'}
                {/if}

                <select id="imgpos" class="form_select" style="width:auto" onchange="jrSetCookie('imgposg', $(this).val());">
                    <option value="normal" {if $imgposg == "normal"}selected="selected"{/if}>{jrCore_lang module="jrUpimg" id="8" default="normal"}</option>
                    <option value="left" {if $imgposg == "left" || $imgposg == ""}selected="selected"{/if} >{jrCore_lang module="jrUpimg" id="9" default="float left"}</option>
                    <option value="right" {if $imgposg == "left"}selected="selected"{/if}>{jrCore_lang module="jrUpimg" id="10" default="float right"}</option>
                    <option value="stretch" {if $imgposg == "left"}selected="selected"{/if}>{jrCore_lang module="jrUpimg" id="12" default="stretch"}</option>
                </select>

            </div>
        </div>
        <div class="col2">
            <div class="page_table_header">{jrCore_lang module="jrUpimg" id=17 default="margin"}</div>
            <div class="page_table_cell center">

                {$imgmarg = jrCore_get_cookie('imgmarg')}
                {if $imgmarg == false}
                    {$imgmarg = '0'}
                {/if}

                <select id="imgmar" class="form_select" style="width:auto" onchange="jrSetCookie('imgmarg', $(this).val());">
                    <option value="0" {if $imgmarg == "0"}selected="selected"{/if}>none</option>
                    <option value="1" {if $imgmarg == "1"}selected="selected"{/if}>1px</option>
                    <option value="2" {if $imgmarg == "2"}selected="selected"{/if}>2px</option>
                    <option value="3" {if $imgmarg == "3"}selected="selected"{/if}>3px</option>
                    <option value="4" {if $imgmarg == "4"}selected="selected"{/if}>4px</option>
                    <option value="5" {if $imgmarg == "5"}selected="selected"{/if}>5px</option>
                    <option value="6" {if $imgmarg == "6"}selected="selected"{/if}>6px</option>
                    <option value="8" {if $imgmarg == "8"}selected="selected"{/if}>8px</option>
                    <option value="10" {if $imgmarg == "10"}selected="selected"{/if}>10px</option>
                    <option value="12" {if $imgmarg == "12"}selected="selected"{/if}>12px</option>
                    <option value="15" {if $imgmarg == "15"}selected="selected"{/if}>15px</option>
                    <option value="18" {if $imgmarg == "18"}selected="selected"{/if}>18px</option>
                    <option value="20" {if $imgmarg == "20"}selected="selected"{/if}>20px</option>
                </select>

            </div>
        </div>
        <div class="col5">
            <div class="page_table_header">{jrCore_lang module="jrUpimg" id=16 default="image"}</div>
            <div class="page_table_cell center">
                <div id="pm_upimg_file" class="qq-upload-holder">
                    <noscript><p>Please enable JavaScript to use file uploader.</p></noscript>
                </div>
            </div>
        </div>

    </div>

    {if isset($_items) && is_array($_items)}
        <div class="container">
            <table class="page_table">

                <tr class="page_table_row_alt">
                    <td class="p5 center">
                        {jrCore_lang module="jrUpimg" id="18" default="Delete this uploaded image?" assign="prompt"}
                        {foreach $_items as $key => $item}
                            <div id="ui{$item._item_id}" class="p5 center" style="display:inline-block" onclick="jrUpimg_insert_image('/{$uimurl}/image/upimg_file/{$item._item_id}', '{$item.upimg_file_name|addslashes}')">
                                <div id="p{$item._item_id}" class="image_update_display">
                                    {jrCore_module_function function="jrImage_display" module="jrUpimg" type="upimg_file" item_id=$item._item_id size="medium" crop="square" alt=$item.upimg_file_name width=132 height=132 title=$item.upimg_file_name ext=$item.upimg_file_extension _v=$item.upimg_file_time}
                                    <div id="d{$item._item_id}" class="image_delete" onclick="jrCore_confirm('','{$prompt|addslashes}',function(){ jrUpimg_delete({$item._item_id})}); event.stopPropagation();">
                                        {jrCore_get_sprite_html('close', 16)}
                                    </div>
                                </div>
                                {$gtitle|truncate:20}<br>
                                <a onclick="jrEmbed_load_module('jrUpimg', 1, 'profile_url:{$item.profile_url}');">@{$item.profile_name}</a><br>
                                <small>{$item.upimg_file_width} x {$item.upimg_file_height}px</small>
                            </div>
                        {/foreach}
                    </td>
                </tr>

            </table>
        </div>
    {else}
        <div class="container">
            <table class="page_table">
                <tr class="page_table_row">
                    <td class="page_table_cell center">No previously uploaded images located</td>
                </tr>
            </table>
        </div>
    {/if}

</div>




<script type="text/javascript">
    function jrUpimg_insert_image(url, title)
    {
        var ed = top.tinymce.activeEditor, dom = ed.dom;
        var s = $('#image-size').val();
        var p = $('#imgpos').val();
        var m = $('#imgmar').val();
        if (s === '') {
            s = 'original';
        }
        switch (p) {
            case 'stretch':
                p = 'width:100%;';
                break;
            case 'left':
                p = 'float:left;';
                break;
            case 'right':
                p = 'float:right;';
                break;
            case '':
                p = '';
                break;
        }
        switch (m) {
            case 0:
                m = '';
                break;
            default:
                m = 'margin:' + m + 'px;';
                break;
        }
        ed.insertContent(dom.createHTML('img', {
            src: core_system_url + url + '/' + s,
            alt: title,
            title: title,
            border: 0,
            style: p + m
        }));
        var h = $(ed.getContainer()).height();
        if (h < s) {
            ed.theme.resizeTo('100%', s);
        }
        ed.windowManager.close();
    }

</script>