<?php
 /**
 * Jamroom Users module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: create_language_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_create_language_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);

    // Validate new_lang_code
    list($one, $two) = explode('-', $_post['new_lang_code']);
    if ((!isset($one) || strlen($one) !== 2) || (!isset($two) || strlen($two) !== 2)) {
        jrCore_set_form_notice('error', 'invalid language code - should be in xx-XX format');
        jrCore_form_field_hilight('new_lang_code');
        jrCore_form_result();
    }
    // Make sure that code does not already exist in the DB
    $cod = jrCore_db_escape($_post['new_lang_code']);
    $ltr = jrCore_db_escape($_post['new_lang_direction']);
    $tbl = jrCore_db_table_name('jrUser', 'language');
    $cln = jrCore_db_escape($_post['new_lang_clone']);
    $req = "SELECT * FROM {$tbl} WHERE lang_code = '{$cod}' LIMIT 1";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (is_array($_rt)) {

        // We already have entries for this lang code in the DB - let's get any NEW
        // lang entries that have not been setup yet and insert those.
        $req = "SELECT CONCAT_WS('-', lang_module, lang_key) AS lkey FROM {$tbl} WHERE lang_code = '{$cod}'";
        $_nl = jrCore_db_query($req, 'lkey', false, 'lkey');

        $req = "SELECT CONCAT_WS('-', lang_module, lang_key) AS lkey, lang_module, lang_code, lang_key, lang_text, lang_default FROM {$tbl} WHERE lang_code = '{$cln}'";
        $_el = jrCore_db_query($req, 'lkey');

        if (count($_nl) < count($_el)) {
            // We have a difference - figure out
            $_ins = array();
            foreach ($_el as $key => $_ls) {
                if (!isset($_nl[$key])) {
                    $_ins[] = "('" . jrCore_db_escape($_ls['lang_module']) . "','{$cod}','utf-8','{$ltr}','{$_ls['lang_key']}','" . jrCore_db_escape($_ls['lang_text']) . "','" . jrCore_db_escape($_ls['lang_default']) . "')";
                }
            }
            if (count($_ins) > 0) {
                $req = "INSERT INTO {$tbl} (lang_module,lang_code,lang_charset,lang_ltr,lang_key,lang_text,lang_default) VALUES " . implode(',', $_ins);
                $cnt = jrCore_db_query($req, 'COUNT');
                if ($cnt && $cnt > 0) {
                    jrCore_logger('INF', "user: created {$cnt} new language strings for {$_post['new_lang_code']}");
                    jrCore_set_form_notice('success', "The language was successfully updated with {$cnt} new language strings");
                    jrCore_form_delete_session();
                    jrCore_form_result();
                }
            }
        }
        if (!isset($cnt)) {
            jrCore_set_form_notice('success', 'There were no new language strings to create or update');
            jrCore_form_delete_session();
            jrCore_form_result();
        }
    }
    else {
        // copy every entry from the CLONE language into the TARGET language
        $req = "INSERT INTO {$tbl} (lang_module,lang_code,lang_charset,lang_ltr,lang_key,lang_text,lang_default) (SELECT lang_module,'{$cod}','utf-8','{$ltr}',lang_key,lang_text,lang_default FROM {$tbl} WHERE lang_code = '{$cln}')";
        jrCore_db_query($req, 'COUNT');
        jrCore_logger('INF', "user: created new user language: {$_post['new_lang_code']}");
        jrCore_set_form_notice('success', 'The new language has been successfully created');
    }
    // Redirect to edit..
    jrCore_form_delete_session();
    jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/language/lang_code={$cod}");
}
