<?php
 /**
 * Jamroom Users module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: forgot
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_forgot($_post, $_user, $_conf)
{
    // Check for maintenance mode
    if (isset($_conf['jrCore_maintenance_mode']) && $_conf['jrCore_maintenance_mode'] == 'on') {
        $_lang = jrUser_load_lang_strings();
        jrCore_set_form_notice('notice', $_lang['jrCore'][35]);
    }

    // Are we showing a template?
    if (!empty($_conf['jrUser_use_templates']) && $_conf['jrUser_use_templates'] == 'on' && (empty($_post['_1']) || ($_post['_1'] != 'widget' && $_post['_1'] != 'modal'))) {

        // Yes - we are using a TEMPLATE for login
        if ($msg = jrCore_get_form_notice(false)) {
            if (is_array($msg)) {
                $type = array_keys($msg);
                $type = reset($type);
                $text = $msg[$type];

                $_user['form_message_type'] = $type;
                $_user['form_message_text'] = $text;
            }
        }
        echo jrCore_parse_template('user_forgot.tpl', $_user, 'jrUser');

    }
    else {

        // our page banner
        jrCore_page_banner(44, null, false);

        if (isset($_post['r']) && $_post['r'] == '1' && !isset($_SESSION['jrcore_form_notices'])) {
            jrCore_set_form_notice('error', 108);
        }
        if (isset($_conf['jrUser_forgot_note']) && strlen($_conf['jrUser_forgot_note']) > 2) {
            jrCore_set_form_notice('notice', $_conf['jrUser_forgot_note'], false);
        }
        jrCore_get_form_notice();

        // Form init
        $_tmp = array(
            'submit_value'     => 46,
            'cancel'           => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/login",
            'form_ajax_submit' => false
        );
        $tok  = jrCore_form_create($_tmp);

        // User Email OR User Name
        $_tmp = array(
            'name'           => 'user_email',
            'label'          => 103,
            'help'           => 104,
            'type'           => 'text',
            'validate'       => 'not_empty',
            'autocapitalize' => 'off',
            'autocorrect'    => 'off',
            'onkeypress'     => "if (event && event.keyCode == 13 && this.value.length > 0) { jrFormSubmit('#jrUser_forgot','{$tok}','ajax'); }"
        );
        jrCore_form_field_create($_tmp);
        jrCore_page_display();
    }
}
