<?php
 /**
 * Jamroom Users module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: signup
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_signup($_post, $_user, $_conf)
{
    if (isset($_post['_1']) && strlen($_post['_1']) > 0) {
        switch ($_post['_1']) {
            case 'widget':
                jrCore_page_set_no_header_or_footer();
                break;
            case 'modal':
                jrCore_page_set_meta_header_only();
                break;
        }
    }

    // Make sure sign ups are turned on...
    if (!isset($_conf['jrUser_signup_on']) || $_conf['jrUser_signup_on'] != 'on') {
        jrCore_notice_page('error', 58);
    }

    // Check for available signup quotas
    $_opt = jrProfile_get_signup_quotas();
    if (!$_opt || !is_array($_opt) || count($_opt) === 0) {
        if (jrUser_is_admin()) {
            jrCore_notice_page('error', 'Admin: There are currently NO QUOTAS that allow signups - please check the User Account Quota Config for quotas and allow signups!');
        }
        else {
            jrCore_notice_page('error', 58);
        }
    }

    // Are we showing a template?
    if (!empty($_conf['jrUser_use_templates']) && $_conf['jrUser_use_templates'] == 'on' && (empty($_post['_1']) || ($_post['_1'] != 'widget' && $_post['_1'] != 'modal'))) {

        if ($msg = jrCore_get_form_notice(false)) {
            if (is_array($msg)) {
                $type = array_keys($msg);
                $type = reset($type);
                $text = $msg[$type];

                $_user['form_message_type'] = $type;
                $_user['form_message_text'] = $text;
            }
        }

        // Yes - we are using a TEMPLATE for login
        echo jrCore_parse_template('user_signup.tpl', $_user, 'jrUser');

    }
    else {

        // our page banner
        $_ln = jrUser_load_lang_strings();
        if (!isset($_post['_1'])) {
            $tmp = jrCore_page_button('login', $_ln['jrUser'][3], "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/login')");
            jrCore_page_banner(31, $tmp, false);
            if (isset($_conf['jrUser_signup_note']) && strlen($_conf['jrUser_signup_note']) > 2) {
                jrCore_set_form_notice('notice', $_conf['jrUser_signup_note'], false);
            }
            jrCore_get_form_notice();

            // Form init
            $_tmp = array(
                'submit_value'     => 45,
                'cancel'           => 'referrer',
                'form_ajax_submit' => false,
                'form_validate'    => false
            );
            jrCore_form_create($_tmp);
        }
        elseif ($_post['_1'] == 'widget') {

            // Form init
            $_tmp = array(
                'submit_value'     => 45,
                'cancel'           => 'referrer',
                'form_ajax_submit' => false,
                'form_validate'    => false
            );
            jrCore_form_create($_tmp);
        }
        else {
            // Form init
            $_tmp = array(
                'submit_value'  => 45,
                'cancel'        => false,
                'form_validate' => false
            );
            jrCore_form_create($_tmp);
        }

        if (isset($_post['r']) && strlen($_post['r']) > 0) {
            if (jrCore_get_memory_url($_post['r'])) {
                // Referrer
                $_tmp = array(
                    'name'  => 'r',
                    'type'  => 'hidden',
                    'value' => $_post['r']
                );
                jrCore_form_field_create($_tmp);
            }
        }

        // User Name
        $_tmp = array(
            'name'           => 'user_name',
            'label'          => 4,
            'help'           => 5,
            'type'           => 'text',
            'validate'       => 'printable',
            'ban_check'      => false,
            'required'       => true,
            'autocapitalize' => 'off',
            'autocorrect'    => 'off',
            'min'            => 1
        );
        jrCore_form_field_create($_tmp);

        // User Email
        $_tmp = array(
            'name'           => 'user_email',
            'label'          => 18,
            'help'           => 19,
            'type'           => 'text',
            'validate'       => 'email',
            'ban_check'      => false,
            'autocapitalize' => 'off',
            'autocorrect'    => 'off',
            'required'       => true
        );
        jrCore_form_field_create($_tmp);

        // Password #1
        $_tmp = array(
            'name'      => 'user_passwd1',
            'label'     => 7,
            'help'      => 8,
            'type'      => 'password',
            'error_msg' => 9,
            'validate'  => 'not_empty',
            'required'  => true
        );
        jrCore_form_field_create($_tmp);

        // Password #2
        $_tmp = array(
            'name'       => 'user_passwd2',
            'label'      => 32,
            'help'       => 23,
            'type'       => 'password',
            'error_msg'  => 9,
            'validate'   => 'not_empty',
            'required'   => true,
            'onkeypress' => "if (event && event.keyCode == 13 && this.value.length > 0) { jrFormSubmit('#jrUser_signup',false,'ajax'); }"
        );
        jrCore_form_field_create($_tmp);

        // Quota option
        $_tmp = array(
            'name'     => 'quota_id',
            'label'    => 59,
            'help'     => 60,
            'default'  => (isset($_post['quota_id']) && jrCore_checktype($_post['quota_id'], 'number_nz') && isset($_opt["{$_post['quota_id']}"])) ? $_post['quota_id'] : $_conf['jrProfile_default_quota_id'],
            'type'     => 'select',
            'options'  => 'jrProfile_get_signup_quotas',
            'validate' => 'number_nz'
        );
        jrCore_form_field_create($_tmp);

        // Spam Bot Check
        // TODO: this should not be checking number of rows
        if (jrCore_db_get_ds_row_count('jrUser') > 0) {
            $_tmp = array(
                'name'      => 'user_is_human',
                'label'     => 90,
                'help'      => 91,
                'type'      => 'checkbox_spambot',
                'error_msg' => 92,
                'validate'  => 'onoff'
            );
            jrCore_form_field_create($_tmp);
        }
        jrCore_page_display();
    }
}
