
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `jamroom702`
--

-- --------------------------------------------------------

--
-- Table structure for table `jr_jraction_hash_tag`
--

CREATE TABLE `jr_jraction_hash_tag` (
  `hash_item_id` int(11) unsigned NOT NULL DEFAULT '0',
  `hash_text` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `hash_time` int(11) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `hash_unique` (`hash_item_id`,`hash_text`),
  KEY `hash_text` (`hash_text`),
  KEY `hash_time` (`hash_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jraction_item`
--

CREATE TABLE `jr_jraction_item` (
  `_item_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jraction_item_key`
--

CREATE TABLE `jr_jraction_item_key` (
  `_item_id` int(11) unsigned NOT NULL DEFAULT '0',
  `_profile_id` int(11) unsigned NOT NULL DEFAULT '0',
  `key` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `index` smallint(5) unsigned NOT NULL DEFAULT '0',
  `value` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`key`,`_item_id`,`index`),
  KEY `_item_id` (`_item_id`),
  KEY `_profile_id` (`_profile_id`),
  KEY `value` (`value`(128))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jraction_share`
--

CREATE TABLE `jr_jraction_share` (
  `share_user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `share_module` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `share_item_id` int(11) unsigned NOT NULL DEFAULT '0',
  `share_time` int(11) unsigned NOT NULL DEFAULT '0',
  `share_action_id` int(11) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `share_unique` (`share_user_id`,`share_module`,`share_item_id`),
  KEY `share_module` (`share_module`),
  KEY `share_item_id` (`share_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrbanned_banned`
--

CREATE TABLE `jr_jrbanned_banned` (
  `ban_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ban_updated` int(10) unsigned NOT NULL DEFAULT '0',
  `ban_type` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ban_value` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ban_note` varchar(4096) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ban_partial` varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'off',
  PRIMARY KEY (`ban_id`),
  UNIQUE KEY `ban_key` (`ban_type`,`ban_value`),
  KEY `ban_value` (`ban_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrblog_item`
--

CREATE TABLE `jr_jrblog_item` (
  `_item_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`_item_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `jr_jrblog_item`
--

INSERT INTO `jr_jrblog_item` VALUES
(1);

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrblog_item_key`
--

CREATE TABLE `jr_jrblog_item_key` (
  `_item_id` int(11) unsigned NOT NULL DEFAULT '0',
  `_profile_id` int(11) unsigned NOT NULL DEFAULT '0',
  `key` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `index` smallint(5) unsigned NOT NULL DEFAULT '0',
  `value` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`key`,`_item_id`,`index`),
  KEY `_item_id` (`_item_id`),
  KEY `_profile_id` (`_profile_id`),
  KEY `value` (`value`(128))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `jr_jrblog_item_key`
--

INSERT INTO `jr_jrblog_item_key` VALUES
(1, 1, '_created', 0, '[[timestamp]]'),
(1, 1, '_profile_id', 0, '1'),
(1, 1, '_updated', 0, '[[timestamp]]'),
(1, 1, '_user_id', 0, '1'),
(1, 1, 'blog_category', 0, 'welcome'),
(1, 1, 'blog_category_url', 0, 'welcome'),
(1, 1, 'blog_display_order', 0, '0'),
(1, 1, 'blog_pending', 0, '0'),
(1, 1, 'blog_publish_date', 0, '[[timestamp]]'),
(1, 1, 'blog_readmore', 0, '0'),
(1, 1, 'blog_text', 1, '\n    Thank you for installing Jamroom!\n\n    Jamroom is an easy to use, and easy to customize CMS that centers around <b>User Profiles</b>.  With excellent media support, thousands of sites have been using Jamroom to power their social media needs for over 13 years.\n\n    When logged in to your new site, click on the &quot;Tour&quot; tabs available in many of the modules - these small tips and tours will help you quickly get up to speed on how Jamroom works and how it can be customized to suit your needs.'),
(1, 1, 'blog_text', 2, '\n\n    Make sure and join us on Jamroom.net:\n\n    https://www.jamroom.net\n\n    and let us know how you''re using Jamroom - we love getting feedback on how we can make Jamroom better.\n\n    Thanks again for installing Jamroom - we hope you enjoy using it and hope to see you online!\n\n    - The Jamroom Team\n'),
(1, 1, 'blog_title', 0, 'Welcome to Jamroom'),
(1, 1, 'blog_title_url', 0, 'welcome-to-jamroom');

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_archive_date`
--

CREATE TABLE `jr_jrcore_archive_date` (
  `archive_table` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `archive_date` int(8) unsigned NOT NULL DEFAULT '0',
  `archive_min` int(11) unsigned NOT NULL DEFAULT '0',
  `archive_max` int(11) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `archive_unique` (`archive_table`,`archive_date`),
  KEY `archive_date` (`archive_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_cache_profile_id`
--

CREATE TABLE `jr_jrcore_cache_profile_id` (
  `cache_key` char(32) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `cache_profile_id` int(11) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `cache_unique` (`cache_key`,`cache_profile_id`),
  KEY `cache_profile_id` (`cache_profile_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `jr_jrcore_cache_profile_id`
--

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_cache_value`
--

CREATE TABLE `jr_jrcore_cache_value` (
  `cache_key` char(32) CHARACTER SET latin1 NOT NULL,
  `cache_expires` int(11) unsigned NOT NULL DEFAULT '0',
  `cache_module` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `cache_user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `cache_encoded` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `cache_value` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`cache_key`),
  KEY `cache_expires` (`cache_expires`),
  KEY `cache_module` (`cache_module`),
  KEY `cache_user_id` (`cache_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `jr_jrcore_cache_value`
--

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_count_ip`
--

CREATE TABLE `jr_jrcore_count_ip` (
  `count_ip` int(11) unsigned NOT NULL DEFAULT '0',
  `count_uid` int(11) unsigned NOT NULL DEFAULT '0',
  `count_user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `count_name` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `count_time` int(11) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `count_hit` (`count_ip`,`count_uid`,`count_user_id`,`count_name`),
  KEY `count_user_id` (`count_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_emoji`
--

CREATE TABLE `jr_jrcore_emoji` (
  `emoji_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `emoji_value` varbinary(16) NOT NULL,
  PRIMARY KEY (`emoji_id`),
  UNIQUE KEY `emoji_value` (`emoji_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_form`
--

CREATE TABLE `jr_jrcore_form` (
  `module` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `view` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `active` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `locked` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `created` int(11) unsigned NOT NULL DEFAULT '0',
  `updated` int(11) unsigned NOT NULL DEFAULT '0',
  `default` varchar(4096) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'text',
  `validate` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `min` int(11) unsigned NOT NULL DEFAULT '0',
  `max` int(11) unsigned NOT NULL DEFAULT '0',
  `options` varchar(8192) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `group` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'user',
  `label` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sublabel` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `help` varchar(4096) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `section` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `order` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`module`,`view`,`name`),
  KEY `order` (`order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_form_session`
--

CREATE TABLE `jr_jrcore_form_session` (
  `form_token` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `form_created` int(11) unsigned NOT NULL DEFAULT '0',
  `form_updated` int(11) unsigned NOT NULL DEFAULT '0',
  `form_rand` int(11) unsigned NOT NULL DEFAULT '0',
  `form_user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `form_view` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `form_validated` tinyint(1) NOT NULL DEFAULT '0',
  `form_params` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `form_fields` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `form_saved` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`form_token`),
  KEY `form_created` (`form_created`),
  KEY `form_view` (`form_view`),
  KEY `form_user_id` (`form_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `jr_jrcore_form_session`
--

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_form_session_meta`
--

CREATE TABLE `jr_jrcore_form_session_meta` (
  `meta_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `meta_token` char(32) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `meta_field` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `meta_data` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`meta_id`),
  UNIQUE KEY `meta_unique` (`meta_token`,`meta_field`),
  KEY `meta_field` (`meta_field`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_global_lock`
--

CREATE TABLE `jr_jrcore_global_lock` (
  `lock_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `lock_unique` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `lock_expires` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lock_id`),
  UNIQUE KEY `lock_unique` (`lock_unique`),
  KEY `lock_expires` (`lock_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_item`
--

CREATE TABLE `jr_jrcore_item` (
  `_item_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_item_key`
--

CREATE TABLE `jr_jrcore_item_key` (
  `_item_id` int(11) unsigned NOT NULL DEFAULT '0',
  `_profile_id` int(11) unsigned NOT NULL DEFAULT '0',
  `key` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `index` smallint(5) unsigned NOT NULL DEFAULT '0',
  `value` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`key`,`_item_id`,`index`),
  KEY `_item_id` (`_item_id`),
  KEY `_profile_id` (`_profile_id`),
  KEY `value` (`value`(128))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_log`
--

CREATE TABLE `jr_jrcore_log` (
  `log_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `log_created` int(11) unsigned NOT NULL DEFAULT '0',
  `log_priority` char(3) CHARACTER SET latin1 NOT NULL DEFAULT 'inf',
  `log_ip` varchar(45) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `log_text` varchar(4096) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`log_id`),
  KEY `log_created` (`log_created`),
  KEY `log_priority` (`log_priority`),
  KEY `log_ip` (`log_ip`),
  FULLTEXT KEY `log_text` (`log_text`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `jr_jrcore_log`
--
-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_log_debug`
--

CREATE TABLE `jr_jrcore_log_debug` (
  `log_log_id` int(11) unsigned NOT NULL DEFAULT '0',
  `log_url` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `log_memory` bigint(20) unsigned NOT NULL DEFAULT '0',
  `log_data` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  UNIQUE KEY `log_log_id` (`log_log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_log_debug_data`
--

CREATE TABLE `jr_jrcore_log_debug_data` (
  `log_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `log_log_id` int(11) unsigned NOT NULL DEFAULT '0',
  `log_created` int(11) unsigned NOT NULL DEFAULT '0',
  `log_url` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `log_memory` bigint(20) unsigned NOT NULL DEFAULT '0',
  `log_data` blob NOT NULL,
  PRIMARY KEY (`log_id`),
  UNIQUE KEY `log_log_id` (`log_log_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `jr_jrcore_log_debug_data`
--

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_menu`
--

CREATE TABLE `jr_jrcore_menu` (
  `menu_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `menu_module` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'jrCore',
  `menu_unique` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `menu_active` varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'off',
  `menu_label` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `menu_category` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'user',
  `menu_action` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `menu_groups` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `menu_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `menu_function` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `menu_onclick` varchar(1024) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `menu_field` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`menu_id`),
  UNIQUE KEY `menu_unique` (`menu_module`,`menu_category`,`menu_action`),
  KEY `menu_category` (`menu_category`),
  KEY `menu_active` (`menu_active`),
  KEY `menu_order` (`menu_order`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `jr_jrcore_menu`
--

INSERT INTO `jr_jrcore_menu` VALUES
(1, 'jrUser', 'account', 'on', '116', 'user', 'account', 'user', 101, '', '', ''),
(2, 'jrUser', 'logout', 'on', '117', 'user', 'logout', 'user', 101, '', 'jrUser_logout()', ''),
(3, 'jrFollower', 'following', 'on', '37', 'user', 'following', 'user', 101, '', '', ''),
(4, 'jrProfile', 'profile_manage', 'on', '25', 'user', 'list_profiles', 'power,multi', 101, 'jrProfile_more_than_one_linked_profile', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_modal`
--

CREATE TABLE `jr_jrcore_modal` (
  `modal_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `modal_updated` int(11) unsigned NOT NULL DEFAULT '0',
  `modal_key` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `modal_value` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`modal_id`),
  KEY `modal_key` (`modal_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_module`
--

CREATE TABLE `jr_jrcore_module` (
  `module_id` mediumint(7) unsigned NOT NULL AUTO_INCREMENT,
  `module_created` int(11) unsigned NOT NULL DEFAULT '0',
  `module_updated` int(11) unsigned NOT NULL DEFAULT '0',
  `module_priority` tinyint(3) unsigned NOT NULL DEFAULT '100',
  `module_directory` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `module_url` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `module_version` varchar(12) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `module_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `module_prefix` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `module_description` varchar(1024) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `module_category` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `module_developer` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `module_active` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `module_locked` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `module_requires` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `module_system_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `module_license` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`module_id`),
  KEY `module_priority` (`module_priority`),
  KEY `module_directory` (`module_directory`),
  KEY `module_url` (`module_url`),
  KEY `module_category` (`module_category`),
  KEY `module_active` (`module_active`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=30 ;

--
-- Dumping data for table `jr_jrcore_module`
--

INSERT INTO `jr_jrcore_module` VALUES
(1, [[timestamp]], [[timestamp]], 0, 'jrCore', 'core', '7.0.2', 'System Core', 'core', 'Provides low level functionality for all system operations', 'core', 'The Jamroom Network, &copy;2025', 1, 1, '', 0, ''),
(2, [[timestamp]], [[timestamp]], 250, 'jrAction', 'timeline', '2.5.5', 'Timeline', 'action', 'Users can enter updates and log activity to their Timeline', 'profiles', 'The Jamroom Network, &copy;2025', 1, 0, 'jrCore:6.5.12,jrImage:2.6.0b1', 0, ''),
(3, [[timestamp]], [[timestamp]], 3, 'jrBanned', 'banned', '1.6.2', 'Banned Items', '', 'Create, Update and Delete Banned names, words, email and IP addresses', 'admin', 'The Jamroom Network, &copy;2025', 1, 0, 'jrCore:6.5.12', 0, ''),
(4, [[timestamp]], [[timestamp]], 100, 'jrBlog', 'blog', '1.1.21', 'Blog', 'blog', 'Add blogging capabilities to profiles', 'profiles', 'The Jamroom Network, &copy;2025', 1, 0, '', 0, ''),
(5, [[timestamp]], [[timestamp]], 100, 'jrDeveloper', 'developer', '2.0.9', 'Developer Tools', 'log', 'Developer tools for working with modules and skins', 'developer', 'The Jamroom Network, &copy;2025', 1, 0, 'jrCore:6.5.12', 0, ''),
(6, [[timestamp]], [[timestamp]], 100, 'jrDisqus', 'disqus', '1.1.0', 'Disqus Comments', '', 'Add Disqus Users Comments to item detail pages', 'item features', 'The Jamroom Network, &copy;2025', 1, 0, '', 0, ''),
(7, [[timestamp]], [[timestamp]], 200, 'jrEmbed', 'embed', '1.5.1', 'Editor Embedded Media', '', 'Adds an embed button to the WYSIWYG editor for embedding items', 'forms', 'The Jamroom Network, &copy;2025', 1, 0, 'jrCore:6.4.0b2', 0, ''),
(8, [[timestamp]], [[timestamp]], 100, 'jrFavicon', 'favicon', '1.2.0', 'Favicon Creator', 'icon', 'Create a site Favicon that supports multiple resolutions including High DPI displays', 'site', 'The Jamroom Network, &copy;2025', 1, 0, 'jrCore:6.5.0b6', 0, ''),
(9, [[timestamp]], [[timestamp]], 100, 'jrFollower', 'follow', '2.1.8', 'Followers', '', 'Users can &quot;follow&quot; other users Profiles', 'profiles', 'The Jamroom Network, &copy;2025', 1, 0, 'jrCore:6.5.0', 0, ''),
(10, [[timestamp]], [[timestamp]], 100, 'jrGeo', 'geo', '2.3.1', 'Geo Location', '', 'Adds Geo Location tools and functionality to the system', 'tools', 'The Jamroom Network, &copy;2025', 1, 0, '', 0, ''),
(11, [[timestamp]], [[timestamp]], 10, 'jrGraph', 'graph', '1.2.2', 'Graph Support', '', 'Support for creating and displaying line, point and bar graphs', 'core', 'The Jamroom Network, &copy;2025', 1, 0, '', 0, ''),
(12, [[timestamp]], [[timestamp]], 100, 'jrGravatar', 'gravatar', '1.2.2', 'Gravatar Images', '', 'Add support for Gravatar images - used if a user has not uploaded a User or Profile Image.', 'site', 'The Jamroom Network, &copy;2025', 1, 0, 'jrCore:6.1.0b1,jrImage:2.0.0b1', 0, ''),
(13, [[timestamp]], [[timestamp]], 5, 'jrImage', 'image', '2.7.2', 'Image Support', 'image', 'Core support for displaying, resizing and manipulating images', 'core', 'The Jamroom Network, &copy;2025', 1, 1, 'jrCore:7.0.0b3,jrSystemTools:1.0.1', 0, ''),
(14, [[timestamp]], [[timestamp]], 1, 'jrMailer', 'mailer', '2.5.1', 'Email Support', '', 'Core support for Sending Email via an SMTP Server', 'communication', 'The Jamroom Network, &copy;2025', 1, 1, 'jrCore:7.0.0b1', 0, ''),
(15, [[timestamp]], [[timestamp]], 100, 'jrMarket', 'marketplace', '1.7.4', 'Marketplace', '', 'Browse, Install and Update modules and skins from the Marketplace', 'core', 'The Jamroom Network, &copy;2025', 1, 0, 'jrCore:6.5.12', 0, ''),
(16, [[timestamp]], [[timestamp]], 100, 'jrMeta', 'metatag', '1.1.4', 'Meta Tag Manager', '', 'Create and insert Meta Tags into site and profile pages', 'tools', 'The Jamroom Network, &copy;2025', 1, 0, '', 0, ''),
(17, [[timestamp]], [[timestamp]], 100, 'jrPage', 'page', '1.1.16', 'Page Creator', 'page', 'Create new pages for your site', 'admin', 'The Jamroom Network, &copy;2025', 1, 0, 'jrCore:6.5.0', 0, ''),
(18, [[timestamp]], [[timestamp]], 200, 'jrProfile', 'profile', '2.0.1', 'Profiles', 'profile', 'Core support for Profiles and Profile Quotas', 'profiles', 'The Jamroom Network, &copy;2025', 1, 1, 'jrCore:6.5.12,jrUser:2.6.0', 0, ''),
(19, [[timestamp]], [[timestamp]], 100, 'jrSearch', 'search', '2.3.1', 'Search', 'search', 'Site Wide Search plus search system for registered modules', 'listing', 'The Jamroom Network, &copy;2025', 1, 0, 'jrCore:5.3.0', 0, ''),
(20, [[timestamp]], [[timestamp]], 5, 'jrSiteBuilder', 'sbcore', '2.4.2', 'Site Builder', '', 'Site Builder Core provides support for all Site Builder functions', 'site', 'The Jamroom Network, &copy;2025', 1, 0, 'jrCore:6.4.1b3', 0, ''),
(21, [[timestamp]], [[timestamp]], 100, 'jrSitemap', 'sitemap', '1.2.0', 'Sitemap Generator', '', 'Create and maintain an XML Sitemap used by search engines', 'tools', 'The Jamroom Network, &copy;2025', 1, 0, 'jrCore:6.5.12', 0, ''),
(22, [[timestamp]], [[timestamp]], 100, 'jrStrongPassword', 'strongpassword', '1.0.6', 'Strong Password', '', 'Enforce a strong password during account creation and password changes', 'users', 'The Jamroom Network, &copy;2025', 1, 0, '', 0, ''),
(23, [[timestamp]], [[timestamp]], 100, 'jrSupport', 'support', '1.1.4', 'Support Center', '', 'Documentation, Support and Help for modules and skins in your system', 'core', 'The Jamroom Network, &copy;2025', 1, 0, 'jrCore:6.5.12', 0, ''),
(24, [[timestamp]], [[timestamp]], 100, 'jrSystemTools', 'systemtools', '2.0.1', 'System Tools', '', 'Provides low level command line tools used by modules', 'core', 'The Jamroom Network, &copy;2025', 1, 1, 'jrCore:6.5.12', 0, ''),
(25, [[timestamp]], [[timestamp]], 100, 'jrTips', 'tips', '2.0.1', 'System Tips', '', 'Provides hover tips functionality for all modules', 'core', 'The Jamroom Network, &copy;2025', 1, 0, 'jrCore:6.0.0', 0, ''),
(26, [[timestamp]], [[timestamp]], 100, 'jrTOS', 'quotatos', '1.2.0', 'Terms of Service', '', 'Adds Terms of Service display and acknowledgement for configured Quotas', 'users', 'The Jamroom Network, &copy;2025', 1, 0, '', 0, ''),
(27, [[timestamp]], [[timestamp]], 50, 'jrTwoFactor', 'twofactor', '2.0.0', '2 Factor Authentication', '', 'Enable 2 factor email authentication in user accounts', 'users', 'The Jamroom Network, &copy;2025', 1, 0, 'jrCore:6.5.12', 0, ''),
(28, [[timestamp]], [[timestamp]], 100, 'jrUpimg', 'upimg', '1.5.0', 'Editor Image Upload', 'upimg', 'Adds an image upload tool to the Embedded Media module in the editor', 'forms', 'The Jamroom Network, &copy;2025', 1, 0, 'jrCore:7.0.0b3,jrEmbed,jrImage:2.3.0b1', 0, ''),
(29, [[timestamp]], [[timestamp]], 5, 'jrUser', 'user', '3.0.2', 'Users', 'user', 'Core support for User Accounts, Sessions and Languages', 'users', 'The Jamroom Network, &copy;2025', 1, 1, 'jrCore:6.5.12', 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_pending`
--

CREATE TABLE `jr_jrcore_pending` (
  `pending_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pending_created` int(11) unsigned NOT NULL DEFAULT '0',
  `pending_module` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `pending_profile_id` int(11) unsigned NOT NULL DEFAULT '0',
  `pending_user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `pending_item_id` int(11) unsigned NOT NULL DEFAULT '0',
  `pending_linked_item_module` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `pending_linked_item_id` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`pending_id`),
  UNIQUE KEY `pending_unique` (`pending_module`,`pending_item_id`),
  KEY `pending_profile_id` (`pending_user_id`),
  KEY `pending_user_id` (`pending_user_id`),
  KEY `pending_item_id` (`pending_item_id`),
  KEY `pending_linked_item_module` (`pending_linked_item_module`),
  KEY `pending_linked_item_id` (`pending_linked_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_pending_reason`
--

CREATE TABLE `jr_jrcore_pending_reason` (
  `reason_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `reason_key` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `reason_text` varchar(1024) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`reason_id`),
  UNIQUE KEY `reason_key` (`reason_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_performance`
--

CREATE TABLE `jr_jrcore_performance` (
  `p_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `p_time` int(10) unsigned NOT NULL DEFAULT '0',
  `p_val` varchar(1024) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `p_provider` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `p_comment` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `p_price` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `p_rating` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `p_type` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`p_id`),
  KEY `p_time` (`p_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_queue`
--

CREATE TABLE `jr_jrcore_queue` (
  `queue_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue_name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `queue_system_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `queue_created` int(10) unsigned NOT NULL DEFAULT '0',
  `queue_module` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `queue_worker` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `queue_started` int(10) unsigned NOT NULL DEFAULT '0',
  `queue_expires` int(10) unsigned NOT NULL DEFAULT '0',
  `queue_sleep` int(10) unsigned NOT NULL DEFAULT '0',
  `queue_count` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`queue_id`),
  KEY `queue_name` (`queue_name`),
  KEY `queue_system_id` (`queue_system_id`),
  KEY `queue_created` (`queue_created`),
  KEY `queue_module` (`queue_module`),
  KEY `queue_worker` (`queue_worker`),
  KEY `queue_started` (`queue_started`),
  KEY `queue_expires` (`queue_expires`),
  KEY `queue_sleep` (`queue_sleep`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `jr_jrcore_queue`
--

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_queue_data`
--

CREATE TABLE `jr_jrcore_queue_data` (
  `queue_id` bigint(20) unsigned NOT NULL,
  `queue_item_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `queue_data` longtext COLLATE utf8_unicode_ci NOT NULL,
  `queue_status` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `queue_note` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`queue_id`),
  KEY `queue_item_id` (`queue_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `jr_jrcore_queue_data`
--

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_queue_info`
--

CREATE TABLE `jr_jrcore_queue_info` (
  `queue_name` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `queue_workers` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `queue_depth` int(11) unsigned NOT NULL DEFAULT '0',
  `queue_status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  UNIQUE KEY `queue_name` (`queue_name`),
  KEY `queue_workers` (`queue_workers`),
  KEY `queue_depth` (`queue_depth`),
  KEY `queue_status` (`queue_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `jr_jrcore_queue_info`
--

INSERT INTO `jr_jrcore_queue_info` VALUES
('jrCore_daily_maintenance', 0, 1, 1),
('jrCore_hourly_maintenance', 0, 1, 1),
('jrCore_send_email', 0, 0, 1),
('jrCore_ten_minute_maintenance', 0, 0, 1),
('jrCore_update_ds_counts', 0, 0, 1),
('jrMailer_process_stats', 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_recycle`
--

CREATE TABLE `jr_jrcore_recycle` (
  `r_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `r_group_id` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `r_time` int(11) unsigned NOT NULL DEFAULT '0',
  `r_module` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `r_table` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `r_profile_id` int(11) unsigned NOT NULL DEFAULT '0',
  `r_item_id` int(11) unsigned NOT NULL DEFAULT '0',
  `r_title` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `r_data` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`r_id`),
  UNIQUE KEY `r_unique` (`r_module`,`r_table`,`r_item_id`),
  KEY `r_group_id` (`r_group_id`),
  KEY `r_profile_id` (`r_profile_id`),
  KEY `r_item_id` (`r_item_id`),
  KEY `r_title` (`r_title`),
  KEY `r_time` (`r_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_setting`
--

CREATE TABLE `jr_jrcore_setting` (
  `module` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `created` int(11) unsigned NOT NULL DEFAULT '0',
  `updated` int(11) unsigned NOT NULL DEFAULT '0',
  `value` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `default` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'text',
  `validate` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `required` varchar(8) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'off',
  `min` int(11) unsigned NOT NULL DEFAULT '0',
  `max` int(11) unsigned NOT NULL DEFAULT '0',
  `options` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `user` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sublabel` varchar(256) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `help` varchar(4096) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `section` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `order` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`module`,`name`),
  KEY `type` (`type`),
  KEY `order` (`order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `jr_jrcore_setting`
--

INSERT INTO `jr_jrcore_setting` VALUES
('jrAction', 'check_modules', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'only active modules', '', 'Check this option to add an additional check that ensures Timeline Entries only appear for modules that are currently Active.  For large and active systems it is recommended to uncheck this option as it adds query overhead that can slow down the Timeline display.', '', 4),
('jrAction', 'delete_with_item', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'delete timeline entries', '', 'If this option is checked, when an item is deleted that has associated created and updated Timeline entries, the Timeline entries will be deleted as well.', '', 5),
('jrAction', 'editor', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'enable editor', '', 'Check this option to enable the WYSIWYG editor for the &quot;Post a new Activity Update&quot; form field', '', 2),
('jrAction', 'max_length', [[timestamp]], [[timestamp]], '140', '140', 'text', 'number_nz', 'off', 100, 256000, '', 'installer', 'Max Update Length', '', 'What is the maximum length of text allowed (in characters) in a Timeline Update?', '', 1),
('jrAction', 'prune', [[timestamp]], [[timestamp]], '0', '0', 'select', 'number_nn', 'on', 0, 0, 'jrAction_get_prune_days', 'installer', 'prune system entries', '', 'Enabling the Prune System Entries option will delete any system generated (i.e. created an item, updated an item, etc.) Timeline entries, as well as Hash Tag search history, after the number of days specified.<br><br><b>NOTE:</b> Timeline entries that are manually created by users are never deleted.', '', 3),
('jrAction', 'quick_share', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'enable quick share', '', 'Check this option to enable the Quick Share options in a Profile timeline.', 'Quick Share', 1),
('jrBanned', 'auto_block', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'enable blocking', '', 'If this option is enabled the system will automatically reject requests from Scanners and User Agent strings configured in the lists below.', '', 2),
('jrBanned', 'auto_block_agents', [[timestamp]], [[timestamp]], 'masscan\njorgee\nnikto\nzmeu\nnmap.org\nbxss.me', 'masscan\njorgee\nnikto\nzmeu\nnmap.org\nbxss.me', 'textarea', 'false', 'off', 0, 0, '', 'installer', 'blocked user agents', '', 'Enter strings, 1 per line, that if found in the viewing User Agent will be blocked.', '', 6),
('jrBanned', 'auto_block_ban', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'auto ban blocked requests', '', 'If this option is enabled, when a site request is <b>Blocked</b>, the IP address of the user will be automatically added as a Banned User IP.<br><br><b>Note:</b> Admin users are never blocked.', '', 4),
('jrBanned', 'auto_block_strings', [[timestamp]], [[timestamp]], '/../\n.git/\n.env\nbxss.me\n.chr(\n.concat(\n.gethostbyname(\n(nslookup\n__import__\n/webdav\n/wp-login.php\n/wp-admin.php\n/wp-admins.php\n/wp-config.php\n/eval-stdin.php\n/wp-includes\n/wp-content\n/xmlrpc.php\n/azenv.php\n/webadmin.php\n/dbadmin\n/myadmin\n/pma\n/mysqlmanager\n/mysql-admin\n/webconfig\n/sqlmanager\nTP/public\n/cgi-bin\n/cgi-perl\n/cgi-exe\n%20union%20select', '/../\n.git/\n.env\nbxss.me\n.chr(\n.concat(\n.gethostbyname(\n(nslookup\n__import__\n/webdav\n/wp-login.php\n/wp-admin.php\n/wp-admins.php\n/wp-config.php\n/eval-stdin.php\n/wp-includes\n/wp-content\n/xmlrpc.php\n/azenv.php\n/webadmin.php\n/dbadmin\n/myadmin\n/pma\n/mysqlmanager\n/mysql-admin\n/webconfig\n/sqlmanager\nTP/public\n/cgi-bin\n/cgi-perl\n/cgi-exe\n%20union%20select', 'textarea', 'false', 'off', 0, 0, '', 'installer', 'blocked URL strings', '', 'Enter URL keywords, 1 per line, that if found in a URL will be blocked.', '', 5),
('jrBanned', 'form_scan', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'enable in forms', '', 'If this option is enabled, when a form is submitted by a non-admin user, any "name" and "title" fields in the form will be scanned for banned words.', '', 1),
('jrBanned', 'log_block', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'log blocked requests', '', 'If this option is enabled an activity log entry will be created when a site request is blocked', '', 3),
('jrBlog', 'pagination', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'Enable Pagination', '', 'When viewing a Blog post on a profile, embedded pagebreaks are turned into separate pages. Unchecking this option will show the entire blog post on a single page. Uncheck if you want to use the pagebreak marker to define the teaser section shown in site lists only.', '', 1),
('jrCore', 'active_cache_system', [[timestamp]], [[timestamp]], 'jrCore_mysql', 'jrCore_mysql', 'hidden', 'not_empty', 'on', 0, 0, '', 'installer', 'active data cache', '', 'this hidden field holds the name of the active caching sub system - do not modify by hand', '', 1),
('jrCore', 'active_datastore_system', [[timestamp]], [[timestamp]], 'jrCore', 'jrCore', 'hidden', 'not_empty', 'on', 0, 0, '', 'installer', 'active datastore system', '', 'this hidden field holds the name of the active DataStore sub system - do not modify by hand', '', 1),
('jrCore', 'active_media_system', [[timestamp]], [[timestamp]], 'jrCore_local', 'jrCore_local', 'select', 'core_string', 'on', 0, 0, 'jrCore_get_media_system_plugins', 'installer', 'active media system', '', 'What Media system should be the active system for storing profile media items (images, audio, video, files, etc.)?', 'content', 35),
('jrCore', 'active_skin', [[timestamp]], [[timestamp]], 'jrElastic2', 'jrElastic2', 'hidden', 'not_empty', 'on', 0, 0, '', 'installer', 'active skin', '', 'this hidden field keeps track of the Active Skin.', '', 1),
('jrCore', 'dashboard_config', [[timestamp]], [[timestamp]], '', '', 'hidden', 'printable', 'on', 0, 0, '', 'installer', 'dashboard config', '', 'this hidden field holds config options for the Dashboard - do not modify', '', 1),
('jrCore', 'date_format', [[timestamp]], [[timestamp]], 'm/d/y', 'm/d/y', 'select', '', 'on', 0, 0, '{"m\\/d\\/y":"mm\\/dd\\/yy","d\\/m\\/y":"dd\\/mm\\/yy","d M Y":"dd mmm yyyy"}', 'installer', 'date format', '', 'Select the Date Format to use for dates.', 'date and time', 12),
('jrCore', 'default_cache_seconds', [[timestamp]], [[timestamp]], '300', '300', 'text', 'number_nn', 'on', 0, 86400, '', 'installer', 'cache seconds', '', 'Cached items will be cached for the number of seconds entered here. Set to "0" (zero) to disable template caching.<br><br><b>NOTE:</b> It is <b>highly recommended</b> that caching is enabled on a live system - disabling caching will have a significant performance impact.', 'caching', 10),
('jrCore', 'detail_feature_order', [[timestamp]], [[timestamp]], '', '', 'hidden', 'printable', 'on', 0, 0, '', 'installer', 'detail feature order', '', 'this hidden field keeps track of the module detail feature order - do not modify or remove', '', 1),
('jrCore', 'ds_row_counts', [[timestamp]], [[timestamp]], '', '', 'hidden', 'printable', 'on', 0, 0, '', 'installer', 'DS pager limit tables', '', 'this hidden field keeps track of DataStore row counts - do not modify by hand.', '', 1),
('jrCore', 'enabled', [[timestamp]], [[timestamp]], 'cri,maj,min,inf', 'cri,maj,min,inf', 'optionlist', '', 'off', 0, 0, '{"cri":"<span class=\\"log-cri\\" style=\\"font-family:monospace;padding:0 2px\\"><b>CRI<\\/b><\\/span> Critical","maj":"<span class=\\"log-maj\\" style=\\"font-family:monospace;padding:0 2px\\"><b>MAJ<\\/b><\\/span> Major","min":"<span class=\\"log-min\\" style=\\"font-family:monospace;padding:0 2px\\"><b>MIN<\\/b><\\/span> Minor","inf":"<span class=\\"log-inf\\" style=\\"font-family:monospace;padding:0 2px\\"><b>INF<\\/b><\\/span> Informational","dbg":"<span class=\\"log-dbg\\" style=\\"font-family:monospace;padding:0 2px\\"><b>DBG<\\/b><\\/span> Developer \\/ Debug"}', 'installer', 'log priorities', 'unchecked are discarded', 'Select the Priority of Log Messages that will be stored in the Activity Log.  If a priority is NOT checked, messages of that type will be discarded.', 'activity log', 20),
('jrCore', 'hour_format', [[timestamp]], [[timestamp]], 'h:i:sA', 'h:i:sA', 'select', '', 'on', 0, 0, '{"h:i:sA":"12 hour format (with AM\\/PM)","H:i:s":"24 hour format"}', 'installer', 'hour format', '', 'This option allows you to define how Hours of the Day will be displayed.', 'date and time', 11),
('jrCore', 'index_keys', [[timestamp]], [[timestamp]], '', '', 'hidden', 'printable', 'on', 0, 0, '', 'installer', 'DS index key tables', '', 'this hidden field keeps track of dedicated DS index tables - do not modify by hand.', '', 1),
('jrCore', 'jrElastic2_css_version', [[timestamp]], [[timestamp]], '57692607718e549a322d71e215ee38e2', '57692607718e549a322d71e215ee38e2', 'hidden', 'md5', 'off', 0, 0, '', 'installer', '', '', '', '', 1),
('jrCore', 'jrElastic2_javascript_version', [[timestamp]], [[timestamp]], 'e398571838053c38aa308609e563bc40', 'e398571838053c38aa308609e563bc40', 'hidden', 'md5', 'off', 0, 0, '', 'installer', '', '', '', '', 1),
('jrCore', 'last_daily_maint_run', [[timestamp]], [[timestamp]], '[[last_daily_maint_run]]', '0', 'hidden', 'number_nn', 'on', 20120801, 20991231, '', 'installer', 'last daily maintenance run', '', 'this hidden field keeps track of the last time the daily maintenance was run - do not modify by hand.', '', 1),
('jrCore', 'last_hourly_maint_run', [[timestamp]], [[timestamp]], '[[last_hourly_maint_run]]', '0', 'hidden', 'number_nn', 'on', 2012080101, 2099123123, '', 'installer', 'last hourly maintenance run', '', 'this hidden field keeps track of the last time the hourly maintenance was run - do not modify by hand.', '', 1),
('jrCore', 'last_ten_min_maint_run', [[timestamp]], [[timestamp]], '[[timestamp]]', '0', 'hidden', 'number_nn', 'on', 0, 0, '', 'installer', 'last ten minute maintenance run', '', 'this hidden field keeps track of the last time the ten minute maintenance was run - do not modify by hand.', '', 1),
('jrCore', 'log_404', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'log 404 not found', '', 'Check this option to enable logging of 404 not found pages to the Activity Log.', 'activity log', 22),
('jrCore', 'maintenance_mode', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'maintenance mode', '', 'Enabling this option will place your system in Maintenance Mode.  While in maintenance mode, only admin users will be able to log into the site - all others will see the Maintenance Message.', 'general', 2),
('jrCore', 'maintenance_notice', [[timestamp]], [[timestamp]], 'The System is currently undergoing system maintenance. We are working to get the system back online as soon as possible. Thank you for your patience.', 'The System is currently undergoing system maintenance. We are working to get the system back online as soon as possible. Thank you for your patience.', 'textarea', 'false', 'off', 0, 0, '', 'installer', 'maintenance message', '', 'If you have enabled &quot;Maintenance Mode&quot; you can enter a message that is shown on the login page.', 'general', 3),
('jrCore', 'max_sql_run_time', [[timestamp]], [[timestamp]], '0', '0', 'select', 'number_nn', 'on', 0, 0, '{"0":"Disabled","1000":"1 Second","2000":"2 Seconds","3000":"3 Seconds","4000":"4 Seconds","5000":"5 Seconds","6000":"6 Seconds","7000":"7 Seconds","8000":"8 Seconds","9000":"9 Seconds","10000":"10 Seconds","12000":"12 Seconds","15000":"15 Seconds","20000":"20 Seconds","25000":"25 Seconds","30000":"30 Seconds","45000":"45 Seconds","60000":"60 Seconds"}', 'installer', 'max query run time', '', 'Enabling this option will set a maximum time (in seconds) that an SQL query is allowed to run for.  Requires MySQL 5.7+.<br><br><b>Note:</b> Individual SQL queries in modules can override this setting to enable loger running queries.<br><br><b>Warning!</b> Setting this value too low for your system could make your system inaccessible!', 'content', 33),
('jrCore', 'optimize_order', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'use optimized ordering', '', 'Checking this option allows the core to determine if it can optimize the ordering of list items.<br><br>Leave this option enabled unless you feel the time-ordering of list items is incorrect (which can happen on imported items).', 'content', 32),
('jrCore', 'pager_limit', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'use optimized pager', '', 'Checking this option will disable the Page Jumper on listing pages when the core determines the resulting SQL COUNT() query would slow down the system.<br><br>Leave this option enabled - disabling this on large systems can result in slow page generation.', 'content', 31),
('jrCore', 'purge_log_days', [[timestamp]], [[timestamp]], '60', '60', 'select', '', 'on', 0, 0, '{"0":"Never","1":"After 1 day","2":"After 2 days","3":"After 3 days","4":"After 4 days","5":"After 5 days","6":"After 6 days","7":"After 7 days","10":"After 10 days","12":"After 12 days","15":"After 15 days","20":"After 20 days","30":"After 30 days","40":"After 40 days","50":"After 50 days","60":"After 60 days","90":"After 90 days","120":"After 120 days","150":"After 150 days","180":"After 180 days","220":"After 220 days","270":"After 270 days","320":"After 320 days","365":"After 1 year"}', 'installer', 'purge activity logs', '', 'How many days after an Activity Log is recorded should it be deleted?', 'activity log', 21),
('jrCore', 'recycle_bin', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'enable recycle bin', '', 'With this option checked when a module DataStore item (such as a Profile, a User, a Blog entry, etc.) is deleted it will be saved in the system Recycle Bin where it can be restored if needed.', 'recycle bin', 50),
('jrCore', 'recycle_bin_expire', [[timestamp]], [[timestamp]], '3', '3', 'select', '', 'on', 0, 0, '{"0":"Never - Recycle Bin must be manually emptied","1":"1 Day","2":"2 Days","3":"3 Days","4":"4 Days","5":"5 Days","6":"6 Days","7":"7 Days","8":"8 Days","9":"9 Days","10":"10 Days","14":"14 Days","21":"21 Days","28":"28 Days","60":"60 Days"}', 'installer', 'delete after', '', 'How many days after an item has been added to the Recycle Bin will it be permanently deleted?', 'recycle bin', 51),
('jrCore', 'system_name', [[timestamp]], [[timestamp]], '[[domhost]]', '[[domhost]]', 'text', 'not_empty', 'on', 0, 0, '', 'installer', 'system name', '', 'This is the name of your system.', 'general', 1),
('jrCore', 'system_timezone', [[timestamp]], [[timestamp]], 'Europe/Dublin', 'Europe/Dublin', 'select', '', 'on', 0, 0, 'jrCore_get_timezone_strings', 'installer', 'system time zone', '', 'Setting the System Time Zone will adjust all of the output Date and Time stamps to the specified time zone, regardless of where your actual server may be physically located.  All Time Zones except UTC will be adjusted for Daylight Savings.', 'date and time', 10),
('jrCore', 'unique_string', [[timestamp]], [[timestamp]], '[[unique_string]]', '0', 'hidden', 'md5', 'on', 0, 0, '', 'installer', 'unique system string', '', 'this hidden field holds a unique string value for use in hashing - do not modify', '', 1),
('jrDeveloper', 'developer_mode', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'run in developer mode', '', 'Enabling the &quot;Run in Developer Mode&quot; option will change the information displayed in the &quot;Info&quot; tab for a module to include information about Module Triggers and Listeners, as well as force all template and cache items to be built on every access.<br><br><b>Warning:</b> Enabling Developer Mode will make your system run much slower than normal!', 'general settings', 1),
('jrDeveloper', 'developer_name', [[timestamp]], [[timestamp]], '', '', 'text', 'printable', 'off', 0, 0, '', 'installer', 'developer name', '', 'This is your Developer Name as registered on Jamroom.net.  It will be used when generating Licenses for modules and skins', 'developer settings', 21),
('jrDeveloper', 'developer_prefix', [[timestamp]], [[timestamp]], '', '', 'text', 'core_string', 'off', 0, 0, '', 'installer', 'developer prefix', '', 'This is your Developer Prefix as registered on Jamroom.net.  Your developer prefix is your unique module and skin directory name &quot;prefix&quot; that only you will use for your modules and skins.<br><br><b>Example:</b> All modules and skins created by The Jamroom Network begin with &quot;jr&quot;.<br><br><b>NOTE:</b> You can set this value to &quot;xx&quot; to enable local module and skin packaging.', 'developer settings', 22),
('jrDeveloper', 'enable_reset', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'enable reset tools', '', 'If this option is enabled, additional tools for rebasing and resetting the system will appear in the Develope Tools -> Tools menu', 'developer settings', 23),
('jrDeveloper', 'language_verify', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'verify language strings', '', 'Log language strings that differ from their default value to the Language Log tool', 'general settings', 3),
('jrDeveloper', 'query_counts', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'track query counts', '', 'If this option is enabled, the number of times an SQL SELECT query is run, as well as the line number of the script where the query was run, will be viewable in the Query Counts tool.', 'database options', 11),
('jrDeveloper', 'query_describe', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'describe queries', '', 'If this option is enabled, SELECT queries will be run a second time with DESCRIBE and logged to view the query plan.<br><br><b>DO NOT ENABLE</b> on a production site.', 'database options', 13),
('jrDeveloper', 'query_sum', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'log database queries', '', 'If this option is enabled, database queries will be logged to the data/logs/sql_query_log at the end of each process.', 'database options', 12),
('jrDeveloper', 'slow_queries', [[timestamp]], [[timestamp]], '0', '0', 'select', 'number_nn', 'on', 0, 0, '{"0":"Disabled","250":".25 Second","500":".50 Second","750":".75 Second","1000":"1 Second","2000":"2 Seconds","3000":"3 Seconds","4000":"4 Seconds","5000":"5 Seconds"}', 'installer', 'slow query log', '', 'With this option enabled, SQL queries that take longer than the configured seconds will be logged to the Activity Log.', 'database options', 10),
('jrDeveloper', 'template_debug', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'template name in source', '', 'Enabling the &quot;Template Name in Source&quot; option will add an html comment with the name of the .tpl file START and END to help locate which html code comes from which template.', 'general settings', 2),
('jrDisqus', 'identifier', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'use unique identifier', '', 'If this option is checked, a unique identifier will be used when embedding comments. If you are upgrading from Disqus module version 1.0.5 or older, it is recommended to leave this option off or comments may not appear in the correct location.', '', 2),
('jrDisqus', 'site_name', [[timestamp]], [[timestamp]], '', '', 'text', 'printable', 'off', 0, 0, '', 'installer', 'disqus shortname', '', 'This is the short name that can be found in Disqus in your site identity section. It was created when when you signed up for Disqus', '', 1),
('jrElastic2', 'auto_play', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'Auto Play', '', 'Enabling this option will turn on your players auto play feature.<br><span class="form_help_small">Note: This is for the following profile players only. Audio, Playlist and Video.</span>', 'Players', 32),
('jrElastic2', 'dark_mode', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'Dark Mode', '', 'If this option is enabled, a visitor that has their Desktop OS in dark mode will see the dark mode version of the site', 'general', 3),
('jrElastic2', 'facebook_url', [[timestamp]], [[timestamp]], '', '', 'text', 'printable', 'off', 0, 0, '', 'installer', 'Facebook profile URL', '', 'If you have an account for your site on Facebook, enter the profile url or name/ID and the network icon will show on your index page.  Enter 0 to disable.', 'social networks', 21),
('jrElastic2', 'follower_count', [[timestamp]], [[timestamp]], '12', '12', 'text', 'number_nn', 'on', 0, 0, '', 'installer', 'Latest Follower Count', '', 'How many &quot;Latest Followers&quot; should be shown in the Profile sidebar? Set to 0 (zero) to disable showing Profile Followers.', 'Profiles', 42),
('jrElastic2', 'instagram_url', [[timestamp]], [[timestamp]], '', '', 'text', 'printable', 'off', 0, 0, '', 'installer', 'Instagram profile URL', '', 'If you have an account for your site on Instagram, enter the profile url or name/ID and the network icon will show on your index page.  Enter 0 to disable.', 'social networks', 22),
('jrElastic2', 'linkedin_url', [[timestamp]], [[timestamp]], '', '', 'text', 'printable', 'off', 0, 0, '', 'installer', 'Linkedin profile URL', '', 'If you have an account for your site on Linkedin, enter the profile url or name/ID and the network icon will show on your index page.  Enter 0 to disable.', 'social networks', 23),
('jrElastic2', 'player_type', [[timestamp]], [[timestamp]], 'blue_monday', 'blue_monday', 'select', '', 'off', 0, 0, '{"blue_monday":"Blue Monday Player","gray_overlay_player":"Gray Overlay Player","player_dark":"Midnight Player","black_overlay_player":"Black Overlay Player","solo_player":"Solo Artist Player"}', 'installer', 'Player Type', '', 'Select the type of media player you want to use on your site.', 'Players', 30),
('jrElastic2', 'profile_ids', [[timestamp]], [[timestamp]], '', '', 'text', 'number_nz', 'off', 0, 0, '', 'installer', 'Admin Blog ID', '', 'Enter the blog ID you would like featured on the index page admin blog.', 'general', 2),
('jrElastic2', 'rated_count', [[timestamp]], [[timestamp]], '12', '12', 'text', 'number_nn', 'on', 0, 0, '', 'installer', 'Recently Rated Count', '', 'How many &quot;Recently Rated&quot; item should be shown in the Profile sidebar? Set to 0 (zero) to disable showing Recently Rated Items.<br><br><strong>NOTE:</strong> Requires the Item Ratings Module is installed and active in the Profile Quota.', 'Profiles', 43),
('jrElastic2', 'show_bio', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'Show Profile Info', '', 'If this option is checked and the profile has entered text for the Profile Biography or Signup question, it will be shown in the Profile sidebar.', 'Profiles', 41),
('jrElastic2', 'show_online', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'Show Online Status', '', 'If this option is checked the online status of the profile users will be shown below the Profile image.', 'Profiles', 40),
('jrElastic2', 'show_stats', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'Show Profile Stats', '', 'If this option is checked, the &quot;Profile Stats&quot; section will show on User Profiles.', 'Profiles', 44),
('jrElastic2', 'show_tag_cloud', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'Show Profile Tag Cloud', '', 'If this option is checked, the &quot;Profile Tag Cloud&quot; section will show on User Profiles.<br><br><strong>NOTE:</strong> Requires the Item Tag Cloud module is installed and active in the Profile Quota.', 'Profiles', 45),
('jrElastic2', 'twitter_url', [[timestamp]], [[timestamp]], '', '', 'text', 'printable', 'off', 0, 0, '', 'installer', 'Twitter profile URL', '', 'If you have an account for your site on Twitter, enter the profile url or name/ID and the network icon will show on your index page.  Enter 0 to disable.', 'social networks', 20),
('jrElastic2', 'welcome_title', [[timestamp]], [[timestamp]], 'Welcome to Elastic', 'Welcome to Elastic', 'text', 'not_empty', 'off', 0, 0, '', 'installer', 'Welcome Title', '', 'Enter You welcome title.', 'general', 1),
('jrElastic2', 'youtube_url', [[timestamp]], [[timestamp]], '', '', 'text', 'printable', 'off', 0, 0, '', 'installer', 'Youtube profile URL', '', 'If you have an account for your site on Youtube, enter the profile url or name/ID and the network icon will show on your index page.  Enter 0 to disable.', 'social networks', 24),
('jrEmbed', 'default_tab', [[timestamp]], [[timestamp]], '', '', 'select', 'printable', 'off', 0, 0, 'jrEmbed_get_active_modules', 'installer', 'default module', '', 'Which module should be selected as the default module tab when the Embedded Media window opens?', '', 1),
('jrEmbed', 'profile_only', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'profile media only', '', 'If this option is checked, then only media from the active profile will show in the TinyMCE Embed popup.  If unchecked, then all media system wide (that is not private) will be available', '', 2),
('jrFavicon', 'active', [[timestamp]], [[timestamp]], '', '', 'hidden', 'printable', 'on', 0, 0, '', 'installer', 'active favicon', '', 'this hidden field holds the active favicon - do not modify or remove', '', 1),
('jrFavicon', 'enabled', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'favicon active', '', 'If this option is checked, then the active Favicon will be active in the HTML of the site', '', 1),
('jrFollower', 'logged_in_only', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'Logged In Viewing Only', '', 'If enabled, only logged in users can see profile followers and those users following', '', 2),
('jrFollower', 'pagebreak', [[timestamp]], [[timestamp]], '16', '16', 'text', 'number_nn', 'on', 0, 0, '', 'installer', 'Follower List Pagebreak', '', 'Enter the pagebreak for lists of follower items. Set to 0 to disable pagination (not recommended)', '', 1),
('jrGeo', 'active', [[timestamp]], [[timestamp]], 'local', 'local', 'select', 'not_empty', 'off', 0, 0, '{"local":"Geo Location Database file v2 - default","old":"Geo Location Database file v1 - deprecated","apilite":"MaxMind Free GeoLite2 API - requires MaxMind API key","api":"MaxMind Paid GeoIP Precision API - requires MaxMind API key"}', 'installer', 'Active Location Service', '', 'Select the GeoIP service that should be the active service for IP Address requests.', '', 1),
('jrGeo', 'google_api_key', [[timestamp]], [[timestamp]], '', '', 'text', 'not_empty', 'off', 0, 0, '', 'installer', 'Google Maps API Key', '', 'Enter your Google Maps API Key.<br><br>For more information on Google Maps, including pricing and how to get an API Key, make sure and visit the Get API Key section of the Google Developer Documentation:<br><br><a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank" rel="noreferrer noopener"><u>How to get a Google Maps API Key</u></a>', '', 2),
('jrGeo', 'ip_file_time', [[timestamp]], [[timestamp]], '0', '0', 'hidden', 'number_nn', 'on', 0, 0, '', 'installer', 'Geo Location Database - version 1 (deprecated) Key Field', '', 'this hidden field keeps track of the Geo database time - do not modify by hand.', '', 1),
('jrGeo', 'ip2_file_time', [[timestamp]], [[timestamp]], '0', '0', 'hidden', 'number_nn', 'on', 0, 0, '', 'installer', 'Geo Location Database - version 2 Key Field', '', 'this hidden field keeps track of the Geo database time - do not modify by hand.', '', 1),
('jrGeo', 'license_key', [[timestamp]], [[timestamp]], '', '', 'text', 'not_empty', 'off', 0, 0, '', 'installer', 'MaxMind License Key', '', 'This is your MaxMind License Key found in the &quot;My License Key&quot; section of your MaxMind Account', 'MaxMind', 11),
('jrGeo', 'user_id', [[timestamp]], [[timestamp]], '', '', 'text', 'not_empty', 'off', 0, 0, '', 'installer', 'MaxMind Account ID', '', 'This is your MaxMind Account ID found in the &quot;My License Key&quot; section of your MaxMind Account', 'MaxMind', 10),
('jrGeo', 'zip_display', [[timestamp]], [[timestamp]], 'miles', 'miles', 'select', 'not_empty', 'off', 0, 0, '{"miles":"Miles","kilometers":"Kilometers"}', 'installer', 'ZIP Search Format', '', 'Select the distance format that will be used in a ZIP Code radius search', '', 3),
('jrGeo', 'zip_file_time', [[timestamp]], [[timestamp]], '0', '0', 'hidden', 'number_nn', 'on', 0, 0, '', 'installer', 'ZIP Code Database Key Field', '', 'this hidden field keeps track of the Geo database time - do not modify by hand.', '', 1),
('jrGravatar', 'default_image', [[timestamp]], [[timestamp]], 'default', 'default', 'select', 'not_empty', 'off', 0, 0, '{"default":"Default","mm":"Mystery Man","identicon":"Identicon","monsterid":"MonsterID","wavatar":"Wavatar","retro":"Retro","blank":"Blank"}', 'installer', 'default image style', '', 'If the user has not uploaded a Gravatar image, what style would you like to use for the default image?<br><br>View details here: <a href="https://secure.gravatar.com/site/implement/images/#default-image">https://secure.gravatar.com/site/implement/images/#default-image</a>', '', 4),
('jrGravatar', 'enable_profile', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'use as profile image', '', 'If this option is checked and the profile has not uploaded a custom profile image, the URL for the user''s Gravatar image will be used in it''s place.', '', 2),
('jrGravatar', 'enabled', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'enable gravatar images', '', 'If this option is checked and the user has not uploaded a custom user image, the URL for a Gravatar image will be used in it''s place.', '', 1),
('jrGravatar', 'local_cache', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'use local cache', '', 'If this option is checked, the gravatar images for Users and Profiles will be cached and served from the local web server', '', 3),
('jrGravatar', 'rating', [[timestamp]], [[timestamp]], 'g', 'g', 'select', 'not_empty', 'off', 0, 0, '{"g":"Rated G","pg":"Rated PG","r":"Rated R","x":"Rated X"}', 'installer', 'image rating', '', 'Select the image rating you would like to have viewable on the site.<br><br>See <a href="https://secure.gravatar.com/site/implement/images/#rating">https://secure.gravatar.com/site/implement/images/#rating</a> for more information.', '', 5),
('jrImage', 'active_cache_dir', [[timestamp]], [[timestamp]], 'aaaaa', 'aaaaa', 'hidden', '', 'on', 0, 0, '', 'installer', 'active cache dir', '', 'used internally - do not change or remove', '', 1),
('jrImage', 'block_original_size', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'Block Original Size', '', 'Images can only be viewed in a set of pre-defined sizes: <br><br>xxsmall (24), xsmall (40), small (72), icon96 (96), icon (128), medium (196), large (256), larger (320), xlarge (384), xxlarge (512), xxxlarge (800), 1280 and original.<br><br>Check this option to prevent the &quot;original&quot; size from being shown, which can prevent downloading images if they are for sale.', '', 3),
('jrImage', 'clean_days', [[timestamp]], [[timestamp]], '1', '1', 'select', 'number_nn', 'off', 0, 0, '{"0":"disabled","1":"1 day","2":"2 days","3":"3 days","4":"4 days","5":"5 days","6":"6 days","7":"7 days","14":"14 days","30":"30 days","60":"60 days","90":"90 days","120":"120 days","180":"180 days","365":"365 days"}', 'installer', 'Delete Cached Images', '', 'If a cached image has not been viewed in the time duration specified here, the cached version of the image will be removed.  This can help cut down on the amount of space used by cached images.', '', 7),
('jrImage', 'convert_to_jpg', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'Convert to JPG', '', 'PNG and GIF images can be very large - check this option so uploaded PNG and GIF media images are converted to the JPG format before being saved - this can significantly reduce the disk space required for cached image thumbnails.<br><br><strong>NOTE:</strong> Animated GIF images and transparent PNG images are excluded.', '', 1),
('jrImage', 'lazy_load', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'Enable Lazy Loading', '', 'If this option is enabled, the &quot;loading&quot; parameter will be added to images with a value of &quot;lazy&quot;. This will defer loading of the image until it reaches a calculated distance from the viewport, as defined by the browser.  This can speed up long pages where there are a lot of images.', '', 4),
('jrImage', 'maximum_width', [[timestamp]], [[timestamp]], '0', '0', 'text', 'number_nn', 'on', 0, 0, '', 'installer', 'Maximum Image Width', '', 'Enter the Maximum Image Width (in pixels) for images.  If an image is uploaded that is LARGER than this setting, it will be resized to this value before being saved. Set to 0 (zero) to disable this setting.', '', 6),
('jrImage', 'minimum_width', [[timestamp]], [[timestamp]], '0', '0', 'text', 'number_nn', 'on', 0, 0, '', 'installer', 'Minimum Image Width', '', 'Enter the Minimum Image Width (in pixels) that an image must be before it is allowed to be uploaded. Set to 0 (zero) to disable this setting.<br><br><b>NOTE:</b> This settings does not affect Profile Admin users.', '', 5),
('jrImage', 'resize_animated', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'Resize Animated GIFs', '', 'Resizing animated GIF images can be slow and place a high load on the server - it is recommended to leave this option disabled unless you specifically need to resize animated GIF images.', '', 2),
('jrMailer', 'active_email_system', [[timestamp]], [[timestamp]], 'jrMailer_smtp', 'jrMailer_smtp', 'select', 'core_string', 'on', 0, 0, 'jrCore_get_email_system_plugins', 'installer', 'active email system', '', 'What Email system should be the active email system?', 'general settings', 1),
('jrMailer', 'from_email', [[timestamp]], [[timestamp]], '[[admin_email]]', '[[admin_email]]', 'text', 'email', 'off', 0, 0, '', 'installer', 'from email address', '', 'When the system sends an automated / system message, what email address should the email be sent from? Note that this should be a real email address that will be checked with an email client.', 'general settings', 2),
('jrMailer', 'from_name', [[timestamp]], [[timestamp]], '', '', 'text', 'printable', 'off', 0, 0, '', 'installer', 'from name', '', 'Some email clients will show a friendly name for an email address - enter a friendly name for the From Email Address here.  Leave empty to use just the email address.', 'general settings', 3),
('jrMailer', 'send_as_html', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'HTML notifications', '', 'Notification email sent from the system can be sent as either Plain Text or HTML.<br><br><b>Tip:</b> You can customize the HTML design of the notification emails by editing the <a href="[[softurl]]/user/template_modify/template=email_html_notification.tpl" target="_blank" rel="noreferrer noopener"><u>email_html_notification.tpl</u></a> template.', 'general settings', 6),
('jrMailer', 'smtp_encryption', [[timestamp]], [[timestamp]], 'none', 'none', 'select', 'not_empty', 'off', 0, 0, '{"none":"no encryption","ssl":"SSL","tls":"TLS"}', 'installer', 'SMTP Encryption', '', 'If your SMTP server supports SSL or TLS, you can enable encryption by selecting the option your SMTP server supports', 'delivery settings', 15),
('jrMailer', 'smtp_host', [[timestamp]], [[timestamp]], 'localhost.com', 'localhost.com', 'text', 'false', 'off', 0, 0, '', 'installer', 'SMTP host', '', 'If you would like to use an external SMTP Server for sending email, enter the hostname or IP address here.<br><br><strong>NOTE:</strong> if you are setting up Gmail as your SMTP server, make sure you have allowed 3rd party applications to send by visiting the following URL:<br><br><a href="https://accounts.google.com/UnlockCaptcha" target="_blank" rel="noreferrer noopener">https://accounts.google.com/UnlockCaptcha</a>', 'delivery settings', 12),
('jrMailer', 'smtp_pass', [[timestamp]], [[timestamp]], '', '', 'password', 'false', 'off', 0, 0, '', 'installer', 'SMTP password', '', 'If you have specified an SMTP user name, enter the password that is used to connect to the SMTP server.', 'delivery settings', 15),
('jrMailer', 'smtp_port', [[timestamp]], [[timestamp]], '25', '25', 'text', 'number_nz', 'off', 0, 0, '', 'installer', 'SMTP port number', '', 'If you have specified an SMTP host, enter the port that the SMTP server is running on.', 'delivery settings', 13),
('jrMailer', 'smtp_user', [[timestamp]], [[timestamp]], '', '', 'text', 'false', 'off', 0, 0, '', 'installer', 'SMTP user name', '', 'If you have specified an SMTP host, enter the user name that is used to connect to the SMTP server.', 'delivery settings', 14),
('jrMailer', 'throttle', [[timestamp]], [[timestamp]], '0', '0', 'select', 'number_nn', 'off', 0, 0, '{"0":"disabled","1":"1","2":"2","3":"3","4":"4","5":"5","10":"10","15":"15","20":"20","25":"25","30":"30","35":"35","40":"40","50":"50","60":"60","75":"75","90":"90","120":"120","150":"150","200":"200"}', 'installer', 'max delivery rate', '(per minute)', 'What is the maximum number of emails that will be sent in any minute?<br><br><strong>NOTE:</strong> For large systems it is recommended that this setting be <strong>disabled</strong>. This setting uses database counters that may cause additional load on the system.', 'delivery settings', 11),
('jrMailer', 'transport', [[timestamp]], [[timestamp]], 'mail', 'mail', 'select', '', 'off', 0, 0, '{"mail":"Internal Mail Server - SMTP settings are not required (default)","smtp":"External Mail Server - SMTP settings required"}', 'installer', 'delivery method', '', 'Select the delivery method you would like to use for outbound email.', 'delivery settings', 10),
('jrMarket', 'archive_versions', [[timestamp]], [[timestamp]], '0', '0', 'select', 'number_nn', 'on', 0, 0, '["Keep All Versions","1 Version","2 Versions","3 Versions","4 Versions","5 Versions"]', 'installer', 'marketplace versions', '', 'How many release versions of each module or skin would you like to keep?<br><br>For example - if this is set to &quot;3&quot;, then the most recent THREE versions of each module and skin will be kept - any older versions will be removed.<br><br>If you lower this setting, run the system Integrity Check to cleanup any archive module and skins that would be affected by the new setting.', '', 6),
('jrMarket', 'ftp_host', [[timestamp]], [[timestamp]], 'localhost', 'localhost', 'text', 'printable', 'off', 0, 0, '', 'installer', 'FTP Host', '', 'If the system is unable to write directly to the module and skin directories, you can enter your FTP Information here and the system will attempt to install items via FTP.<br><br><b>NOTE:</b> If you are not sure of the hostname for your FTP server, you may need to contact your hosting provider for assistance.', 'FTP settings', 10),
('jrMarket', 'ftp_pass', [[timestamp]], [[timestamp]], '', '', 'password', 'printable', 'off', 0, 0, '', 'installer', 'FTP Password', '', 'If you are using FTP to install modules and skins, enter the FTP Password', 'FTP settings', 13),
('jrMarket', 'ftp_port', [[timestamp]], [[timestamp]], '21', '21', 'text', 'number_nz', 'off', 0, 0, '', 'installer', 'FTP Port', '', 'If you are using FTP to install modules and skins, enter the FTP Port here. FTP servers normally run on port 21.<br><br><b>NOTE:</b> If you are not sure of the port number for your FTP server, you may need to contact your hosting provider for assistance.', 'FTP settings', 11),
('jrMarket', 'ftp_user', [[timestamp]], [[timestamp]], '', '', 'text', 'printable', 'off', 0, 0, '', 'installer', 'FTP User', '', 'If you are using FTP to install modules and skins, enter the FTP Username', 'FTP settings', 12),
('jrMarket', 'quick_purchase', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'quick purchase', 'uncheck to force new credit card', 'Once a purchase has been made through the Marketplace, future purchases can bypass the Credit Card checkout step and instead use the same information from your last purchase.  Uncheck this option to require a full checkout for each purchase.', '', 4),
('jrMarket', 'update_check', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'check for updates', '', 'During daily maintenance the system will check if there are available Marketplace updates - if there are, an email will be sent to master admins letting them know updates are available.', '', 2),
('jrMeta', 'names', [[timestamp]], [[timestamp]], 'abstract\napplication-name\nauthor\ncopyright\ndescription\ndistribution\ngenerator\ngoogle-site-verification\nkeywords\nlanguage\nog:audio\nog:description\nog:determiner\nog:image\nog:image:height\nog:image:width\nog:locale\nog:site_name\nog:title\nog:type\nog:url\nog:video\nrating\nreferrer\nrevisit-after\nrights-standard\nrobots\ntwitter:card\ntwitter:creator\ntwitter:creator:id\ntwitter:description\ntwitter:image\ntwitter:image:alt\ntwitter:player\ntwitter:player:height\ntwitter:player:stream\ntwitter:player:width\ntwitter:site\ntwitter:site:id\ntwitter:title\nweb_author', 'abstract\napplication-name\nauthor\ncopyright\ndescription\ndistribution\ngenerator\ngoogle-site-verification\nkeywords\nlanguage\nog:audio\nog:description\nog:determiner\nog:image\nog:image:height\nog:image:width\nog:locale\nog:site_name\nog:title\nog:type\nog:url\nog:video\nrating\nreferrer\nrevisit-after\nrights-standard\nrobots\ntwitter:card\ntwitter:creator\ntwitter:creator:id\ntwitter:description\ntwitter:image\ntwitter:image:alt\ntwitter:player\ntwitter:player:height\ntwitter:player:stream\ntwitter:player:width\ntwitter:site\ntwitter:site:id\ntwitter:title\nweb_author', 'textarea', 'not_empty', 'off', 0, 0, '', 'installer', 'Meta Tag Names', '', 'You can add custom Meta Tag names to this list by placing tags one per line', '', 1),
('jrMeta', 'tagset', [[timestamp]], [[timestamp]], '', '', 'hidden', 'printable', 'on', 0, 0, '', 'installer', 'meta tag set', '', 'this hidden field holds the configured meta tags for the Meta Tags module', '', 1),
('jrProfile', 'allow_delete', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'allow profile deletion', '', 'If this option is checked, a user can delete their own profile', 'profile options', 3),
('jrProfile', 'change', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'allow quota changes', '', 'If you have multiple Signup Quotas, check this option to give your users the ability to change Profile Quotas to any other free quota.', 'signup settings', 2),
('jrProfile', 'default_quota_id', [[timestamp]], [[timestamp]], '1', '1', 'select', 'number_nz', 'off', 0, 0, 'jrProfile_get_quotas', 'installer', 'default profile quota', '', 'What Profile Quota should be the default for new users when they signup?', 'signup settings', 1),
('jrProfile', 'show_help', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'show profile help', '', 'If this option is checked, and a profile owner views a section on their profile that has no items, a message will show to help them create an item', 'profile options', 4),
('jrSearch', 'dedicated', [[timestamp]], [[timestamp]], '', '', 'optionlist', 'core_string', 'off', 0, 0, 'jrSearch_get_search_modules', 'installer', 'Unique Module Indexes', 'see help for details', 'Any module checked here will have an additional index created specifically for searches within that module''s DataStore.  This can help speed up search queries on modules with a very large amount of data.  It is recommended you do NOT check a module here unless you are certain you need the additional search index', 'index options', 30),
('jrSearch', 'disabled', [[timestamp]], [[timestamp]], '', '', 'optionlist', 'core_string', 'off', 0, 0, 'jrSearch_get_search_modules', 'installer', 'Disabled Modules', 'see help for details', 'Any module checked here will be excluded from being searched and will not have its DataStore items added to the Search index', 'disabled modules', 40),
('jrSearch', 'display_order', [[timestamp]], [[timestamp]], '', '', 'custom', '', 'off', 0, 0, '', 'installer', 'Search Result Order', '', 'When viewing the results of a search, the order the module results appear in can be set by clicking the &quot;Set Result Order&quot; button', 'display options', 20),
('jrSearch', 'index_limit', [[timestamp]], [[timestamp]], '4', '4', 'text', 'number_nz', 'off', 0, 0, '', 'installer', 'index result count', '', 'How many results from each module that has matching results should be shown on the results page?', 'display options', 10),
('jrSearch', 'log_no_result', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'log no results', '', 'If this option is checked, and a search term returns no results, the search term will be logged to the Activity Log', 'search options', 4),
('jrSearch', 'method', [[timestamp]], [[timestamp]], 'both', 'both', 'select', 'not_empty', 'off', 0, 0, '{"both":"Default","boolean":"Keyword Only","natural":"Natural Language Only"}', 'installer', 'search method', '', 'The Search Method controls how a search term will be processed:<br><br><b>Default:</b> If the search query is 5 words or longer, and contains no Keyword operators (AND, OR, NOT) it will be treated as a Natural Language search, otherwise it will run as a Keyword search.<br><br><b>Keyword Only:</b> The search term will be treated as separate keywords (which can be manipulated using AND, OR and NOT).<br><br><b>Natural Language Only:</b> The search term will be treated as a question or phrase which may return more relevant results.', 'search options', 5),
('jrSearch', 'optimize', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'optimize queries', '', 'This option enables a query optimizer that can speed up some search queries.  It is recommended to leave this enabled unless you notice inconsistent result pagination.', 'search options', 3),
('jrSearch', 'partial', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'include partial matches', '', 'If a search query returns no exact results, do you want to run a second query to find sub string matches?', 'search options', 2),
('jrSearch', 'result_limit', [[timestamp]], [[timestamp]], '12', '12', 'text', 'number_nz', 'off', 0, 0, '', 'installer', 'module result count', '', 'When viewing the search results for an individual module, how many results should be shown on each page?', 'display options', 11),
('jrSearch', 'search_fields', [[timestamp]], [[timestamp]], '', '', 'textarea', 'searchable_field', 'off', 0, 0, '', 'installer', 'additional search fields', '', 'If you would like to have additional DataStore fields available for search, enter the DataStore field name, one per line.<br><br><strong>Example:</strong><br>If you have created a custom User Profiles field via the Form Designer called &quot;profile_location&quot; you would enter <strong>profile_location</strong> on a line by itself to enable that field to be searched.<br><br>You may also include an optional <strong>weight</strong> value that will make the search field have more impact on the search results:<br><br>profile_location,10<br><br>Would set the weight for the profile_location field to 10, which means a search match on that field would be 10 times more important than the default value of 1.', 'search options', 1),
('jrSiteBuilder', 'backup', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'Daily Backup', '', 'A daily export of Site Builder widget configurations will be performed allowing you to restore your widget settings to a specific day.', '', 2),
('jrSiteBuilder', 'backup_retain_days', [[timestamp]], [[timestamp]], '30', '30', 'select', 'number_nn', 'on', 0, 0, '{"0":"Forever","3":"3 Days","10":"10 Days","30":"30 Days (Default)","45":"45 Days","90":"90 Days"}', 'installer', 'Backup Days', '', 'How many days of backups would you like to keep - any auto-created backup files older than what is selected here will be removed during nightly maintenance.', '', 3),
('jrSiteBuilder', 'enabled', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'on', 0, 0, '', 'installer', 'show site builder button', '', 'If this option is checked, then Master Admins will see a &quot;Site Builder&quot; button on pages that can be edited in Site Builder', '', 1),
('jrSitemap', 'file_count', [[timestamp]], [[timestamp]], '0', '0', 'hidden', '', 'off', 0, 0, '', 'installer', 'XML File Count (hidden)', '', 'This hidden field keeps track of the number of XML files created - do not modify', '', 10),
('jrSitemap', 'profile_freq', [[timestamp]], [[timestamp]], 'daily', 'daily', 'select', '', 'off', 0, 0, '{"hourly":"hourly","daily":"daily","weekly":"weekly","monthly":"monthly","yearly":"yearly"}', 'installer', 'profile page frequency', '', 'Select the recommendation for how often profile pages should be updated in the sitemap.xml file.<br><br><strong>Note:</strong> This is only a recommendation - search engines are free to ignore this value.', '', 2),
('jrSitemap', 'site_freq', [[timestamp]], [[timestamp]], 'daily', 'daily', 'select', '', 'off', 0, 0, '{"hourly":"hourly","daily":"daily","weekly":"weekly","monthly":"monthly","yearly":"yearly"}', 'installer', 'site page frequency', '', 'Select the recommendation for how often site pages should be updated in the sitemap.xml file.<br><br><strong>Note:</strong> This is only a recommendation - search engines are free to ignore this value.', '', 1);
INSERT INTO `jr_jrcore_setting` VALUES
('jrStrongPassword', 'active', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'active', '', 'Check this option to activate the Password policy', '', 1),
('jrStrongPassword', 'length', [[timestamp]], [[timestamp]], '8', '8', 'text', 'number_nz', 'off', 4, 256, '', 'installer', 'minimum length', '', 'Enter the minimum password length that will be accepted', 'password policy', 2),
('jrStrongPassword', 'lowercase', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'require lowercase letter', '', 'Check this option to require at least 1 <strong>lowercase</strong> letter in a password.', 'password policy', 3),
('jrStrongPassword', 'number', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'require a number', '', 'Check this option to require at least 1 <strong>number</strong> in a password.', 'password policy', 6),
('jrStrongPassword', 'symbol', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'require a symbol', '', 'Check this option to require at least 1 <strong>symbol</strong> in a password.', 'password policy', 5),
('jrStrongPassword', 'uppercase', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'require uppercase letter', '', 'Check this option to require at least 1 <strong>uppercase</strong> letter in a password.', 'password policy', 4),
('jrSupport', 'support_email', [[timestamp]], [[timestamp]], '', '', 'text', 'email', 'on', 0, 0, '', 'installer', 'email address', 'Of your Jamroom.net Account', 'Enter your Jamroom.net user email address - this enables the Support Center to show you the available support options for your account.', '', 1),
('jrSystemTools', 'convert_binary', [[timestamp]], [[timestamp]], 'auto', 'auto', 'select', 'not_empty', 'on', 0, 0, '{"auto":"Auto Detect"}', 'installer', 'convert binary', 'resizes animated GIFs', 'The <b>convert</b> tool is used to resize animated GIF images<br><br>Set this value to <b>Auto Detect</b> to have the system automatically figure out the correct binary to use on your system, otherwise select the binary to use for this tool.', 'Tool Locations', 1),
('jrSystemTools', 'ffmpeg_binary', [[timestamp]], [[timestamp]], 'auto', 'auto', 'select', 'not_empty', 'on', 0, 0, '{"auto":"Auto Detect"}', 'installer', 'ffmpeg binary', 'converts audio and video', 'The <b>ffmpeg</b> tool is used for converting Audio and Video files in to a format that the system can use<br><br>Set this value to <b>Auto Detect</b> to have the system automatically figure out the correct binary to use on your system, otherwise select the binary to use for this tool.', 'Tool Locations', 2),
('jrSystemTools', 'id3v2_binary', [[timestamp]], [[timestamp]], 'auto', 'auto', 'select', 'not_empty', 'on', 0, 0, '{"auto":"Auto Detect"}', 'installer', 'id3v2 binary', 'read and write audio ID3 tags', 'The <b>id3v2</b> tool is used to read ID3 tags that are found in some audio files<br><br>Set this value to <b>Auto Detect</b> to have the system automatically figure out the correct binary to use on your system, otherwise select the binary to use for this tool.', 'Tool Locations', 3),
('jrSystemTools', 'jpegoptim_binary', [[timestamp]], [[timestamp]], 'auto', 'auto', 'select', 'not_empty', 'on', 0, 0, '{"auto":"Auto Detect"}', 'installer', 'jpegoptim binary', 'optimizes JPEG images', 'The <b>jpegoptim</b> tool is used to optimize JPG images<br><br>Set this value to <b>Auto Detect</b> to have the system automatically figure out the correct binary to use on your system, otherwise select the binary to use for this tool.', 'Tool Locations', 4),
('jrSystemTools', 'sox_binary', [[timestamp]], [[timestamp]], 'auto', 'auto', 'select', 'not_empty', 'on', 0, 0, '{"auto":"Auto Detect"}', 'installer', 'sox binary', 'audio file editing tool', 'The <b>sox</b> tool is used to manipulate audio files and provide fade-in and fade-out functionality when creating audio snippets<br><br>Set this value to <b>Auto Detect</b> to have the system automatically figure out the correct binary to use on your system, otherwise select the binary to use for this tool.', 'Tool Locations', 5),
('jrSystemTools', 'tifig_binary', [[timestamp]], [[timestamp]], 'auto', 'auto', 'select', 'not_empty', 'on', 0, 0, '{"auto":"Auto Detect"}', 'installer', 'tifig binary', 'convert HEIC images to JPG', 'The <b>tifig</b> tool is used to convert HEIC and HEIF image formats to JPG<br><br>Set this value to <b>Auto Detect</b> to have the system automatically figure out the correct binary to use on your system, otherwise select the binary to use for this tool.', 'Tool Locations', 6),
('jrSystemTools', 'wget_binary', [[timestamp]], [[timestamp]], 'auto', 'auto', 'select', 'not_empty', 'on', 0, 0, '{"auto":"Auto Detect","\\/usr\\/bin\\/wget":"\\/usr\\/bin\\/wget"}', 'installer', 'wget binary', 'command line HTML browser', 'The <b>wget</b> tool is used to download web pages and parse HTML for Open Graph tags<br><br>Set this value to <b>Auto Detect</b> to have the system automatically figure out the correct binary to use on your system, otherwise select the binary to use for this tool.', 'Tool Locations', 7),
('jrTips', 'delay', [[timestamp]], [[timestamp]], '2000', '2000', 'text', 'number_nn', 'off', 0, 0, '', 'installer', 'Tips Delay', '', 'How fast the tips should show when you hover over an element with a tip.<br><br><b>NOTE:</b> Number is in milliseconds, so a value of 1000 equals 1 second.', '', 1),
('jrTOS', 'prompt', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'Prompt for Changes', '', 'If this option is checked, when a required Terms Of Service page is updated the user will be required at login time to agree to the updated version', '', 1),
('jrTwoFactor', 'required', [[timestamp]], [[timestamp]], 'none', 'none', 'select_multiple', 'printable', 'on', 0, 0, 'jrTwoFactor_get_required_user_groups', 'installer', 'Required For', '', 'Select the User groups that will be required to use Two Factor Authentication.', '', 1),
('jrUser', 'active_session_system', [[timestamp]], [[timestamp]], 'jrUser_mysql', 'jrUser_mysql', 'hidden', 'not_empty', 'on', 0, 0, '', 'installer', 'active session system', '', 'This hidden field holds the name of the active session sub system - do not modify by hand', '', 1),
('jrUser', 'allow_delete', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'allow delete', '', 'If this option is checked a &quot;delete account&quot; option will show in the User Settings', 'account', 12),
('jrUser', 'authenticate', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'Re-Authenticate', '', 'If this option is checked, when a user attempts to change their <strong>email address</strong> or <strong>password</strong> they will have to enter their existing password to continue.', 'account', 10),
('jrUser', 'autologin', [[timestamp]], [[timestamp]], '2', '2', 'select', '', 'on', 0, 0, '{"1":"Every Login (auto login disabled)","7":"Every 7 days","2":"Every 14 days","30":"Every 30 days","60":"Every 60 days","90":"Every 90 days","3":"Permanent (until user resets cookies)"}', 'installer', 'auto login reset', '', 'How often should a user have to re-enter their login credentials? If the user does not visit the site for the number of days selected here, they will need to login again.', 'sessions', 21),
('jrUser', 'bot_sessions', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'enable bot sessions', '', 'If this option is checked, session tracking will be enable for Web Bots (such as Google bot, Bing bot, etc.). This allows the dashboard to display the number of bots online. Disable this to turn off bot sessions, which will use less system resources', 'sessions', 22),
('jrUser', 'change_notice', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'change notification', '', 'If this option is checked and a user changes their email address or password they will be sent a notification to their <strong>old</strong> email address letting them know that their account information has been changed.', 'account', 11),
('jrUser', 'default_language', [[timestamp]], [[timestamp]], 'en-US', 'en-US', 'select', '', 'on', 0, 0, 'jrUser_get_languages', 'installer', 'default language', '', 'The Default language is the language that is setup for new user accounts by default.', 'account', 13),
('jrUser', 'forgot_note', [[timestamp]], [[timestamp]], '', '', 'textarea', 'allowed_html', 'off', 0, 0, '', 'installer', 'forgot note', 'HTML is allowed', 'Enter a note that will be shown on the forgot page', 'notes', 42),
('jrUser', 'login_note', [[timestamp]], [[timestamp]], '', '', 'textarea', 'allowed_html', 'off', 0, 0, '', 'installer', 'login note', 'HTML is allowed', 'Enter a note that will be shown on the login page.', 'notes', 40),
('jrUser', 'notification_layout', [[timestamp]], [[timestamp]], 'compact', 'compact', 'select', '', 'off', 0, 0, '{"compact":"Compact","expanded":"Expanded"}', 'installer', 'Notification Layout', 'for Account Settings -> Notifications', 'The default is the compact layout that shows just one notificaiton option at a time. Expanded shows all the notification options on one screen.', 'site options', 32),
('jrUser', 'session_expire_min', [[timestamp]], [[timestamp]], '360', '360', 'text', 'number_nz', 'on', 10, 20160, '', 'installer', 'session expiration', '', 'How many minutes of inactivity will cause a User session to be marked as expired?', 'sessions', 20),
('jrUser', 'signup_note', [[timestamp]], [[timestamp]], '', '', 'textarea', 'allowed_html', 'off', 0, 0, '', 'installer', 'signup note', 'HTML is allowed', 'Enter a note that will be shown on the signup page', 'notes', 41),
('jrUser', 'signup_notify', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'Signup Notification', '', 'If this option is checked the system will notify Admins when a new User Account is created.', 'signup', 2),
('jrUser', 'signup_on', [[timestamp]], [[timestamp]], 'on', 'on', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'User Signups', '', 'Check this option to allow users to signup for your site.', 'signup', 1),
('jrUser', 'site_privacy', [[timestamp]], [[timestamp]], '1', '1', 'select', '', 'on', 0, 0, '{"1":"Public (all pages visible)","2":"Limited (site index and log in \\/ signup only)","3":"Private (no pages visible)"}', 'installer', 'Site Privacy', '', 'Select which site pages visitors who are not logged in can see.<br><br><strong>NOTE:</strong> This setting only applies to users who are not logged in.', 'site options', 31),
('jrUser', 'use_templates', [[timestamp]], [[timestamp]], 'off', 'off', 'checkbox', 'onoff', 'off', 0, 0, '', 'installer', 'Enable Templates', 'For login and signup', 'By default the login and signup screens use internally generated Forms, which allows for easy customization using the Form Designer.  If you would prefer to have 100% control over the login and signup pages, check this option and ensure the &quot;user_login.tpl&quot; and &quot;user_signup.tpl&quot; files are customized to suit your needs.', 'site options', 33);

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_skin`
--

CREATE TABLE `jr_jrcore_skin` (
  `skin_directory` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `skin_updated` int(11) unsigned NOT NULL DEFAULT '0',
  `skin_custom_css` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `skin_direct_css` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `skin_custom_image` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `skin_system_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `skin_license` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `skin_cloned_from` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`skin_directory`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_stat_count`
--

CREATE TABLE `jr_jrcore_stat_count` (
  `stat_module` varchar(64) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `stat_key` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `stat_index` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `stat_date` bigint(20) unsigned NOT NULL DEFAULT '0',
  `stat_value` bigint(20) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `stat_unique` (`stat_key`,`stat_module`,`stat_index`,`stat_date`),
  KEY `stat_index` (`stat_index`),
  KEY `stat_date` (`stat_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_stat_unique`
--

CREATE TABLE `jr_jrcore_stat_unique` (
  `stat_ip` varchar(45) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `stat_user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `stat_key` varchar(192) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `stat_date` bigint(20) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `stat_unique` (`stat_ip`,`stat_user_id`,`stat_key`,`stat_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_template`
--

CREATE TABLE `jr_jrcore_template` (
  `template_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `template_module` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'jrCore',
  `template_created` int(11) unsigned NOT NULL DEFAULT '0',
  `template_updated` int(11) unsigned NOT NULL DEFAULT '0',
  `template_user` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `template_active` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `template_name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `template_type` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `template_body` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`template_id`),
  UNIQUE KEY `template_unique` (`template_module`,`template_name`),
  KEY `template_active` (`template_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrcore_tempvalue`
--

CREATE TABLE `jr_jrcore_tempvalue` (
  `temp_module` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'jrCore',
  `temp_key` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `temp_updated` int(11) unsigned NOT NULL DEFAULT '0',
  `temp_value` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  UNIQUE KEY `temp_unique` (`temp_module`,`temp_key`),
  KEY `temp_key` (`temp_key`),
  KEY `temp_updated` (`temp_updated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `jr_jrcore_tempvalue`
--

INSERT INTO `jr_jrcore_tempvalue` VALUES
('jrAction', 'core_ds_new_count', [[timestamp]], '0'),
('jrBlog', 'core_ds_new_count', [[timestamp]], '1'),
('jrCore', 'core_ds_new_count', [[timestamp]], '0'),
('jrCore', 'core_ds_row_counts', [[timestamp]], '{"jrCore":0,"jrImage":0,"jrUser":1,"jrBlog":1,"jrDeveloper":0,"jrFavicon":0,"jrPage":0,"jrSearch":0,"jrUpimg":0,"jrProfile":1,"jrAction":0}'),
('jrDeveloper', 'core_ds_new_count', [[timestamp]], '0'),
('jrFavicon', 'core_ds_new_count', [[timestamp]], '0'),
('jrImage', 'core_ds_new_count', [[timestamp]], '0'),
('jrPage', 'core_ds_new_count', [[timestamp]], '0'),
('jrProfile', 'core_ds_new_count', [[timestamp]], '1'),
('jrSearch', 'core_ds_new_count', [[timestamp]], '0'),
('jrUpimg', 'core_ds_new_count', [[timestamp]], '0'),
('jrUser', 'core_ds_new_count', [[timestamp]], '1');

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrdeveloper_item`
--

CREATE TABLE `jr_jrdeveloper_item` (
  `_item_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrdeveloper_item_key`
--

CREATE TABLE `jr_jrdeveloper_item_key` (
  `_item_id` int(11) unsigned NOT NULL DEFAULT '0',
  `_profile_id` int(11) unsigned NOT NULL DEFAULT '0',
  `key` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `index` smallint(5) unsigned NOT NULL DEFAULT '0',
  `value` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`key`,`_item_id`,`index`),
  KEY `_item_id` (`_item_id`),
  KEY `_profile_id` (`_profile_id`),
  KEY `value` (`value`(128))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrfavicon_item`
--

CREATE TABLE `jr_jrfavicon_item` (
  `_item_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrfavicon_item_key`
--

CREATE TABLE `jr_jrfavicon_item_key` (
  `_item_id` int(11) unsigned NOT NULL DEFAULT '0',
  `_profile_id` int(11) unsigned NOT NULL DEFAULT '0',
  `key` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `index` smallint(5) unsigned NOT NULL DEFAULT '0',
  `value` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`key`,`_item_id`,`index`),
  KEY `_item_id` (`_item_id`),
  KEY `_profile_id` (`_profile_id`),
  KEY `value` (`value`(128))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrfollower_follow`
--

CREATE TABLE `jr_jrfollower_follow` (
  `follow_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `follow_created` int(11) unsigned NOT NULL DEFAULT '0',
  `follow_user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `follow_profile_id` int(11) unsigned NOT NULL DEFAULT '0',
  `follow_active` tinyint(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`follow_id`),
  UNIQUE KEY `follow_unique` (`follow_user_id`,`follow_profile_id`),
  KEY `follow_created` (`follow_created`),
  KEY `follow_profile_id` (`follow_profile_id`),
  KEY `follow_active` (`follow_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrgeo_ip_cache`
--

CREATE TABLE `jr_jrgeo_ip_cache` (
  `ip_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ip_time` int(11) unsigned NOT NULL DEFAULT '0',
  `ip_info` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`ip_id`),
  UNIQUE KEY `ip_address` (`ip_address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrgeo_zip_cache`
--

CREATE TABLE `jr_jrgeo_zip_cache` (
  `zip_hash` char(32) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `zip_info` varchar(32768) CHARACTER SET latin1 NOT NULL DEFAULT '',
  UNIQUE KEY `zip_hash` (`zip_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrgeo_zip_code`
--

CREATE TABLE `jr_jrgeo_zip_code` (
  `zip_country` char(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `zip_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `zip_place` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `zip_lat` varchar(12) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `zip_lon` varchar(12) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  KEY `zip_country` (`zip_country`),
  KEY `zip_code` (`zip_code`),
  KEY `zip_lat` (`zip_lat`),
  KEY `zip_lon` (`zip_lon`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrimage_conversion_0`
--

CREATE TABLE `jr_jrimage_conversion_0` (
  `con_key` char(32) CHARACTER SET latin1 NOT NULL,
  `con_url` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`con_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrimage_conversion_1`
--

CREATE TABLE `jr_jrimage_conversion_1` (
  `con_key` char(32) CHARACTER SET latin1 NOT NULL,
  `con_url` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`con_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrimage_conversion_2`
--

CREATE TABLE `jr_jrimage_conversion_2` (
  `con_key` char(32) CHARACTER SET latin1 NOT NULL,
  `con_url` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`con_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrimage_conversion_3`
--

CREATE TABLE `jr_jrimage_conversion_3` (
  `con_key` char(32) CHARACTER SET latin1 NOT NULL,
  `con_url` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`con_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrimage_conversion_4`
--

CREATE TABLE `jr_jrimage_conversion_4` (
  `con_key` char(32) CHARACTER SET latin1 NOT NULL,
  `con_url` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`con_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrimage_conversion_5`
--

CREATE TABLE `jr_jrimage_conversion_5` (
  `con_key` char(32) CHARACTER SET latin1 NOT NULL,
  `con_url` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`con_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrimage_conversion_6`
--

CREATE TABLE `jr_jrimage_conversion_6` (
  `con_key` char(32) CHARACTER SET latin1 NOT NULL,
  `con_url` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`con_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrimage_conversion_7`
--

CREATE TABLE `jr_jrimage_conversion_7` (
  `con_key` char(32) CHARACTER SET latin1 NOT NULL,
  `con_url` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`con_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrimage_conversion_8`
--

CREATE TABLE `jr_jrimage_conversion_8` (
  `con_key` char(32) CHARACTER SET latin1 NOT NULL,
  `con_url` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`con_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrimage_conversion_9`
--

CREATE TABLE `jr_jrimage_conversion_9` (
  `con_key` char(32) CHARACTER SET latin1 NOT NULL,
  `con_url` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`con_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrimage_conversion_a`
--

CREATE TABLE `jr_jrimage_conversion_a` (
  `con_key` char(32) CHARACTER SET latin1 NOT NULL,
  `con_url` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`con_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrimage_conversion_b`
--

CREATE TABLE `jr_jrimage_conversion_b` (
  `con_key` char(32) CHARACTER SET latin1 NOT NULL,
  `con_url` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`con_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrimage_conversion_c`
--

CREATE TABLE `jr_jrimage_conversion_c` (
  `con_key` char(32) CHARACTER SET latin1 NOT NULL,
  `con_url` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`con_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrimage_conversion_d`
--

CREATE TABLE `jr_jrimage_conversion_d` (
  `con_key` char(32) CHARACTER SET latin1 NOT NULL,
  `con_url` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`con_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrimage_conversion_e`
--

CREATE TABLE `jr_jrimage_conversion_e` (
  `con_key` char(32) CHARACTER SET latin1 NOT NULL,
  `con_url` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`con_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrimage_conversion_f`
--

CREATE TABLE `jr_jrimage_conversion_f` (
  `con_key` char(32) CHARACTER SET latin1 NOT NULL,
  `con_url` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`con_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrimage_item`
--

CREATE TABLE `jr_jrimage_item` (
  `_item_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrimage_item_key`
--

CREATE TABLE `jr_jrimage_item_key` (
  `_item_id` int(11) unsigned NOT NULL DEFAULT '0',
  `_profile_id` int(11) unsigned NOT NULL DEFAULT '0',
  `key` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `index` smallint(5) unsigned NOT NULL DEFAULT '0',
  `value` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`key`,`_item_id`,`index`),
  KEY `_item_id` (`_item_id`),
  KEY `_profile_id` (`_profile_id`),
  KEY `value` (`value`(128))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrmailer_campaign`
--

CREATE TABLE `jr_jrmailer_campaign` (
  `c_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `c_module` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `c_unique` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `c_created` int(11) unsigned NOT NULL DEFAULT '0',
  `c_updated` int(11) unsigned NOT NULL DEFAULT '0',
  `c_title` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `c_sent` int(11) unsigned NOT NULL DEFAULT '0',
  `c_unsub` int(11) unsigned NOT NULL DEFAULT '0',
  `c_bounce` int(11) unsigned NOT NULL DEFAULT '0',
  `c_message` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`c_id`),
  UNIQUE KEY `c_unique_idx` (`c_module`,`c_unique`),
  KEY `c_unique` (`c_unique`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrmailer_click`
--

CREATE TABLE `jr_jrmailer_click` (
  `click_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `click_time` int(11) unsigned NOT NULL DEFAULT '0',
  `click_url_id` int(11) unsigned NOT NULL DEFAULT '0',
  `click_campaign_id` int(11) unsigned NOT NULL DEFAULT '0',
  `click_user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `click_count` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`click_id`),
  UNIQUE KEY `click_unique_idx` (`click_url_id`,`click_user_id`),
  KEY `click_campaign_id` (`click_campaign_id`),
  KEY `click_user_id` (`click_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrmailer_throttle`
--

CREATE TABLE `jr_jrmailer_throttle` (
  `t_min` int(10) unsigned NOT NULL DEFAULT '0',
  `t_cnt` smallint(5) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `t_min` (`t_min`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrmailer_track`
--

CREATE TABLE `jr_jrmailer_track` (
  `t_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `t_cid` int(11) unsigned NOT NULL DEFAULT '0',
  `t_uid` int(11) unsigned NOT NULL DEFAULT '0',
  `t_time` int(11) unsigned NOT NULL DEFAULT '0',
  `t_ip` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `t_lat` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `t_long` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `t_country` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `t_region` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `t_city` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `t_unsub` tinyint(1) NOT NULL DEFAULT '0',
  `t_agent` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `t_info` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`t_id`),
  UNIQUE KEY `t_id_unique` (`t_cid`,`t_uid`),
  KEY `t_uid` (`t_uid`),
  KEY `t_time` (`t_time`),
  KEY `t_ip` (`t_ip`),
  KEY `t_lat` (`t_lat`),
  KEY `t_country` (`t_country`),
  KEY `t_region` (`t_region`),
  KEY `t_city` (`t_city`),
  KEY `t_unsub` (`t_unsub`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrmailer_unsubscribe`
--

CREATE TABLE `jr_jrmailer_unsubscribe` (
  `u_uid` int(11) unsigned NOT NULL DEFAULT '0',
  `u_cid` int(11) unsigned NOT NULL DEFAULT '0',
  `u_time` int(11) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `u_uid` (`u_uid`,`u_cid`),
  KEY `u_time` (`u_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrmailer_url`
--

CREATE TABLE `jr_jrmailer_url` (
  `url_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `url_cid` int(11) unsigned NOT NULL DEFAULT '0',
  `url_uri` varchar(244) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`url_id`),
  UNIQUE KEY `url_unique_idx` (`url_cid`,`url_uri`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrmarket_channel`
--

CREATE TABLE `jr_jrmarket_channel` (
  `channel_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `channel_system_id` int(11) unsigned NOT NULL DEFAULT '0',
  `channel_created` int(11) unsigned NOT NULL DEFAULT '0',
  `channel_name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `channel_active` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `channel_code` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`channel_id`),
  KEY `channel_code` (`channel_code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `jr_jrmarket_channel`
--

INSERT INTO `jr_jrmarket_channel` VALUES
(1, 1, [[timestamp]], 'stable', 1, ''),
(2, 1, [[timestamp]], 'beta', 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrmarket_install`
--

CREATE TABLE `jr_jrmarket_install` (
  `install_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `install_time` int(11) unsigned NOT NULL DEFAULT '0',
  `install_data` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`install_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrmarket_system`
--

CREATE TABLE `jr_jrmarket_system` (
  `system_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `system_name` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `system_url` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `system_email` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `system_code` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `system_active` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'off',
  `system_default` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'off',
  PRIMARY KEY (`system_id`),
  KEY `system_active` (`system_active`),
  KEY `system_default` (`system_default`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `jr_jrmarket_system`
--

INSERT INTO `jr_jrmarket_system` VALUES
(1, 'Jamroom Network', 'https://www.jamroom.net', '', '', 'on', 'on');

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrmeta_meta`
--

CREATE TABLE `jr_jrmeta_meta` (
  `meta_id` tinyint(1) unsigned NOT NULL,
  `meta_json` longtext COLLATE utf8_unicode_ci NOT NULL,
  UNIQUE KEY `meta_id` (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrpage_item`
--

CREATE TABLE `jr_jrpage_item` (
  `_item_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrpage_item_key`
--

CREATE TABLE `jr_jrpage_item_key` (
  `_item_id` int(11) unsigned NOT NULL DEFAULT '0',
  `_profile_id` int(11) unsigned NOT NULL DEFAULT '0',
  `key` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `index` smallint(5) unsigned NOT NULL DEFAULT '0',
  `value` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`key`,`_item_id`,`index`),
  KEY `_item_id` (`_item_id`),
  KEY `_profile_id` (`_profile_id`),
  KEY `value` (`value`(128))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrprofile_item`
--

CREATE TABLE `jr_jrprofile_item` (
  `_item_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`_item_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `jr_jrprofile_item`
--

INSERT INTO `jr_jrprofile_item` VALUES
(1);

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrprofile_item_key`
--

CREATE TABLE `jr_jrprofile_item_key` (
  `_item_id` int(11) unsigned NOT NULL DEFAULT '0',
  `_profile_id` int(11) unsigned NOT NULL DEFAULT '0',
  `key` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `index` smallint(5) unsigned NOT NULL DEFAULT '0',
  `value` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`key`,`_item_id`,`index`),
  KEY `_item_id` (`_item_id`),
  KEY `_profile_id` (`_profile_id`),
  KEY `value` (`value`(128))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `jr_jrprofile_item_key`
--

INSERT INTO `jr_jrprofile_item_key` VALUES
(1, 1, '_created', 0, '[[timestamp]]'),
(1, 1, '_profile_id', 0, '1'),
(1, 1, '_updated', 0, '[[timestamp]]'),
(1, 1, '_user_id', 0, '1'),
(1, 1, 'profile_active', 0, '1'),
(1, 1, 'profile_jrBlog_item_count', 0, '1'),
(1, 1, 'profile_name', 0, '[[admin_username]]'),
(1, 1, 'profile_private', 0, '1'),
(1, 1, 'profile_quota_id', 0, '1'),
(1, 1, 'profile_url', 0, '[[admin_username]]');

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrprofile_profile_link`
--

CREATE TABLE `jr_jrprofile_profile_link` (
  `user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `profile_id` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`profile_id`),
  KEY `profile_id` (`profile_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `jr_jrprofile_profile_link`
--

INSERT INTO `jr_jrprofile_profile_link` VALUES
(1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrprofile_pulse`
--

CREATE TABLE `jr_jrprofile_pulse` (
  `pulse_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pulse_profile_id` int(11) unsigned NOT NULL DEFAULT '0',
  `pulse_module` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `pulse_key` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `pulse_updated` int(11) unsigned NOT NULL DEFAULT '0',
  `pulse_count` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`pulse_id`),
  UNIQUE KEY `pulse_unique` (`pulse_profile_id`,`pulse_module`,`pulse_key`),
  KEY `pulse_key` (`pulse_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrprofile_quota`
--

CREATE TABLE `jr_jrprofile_quota` (
  `quota_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `quota_created` int(11) unsigned NOT NULL DEFAULT '0',
  `quota_updated` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`quota_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `jr_jrprofile_quota`
--

INSERT INTO `jr_jrprofile_quota` VALUES
(1, [[timestamp]], [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrprofile_quota_setting`
--

CREATE TABLE `jr_jrprofile_quota_setting` (
  `module` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `created` int(11) unsigned NOT NULL DEFAULT '0',
  `default` varchar(4096) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'text',
  `validate` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `required` varchar(8) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'off',
  `min` int(11) unsigned NOT NULL DEFAULT '0',
  `max` int(11) unsigned NOT NULL DEFAULT '0',
  `options` varchar(8192) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sublabel` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `help` varchar(4096) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `section` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `order` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`module`,`name`),
  KEY `name` (`name`),
  KEY `order` (`order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `jr_jrprofile_quota_setting`
--

INSERT INTO `jr_jrprofile_quota_setting` VALUES
('jrAction', 'allowed', [[timestamp]], 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'allowed on profile', '', 'Should this Quota be allowed access to this module?', 'permissions', 1),
('jrAction', 'can_post', [[timestamp]], 'on', 'checkbox', 'onoff', 'on', 0, 0, '', 'can post activity updates', '', 'If this option is checked, the &quot;Post a new Activity Update&quot; form will appear at the top of their Activity Timeline where they can post an update.', 'permissions', 10),
('jrAction', 'pending', [[timestamp]], '0', 'select', 'number_nz', 'on', 0, 0, '["No Approval Needed","Approval on Create","Approval on Create and Update"]', 'Item Approval', '', 'When a new Item is created by a Profile in this Quota, should the item be placed in a pending state before being visible in the system?<br><br><b>No Approval Needed:</b> item is immediately visible.<br><b>Approval on Create:</b> item will need to be approved by an admin after being created.<br><b>Approval on Create and Update:</b> item will need to be approved by an admin after being created or updated.', 'permissions', 3),
('jrAction', 'show_add', [[timestamp]], 'on', 'checkbox', 'onoff', 'on', 0, 0, '', 'add to timeline option', '', 'If this option is checked, an &quot;Add To Timeline&quot; checkbox will appear in create/update forms that will allow the user to decide if they want their action added to their timeline.  If this is unchecked, then all actions will be recorded to the Timeline.', 'permissions', 11),
('jrAction', 'show_detail', [[timestamp]], 'off', 'checkbox', 'onoff', 'off', 0, 0, '', 'Show on Detail Pages', '', 'If this option is checked, a &quot;Share To Timeline&quot; button will show at the bottom of Item Detail Pages for profiles in this quota.', 'permissions', 12),
('jrBlog', 'allowed', [[timestamp]], 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'allowed on profile', '', 'Should this Quota be allowed access to this module?', 'permissions', 1),
('jrBlog', 'max_items', [[timestamp]], '0', 'text', 'number_nn', 'on', 0, 0, '', 'max items', '', 'How many items of this type can a profile create in this Quota?  Set to zero (0) to allow an unlimited number of items to be created.', 'permissions', 2),
('jrBlog', 'pending', [[timestamp]], '0', 'select', 'number_nz', 'on', 0, 0, '["No Approval Needed","Approval on Create","Approval on Create and Update"]', 'Item Approval', '', 'When a new Item is created by a Profile in this Quota, should the item be placed in a pending state before being visible in the system?<br><br><b>No Approval Needed:</b> item is immediately visible.<br><b>Approval on Create:</b> item will need to be approved by an admin after being created.<br><b>Approval on Create and Update:</b> item will need to be approved by an admin after being created or updated.', 'permissions', 3),
('jrCore', 'active_formatters', [[timestamp]], 'jrCore_format_string_allowed_html,jrCore_format_string_convert_at_tags,jrCore_format_string_clickable_urls', 'optionlist', 'printable', 'on', 0, 0, 'jrCore_get_format_string_listeners', 'Active Text Formatters', '', 'jrCore_get_format_string_help', 'text permissions', 3),
('jrCore', 'allow_all_html', [[timestamp]], 'off', 'checkbox', 'onoff', 'off', 0, 0, '', 'allow ALL HTML tags', '', 'If this options is checked, then ALL HTML tags will be allowed for profiles in this quota.<br><br><b>WARNING!</b> Enabling this option will allow users to embed HTML tags that could compromise your system security or affect the design and/or layout of your pages.<br><br>Enabling this option overrides the &quot;Allowed HTML Tags&quot; option below.', 'text permissions', 1),
('jrCore', 'allowed_tags', [[timestamp]], 'span,strong,em,a,b,u,i,p,div,br,img,h1,h2,h3,h4,pre,hr,ul,ol,li,sub,sup,table,tbody,th,tr,td', 'text', 'printable', 'on', 0, 0, '', 'allowed HTML tags', '', 'For profiles in this quota, when they enter text into a textarea, what HTML tags do you want to allow in the text? Separate multiple tags with commas.<br><br><b>CAUTION:</b> The safest option is to not allow ANY HTML in any output, or only allow tags that do not have a &quot;src&quot; attribute. <br><br><b>NOTE:</b> If you are using the Editor Embedded Media, to allow your users to use all the possible editor buttons, use: <br> span,strong,em,a,b,u,i,p,div,br,img,h1,h2,h3,h4,pre,hr,ul,ol,li,sub,sup', 'text permissions', 2),
('jrCore', 'disk', [[timestamp]], '0', 'select', 'number_nn', 'off', 0, 0, '{"0":"unlimited","10":"10MB","20":"20MB","30":"30MB","40":"40MB","50":"50MB","60":"60MB","70":"70MB","80":"80MB","90":"90MB","100":"100MB","150":"150MB","200":"200MB","250":"250MB","300":"300MB","350":"350MB","400":"400MB","450":"450MB","500":"500MB","550":"550MB","600":"600MB","650":"650MB","700":"700MB","750":"750MB","800":"800MB","850":"850MB","900":"900MB","950":"950MB","1024":"1GB","1536":"1.5GB","2048":"2GB","2560":"2.5GB","3072":"3GB","3584":"3.5GB","4096":"4GB","4608":"4.5GB","5120":"5GB","6144":"6GB","7168":"7GB","8192":"8GB","9216":"9GB","10240":"10GB"}', 'media space', '', 'How much disk space should profiles in this quota be allowed to have for media items?', 'resources', 10),
('jrCore', 'max_upload_size', [[timestamp]], '20971520', 'select', 'number_nz', 'on', 0, 0, 'jrCore_get_upload_sizes', 'max upload size', '', 'Select the maximum allowed size for a file upload by a user to a profile in this quota.<br><br><b>NOTE:</b> This value is limited by the following settings in your server php.ini file: post_max_size, upload_max_filesize and memory_limit.  The upload size will be smaller than these settings due to the overhead involved in the Upload Progress Meter.  To change these values contact your hosting provider.', 'resources', 11),
('jrDisqus', 'allowed', [[timestamp]], 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'allowed on profile', '', 'Should this Quota be allowed access to this module?', 'permissions', 1),
('jrDisqus', 'show_detail', [[timestamp]], 'on', 'checkbox', 'onoff', 'off', 0, 0, '', 'Show on Detail Pages', '', 'If this option is checked, a Disqus Comments section will show at the bottom of Item Detail Pages for profiles in this quota.', 'permissions', 2),
('jrEmbed', 'allowed', [[timestamp]], 'on', 'checkbox', 'onoff', 'on', 0, 0, '', 'allowed on profile', '', 'Should this Quota be allowed access to this module?', 'permissions', 1),
('jrFollower', 'share_type', [[timestamp]], '', 'select', 'not_empty', 'off', 0, 0, '{"user":"User Option","always":"Create Timeline entries for all follows","never":"No Timeline entries are created for follows"}', 'Follow Timeline Control', '', 'This setting controls whether or a not a Timeline entry is created when a user follows a profile:<br><br><b>User Option</b> - The User is in control if their follows show or not by setting the &quot;Share Who You Follow&quot; setting in the User Account section.<br><b>Create Timeline entries for all follows</b> - A timeline entry will always be created.<br><b>No Timeline entries are created for follows</b> - Timeline entries are never created.', '', 1),
('jrImage', 'allowed_image_types', [[timestamp]], 'png,gif,jpg,jpeg', 'optionlist', 'core_string', 'on', 0, 0, '{"png":"png","gif":"gif","jpg":"jpg","jpeg":"jpeg","webp":"webp"}', 'allowed image types', '', 'Select the image file types you would like to allow', '', 2),
('jrImage', 'max_image_size', [[timestamp]], '2097152', 'select', 'number_nz', 'on', 0, 0, 'jrImage_get_allowed_image_sizes', 'max image file size', '', 'Select the maximum allowed size for an image file upload by a user to a profile in this quota.<br><br><b>NOTE:</b> This value is limited by the following settings in your server php.ini file: post_max_size, upload_max_filesize and memory_limit.  The upload size will be smaller than these settings due to the overhead involved in the Upload Progress Meter. To change these values contact your hosting provider.', '', 1),
('jrImage', 'watermark', [[timestamp]], 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'watermark images', '', 'If this option is checked, when an image is displayed it will be watermarked using the watermark image that is active in the Image Support -> Images tab.<br><br><strong>NOTE:</strong> The uploaded watermark image MUST be a PNG image with transparency in order to work properly', 'watermark', 10),
('jrImage', 'watermark_cutoff', [[timestamp]], '80', 'text', 'number_nn', 'on', 0, 0, '', 'watermark cutoff', '', 'If an image has a width LOWER than this value, a watermark will not be applied to the image (this can save processing time for images that are too small for the watermark to be effective on).<br><br>Set this to 0 (zero) to enable watermarking for all images regardless of size.', 'watermark', 11),
('jrImage', 'watermark_sale_only', [[timestamp]], 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'only images for sale', '', 'If this option is checked then only images that <b>have a price</b> will have a watermark applied to them', 'watermark', 14),
('jrImage', 'watermark_x_offset', [[timestamp]], '-5', 'text', 'signed', 'on', 0, 0, '', 'watermark x offset', '', 'How many pixels from the top (positive) or the bottom (negative) do you want the watermark to appear?', 'watermark', 12),
('jrImage', 'watermark_y_offset', [[timestamp]], '-5', 'text', 'signed', 'on', 0, 0, '', 'watermark y offset', '', 'How many pixels from the left (positive) or the right (negative) do you want the watermark to appear?', 'watermark', 13),
('jrPage', 'allowed', [[timestamp]], 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'allowed on profile', '', 'Should this Quota be allowed access to this module?', 'permissions', 1),
('jrPage', 'max_items', [[timestamp]], '0', 'text', 'number_nn', 'on', 0, 0, '', 'max items', '', 'How many items of this type can a profile create in this Quota?  Set to zero (0) to allow an unlimited number of items to be created.', 'permissions', 2),
('jrPage', 'pending', [[timestamp]], '0', 'select', 'number_nz', 'on', 0, 0, '["No Approval Needed","Approval on Create","Approval on Create and Update"]', 'Item Approval', '', 'When a new Item is created by a Profile in this Quota, should the item be placed in a pending state before being visible in the system?<br><br><b>No Approval Needed:</b> item is immediately visible.<br><b>Approval on Create:</b> item will need to be approved by an admin after being created.<br><b>Approval on Create and Update:</b> item will need to be approved by an admin after being created or updated.', 'permissions', 3),
('jrProfile', 'admin_note', [[timestamp]], '', 'textarea', 'printable', 'off', 0, 0, '', 'quota admin note', '', 'You can save a note about this quota', '', 2),
('jrProfile', 'cap_type', [[timestamp]], 'hard', 'select', 'not_empty', 'off', 0, 0, '{"soft":"Soft Limit on Items","hard":"Hard Limit on Items"}', 'quota limit type', '', 'The Quota Limit Type setting affects how items are shown on a Profile when a profile matches or exceeds the number of items allowed by their quota.<br><br><b>SOFT</b>: All items are viewable on the profile but the profile owners will no longer be able to add any new items until the number of items falls below the amount allowed in their quota.<br><br><b>HARD</b>: Items that exceed the number allowed in the quota will only be visible to admin users and profile owners.  All other users will see a notification that the profile has exceeded the number of items allowed.', '', 3),
('jrProfile', 'default_privacy', [[timestamp]], '1', 'select', 'number_nn', 'off', 0, 3, 'jrProfile_get_privacy_options', 'default profile privacy', '', 'Select the default profile privacy option - new profiles created in this Quota will have their profile privacy set to this value', '', 4),
('jrProfile', 'name', [[timestamp]], '', 'text', 'printable', 'off', 0, 0, '', 'quota name', '', 'What name would you like to use for this quota?', '', 1),
('jrProfile', 'privacy_changes', [[timestamp]], 'on', 'checkbox', 'onoff', 'off', 0, 0, '', 'show privacy options', '', 'If this option is checked, Profiles in this quota will be allowed to change their Profile Privacy.  If unchecked, the Default Profile Privacy will be used instead.', '', 5),
('jrProfile', 'profile_count', [[timestamp]], '0', 'hidden', 'number_nz', 'off', 0, 0, '', 'profile count', '', '@internal tracks number of profiles in quota', '', 1),
('jrProfile', 'url_changes', [[timestamp]], 'off', 'checkbox', 'onoff', 'off', 0, 0, '', 'Custom Profile URL', '', 'If this option is checked, Profiles in this quota will be allowed to change their profile URL.  If unchecked, the profile URL is derived from their profile name.', '', 6),
('jrTOS', 'show_tos', [[timestamp]], '0', 'select', 'core_string', 'on', 0, 0, 'jrTOS_get_tos_pages', 'display terms of service', '', 'Select the Terms of Service pages you want to display to Users with profiles in this quota on login. The user will be required to agree to the displayed Terms of Service before continuing.<br><br>To create new Terms of Service Pages, simply create a new Page in the Page Creator module, and include the keyword &quot;terms&quot; in the title of the new Page.', '', 1),
('jrTwoFactor', 'allowed', [[timestamp]], 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'allowed on profile', '', 'Should this Quota be allowed access to this module?', 'permissions', 1),
('jrUpimg', 'allowed', [[timestamp]], 'off', 'checkbox', 'onoff', 'on', 0, 0, '', 'allowed on profile', '', 'Should this Quota be allowed access to this module?', 'permissions', 1),
('jrUser', 'add_to_timeline', [[timestamp]], 'off', 'checkbox', 'onoff', 'off', 0, 0, '', 'add to timeline', '', 'If this option is checked, when a user signs up or logs in to this quota, the action will be added to the timeline.', '', 6),
('jrUser', 'allow_signups', [[timestamp]], 'off', 'checkbox', 'onoff', 'off', 0, 0, '', 'allow signups', '', 'If the &quot;Allow Signups&quot; option is <b>checked</b>, then new users signing up for your system will be able to signup directly to this Profile Quota.', '', 1),
('jrUser', 'device_notice', [[timestamp]], 'off', 'checkbox', 'onoff', 'off', 0, 0, '', 'new device notice', '', 'If this option is checked, when a user logs in for the first time on a new device, they will be sent an email notification letting them know about the login.', '', 3),
('jrUser', 'login_page', [[timestamp]], 'profile', 'text', 'printable', 'off', 0, 0, '', 'Login Redirect Page', '', 'After a successful login, what location should the user be redirected to?<br><br><strong>&quot;profile&quot;</strong> - User will be redirected to their Profile.<br><br><strong>&quot;index&quot;</strong> - User will be redirected to the Site index page.<br><br><strong>URL</strong> - Enter an actual URL (eg. http://www.yoursite.com/post_login_page) for the user to be redirected to.', '', 4),
('jrUser', 'power_user', [[timestamp]], 'off', 'checkbox', 'onoff', 'off', 0, 0, '', 'power user enabled', '', 'If this option is checked, User Accounts belonging to profiles in this Quota will be Power Users that can create new profiles.', 'power user', 10),
('jrUser', 'power_user_max', [[timestamp]], '2', 'text', 'number_nz', 'off', 0, 0, '', 'max profiles', '', 'How many profiles can a Power User in this quota create?', 'power user', 11),
('jrUser', 'power_user_quotas', [[timestamp]], '0', 'select_multiple', '', 'off', 0, 0, 'jrProfile_get_quotas', 'allowed quotas', '', 'When a Power User in this Quota creates a new Profile, what Quotas can they select for their new profile?', 'power user', 12),
('jrUser', 'signup_method', [[timestamp]], 'email', 'select', '', 'on', 0, 0, '{"instant":"Instant Validation","email":"Email Validation","admin":"Admin Validation"}', 'signup method', '', 'How should users signup for this Quota?<br><br><b>Instant Validation</b> - The new user account and profile are activated on signup.<br><b>Email Validation</b> - An activation email is sent on signup to activate the new account.<br><b>Admin Validation</b> - New users will be put into the PENDING tab of the dashboard for an admin user to approve.', '', 2),
('jrUser', 'signup_page', [[timestamp]], 'profile', 'text', 'printable', 'off', 0, 0, '', 'Signup Redirect Page', '', 'After a successful signup, what location should the user be redirected to?<br><br><strong>&quot;profile&quot;</strong> - User will be redirected to their Profile.<br><br><strong>&quot;index&quot;</strong> - User will be redirected to the Site index page.<br><br><strong>URL</strong> - Enter an actual URL (eg. http://www.yoursite.com/post_login_page) for the user to be redirected to.', '', 5);

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrprofile_quota_value`
--

CREATE TABLE `jr_jrprofile_quota_value` (
  `quota_id` int(11) unsigned NOT NULL DEFAULT '0',
  `module` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `updated` int(11) unsigned NOT NULL DEFAULT '0',
  `value` varchar(8196) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`quota_id`,`module`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `jr_jrprofile_quota_value`
--

INSERT INTO `jr_jrprofile_quota_value` VALUES
(1, 'jrAction', 'allowed', [[timestamp]], 'on', 'system'),
(1, 'jrBlog', 'allowed', [[timestamp]], 'on', 'system'),
(1, 'jrCore', 'active_formatters', [[timestamp]], 'jrCore_format_string_allowed_html,jrCore_format_string_convert_at_tags,jrCore_format_string_clickable_urls,jrAction_format_string_convert_hash_tags,jrEmbed_format_string_embed_tags', 'system'),
(1, 'jrDisqus', 'allowed', [[timestamp]], 'on', 'system'),
(1, 'jrEmbed', 'allowed', [[timestamp]], 'on', 'system'),
(1, 'jrPage', 'allowed', [[timestamp]], 'on', 'system'),
(1, 'jrProfile', 'name', [[timestamp]], 'example quota', 'system'),
(1, 'jrProfile', 'profile_count', [[timestamp]], '1', 'system'),
(1, 'jrTwoFactor', 'allowed', [[timestamp]], 'on', 'system'),
(1, 'jrUpimg', 'allowed', [[timestamp]], 'on', 'system'),
(1, 'jrUser', 'allow_signups', [[timestamp]], 'on', 'system');

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrsearch_fulltext`
--

CREATE TABLE `jr_jrsearch_fulltext` (
  `s_module` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `s_id` int(11) unsigned NOT NULL DEFAULT '0',
  `s_mod` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `s_text` text COLLATE utf8_unicode_ci NOT NULL,
  UNIQUE KEY `s_unique` (`s_module`,`s_id`,`s_mod`),
  FULLTEXT KEY `s_text` (`s_text`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `jr_jrsearch_fulltext`
--

INSERT INTO `jr_jrsearch_fulltext` VALUES
('jrBlog', 1, 1, 'Thank you for installing Jamroom! Jamroom is an easy to use, and easy to customize CMS that centers around User Profiles. With excellent media support, thousands of sites have been using Jamroom to power their social media needs for over 13 years. When logged in to your new site, click on the &quot;Tour&quot; tabs available in many of the modules - these small tips and tours will help you quickly get up to speed on how Jamroom works and how it can be customized to suit your needs. Make sure and join us on Jamroom.net: https://www.jamroom.net and let us know how you''re using Jamroom - we love getting feedback on how we can make Jamroom better. Thanks again for installing Jamroom - we hope you enjoy using it and hope to see you online! - The Jamroom Team'),
('jrBlog', 1, 3, 'Welcome to Jamroom'),
('jrProfile', 1, 3, '[[admin_username]]'),
('jrUser', 1, 3, '[[admin_username]]');

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrsearch_item`
--

CREATE TABLE `jr_jrsearch_item` (
  `_item_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrsearch_item_key`
--

CREATE TABLE `jr_jrsearch_item_key` (
  `_item_id` int(11) unsigned NOT NULL DEFAULT '0',
  `_profile_id` int(11) unsigned NOT NULL DEFAULT '0',
  `key` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `index` smallint(5) unsigned NOT NULL DEFAULT '0',
  `value` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`key`,`_item_id`,`index`),
  KEY `_item_id` (`_item_id`),
  KEY `_profile_id` (`_profile_id`),
  KEY `value` (`value`(128))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrsitebuilder_backup`
--

CREATE TABLE `jr_jrsitebuilder_backup` (
  `backup_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `backup_time` int(11) unsigned NOT NULL DEFAULT '0',
  `backup_data` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`backup_id`),
  UNIQUE KEY `backup_time` (`backup_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrsitebuilder_menu`
--

CREATE TABLE `jr_jrsitebuilder_menu` (
  `menu_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `menu_updated` int(11) unsigned NOT NULL DEFAULT '0',
  `menu_parent_id` int(11) unsigned NOT NULL DEFAULT '0',
  `menu_order` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `menu_title` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `menu_url` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `menu_group` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `menu_onclick` varchar(2048) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`menu_id`),
  KEY `menu_parent_id` (`menu_parent_id`),
  KEY `menu_order` (`menu_order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrsitebuilder_page`
--

CREATE TABLE `jr_jrsitebuilder_page` (
  `page_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `page_updated` int(11) unsigned NOT NULL DEFAULT '0',
  `page_uri` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `page_title` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `page_groups` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `page_active` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `page_layout` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `page_settings` text COLLATE utf8_unicode_ci NOT NULL,
  `page_head` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`page_id`),
  UNIQUE KEY `page_uri` (`page_uri`),
  KEY `page_title` (`page_title`),
  KEY `page_active` (`page_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrsitebuilder_template`
--

CREATE TABLE `jr_jrsitebuilder_template` (
  `template_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `template_module` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `template_created` int(11) unsigned NOT NULL DEFAULT '0',
  `template_updated` int(11) unsigned NOT NULL DEFAULT '0',
  `template_name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `template_body` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`template_id`),
  UNIQUE KEY `template_unique` (`template_module`,`template_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrsitebuilder_widget`
--

CREATE TABLE `jr_jrsitebuilder_widget` (
  `widget_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `widget_updated` int(11) unsigned NOT NULL DEFAULT '0',
  `widget_page_id` int(11) unsigned NOT NULL DEFAULT '0',
  `widget_location` int(11) unsigned NOT NULL DEFAULT '0',
  `widget_weight` int(11) unsigned NOT NULL DEFAULT '0',
  `widget_groups` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `widget_title` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `widget_module` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `widget_name` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `widget_data` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `widget_unique` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`widget_id`),
  KEY `widget_page_id` (`widget_page_id`),
  KEY `widget_name` (`widget_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrtwofactor_session`
--

CREATE TABLE `jr_jrtwofactor_session` (
  `factor_code` varchar(8) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `factor_created` int(11) unsigned NOT NULL DEFAULT '0',
  `factor_user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `factor_session` text COLLATE utf8_unicode_ci NOT NULL,
  UNIQUE KEY `factor_index` (`factor_code`,`factor_user_id`),
  KEY `factor_created` (`factor_created`),
  KEY `factor_user_id` (`factor_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrupimg_item`
--

CREATE TABLE `jr_jrupimg_item` (
  `_item_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`_item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jrupimg_item_key`
--

CREATE TABLE `jr_jrupimg_item_key` (
  `_item_id` int(11) unsigned NOT NULL DEFAULT '0',
  `_profile_id` int(11) unsigned NOT NULL DEFAULT '0',
  `key` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `index` smallint(5) unsigned NOT NULL DEFAULT '0',
  `value` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`key`,`_item_id`,`index`),
  KEY `_item_id` (`_item_id`),
  KEY `_profile_id` (`_profile_id`),
  KEY `value` (`value`(128))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jruser_cookie`
--

CREATE TABLE `jr_jruser_cookie` (
  `cookie_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cookie_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cookie_time` int(10) unsigned NOT NULL DEFAULT '0',
  `cookie_value` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`cookie_id`),
  KEY `cookie_user_id` (`cookie_user_id`),
  KEY `cookie_time` (`cookie_time`),
  KEY `cookie_value` (`cookie_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jruser_device`
--

CREATE TABLE `jr_jruser_device` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `device_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ip_address` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `notified` tinyint(1) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `device` (`user_id`,`device_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jruser_forgot`
--

CREATE TABLE `jr_jruser_forgot` (
  `forgot_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `forgot_user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `forgot_time` int(10) unsigned NOT NULL DEFAULT '0',
  `forgot_key` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`forgot_id`),
  UNIQUE KEY `forgot_key` (`forgot_key`),
  KEY `forgot_user_id` (`forgot_user_id`),
  KEY `forgot_time` (`forgot_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jruser_item`
--

CREATE TABLE `jr_jruser_item` (
  `_item_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`_item_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `jr_jruser_item`
--

INSERT INTO `jr_jruser_item` VALUES
(1);

-- --------------------------------------------------------

--
-- Table structure for table `jr_jruser_item_key`
--

CREATE TABLE `jr_jruser_item_key` (
  `_item_id` int(11) unsigned NOT NULL DEFAULT '0',
  `_profile_id` int(11) unsigned NOT NULL DEFAULT '0',
  `key` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `index` smallint(5) unsigned NOT NULL DEFAULT '0',
  `value` varchar(512) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`key`,`_item_id`,`index`),
  KEY `_item_id` (`_item_id`),
  KEY `_profile_id` (`_profile_id`),
  KEY `value` (`value`(128))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `jr_jruser_item_key`
--

INSERT INTO `jr_jruser_item_key` VALUES
(1, 1, '_created', 0, '[[timestamp]]'),
(1, 1, '_profile_id', 0, '1'),
(1, 1, '_updated', 0, '[[timestamp]]'),
(1, 1, '_user_id', 0, '1'),
(1, 1, 'user_active', 0, '1'),
(1, 1, 'user_email', 0, '[[admin_email]]'),
(1, 1, 'user_group', 0, 'master'),
(1, 1, 'user_jrBlog_item_count', 0, '1'),
(1, 1, 'user_language', 0, 'en-US'),
(1, 1, 'user_last_login', 0, '[[timestamp]]'),
(1, 1, 'user_name', 0, '[[admin_username]]'),
(1, 1, 'user_password', 0, '[[admin_pass]]'),
(1, 1, 'user_validate', 0, '[[user_validate]]'),
(1, 1, 'user_validated', 0, '1');

-- --------------------------------------------------------

--
-- Table structure for table `jr_jruser_language`
--

CREATE TABLE `jr_jruser_language` (
  `lang_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `lang_module` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `lang_code` varchar(12) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'en-US',
  `lang_charset` varchar(12) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'utf-8',
  `lang_ltr` varchar(12) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'ltr',
  `lang_key` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `lang_text` varchar(1024) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `lang_default` varchar(1024) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`lang_id`),
  KEY `lang_module` (`lang_module`),
  KEY `lang_code` (`lang_code`),
  KEY `lang_key` (`lang_key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=695 ;

--
-- Dumping data for table `jr_jruser_language`
--

INSERT INTO `jr_jruser_language` VALUES
(1, 'jrCore', 'en-US', 'utf-8', 'ltr', '1', 'save', 'save'),
(2, 'jrCore', 'en-US', 'utf-8', 'ltr', '2', 'cancel', 'cancel'),
(3, 'jrCore', 'en-US', 'utf-8', 'ltr', '3', 'options', 'options'),
(4, 'jrCore', 'en-US', 'utf-8', 'ltr', '4', 'settings', 'settings'),
(5, 'jrCore', 'en-US', 'utf-8', 'ltr', '5', 'tools', 'tools'),
(6, 'jrCore', 'en-US', 'utf-8', 'ltr', '6', 'config', 'config'),
(7, 'jrCore', 'en-US', 'utf-8', 'ltr', '7', 'enable', 'enable'),
(8, 'jrCore', 'en-US', 'utf-8', 'ltr', '8', 'search', 'search'),
(9, 'jrCore', 'en-US', 'utf-8', 'ltr', '9', 'undo changes', 'undo changes'),
(10, 'jrCore', 'en-US', 'utf-8', 'ltr', '10', 'January', 'January'),
(11, 'jrCore', 'en-US', 'utf-8', 'ltr', '11', 'February', 'February'),
(12, 'jrCore', 'en-US', 'utf-8', 'ltr', '12', 'March', 'March'),
(13, 'jrCore', 'en-US', 'utf-8', 'ltr', '13', 'April', 'April'),
(14, 'jrCore', 'en-US', 'utf-8', 'ltr', '14', 'May', 'May'),
(15, 'jrCore', 'en-US', 'utf-8', 'ltr', '15', 'June', 'June'),
(16, 'jrCore', 'en-US', 'utf-8', 'ltr', '16', 'July', 'July'),
(17, 'jrCore', 'en-US', 'utf-8', 'ltr', '17', 'August', 'August'),
(18, 'jrCore', 'en-US', 'utf-8', 'ltr', '18', 'September', 'September'),
(19, 'jrCore', 'en-US', 'utf-8', 'ltr', '19', 'October', 'October'),
(20, 'jrCore', 'en-US', 'utf-8', 'ltr', '20', 'November', 'November'),
(21, 'jrCore', 'en-US', 'utf-8', 'ltr', '21', 'December', 'December'),
(22, 'jrCore', 'en-US', 'utf-8', 'ltr', '22', 'notice', 'notice'),
(23, 'jrCore', 'en-US', 'utf-8', 'ltr', '23', 'warning', 'warning'),
(24, 'jrCore', 'en-US', 'utf-8', 'ltr', '24', 'error', 'error'),
(25, 'jrCore', 'en-US', 'utf-8', 'ltr', '25', 'success', 'success'),
(26, 'jrCore', 'en-US', 'utf-8', 'ltr', '26', '&lt;', '&lt;'),
(27, 'jrCore', 'en-US', 'utf-8', 'ltr', '27', '&gt;', '&gt;'),
(28, 'jrCore', 'en-US', 'utf-8', 'ltr', '28', 'close', 'close'),
(29, 'jrCore', 'en-US', 'utf-8', 'ltr', '29', 'clear', 'clear'),
(30, 'jrCore', 'en-US', 'utf-8', 'ltr', '30', 'You have entered an invalid value for &quot;', 'You have entered an invalid value for &quot;'),
(31, 'jrCore', 'en-US', 'utf-8', 'ltr', '31', '&quot; - value must be', '&quot; - value must be'),
(32, 'jrCore', 'en-US', 'utf-8', 'ltr', '32', 'date', 'date'),
(33, 'jrCore', 'en-US', 'utf-8', 'ltr', '33', 'log text', 'log text'),
(34, 'jrCore', 'en-US', 'utf-8', 'ltr', '34', 'expand help', 'expand help'),
(35, 'jrCore', 'en-US', 'utf-8', 'ltr', '35', 'only site admins can log in while the site is in maintenance mode', 'only site admins can log in while the site is in maintenance mode'),
(36, 'jrCore', 'en-US', 'utf-8', 'ltr', '36', 'create', 'create'),
(37, 'jrCore', 'en-US', 'utf-8', 'ltr', '37', 'update', 'update'),
(38, 'jrCore', 'en-US', 'utf-8', 'ltr', '38', 'delete', 'delete'),
(39, 'jrCore', 'en-US', 'utf-8', 'ltr', '39', 'select', 'select'),
(40, 'jrCore', 'en-US', 'utf-8', 'ltr', '40', 'Delete this item?', 'Delete this item?'),
(41, 'jrCore', 'en-US', 'utf-8', 'ltr', '41', 'You do not have the proper privileges to perform that action!', 'You do not have the proper privileges to perform that action!'),
(42, 'jrCore', 'en-US', 'utf-8', 'ltr', '42', 'The file(s) you attempted to upload are larger then allowed - please select smaller files for upload.', 'The file(s) you attempted to upload are larger then allowed - please select smaller files for upload.'),
(43, 'jrCore', 'en-US', 'utf-8', 'ltr', '43', 'upload a file', 'upload a file'),
(44, 'jrCore', 'en-US', 'utf-8', 'ltr', '44', 'upload failed', 'upload failed'),
(45, 'jrCore', 'en-US', 'utf-8', 'ltr', '45', 'upload files', 'upload files'),
(46, 'jrCore', 'en-US', 'utf-8', 'ltr', '46', 'upload another', 'upload another'),
(47, 'jrCore', 'en-US', 'utf-8', 'ltr', '47', 'select existing:', 'select existing:'),
(48, 'jrCore', 'en-US', 'utf-8', 'ltr', '48', 'New Value', 'New Value'),
(49, 'jrCore', 'en-US', 'utf-8', 'ltr', '49', 'max upload:', 'max upload:'),
(50, 'jrCore', 'en-US', 'utf-8', 'ltr', '50', 'Create New Entry', 'Create New Entry'),
(51, 'jrCore', 'en-US', 'utf-8', 'ltr', '51', 'seconds ago', 'seconds ago'),
(52, 'jrCore', 'en-US', 'utf-8', 'ltr', '52', 'a second ago', 'a second ago'),
(53, 'jrCore', 'en-US', 'utf-8', 'ltr', '53', 'minutes ago', 'minutes ago'),
(54, 'jrCore', 'en-US', 'utf-8', 'ltr', '54', 'a minute ago', 'a minute ago'),
(55, 'jrCore', 'en-US', 'utf-8', 'ltr', '55', 'hours ago', 'hours ago'),
(56, 'jrCore', 'en-US', 'utf-8', 'ltr', '56', 'an hour ago', 'an hour ago'),
(57, 'jrCore', 'en-US', 'utf-8', 'ltr', '57', 'days ago', 'days ago'),
(58, 'jrCore', 'en-US', 'utf-8', 'ltr', '58', 'yesterday', 'yesterday'),
(59, 'jrCore', 'en-US', 'utf-8', 'ltr', '59', 'weeks ago', 'weeks ago'),
(60, 'jrCore', 'en-US', 'utf-8', 'ltr', '60', 'one week ago', 'one week ago'),
(61, 'jrCore', 'en-US', 'utf-8', 'ltr', '61', 'months ago', 'months ago'),
(62, 'jrCore', 'en-US', 'utf-8', 'ltr', '62', 'one month ago', 'one month ago'),
(63, 'jrCore', 'en-US', 'utf-8', 'ltr', '63', 'years ago', 'years ago'),
(64, 'jrCore', 'en-US', 'utf-8', 'ltr', '64', 'last year', 'last year'),
(65, 'jrCore', 'en-US', 'utf-8', 'ltr', '65', 'There is already an entry using the same ', 'There is already an entry using the same '),
(66, 'jrCore', 'en-US', 'utf-8', 'ltr', '66', ' - please enter a unique value', ' - please enter a unique value'),
(67, 'jrCore', 'en-US', 'utf-8', 'ltr', '67', 'Your entry contains the following text which is not allowed: ', 'Your entry contains the following text which is not allowed: '),
(68, 'jrCore', 'en-US', 'utf-8', 'ltr', '68', 'Allowed File Types:', 'Allowed File Types:'),
(69, 'jrCore', 'en-US', 'utf-8', 'ltr', '69', '(per file)', '(per file)'),
(70, 'jrCore', 'en-US', 'utf-8', 'ltr', '70', 'You have created the maximum number of items of this type allowed by your Quota plan', 'You have created the maximum number of items of this type allowed by your Quota plan'),
(71, 'jrCore', 'en-US', 'utf-8', 'ltr', '71', 'This item is currently pending approval by an admin, and will be visible to other users once approved.', 'This item is currently pending approval by an admin, and will be visible to other users once approved.'),
(72, 'jrCore', 'en-US', 'utf-8', 'ltr', '72', 'save changes', 'save changes'),
(73, 'jrCore', 'en-US', 'utf-8', 'ltr', '73', 'working...', 'working...'),
(74, 'jrCore', 'en-US', 'utf-8', 'ltr', '74', 'name', 'name'),
(75, 'jrCore', 'en-US', 'utf-8', 'ltr', '75', 'size', 'size'),
(76, 'jrCore', 'en-US', 'utf-8', 'ltr', '76', 'date', 'date'),
(77, 'jrCore', 'en-US', 'utf-8', 'ltr', '77', 'Your item has been approved and is now on your profile!', 'Your item has been approved and is now on your profile!'),
(78, 'jrCore', 'en-US', 'utf-8', 'ltr', '78', 'Your item has been rejected for the following reasons:', 'Your item has been rejected for the following reasons:'),
(79, 'jrCore', 'en-US', 'utf-8', 'ltr', '79', 'Once you fix these issues it can be viewable on your profile.', 'Once you fix these issues it can be viewable on your profile.'),
(80, 'jrCore', 'en-US', 'utf-8', 'ltr', '80', 'Your item has been rejected - please resubmit', 'Your item has been rejected - please resubmit'),
(81, 'jrCore', 'en-US', 'utf-8', 'ltr', '81', 'You forgot to select a file to upload', 'You forgot to select a file to upload'),
(82, 'jrCore', 'en-US', 'utf-8', 'ltr', '82', 'item(s) max', 'item(s) max'),
(83, 'jrCore', 'en-US', 'utf-8', 'ltr', '83', 'set item order', 'set item order'),
(84, 'jrCore', 'en-US', 'utf-8', 'ltr', '84', 'Not Found', 'Not Found'),
(85, 'jrCore', 'en-US', 'utf-8', 'ltr', '85', 'drag and drop entries to set order', 'drag and drop entries to set order'),
(86, 'jrCore', 'en-US', 'utf-8', 'ltr', '86', 'item order successfully updated', 'item order successfully updated'),
(87, 'jrCore', 'en-US', 'utf-8', 'ltr', '87', 'continue', 'continue'),
(88, 'jrCore', 'en-US', 'utf-8', 'ltr', '88', 'This item will require admin approval before it is visible to other users', 'This item will require admin approval before it is visible to other users'),
(89, 'jrCore', 'en-US', 'utf-8', 'ltr', '89', 'Attach File', 'Attach File'),
(90, 'jrCore', 'en-US', 'utf-8', 'ltr', '90', 'Attachments', 'Attachments'),
(91, 'jrCore', 'en-US', 'utf-8', 'ltr', '91', 'Delete this attachment?', 'Delete this attachment?'),
(92, 'jrCore', 'en-US', 'utf-8', 'ltr', '92', 'download', 'download'),
(93, 'jrCore', 'en-US', 'utf-8', 'ltr', '93', 'Please enter a valid 4 digit year in YYYY format', 'Please enter a valid 4 digit year in YYYY format'),
(94, 'jrCore', 'en-US', 'utf-8', 'ltr', '94', 'Please select a valid month name from the list', 'Please select a valid month name from the list'),
(95, 'jrCore', 'en-US', 'utf-8', 'ltr', '95', 'Please select a valid day of the month from the list', 'Please select a valid day of the month from the list'),
(96, 'jrCore', 'en-US', 'utf-8', 'ltr', '96', 'Quote', 'Quote'),
(97, 'jrCore', 'en-US', 'utf-8', 'ltr', '97', 'pending item approved', 'pending item approved'),
(98, 'jrCore', 'en-US', 'utf-8', 'ltr', '98', 'When a pending item is approved, how do you want to be notified?', 'When a pending item is approved, how do you want to be notified?'),
(99, 'jrCore', 'en-US', 'utf-8', 'ltr', '99', 'This item has been rejected and needs to be updated before it can be approved', 'This item has been rejected and needs to be updated before it can be approved'),
(100, 'jrCore', 'en-US', 'utf-8', 'ltr', '100', ', with a minimum value of %1', ', with a minimum value of %1'),
(101, 'jrCore', 'en-US', 'utf-8', 'ltr', '101', ', with a maximum value of %1', ', with a maximum value of %1'),
(102, 'jrCore', 'en-US', 'utf-8', 'ltr', '102', ' and at least %1 character(s) long', ' and at least %1 character(s) long'),
(103, 'jrCore', 'en-US', 'utf-8', 'ltr', '103', ', with a maximum length of %1 characters', ', with a maximum length of %1 characters'),
(104, 'jrCore', 'en-US', 'utf-8', 'ltr', '104', 'printable characters with the following allowed HTML tags:', 'printable characters with the following allowed HTML tags:'),
(105, 'jrCore', 'en-US', 'utf-8', 'ltr', '105', 'printable characters and HTML allowed by Quota', 'printable characters and HTML allowed by Quota'),
(106, 'jrCore', 'en-US', 'utf-8', 'ltr', '106', 'the numbers 0-9, letters a-z and _ (underscore)', 'the numbers 0-9, letters a-z and _ (underscore)'),
(107, 'jrCore', 'en-US', 'utf-8', 'ltr', '107', 'the numbers 0-9, letters a-z, _ (underscore), - (dash) and spaces', 'the numbers 0-9, letters a-z, _ (underscore), - (dash) and spaces'),
(108, 'jrCore', 'en-US', 'utf-8', 'ltr', '108', 'the numbers 0-9, letters a-z, _ and - (dash) or %', 'the numbers 0-9, letters a-z, _ and - (dash) or %'),
(109, 'jrCore', 'en-US', 'utf-8', 'ltr', '109', 'the numbers 0-9, letters a-z, _ and - (dash) and . (dot)', 'the numbers 0-9, letters a-z, _ and - (dash) and . (dot)'),
(110, 'jrCore', 'en-US', 'utf-8', 'ltr', '110', 'boolean or string TRUE or int or string 1', 'boolean or string TRUE or int or string 1'),
(111, 'jrCore', 'en-US', 'utf-8', 'ltr', '111', 'a string', 'a string'),
(112, 'jrCore', 'en-US', 'utf-8', 'ltr', '112', 'a valid domain name (no www)', 'a valid domain name (no www)'),
(113, 'jrCore', 'en-US', 'utf-8', 'ltr', '113', 'numbers, letters, spaces or punctuation and contain no HTML', 'numbers, letters, spaces or punctuation and contain no HTML'),
(114, 'jrCore', 'en-US', 'utf-8', 'ltr', '114', 'a valid date', 'a valid date'),
(115, 'jrCore', 'en-US', 'utf-8', 'ltr', '115', 'a valid date in the format YYYYMMDD', 'a valid date in the format YYYYMMDD'),
(116, 'jrCore', 'en-US', 'utf-8', 'ltr', '116', 'a valid email address', 'a valid email address'),
(117, 'jrCore', 'en-US', 'utf-8', 'ltr', '117', 'a floating point number', 'a floating point number'),
(118, 'jrCore', 'en-US', 'utf-8', 'ltr', '118', 'a hexadecimal value', 'a hexadecimal value'),
(119, 'jrCore', 'en-US', 'utf-8', 'ltr', '119', 'a valid IP Address', 'a valid IP Address'),
(120, 'jrCore', 'en-US', 'utf-8', 'ltr', '120', 'a reserved (private) IP Address', 'a reserved (private) IP Address'),
(121, 'jrCore', 'en-US', 'utf-8', 'ltr', '121', 'a 32 character MD5 hash', 'a 32 character MD5 hash'),
(122, 'jrCore', 'en-US', 'utf-8', 'ltr', '122', 'a string with more than 1 word', 'a string with more than 1 word'),
(123, 'jrCore', 'en-US', 'utf-8', 'ltr', '123', 'a whole number greater than 0 (zero)', 'a whole number greater than 0 (zero)'),
(124, 'jrCore', 'en-US', 'utf-8', 'ltr', '124', 'a whole number greater than or equal to 0 (zero)', 'a whole number greater than or equal to 0 (zero)'),
(125, 'jrCore', 'en-US', 'utf-8', 'ltr', '125', 'a whole number (unsigned)', 'a whole number (unsigned)'),
(126, 'jrCore', 'en-US', 'utf-8', 'ltr', '126', 'a signed (+, -) whole number', 'a signed (+, -) whole number'),
(127, 'jrCore', 'en-US', 'utf-8', 'ltr', '127', 'either on or off (checkbox)', 'either on or off (checkbox)'),
(128, 'jrCore', 'en-US', 'utf-8', 'ltr', '128', 'a price in D.CC format', 'a price in D.CC format'),
(129, 'jrCore', 'en-US', 'utf-8', 'ltr', '129', 'a 40 character SHA1 hash', 'a 40 character SHA1 hash'),
(130, 'jrCore', 'en-US', 'utf-8', 'ltr', '130', 'a string that does not contain HTML or hidden characters', 'a string that does not contain HTML or hidden characters'),
(131, 'jrCore', 'en-US', 'utf-8', 'ltr', '131', 'a valid URL', 'a valid URL'),
(132, 'jrCore', 'en-US', 'utf-8', 'ltr', '132', 'either yes or no', 'either yes or no'),
(133, 'jrCore', 'en-US', 'utf-8', 'ltr', '133', 'a JSON encoded string', 'a JSON encoded string'),
(134, 'jrCore', 'en-US', 'utf-8', 'ltr', '134', 'Uploaded file is too large - maximum allowed size is', 'Uploaded file is too large - maximum allowed size is'),
(135, 'jrCore', 'en-US', 'utf-8', 'ltr', '135', 'Invalid file type - the file extension must match one of the following: ', 'Invalid file type - the file extension must match one of the following: '),
(136, 'jrCore', 'en-US', 'utf-8', 'ltr', '136', 'Sun', 'Sun'),
(137, 'jrCore', 'en-US', 'utf-8', 'ltr', '137', 'Mon', 'Mon'),
(138, 'jrCore', 'en-US', 'utf-8', 'ltr', '138', 'Tue', 'Tue'),
(139, 'jrCore', 'en-US', 'utf-8', 'ltr', '139', 'Wed', 'Wed'),
(140, 'jrCore', 'en-US', 'utf-8', 'ltr', '140', 'Thu', 'Thu'),
(141, 'jrCore', 'en-US', 'utf-8', 'ltr', '141', 'Fri', 'Fri'),
(142, 'jrCore', 'en-US', 'utf-8', 'ltr', '142', 'Sat', 'Sat'),
(143, 'jrCore', 'en-US', 'utf-8', 'ltr', '143', 'per page', 'per page'),
(144, 'jrCore', 'en-US', 'utf-8', 'ltr', '144', 'Pounds', 'Pounds'),
(145, 'jrCore', 'en-US', 'utf-8', 'ltr', '145', 'Kilograms', 'Kilograms'),
(146, 'jrCore', 'en-US', 'utf-8', 'ltr', '146', 'An error was encountered loading the media URL', 'An error was encountered loading the media URL'),
(147, 'jrCore', 'en-US', 'utf-8', 'ltr', '147', 'The file was successfully deleted', 'The file was successfully deleted'),
(148, 'jrCore', 'en-US', 'utf-8', 'ltr', '148', 'Direct Links to download media are blocked', 'Direct Links to download media are blocked'),
(149, 'jrCore', 'en-US', 'utf-8', 'ltr', '149', 'You must be logged in to stream media', 'You must be logged in to stream media'),
(150, 'jrCore', 'en-US', 'utf-8', 'ltr', '150', 'log in', 'log in'),
(151, 'jrCore', 'en-US', 'utf-8', 'ltr', '151', 'You must be logged in to download', 'You must be logged in to download'),
(152, 'jrCore', 'en-US', 'utf-8', 'ltr', '152', 'boolean or string FALSE or int or string 0', 'boolean or string FALSE or int or string 0'),
(153, 'jrCore', 'en-US', 'utf-8', 'ltr', '153', 'a phone number', 'a phone number'),
(154, 'jrCore', 'en-US', 'utf-8', 'ltr', '154', 'an age range', 'an age range'),
(155, 'jrCore', 'en-US', 'utf-8', 'ltr', '155', 'a unique user or profile name', 'a unique user or profile name'),
(156, 'jrCore', 'en-US', 'utf-8', 'ltr', '156', 'Ending', 'Ending'),
(157, 'jrCore', 'en-US', 'utf-8', 'ltr', '157', 'Every Day', 'Every Day'),
(158, 'jrCore', 'en-US', 'utf-8', 'ltr', '158', 'Every 2nd Day', 'Every 2nd Day'),
(159, 'jrCore', 'en-US', 'utf-8', 'ltr', '159', 'Every 3rd Day', 'Every 3rd Day'),
(160, 'jrCore', 'en-US', 'utf-8', 'ltr', '160', 'Every 4th Day', 'Every 4th Day'),
(161, 'jrCore', 'en-US', 'utf-8', 'ltr', '161', 'Every 5th Day', 'Every 5th Day'),
(162, 'jrCore', 'en-US', 'utf-8', 'ltr', '162', 'Every 6th Day', 'Every 6th Day'),
(163, 'jrCore', 'en-US', 'utf-8', 'ltr', '163', 'Every Week', 'Every Week'),
(164, 'jrCore', 'en-US', 'utf-8', 'ltr', '164', 'Every 2 Weeks', 'Every 2 Weeks'),
(165, 'jrCore', 'en-US', 'utf-8', 'ltr', '165', 'Every 3 Weeks', 'Every 3 Weeks'),
(166, 'jrCore', 'en-US', 'utf-8', 'ltr', '166', 'Every 4 Weeks', 'Every 4 Weeks'),
(167, 'jrCore', 'en-US', 'utf-8', 'ltr', '167', 'Every 5 Weeks', 'Every 5 Weeks'),
(168, 'jrCore', 'en-US', 'utf-8', 'ltr', '168', 'Every 6 Weeks', 'Every 6 Weeks'),
(169, 'jrCore', 'en-US', 'utf-8', 'ltr', '169', 'Every Month', 'Every Month'),
(170, 'jrCore', 'en-US', 'utf-8', 'ltr', '170', 'Every 2 Months', 'Every 2 Months'),
(171, 'jrCore', 'en-US', 'utf-8', 'ltr', '171', 'Every 3 Months', 'Every 3 Months'),
(172, 'jrCore', 'en-US', 'utf-8', 'ltr', '172', 'Every 4 Months', 'Every 4 Months'),
(173, 'jrCore', 'en-US', 'utf-8', 'ltr', '173', 'Every 5 Months', 'Every 5 Months'),
(174, 'jrCore', 'en-US', 'utf-8', 'ltr', '174', 'Every 6 Months', 'Every 6 Months'),
(175, 'jrCore', 'en-US', 'utf-8', 'ltr', '175', 'Every Year', 'Every Year'),
(176, 'jrCore', 'en-US', 'utf-8', 'ltr', '176', 'Repeat...', 'Repeat...'),
(177, 'jrCore', 'en-US', 'utf-8', 'ltr', '177', 'in', 'in'),
(178, 'jrCore', 'en-US', 'utf-8', 'ltr', '178', 'seconds time', 'seconds time'),
(179, 'jrCore', 'en-US', 'utf-8', 'ltr', '179', 'in a second', 'in a second'),
(180, 'jrCore', 'en-US', 'utf-8', 'ltr', '180', 'minutes time', 'minutes time'),
(181, 'jrCore', 'en-US', 'utf-8', 'ltr', '181', 'in a minute', 'in a minute'),
(182, 'jrCore', 'en-US', 'utf-8', 'ltr', '182', 'hours time', 'hours time'),
(183, 'jrCore', 'en-US', 'utf-8', 'ltr', '183', 'in an hour', 'in an hour'),
(184, 'jrCore', 'en-US', 'utf-8', 'ltr', '184', 'days time', 'days time'),
(185, 'jrCore', 'en-US', 'utf-8', 'ltr', '185', 'tomorrow', 'tomorrow'),
(186, 'jrCore', 'en-US', 'utf-8', 'ltr', '186', 'weeks time', 'weeks time'),
(187, 'jrCore', 'en-US', 'utf-8', 'ltr', '187', 'next week', 'next week'),
(188, 'jrCore', 'en-US', 'utf-8', 'ltr', '188', 'months time', 'months time'),
(189, 'jrCore', 'en-US', 'utf-8', 'ltr', '189', 'next month', 'next month'),
(190, 'jrCore', 'en-US', 'utf-8', 'ltr', '190', 'years time', 'years time'),
(191, 'jrCore', 'en-US', 'utf-8', 'ltr', '191', 'next year', 'next year'),
(192, 'jrAction', 'en-US', 'utf-8', 'ltr', 'menu', 'Timeline', 'Timeline'),
(193, 'jrAction', 'en-US', 'utf-8', 'ltr', '1', 'Created new Item', 'Created new Item'),
(194, 'jrAction', 'en-US', 'utf-8', 'ltr', '2', 'Posted a new Update', 'Posted a new Update'),
(195, 'jrAction', 'en-US', 'utf-8', 'ltr', '3', 'Status Update', 'Status Update'),
(196, 'jrAction', 'en-US', 'utf-8', 'ltr', '4', 'Timeline', 'Timeline'),
(197, 'jrAction', 'en-US', 'utf-8', 'ltr', '5', 'save update', 'save update'),
(198, 'jrAction', 'en-US', 'utf-8', 'ltr', '6', 'characters left', 'characters left'),
(199, 'jrAction', 'en-US', 'utf-8', 'ltr', '7', 'Mentions', 'Mentions'),
(200, 'jrAction', 'en-US', 'utf-8', 'ltr', '8', 'Search', 'Search'),
(201, 'jrAction', 'en-US', 'utf-8', 'ltr', '9', 'Share this update with your followers?', 'Share this update with your followers?'),
(202, 'jrAction', 'en-US', 'utf-8', 'ltr', '10', 'Share This', 'Share This'),
(203, 'jrAction', 'en-US', 'utf-8', 'ltr', '11', 'Activity Stream', 'Activity Stream'),
(204, 'jrAction', 'en-US', 'utf-8', 'ltr', '12', 'mentioned in activity stream', 'mentioned in activity stream'),
(205, 'jrAction', 'en-US', 'utf-8', 'ltr', '13', 'share to timeline', 'share to timeline'),
(206, 'jrAction', 'en-US', 'utf-8', 'ltr', '14', 'Share this action with your followers in your timeline.', 'Share this action with your followers in your timeline.'),
(207, 'jrAction', 'en-US', 'utf-8', 'ltr', '15', 'timeline updates', 'timeline updates'),
(208, 'jrAction', 'en-US', 'utf-8', 'ltr', '16', 'If your profile name is mentioned in an Activity Stream do you want to be notified?', 'If your profile name is mentioned in an Activity Stream do you want to be notified?'),
(209, 'jrAction', 'en-US', 'utf-8', 'ltr', '17', 'You have just been mentioned by %1!', 'You have just been mentioned by %1!'),
(210, 'jrAction', 'en-US', 'utf-8', 'ltr', '18', '%1 has mentioned you:', '%1 has mentioned you:'),
(211, 'jrAction', 'en-US', 'utf-8', 'ltr', '19', 'A list of the most recent %1 actions by %2', 'A list of the most recent %1 actions by %2'),
(212, 'jrAction', 'en-US', 'utf-8', 'ltr', '20', 'share this: ', 'share this: '),
(213, 'jrAction', 'en-US', 'utf-8', 'ltr', '21', 'shared', 'shared'),
(214, 'jrAction', 'en-US', 'utf-8', 'ltr', '22', 'comments', 'comments'),
(215, 'jrAction', 'en-US', 'utf-8', 'ltr', '23', 'link to this', 'link to this'),
(216, 'jrAction', 'en-US', 'utf-8', 'ltr', '24', 'Shared By', 'Shared By'),
(217, 'jrAction', 'en-US', 'utf-8', 'ltr', '25', 'follower(s)', 'follower(s)'),
(218, 'jrAction', 'en-US', 'utf-8', 'ltr', '26', 'shared by you', 'shared by you'),
(219, 'jrAction', 'en-US', 'utf-8', 'ltr', '27', 'Timeline Update', 'Timeline Update'),
(220, 'jrAction', 'en-US', 'utf-8', 'ltr', '28', 'Update', 'Update'),
(221, 'jrAction', 'en-US', 'utf-8', 'ltr', '29', 'Timeline Entry', 'Timeline Entry'),
(222, 'jrAction', 'en-US', 'utf-8', 'ltr', '30', 'Update your Timeline post', 'Update your Timeline post'),
(223, 'jrAction', 'en-US', 'utf-8', 'ltr', '31', 'timeline feed', 'timeline feed'),
(224, 'jrAction', 'en-US', 'utf-8', 'ltr', '32', 'Add a Comment', 'Add a Comment'),
(225, 'jrAction', 'en-US', 'utf-8', 'ltr', '33', 'Share', 'Share'),
(226, 'jrAction', 'en-US', 'utf-8', 'ltr', '34', 'Share This with your Followers', 'Share This with your Followers'),
(227, 'jrAction', 'en-US', 'utf-8', 'ltr', '35', 'You have shared this with your Followers', 'You have shared this with your Followers'),
(228, 'jrAction', 'en-US', 'utf-8', 'ltr', '36', 'Who To Follow', 'Who To Follow'),
(229, 'jrAction', 'en-US', 'utf-8', 'ltr', '37', 'Notifications', 'Notifications'),
(230, 'jrAction', 'en-US', 'utf-8', 'ltr', '38', 'item is shared', 'item is shared'),
(231, 'jrAction', 'en-US', 'utf-8', 'ltr', '39', 'If an item of yours is shared do you want to be notified?', 'If an item of yours is shared do you want to be notified?'),
(232, 'jrAction', 'en-US', 'utf-8', 'ltr', '40', 'mentioned', 'mentioned'),
(233, 'jrAction', 'en-US', 'utf-8', 'ltr', '41', 'view', 'view'),
(234, 'jrAction', 'en-US', 'utf-8', 'ltr', '42', 'posted', 'posted'),
(235, 'jrAction', 'en-US', 'utf-8', 'ltr', '43', 'created an item', 'created an item'),
(236, 'jrAction', 'en-US', 'utf-8', 'ltr', '44', 'updated an item', 'updated an item'),
(237, 'jrAction', 'en-US', 'utf-8', 'ltr', '45', 'This item has been deleted', 'This item has been deleted'),
(238, 'jrBanned', 'en-US', 'utf-8', 'ltr', '1', 'Your entry contains the following text which is not allowed: ', 'Your entry contains the following text which is not allowed: '),
(239, 'jrBlog', 'en-US', 'utf-8', 'ltr', 'menu', 'blog', 'blog'),
(240, 'jrBlog', 'en-US', 'utf-8', 'ltr', '1', 'Create a Blog', 'Create a Blog'),
(241, 'jrBlog', 'en-US', 'utf-8', 'ltr', '2', 'Create New Blog', 'Create New Blog'),
(242, 'jrBlog', 'en-US', 'utf-8', 'ltr', '3', 'Blog Title', 'Blog Title'),
(243, 'jrBlog', 'en-US', 'utf-8', 'ltr', '4', 'Enter a title for this blog', 'Enter a title for this blog'),
(244, 'jrBlog', 'en-US', 'utf-8', 'ltr', '5', 'Blog Category', 'Blog Category'),
(245, 'jrBlog', 'en-US', 'utf-8', 'ltr', '6', 'Select a category for this blog or enter a new one', 'Select a category for this blog or enter a new one'),
(246, 'jrBlog', 'en-US', 'utf-8', 'ltr', '7', 'Blog Text', 'Blog Text'),
(247, 'jrBlog', 'en-US', 'utf-8', 'ltr', '8', 'Enter the contents of your Blog post', 'Enter the contents of your Blog post'),
(248, 'jrBlog', 'en-US', 'utf-8', 'ltr', '9', 'Blog List Image', 'Blog List Image'),
(249, 'jrBlog', 'en-US', 'utf-8', 'ltr', '10', 'Optionally upload a blog image. This image is used in blog lists as the default image for the post.', 'Optionally upload a blog image. This image is used in blog lists as the default image for the post.'),
(250, 'jrBlog', 'en-US', 'utf-8', 'ltr', '11', 'select', 'select'),
(251, 'jrBlog', 'en-US', 'utf-8', 'ltr', '12', 'An error was encountered creating the blog - please try again.', 'An error was encountered creating the blog - please try again.'),
(252, 'jrBlog', 'en-US', 'utf-8', 'ltr', '14', 'Invalid id - please pass in a valid blog id.', 'Invalid id - please pass in a valid blog id.'),
(253, 'jrBlog', 'en-US', 'utf-8', 'ltr', '15', 'The blog entry was not found in the datastore - please try again.', 'The blog entry was not found in the datastore - please try again.'),
(254, 'jrBlog', 'en-US', 'utf-8', 'ltr', '16', 'update blog', 'update blog'),
(255, 'jrBlog', 'en-US', 'utf-8', 'ltr', '17', 'update', 'update'),
(256, 'jrBlog', 'en-US', 'utf-8', 'ltr', '19', 'Posted a new blog', 'Posted a new blog'),
(257, 'jrBlog', 'en-US', 'utf-8', 'ltr', '20', 'Category', 'Category'),
(258, 'jrBlog', 'en-US', 'utf-8', 'ltr', '21', 'Content', 'Content'),
(259, 'jrBlog', 'en-US', 'utf-8', 'ltr', '22', 'Blog Publish Date', 'Blog Publish Date'),
(260, 'jrBlog', 'en-US', 'utf-8', 'ltr', '23', 'This is the date that will appear on the blog.  If this date is in the future, this blog post will not be shown until then.', 'This is the date that will appear on the blog.  If this date is in the future, this blog post will not be shown until then.'),
(261, 'jrBlog', 'en-US', 'utf-8', 'ltr', '24', 'Blog', 'Blog'),
(262, 'jrBlog', 'en-US', 'utf-8', 'ltr', '25', 'Read more', 'Read more'),
(263, 'jrBlog', 'en-US', 'utf-8', 'ltr', '26', 'Posted in', 'Posted in'),
(264, 'jrBlog', 'en-US', 'utf-8', 'ltr', '27', 'comments', 'comments'),
(265, 'jrBlog', 'en-US', 'utf-8', 'ltr', '28', 'By', 'By'),
(266, 'jrBlog', 'en-US', 'utf-8', 'ltr', '29', 'Blogs', 'Blogs'),
(267, 'jrBlog', 'en-US', 'utf-8', 'ltr', '30', 'Updated a Blog', 'Updated a Blog'),
(268, 'jrBlog', 'en-US', 'utf-8', 'ltr', '31', 'Subscribe', 'Subscribe'),
(269, 'jrBlog', 'en-US', 'utf-8', 'ltr', '32', 'Categories', 'Categories'),
(270, 'jrBlog', 'en-US', 'utf-8', 'ltr', '33', 'Page', 'Page'),
(271, 'jrEmbed', 'en-US', 'utf-8', 'ltr', '1', 'Embed this Media', 'Embed this Media'),
(272, 'jrEmbed', 'en-US', 'utf-8', 'ltr', '2', 'Cancel', 'Cancel'),
(273, 'jrFollower', 'en-US', 'utf-8', 'ltr', 'menu', 'followers', 'followers'),
(274, 'jrFollower', 'en-US', 'utf-8', 'ltr', '1', 'follow', 'follow'),
(275, 'jrFollower', 'en-US', 'utf-8', 'ltr', '2', 'following', 'following'),
(276, 'jrFollower', 'en-US', 'utf-8', 'ltr', '3', 'Followers Require Approval', 'Followers Require Approval'),
(277, 'jrFollower', 'en-US', 'utf-8', 'ltr', '4', 'If &quot;Followers Require Approval&quot; is checked, anyone following your profile will need to be approved by you before becoming a follower of your profile.', 'If &quot;Followers Require Approval&quot; is checked, anyone following your profile will need to be approved by you before becoming a follower of your profile.'),
(278, 'jrFollower', 'en-US', 'utf-8', 'ltr', '5', 'pending', 'pending'),
(279, 'jrFollower', 'en-US', 'utf-8', 'ltr', '6', 'No longer follow this profile?', 'No longer follow this profile?'),
(280, 'jrFollower', 'en-US', 'utf-8', 'ltr', '7', 'Your follow request is currently pending - once the profile owner approves your follow request, you will be notified', 'Your follow request is currently pending - once the profile owner approves your follow request, you will be notified'),
(281, 'jrFollower', 'en-US', 'utf-8', 'ltr', '8', 'You are currently following this profile', 'You are currently following this profile'),
(282, 'jrFollower', 'en-US', 'utf-8', 'ltr', '9', 'new pending follower', 'new pending follower'),
(283, 'jrFollower', 'en-US', 'utf-8', 'ltr', '10', 'new follower', 'new follower'),
(284, 'jrFollower', 'en-US', 'utf-8', 'ltr', '11', 'follow approved', 'follow approved'),
(285, 'jrFollower', 'en-US', 'utf-8', 'ltr', '12', 'You have a new follower awaiting approval', 'You have a new follower awaiting approval'),
(286, 'jrFollower', 'en-US', 'utf-8', 'ltr', '13', 'user', 'user'),
(287, 'jrFollower', 'en-US', 'utf-8', 'ltr', '14', 'If you would like to approve this user to be a new follower, click the the following URL (or cut and paste it into your browser)', 'If you would like to approve this user to be a new follower, click the the following URL (or cut and paste it into your browser)'),
(288, 'jrFollower', 'en-US', 'utf-8', 'ltr', '15', 'If you would like to ignore or delete this request, click this URL instead (or cut and paste into your browser)', 'If you would like to ignore or delete this request, click this URL instead (or cut and paste into your browser)'),
(289, 'jrFollower', 'en-US', 'utf-8', 'ltr', '16', 'You have a new follower awaiting approval!', 'You have a new follower awaiting approval!'),
(290, 'jrFollower', 'en-US', 'utf-8', 'ltr', '17', 'You are now following', 'You are now following'),
(291, 'jrFollower', 'en-US', 'utf-8', 'ltr', '18', 'You can now keep up with what', 'You can now keep up with what'),
(292, 'jrFollower', 'en-US', 'utf-8', 'ltr', '19', 'is doing', 'is doing'),
(293, 'jrFollower', 'en-US', 'utf-8', 'ltr', '20', 'You have a new', 'You have a new'),
(294, 'jrFollower', 'en-US', 'utf-8', 'ltr', '21', 'follower!', 'follower!'),
(295, 'jrFollower', 'en-US', 'utf-8', 'ltr', '22', 'is now following', 'is now following'),
(296, 'jrFollower', 'en-US', 'utf-8', 'ltr', '23', 'If you are approving new followers, do you want to be notified when a new follower is waiting to be approved?', 'If you are approving new followers, do you want to be notified when a new follower is waiting to be approved?'),
(297, 'jrFollower', 'en-US', 'utf-8', 'ltr', '24', 'Do you want to be notified when you get a new follower?', 'Do you want to be notified when you get a new follower?'),
(298, 'jrFollower', 'en-US', 'utf-8', 'ltr', '25', 'Do you want to be notified if your pending follow request for another profile is approved?', 'Do you want to be notified if your pending follow request for another profile is approved?'),
(299, 'jrFollower', 'en-US', 'utf-8', 'ltr', '26', 'followers', 'followers'),
(300, 'jrFollower', 'en-US', 'utf-8', 'ltr', '27', 'user name', 'user name'),
(301, 'jrFollower', 'en-US', 'utf-8', 'ltr', '28', 'profile name', 'profile name'),
(302, 'jrFollower', 'en-US', 'utf-8', 'ltr', '29', 'follower since', 'follower since'),
(303, 'jrFollower', 'en-US', 'utf-8', 'ltr', '30', 'approve', 'approve'),
(304, 'jrFollower', 'en-US', 'utf-8', 'ltr', '31', 'delete', 'delete'),
(305, 'jrFollower', 'en-US', 'utf-8', 'ltr', '32', 'No followers found', 'No followers found'),
(306, 'jrFollower', 'en-US', 'utf-8', 'ltr', '33', 'Are you sure you want to delete this follower?', 'Are you sure you want to delete this follower?'),
(307, 'jrFollower', 'en-US', 'utf-8', 'ltr', '34', 'You have a new %1 follower!', 'You have a new %1 follower!'),
(308, 'jrFollower', 'en-US', 'utf-8', 'ltr', '35', '%1 is now following you:', '%1 is now following you:'),
(309, 'jrFollower', 'en-US', 'utf-8', 'ltr', '36', 'You are not following any profiles', 'You are not following any profiles'),
(310, 'jrFollower', 'en-US', 'utf-8', 'ltr', '37', 'Profiles You Follow', 'Profiles You Follow'),
(311, 'jrFollower', 'en-US', 'utf-8', 'ltr', '38', 'Share Who you Follow', 'Share Who you Follow'),
(312, 'jrFollower', 'en-US', 'utf-8', 'ltr', '39', 'If this option is checked, when you follow a new profile an entry will be added to your Timeline for others to view', 'If this option is checked, when you follow a new profile an entry will be added to your Timeline for others to view'),
(313, 'jrFollower', 'en-US', 'utf-8', 'ltr', '40', 'Followed by:', 'Followed by:'),
(314, 'jrFollower', 'en-US', 'utf-8', 'ltr', '41', 'Keep Followers Pending until my Approval', 'Keep Followers Pending until my Approval'),
(315, 'jrGeo', 'en-US', 'utf-8', 'ltr', '1', 'ZIP Code', 'ZIP Code'),
(316, 'jrGeo', 'en-US', 'utf-8', 'ltr', '2', 'Miles', 'Miles'),
(317, 'jrGeo', 'en-US', 'utf-8', 'ltr', '3', 'Search', 'Search'),
(318, 'jrGeo', 'en-US', 'utf-8', 'ltr', '4', 'No Results Found', 'No Results Found'),
(319, 'jrGeo', 'en-US', 'utf-8', 'ltr', '5', 'ZIP Search Results', 'ZIP Search Results'),
(320, 'jrGeo', 'en-US', 'utf-8', 'ltr', '6', 'Kilometers', 'Kilometers'),
(321, 'jrGeo', 'en-US', 'utf-8', 'ltr', '7', 'Updating Search Results', 'Updating Search Results'),
(322, 'jrImage', 'en-US', 'utf-8', 'ltr', '1', 'Your forgot to select an image for upload', 'Your forgot to select an image for upload'),
(323, 'jrImage', 'en-US', 'utf-8', 'ltr', '2', 'delete this image', 'delete this image'),
(324, 'jrImage', 'en-US', 'utf-8', 'ltr', '3', 'Are you sure you want to delete this image?', 'Are you sure you want to delete this image?'),
(325, 'jrImage', 'en-US', 'utf-8', 'ltr', '4', 'Upload New Image', 'Upload New Image'),
(326, 'jrImage', 'en-US', 'utf-8', 'ltr', '5', 'Invalid image file - please upload a valid image file', 'Invalid image file - please upload a valid image file'),
(327, 'jrImage', 'en-US', 'utf-8', 'ltr', '6', 'The image you have entered is too small - it must be at least %1 pixels wide', 'The image you have entered is too small - it must be at least %1 pixels wide'),
(328, 'jrImage', 'en-US', 'utf-8', 'ltr', '7', 'Invalid image id - please try again', 'Invalid image id - please try again'),
(329, 'jrPage', 'en-US', 'utf-8', 'ltr', 'menu', 'pages', 'pages'),
(330, 'jrPage', 'en-US', 'utf-8', 'ltr', '1', 'create a new page', 'create a new page'),
(331, 'jrPage', 'en-US', 'utf-8', 'ltr', '2', 'create', 'create'),
(332, 'jrPage', 'en-US', 'utf-8', 'ltr', '3', 'page title', 'page title'),
(333, 'jrPage', 'en-US', 'utf-8', 'ltr', '4', 'enter a title for this page - this will be used in the URL to view this page.', 'enter a title for this page - this will be used in the URL to view this page.'),
(334, 'jrPage', 'en-US', 'utf-8', 'ltr', '5', 'page content', 'page content'),
(335, 'jrPage', 'en-US', 'utf-8', 'ltr', '6', 'enter the content for this page.', 'enter the content for this page.'),
(336, 'jrPage', 'en-US', 'utf-8', 'ltr', '7', 'An error was encountered saving the page - please try again.', 'An error was encountered saving the page - please try again.'),
(337, 'jrPage', 'en-US', 'utf-8', 'ltr', '8', 'The new page was successfully created!', 'The new page was successfully created!'),
(338, 'jrPage', 'en-US', 'utf-8', 'ltr', '9', 'Invalid page_id - please try again', 'Invalid page_id - please try again'),
(339, 'jrPage', 'en-US', 'utf-8', 'ltr', '10', 'update an existing page', 'update an existing page'),
(340, 'jrPage', 'en-US', 'utf-8', 'ltr', '11', 'save changes', 'save changes'),
(341, 'jrPage', 'en-US', 'utf-8', 'ltr', '12', 'The page update was successfully saved.', 'The page update was successfully saved.'),
(342, 'jrPage', 'en-US', 'utf-8', 'ltr', '13', 'page location', 'page location'),
(343, 'jrPage', 'en-US', 'utf-8', 'ltr', '14', 'Would you like this page to appear on your profile or on the main site?', 'Would you like this page to appear on your profile or on the main site?'),
(344, 'jrPage', 'en-US', 'utf-8', 'ltr', '15', 'Page is visible on Main Site', 'Page is visible on Main Site'),
(345, 'jrPage', 'en-US', 'utf-8', 'ltr', '16', 'Page is visible on Profile', 'Page is visible on Profile'),
(346, 'jrPage', 'en-US', 'utf-8', 'ltr', '17', 'view page', 'view page'),
(347, 'jrPage', 'en-US', 'utf-8', 'ltr', '18', 'Created a new Page', 'Created a new Page'),
(348, 'jrPage', 'en-US', 'utf-8', 'ltr', '19', 'Pages', 'Pages'),
(349, 'jrPage', 'en-US', 'utf-8', 'ltr', '20', 'home', 'home'),
(350, 'jrPage', 'en-US', 'utf-8', 'ltr', '21', 'Updated a Page', 'Updated a Page'),
(351, 'jrPage', 'en-US', 'utf-8', 'ltr', '22', 'show page header', 'show page header'),
(352, 'jrPage', 'en-US', 'utf-8', 'ltr', '23', 'If checked, the page title and breadcrumb navigation will be added above the page content.', 'If checked, the page title and breadcrumb navigation will be added above the page content.'),
(353, 'jrPage', 'en-US', 'utf-8', 'ltr', '24', 'allow item features', 'allow item features'),
(354, 'jrPage', 'en-US', 'utf-8', 'ltr', '25', 'If checked, Item Detail features such as comments, tags, etc. will be shown at the bottom of the page.', 'If checked, Item Detail features such as comments, tags, etc. will be shown at the bottom of the page.'),
(355, 'jrProfile', 'en-US', 'utf-8', 'ltr', '1', 'Unable to switch active profiles - you do not appear to have access to the requested profile', 'Unable to switch active profiles - you do not appear to have access to the requested profile'),
(356, 'jrProfile', 'en-US', 'utf-8', 'ltr', '2', 'Profile', 'Profile'),
(357, 'jrProfile', 'en-US', 'utf-8', 'ltr', '3', 'save settings', 'save settings'),
(358, 'jrProfile', 'en-US', 'utf-8', 'ltr', '4', 'active profile', 'active profile'),
(359, 'jrProfile', 'en-US', 'utf-8', 'ltr', '5', 'profile URL name', 'profile URL name'),
(360, 'jrProfile', 'en-US', 'utf-8', 'ltr', '6', 'profile image', 'profile image'),
(361, 'jrProfile', 'en-US', 'utf-8', 'ltr', '7', 'create new profile', 'create new profile'),
(362, 'jrProfile', 'en-US', 'utf-8', 'ltr', '8', 'create', 'create'),
(363, 'jrProfile', 'en-US', 'utf-8', 'ltr', '9', 'profile name', 'profile name'),
(364, 'jrProfile', 'en-US', 'utf-8', 'ltr', '10', 'Enter the name for the profile.', 'Enter the name for the profile.'),
(365, 'jrProfile', 'en-US', 'utf-8', 'ltr', '11', 'profile privacy', 'profile privacy'),
(366, 'jrProfile', 'en-US', 'utf-8', 'ltr', '12', 'What level of privacy would you like to have for your Profile?', 'What level of privacy would you like to have for your Profile?'),
(367, 'jrProfile', 'en-US', 'utf-8', 'ltr', '13', 'Global - visible to everyone', 'Global - visible to everyone'),
(368, 'jrProfile', 'en-US', 'utf-8', 'ltr', '14', 'Private - profile owners only', 'Private - profile owners only'),
(369, 'jrProfile', 'en-US', 'utf-8', 'ltr', '15', 'Shared - profile owners and followers only', 'Shared - profile owners and followers only'),
(370, 'jrProfile', 'en-US', 'utf-8', 'ltr', '16', 'This profile is a private profile and cannot be viewed', 'This profile is a private profile and cannot be viewed'),
(371, 'jrProfile', 'en-US', 'utf-8', 'ltr', '17', 'This is the URL name for your profile, which allows your profile to be accessed at the following URL:', 'This is the URL name for your profile, which allows your profile to be accessed at the following URL:'),
(372, 'jrProfile', 'en-US', 'utf-8', 'ltr', '18', 'The Profile Name you entered is already being used by another profile or is a reserved or invalid name - please try another.', 'The Profile Name you entered is already being used by another profile or is a reserved or invalid name - please try another.'),
(373, 'jrProfile', 'en-US', 'utf-8', 'ltr', '19', 'There is already another profile using that name - please select another.', 'There is already another profile using that name - please select another.'),
(374, 'jrProfile', 'en-US', 'utf-8', 'ltr', '20', 'The Profile Name you have entered is not allowed - please try another', 'The Profile Name you have entered is not allowed - please try another'),
(375, 'jrProfile', 'en-US', 'utf-8', 'ltr', '21', 'profile biography', 'profile biography'),
(376, 'jrProfile', 'en-US', 'utf-8', 'ltr', '22', 'Enter a biography for this profile', 'Enter a biography for this profile'),
(377, 'jrProfile', 'en-US', 'utf-8', 'ltr', '23', 'Upload an image for your profile - this image will only be seen on your profile, and is separate from the image associated with your User Account.', 'Upload an image for your profile - this image will only be seen on your profile, and is separate from the image associated with your User Account.'),
(378, 'jrProfile', 'en-US', 'utf-8', 'ltr', '24', 'This profile is private, and is only visible to followers.', 'This profile is private, and is only visible to followers.'),
(379, 'jrProfile', 'en-US', 'utf-8', 'ltr', '25', 'Your Profiles', 'Your Profiles'),
(380, 'jrProfile', 'en-US', 'utf-8', 'ltr', '26', 'Profiles', 'Profiles'),
(381, 'jrProfile', 'en-US', 'utf-8', 'ltr', '27', 'Your profile has exceeded the allowed disk space for media items - modify or delete items to free up some space.', 'Your profile has exceeded the allowed disk space for media items - modify or delete items to free up some space.'),
(382, 'jrProfile', 'en-US', 'utf-8', 'ltr', '28', 'Total Profiles you can create based on your account settings:', 'Total Profiles you can create based on your account settings:'),
(383, 'jrProfile', 'en-US', 'utf-8', 'ltr', '29', 'profile quota', 'profile quota'),
(384, 'jrProfile', 'en-US', 'utf-8', 'ltr', '30', 'Select the Profile Quota you would like your profile to belong to', 'Select the Profile Quota you would like your profile to belong to'),
(385, 'jrProfile', 'en-US', 'utf-8', 'ltr', '31', 'Invalid Quota - please select from the list of allowed Quotas', 'Invalid Quota - please select from the list of allowed Quotas'),
(386, 'jrProfile', 'en-US', 'utf-8', 'ltr', '32', 'Unable to determine Power User Quota - please contact the system adminstrator', 'Unable to determine Power User Quota - please contact the system adminstrator'),
(387, 'jrProfile', 'en-US', 'utf-8', 'ltr', '33', 'The profile has been successfully deleted', 'The profile has been successfully deleted'),
(388, 'jrProfile', 'en-US', 'utf-8', 'ltr', '34', 'You cannot delete a profile that was not created by you!', 'You cannot delete a profile that was not created by you!'),
(389, 'jrProfile', 'en-US', 'utf-8', 'ltr', '35', 'You are viewing the profile information for:', 'You are viewing the profile information for:'),
(390, 'jrProfile', 'en-US', 'utf-8', 'ltr', '36', 'This Profile is <strong>inactive</strong> and is only visible to admin users and the site owner', 'This Profile is <strong>inactive</strong> and is only visible to admin users and the site owner'),
(391, 'jrProfile', 'en-US', 'utf-8', 'ltr', '37', 'You have already created the maximum number of Profiles allowed by your account settings', 'You have already created the maximum number of Profiles allowed by your account settings'),
(392, 'jrProfile', 'en-US', 'utf-8', 'ltr', '38', 'Shared - profile owners and followers only (profile visible in search)', 'Shared - profile owners and followers only (profile visible in search)'),
(393, 'jrProfile', 'en-US', 'utf-8', 'ltr', '39', 'Delete this Profile', 'Delete this Profile'),
(394, 'jrProfile', 'en-US', 'utf-8', 'ltr', '40', 'Are you sure you want to delete this profile?', 'Are you sure you want to delete this profile?'),
(395, 'jrProfile', 'en-US', 'utf-8', 'ltr', '41', 'Invalid Profile - no data found', 'Invalid Profile - no data found'),
(396, 'jrProfile', 'en-US', 'utf-8', 'ltr', '42', 'profile URL name', 'profile URL name'),
(397, 'jrProfile', 'en-US', 'utf-8', 'ltr', '43', 'only numbers, letters, - or _', 'only numbers, letters, - or _'),
(398, 'jrProfile', 'en-US', 'utf-8', 'ltr', '44', 'If you would like to use a different profile URL, enter it here.', 'If you would like to use a different profile URL, enter it here.'),
(399, 'jrProfile', 'en-US', 'utf-8', 'ltr', '45', 'The Profile URL you have entered is already being used - please try another.', 'The Profile URL you have entered is already being used - please try another.'),
(400, 'jrProfile', 'en-US', 'utf-8', 'ltr', '46', 'This profile has exceeded the maximum number of items of this type and it is currently unavailable.<br>Please check back later.', 'This profile has exceeded the maximum number of items of this type and it is currently unavailable.<br>Please check back later.'),
(401, 'jrProfile', 'en-US', 'utf-8', 'ltr', '47', 'Invalid Profile Name - please enter a valid profile name', 'Invalid Profile Name - please enter a valid profile name'),
(402, 'jrProfile', 'en-US', 'utf-8', 'ltr', '48', 'You haven''t created any %1 items yet!', 'You haven''t created any %1 items yet!'),
(403, 'jrProfile', 'en-US', 'utf-8', 'ltr', '49', 'Click the &quot;+&quot; button to get started', 'Click the &quot;+&quot; button to get started'),
(404, 'jrSearch', 'en-US', 'utf-8', 'ltr', '1', 'search site', 'search site'),
(405, 'jrSearch', 'en-US', 'utf-8', 'ltr', '2', 'recent searches', 'recent searches'),
(406, 'jrSearch', 'en-US', 'utf-8', 'ltr', '3', 'popular searches', 'popular searches'),
(407, 'jrSearch', 'en-US', 'utf-8', 'ltr', '4', 'prev', 'prev'),
(408, 'jrSearch', 'en-US', 'utf-8', 'ltr', '5', 'next', 'next'),
(409, 'jrSearch', 'en-US', 'utf-8', 'ltr', '6', 'All Search Results for', 'All Search Results for'),
(410, 'jrSearch', 'en-US', 'utf-8', 'ltr', '7', 'search', 'search'),
(411, 'jrSearch', 'en-US', 'utf-8', 'ltr', '8', 'Search Results for', 'Search Results for'),
(412, 'jrSearch', 'en-US', 'utf-8', 'ltr', '9', 'See All Results', 'See All Results'),
(413, 'jrSearch', 'en-US', 'utf-8', 'ltr', '10', 'No results found for your search', 'No results found for your search'),
(414, 'jrSearch', 'en-US', 'utf-8', 'ltr', '11', 'Home', 'Home'),
(415, 'jrSearch', 'en-US', 'utf-8', 'ltr', '12', 'Reset', 'Reset'),
(416, 'jrSearch', 'en-US', 'utf-8', 'ltr', '13', 'Search Results', 'Search Results'),
(417, 'jrStrongPassword', 'en-US', 'utf-8', 'ltr', '1', 'Your password does not meet the minimum password requirements - it is:', 'Your password does not meet the minimum password requirements - it is:'),
(418, 'jrStrongPassword', 'en-US', 'utf-8', 'ltr', '2', 'missing at least 1 uppercase letter', 'missing at least 1 uppercase letter'),
(419, 'jrStrongPassword', 'en-US', 'utf-8', 'ltr', '3', 'missing at least 1 lowercase letter', 'missing at least 1 lowercase letter'),
(420, 'jrStrongPassword', 'en-US', 'utf-8', 'ltr', '4', 'missing at least 1 symbol: @ # $ % ^ & * ( ) \\ - _ = + { } ; : , &lt; . &gt;', 'missing at least 1 symbol: @ # $ % ^ & * ( ) \\ - _ = + { } ; : , &lt; . &gt;'),
(421, 'jrStrongPassword', 'en-US', 'utf-8', 'ltr', '5', 'missing at least 1 number', 'missing at least 1 number'),
(422, 'jrStrongPassword', 'en-US', 'utf-8', 'ltr', '6', 'too short - it must be at least ', 'too short - it must be at least '),
(423, 'jrStrongPassword', 'en-US', 'utf-8', 'ltr', '7', 'characters long ', 'characters long '),
(424, 'jrTips', 'en-US', 'utf-8', 'ltr', '1', 'All Tips have been successfully turned off - you can re-enable Tips again from your Account Settings section', 'All Tips have been successfully turned off - you can re-enable Tips again from your Account Settings section'),
(425, 'jrTips', 'en-US', 'utf-8', 'ltr', '2', 'unable to save changes to preferences - please try again', 'unable to save changes to preferences - please try again'),
(426, 'jrTips', 'en-US', 'utf-8', 'ltr', '3', 'Continue', 'Continue'),
(427, 'jrTips', 'en-US', 'utf-8', 'ltr', '4', 'Close', 'Close'),
(428, 'jrTips', 'en-US', 'utf-8', 'ltr', '5', 'Don''t show me Tips', 'Don''t show me Tips'),
(429, 'jrTips', 'en-US', 'utf-8', 'ltr', '6', 'Show Tips', 'Show Tips'),
(430, 'jrTips', 'en-US', 'utf-8', 'ltr', '7', 'Check this option to enable tours in the user interface', 'Check this option to enable tours in the user interface'),
(431, 'jrTips', 'en-US', 'utf-8', 'ltr', '8', 'Watch the Video Tour', 'Watch the Video Tour'),
(432, 'jrTOS', 'en-US', 'utf-8', 'ltr', '1', 'You must accept the following terms of service to continue', 'You must accept the following terms of service to continue'),
(433, 'jrTOS', 'en-US', 'utf-8', 'ltr', '2', 'continue', 'continue'),
(434, 'jrTOS', 'en-US', 'utf-8', 'ltr', '3', 'log out', 'log out'),
(435, 'jrTOS', 'en-US', 'utf-8', 'ltr', '4', 'You must check the Agree to Terms checkbox to continue', 'You must check the Agree to Terms checkbox to continue'),
(436, 'jrTOS', 'en-US', 'utf-8', 'ltr', '5', 'agree to terms', 'agree to terms'),
(437, 'jrTOS', 'en-US', 'utf-8', 'ltr', '6', 'Check this option to indicate you have read and agree to adhere to the displayed Terms of Service', 'Check this option to indicate you have read and agree to adhere to the displayed Terms of Service'),
(438, 'jrTOS', 'en-US', 'utf-8', 'ltr', '7', 'Unable to save terms of service agreement due to an internal error - please try again', 'Unable to save terms of service agreement due to an internal error - please try again'),
(439, 'jrTwoFactor', 'en-US', 'utf-8', 'ltr', '1', 'continue login', 'continue login'),
(440, 'jrTwoFactor', 'en-US', 'utf-8', 'ltr', '2', 'authentication code', 'authentication code'),
(441, 'jrTwoFactor', 'en-US', 'utf-8', 'ltr', '3', 'Enter the <b>6 digit</b> authentication code you received in your email', 'Enter the <b>6 digit</b> authentication code you received in your email'),
(442, 'jrTwoFactor', 'en-US', 'utf-8', 'ltr', '4', 'resend code', 'resend code'),
(443, 'jrTwoFactor', 'en-US', 'utf-8', 'ltr', '5', 'Invalid authentication code - please try again', 'Invalid authentication code - please try again'),
(444, 'jrTwoFactor', 'en-US', 'utf-8', 'ltr', '6', 'invalid user_id received - please try again', 'invalid user_id received - please try again'),
(445, 'jrTwoFactor', 'en-US', 'utf-8', 'ltr', '7', 'The authentication code has been resent to your email address', 'The authentication code has been resent to your email address'),
(446, 'jrTwoFactor', 'en-US', 'utf-8', 'ltr', '8', '2 Factor Authentication', '2 Factor Authentication'),
(447, 'jrTwoFactor', 'en-US', 'utf-8', 'ltr', '9', 'Check this box to enable 2 Factor Authentication on your account. Enabling 2 Factor Authentication makes your account more secure, by requiring a special code that is sent to your email address to log into the system', 'Check this box to enable 2 Factor Authentication on your account. Enabling 2 Factor Authentication makes your account more secure, by requiring a special code that is sent to your email address to log into the system'),
(448, 'jrTwoFactor', 'en-US', 'utf-8', 'ltr', '10', 'Two Factor Authentication is enabled for this account.<br>You have just been sent an Authentication Code - please check your email.<br><br>Enter the Authentication Code to continue with your login.', 'Two Factor Authentication is enabled for this account.<br>You have just been sent an Authentication Code - please check your email.<br><br>Enter the Authentication Code to continue with your login.'),
(449, 'jrTwoFactor', 'en-US', 'utf-8', 'ltr', '11', 'enter authentication code', 'enter authentication code'),
(450, 'jrTwoFactor', 'en-US', 'utf-8', 'ltr', '12', 'required', 'required'),
(451, 'jrUpimg', 'en-US', 'utf-8', 'ltr', '1', 'upload an image', 'upload an image');
INSERT INTO `jr_jruser_language` VALUES
(452, 'jrUpimg', 'en-US', 'utf-8', 'ltr', '2', 'upload and insert a new image', 'upload and insert a new image'),
(453, 'jrUpimg', 'en-US', 'utf-8', 'ltr', '3', 'Upload an image from your computer to embed it where the cursor is located.', 'Upload an image from your computer to embed it where the cursor is located.'),
(454, 'jrUpimg', 'en-US', 'utf-8', 'ltr', '4', 'size', 'size'),
(455, 'jrUpimg', 'en-US', 'utf-8', 'ltr', '5', '- select image size -', '- select image size -'),
(456, 'jrUpimg', 'en-US', 'utf-8', 'ltr', '6', 'position', 'position'),
(457, 'jrUpimg', 'en-US', 'utf-8', 'ltr', '7', '- select image position -', '- select image position -'),
(458, 'jrUpimg', 'en-US', 'utf-8', 'ltr', '8', 'normal', 'normal'),
(459, 'jrUpimg', 'en-US', 'utf-8', 'ltr', '9', 'float left', 'float left'),
(460, 'jrUpimg', 'en-US', 'utf-8', 'ltr', '10', 'float right', 'float right'),
(461, 'jrUpimg', 'en-US', 'utf-8', 'ltr', '11', 'image options', 'image options'),
(462, 'jrUpimg', 'en-US', 'utf-8', 'ltr', '12', 'stretch', 'stretch'),
(463, 'jrUpimg', 'en-US', 'utf-8', 'ltr', '13', 'No uploaded images found.', 'No uploaded images found.'),
(464, 'jrUpimg', 'en-US', 'utf-8', 'ltr', '14', 'Select and upload new images', 'Select and upload new images'),
(465, 'jrUpimg', 'en-US', 'utf-8', 'ltr', '15', 'Upload Images', 'Upload Images'),
(466, 'jrUpimg', 'en-US', 'utf-8', 'ltr', '16', 'image', 'image'),
(467, 'jrUpimg', 'en-US', 'utf-8', 'ltr', '17', 'margin', 'margin'),
(468, 'jrUpimg', 'en-US', 'utf-8', 'ltr', '18', 'Delete this uploaded image?', 'Delete this uploaded image?'),
(469, 'jrUpimg', 'en-US', 'utf-8', 'ltr', '19', 'delete', 'delete'),
(470, 'jrUpimg', 'en-US', 'utf-8', 'ltr', '20', 'Invalid image id - please try again', 'Invalid image id - please try again'),
(471, 'jrUpimg', 'en-US', 'utf-8', 'ltr', '21', 'No previously uploaded images located', 'No previously uploaded images located'),
(472, 'jrUser', 'en-US', 'utf-8', 'ltr', '1', 'user login', 'user login'),
(473, 'jrUser', 'en-US', 'utf-8', 'ltr', '2', 'please enter your user name and password to login', 'please enter your user name and password to login'),
(474, 'jrUser', 'en-US', 'utf-8', 'ltr', '3', 'login', 'login'),
(475, 'jrUser', 'en-US', 'utf-8', 'ltr', '4', 'user name', 'user name'),
(476, 'jrUser', 'en-US', 'utf-8', 'ltr', '5', 'please enter your user name', 'please enter your user name'),
(477, 'jrUser', 'en-US', 'utf-8', 'ltr', '6', 'you forgot to enter your user name', 'you forgot to enter your user name'),
(478, 'jrUser', 'en-US', 'utf-8', 'ltr', '7', 'password', 'password'),
(479, 'jrUser', 'en-US', 'utf-8', 'ltr', '8', 'please enter your password', 'please enter your password'),
(480, 'jrUser', 'en-US', 'utf-8', 'ltr', '9', 'you forgot to enter a password', 'you forgot to enter a password'),
(481, 'jrUser', 'en-US', 'utf-8', 'ltr', '10', 'You have entered an invalid user name or password - please try again', 'You have entered an invalid user name or password - please try again'),
(482, 'jrUser', 'en-US', 'utf-8', 'ltr', '11', 'The system is currently down for maintenance - please try again shortly', 'The system is currently down for maintenance - please try again shortly'),
(483, 'jrUser', 'en-US', 'utf-8', 'ltr', '12', 'Your account has logged in from too many different locations and has been temporarily locked. Please contact the system administrator for assistance with your account', 'Your account has logged in from too many different locations and has been temporarily locked. Please contact the system administrator for assistance with your account'),
(484, 'jrUser', 'en-US', 'utf-8', 'ltr', '13', 'remember login', 'remember login'),
(485, 'jrUser', 'en-US', 'utf-8', 'ltr', '14', 'check this option to remember your login information for next time', 'check this option to remember your login information for next time'),
(486, 'jrUser', 'en-US', 'utf-8', 'ltr', '15', 'update account info', 'update account info'),
(487, 'jrUser', 'en-US', 'utf-8', 'ltr', '16', 'update existing account information', 'update existing account information'),
(488, 'jrUser', 'en-US', 'utf-8', 'ltr', '17', 'save changes', 'save changes'),
(489, 'jrUser', 'en-US', 'utf-8', 'ltr', '18', 'email address', 'email address'),
(490, 'jrUser', 'en-US', 'utf-8', 'ltr', '19', 'please enter a valid email address or user name to log into the system.', 'please enter a valid email address or user name to log into the system.'),
(491, 'jrUser', 'en-US', 'utf-8', 'ltr', '20', 'new password', 'new password'),
(492, 'jrUser', 'en-US', 'utf-8', 'ltr', '21', 'please enter a strong password', 'please enter a strong password'),
(493, 'jrUser', 'en-US', 'utf-8', 'ltr', '22', 'repeat new password', 'repeat new password'),
(494, 'jrUser', 'en-US', 'utf-8', 'ltr', '23', 'repeat the password you entered to be sure there are no typos', 'repeat the password you entered to be sure there are no typos'),
(495, 'jrUser', 'en-US', 'utf-8', 'ltr', '24', 'maintenance login', 'maintenance login'),
(496, 'jrUser', 'en-US', 'utf-8', 'ltr', '25', 'if checked, this user will be allowed to log into the system when the system is in maintenance mode', 'if checked, this user will be allowed to log into the system when the system is in maintenance mode'),
(497, 'jrUser', 'en-US', 'utf-8', 'ltr', '26', 'Invalid Login or Password - please try again', 'Invalid Login or Password - please try again'),
(498, 'jrUser', 'en-US', 'utf-8', 'ltr', '27', 'Your account is pending validation - please check your email for the activation link.', 'Your account is pending validation - please check your email for the activation link.'),
(499, 'jrUser', 'en-US', 'utf-8', 'ltr', '28', 'Click to resend the Activation Email', 'Click to resend the Activation Email'),
(500, 'jrUser', 'en-US', 'utf-8', 'ltr', '29', 'Your account is not currently active - please contact the System Administrator for assistance', 'Your account is not currently active - please contact the System Administrator for assistance'),
(501, 'jrUser', 'en-US', 'utf-8', 'ltr', '30', 'Only admins can login while the system is in maintenance mode', 'Only admins can login while the system is in maintenance mode'),
(502, 'jrUser', 'en-US', 'utf-8', 'ltr', '31', 'Create Account', 'Create Account'),
(503, 'jrUser', 'en-US', 'utf-8', 'ltr', '32', 'repeat password', 'repeat password'),
(504, 'jrUser', 'en-US', 'utf-8', 'ltr', '33', 'That User Name is already being used - did you already create an account previously?', 'That User Name is already being used - did you already create an account previously?'),
(505, 'jrUser', 'en-US', 'utf-8', 'ltr', '34', 'That Email Address is already being used - did you already create an account previously?', 'That Email Address is already being used - did you already create an account previously?'),
(506, 'jrUser', 'en-US', 'utf-8', 'ltr', '35', 'The passwords you have entered do not match', 'The passwords you have entered do not match'),
(507, 'jrUser', 'en-US', 'utf-8', 'ltr', '36', 'An error was encountered saving the account information - please try again', 'An error was encountered saving the account information - please try again'),
(508, 'jrUser', 'en-US', 'utf-8', 'ltr', '37', 'You''re almost done - we have just sent you an activation email!<br><br>Please check your email account for instructions on validating your account.', 'You''re almost done - we have just sent you an activation email!<br><br>Please check your email account for instructions on validating your account.'),
(509, 'jrUser', 'en-US', 'utf-8', 'ltr', '38', '<b>Invalid Activation Key!</b><br><br>Make sure you are entering the full URL from the activation email - some email clients will cut the URL off.', '<b>Invalid Activation Key!</b><br><br>Make sure you are entering the full URL from the activation email - some email clients will cut the URL off.'),
(510, 'jrUser', 'en-US', 'utf-8', 'ltr', '39', '<p>Your account has been activated, and you have been logged in.<br><br>Thank you for signing up!</p>', '<p>Your account has been activated, and you have been logged in.<br><br>Thank you for signing up!</p>'),
(511, 'jrUser', 'en-US', 'utf-8', 'ltr', '40', 'Login', 'Login'),
(512, 'jrUser', 'en-US', 'utf-8', 'ltr', '41', 'Forgot Login?', 'Forgot Login?'),
(513, 'jrUser', 'en-US', 'utf-8', 'ltr', '42', 'Account', 'Account'),
(514, 'jrUser', 'en-US', 'utf-8', 'ltr', '43', 'The account settings were successfully saved', 'The account settings were successfully saved'),
(515, 'jrUser', 'en-US', 'utf-8', 'ltr', '44', 'Forgot Login', 'Forgot Login'),
(516, 'jrUser', 'en-US', 'utf-8', 'ltr', '45', 'create account', 'create account'),
(517, 'jrUser', 'en-US', 'utf-8', 'ltr', '46', 'submit address or user name', 'submit address or user name'),
(518, 'jrUser', 'en-US', 'utf-8', 'ltr', '47', 'enter the email address you used to signup with', 'enter the email address you used to signup with'),
(519, 'jrUser', 'en-US', 'utf-8', 'ltr', '48', 'An account with that email address or user name was not found - please try again', 'An account with that email address or user name was not found - please try again'),
(520, 'jrUser', 'en-US', 'utf-8', 'ltr', '49', 'Please check your email account for further instructions on accessing your account', 'Please check your email account for further instructions on accessing your account'),
(521, 'jrUser', 'en-US', 'utf-8', 'ltr', '50', 'Set a new Password', 'Set a new Password'),
(522, 'jrUser', 'en-US', 'utf-8', 'ltr', '51', 'set new password and login', 'set new password and login'),
(523, 'jrUser', 'en-US', 'utf-8', 'ltr', '52', 'Invalid Password Reset token - please check your password reset email for the proper reset URL', 'Invalid Password Reset token - please check your password reset email for the proper reset URL'),
(524, 'jrUser', 'en-US', 'utf-8', 'ltr', '53', 'photo', 'photo'),
(525, 'jrUser', 'en-US', 'utf-8', 'ltr', '54', 'view your profile', 'view your profile'),
(526, 'jrUser', 'en-US', 'utf-8', 'ltr', '55', 'The User Name you have entered is not allowed - please try another', 'The User Name you have entered is not allowed - please try another'),
(527, 'jrUser', 'en-US', 'utf-8', 'ltr', '56', 'Your account has already been validated, and you should be able to log in now', 'Your account has already been validated, and you should be able to log in now'),
(528, 'jrUser', 'en-US', 'utf-8', 'ltr', '57', 'The Email Address that your account is tied to - please ensure this is a valid email address.  If you forget your password, this is the email address where you can receive instructions on resetting your password.', 'The Email Address that your account is tied to - please ensure this is a valid email address.  If you forget your password, this is the email address where you can receive instructions on resetting your password.'),
(529, 'jrUser', 'en-US', 'utf-8', 'ltr', '58', 'Signups are currently disabled - please try again shortly.', 'Signups are currently disabled - please try again shortly.'),
(530, 'jrUser', 'en-US', 'utf-8', 'ltr', '59', 'Account Type', 'Account Type'),
(531, 'jrUser', 'en-US', 'utf-8', 'ltr', '60', 'Select the Type of Account you would like to sign up for.', 'Select the Type of Account you would like to sign up for.'),
(532, 'jrUser', 'en-US', 'utf-8', 'ltr', '61', 'Invalid Signup Account Type - please ensure you are choosing a valid Signup Account Type', 'Invalid Signup Account Type - please ensure you are choosing a valid Signup Account Type'),
(533, 'jrUser', 'en-US', 'utf-8', 'ltr', '62', 'language', 'language'),
(534, 'jrUser', 'en-US', 'utf-8', 'ltr', '63', 'Select the language you would like to use throughout the site', 'Select the language you would like to use throughout the site'),
(535, 'jrUser', 'en-US', 'utf-8', 'ltr', '64', 'Notifications', 'Notifications'),
(536, 'jrUser', 'en-US', 'utf-8', 'ltr', '65', 'Do Not Notify', 'Do Not Notify'),
(537, 'jrUser', 'en-US', 'utf-8', 'ltr', '66', 'Send Email', 'Send Email'),
(538, 'jrUser', 'en-US', 'utf-8', 'ltr', '67', 'Send Private Note', 'Send Private Note'),
(539, 'jrUser', 'en-US', 'utf-8', 'ltr', '68', 'Please enter an email address - without an email address you will not be able to retrieve your account information if needed.', 'Please enter an email address - without an email address you will not be able to retrieve your account information if needed.'),
(540, 'jrUser', 'en-US', 'utf-8', 'ltr', '69', 'This is a quick email to let you know that your email address on your', 'This is a quick email to let you know that your email address on your'),
(541, 'jrUser', 'en-US', 'utf-8', 'ltr', '70', 'account has been changed to', 'account has been changed to'),
(542, 'jrUser', 'en-US', 'utf-8', 'ltr', '71', 'If you did NOT change this in your account, please login ASAP and change your email address back, and let us know.', 'If you did NOT change this in your account, please login ASAP and change your email address back, and let us know.'),
(543, 'jrUser', 'en-US', 'utf-8', 'ltr', '72', 'Your email address on your account has been changed', 'Your email address on your account has been changed'),
(544, 'jrUser', 'en-US', 'utf-8', 'ltr', '73', 'A new', 'A new'),
(545, 'jrUser', 'en-US', 'utf-8', 'ltr', '74', 'account has been created for you!', 'account has been created for you!'),
(546, 'jrUser', 'en-US', 'utf-8', 'ltr', '75', 'username', 'username'),
(547, 'jrUser', 'en-US', 'utf-8', 'ltr', '76', 'Log in to the system here', 'Log in to the system here'),
(548, 'jrUser', 'en-US', 'utf-8', 'ltr', '77', 'Please CHANGE YOUR PASSWORD once you are logged in.', 'Please CHANGE YOUR PASSWORD once you are logged in.'),
(549, 'jrUser', 'en-US', 'utf-8', 'ltr', '78', 'We look forward to seeing you online!', 'We look forward to seeing you online!'),
(550, 'jrUser', 'en-US', 'utf-8', 'ltr', '79', 'your new', 'your new'),
(551, 'jrUser', 'en-US', 'utf-8', 'ltr', '80', 'account', 'account'),
(552, 'jrUser', 'en-US', 'utf-8', 'ltr', '81', 'We''ve received a password reset request for this email address.  If you requested your password to be reset, please click on the following link, or cut and paste it into your browser window', 'We''ve received a password reset request for this email address.  If you requested your password to be reset, please click on the following link, or cut and paste it into your browser window'),
(553, 'jrUser', 'en-US', 'utf-8', 'ltr', '82', 'This will allow you to set a new password for your account. If you did not request this password reset request, you can ignore this email and the request will expire.', 'This will allow you to set a new password for your account. If you did not request this password reset request, you can ignore this email and the request will expire.'),
(554, 'jrUser', 'en-US', 'utf-8', 'ltr', '83', 'password reset', 'password reset'),
(555, 'jrUser', 'en-US', 'utf-8', 'ltr', '84', 'Thank you for signing up for a', 'Thank you for signing up for a'),
(556, 'jrUser', 'en-US', 'utf-8', 'ltr', '85', 'account!', 'account!'),
(557, 'jrUser', 'en-US', 'utf-8', 'ltr', '86', 'You are one step away from joining our community - simply click on the following link to activate your account', 'You are one step away from joining our community - simply click on the following link to activate your account'),
(558, 'jrUser', 'en-US', 'utf-8', 'ltr', '87', 'If you have any questions, or have any issues validating your account, please don''t hesitate to contact us.', 'If you have any questions, or have any issues validating your account, please don''t hesitate to contact us.'),
(559, 'jrUser', 'en-US', 'utf-8', 'ltr', '88', 'account validation', 'account validation'),
(560, 'jrUser', 'en-US', 'utf-8', 'ltr', '89', 'invalid user id - please try again', 'invalid user id - please try again'),
(561, 'jrUser', 'en-US', 'utf-8', 'ltr', '90', 'human check', 'human check'),
(562, 'jrUser', 'en-US', 'utf-8', 'ltr', '91', 'check this to let us know you are human, and not a spam bot.', 'check this to let us know you are human, and not a spam bot.'),
(563, 'jrUser', 'en-US', 'utf-8', 'ltr', '92', 'You forgot to check the &quot;human check&quot; checkbox - if you are not a spam bot, make sure it is checked.', 'You forgot to check the &quot;human check&quot; checkbox - if you are not a spam bot, make sure it is checked.'),
(564, 'jrUser', 'en-US', 'utf-8', 'ltr', '93', 'Upload a unique User Photo that will be used in your User Account. Note that this photo is different than the photo used in your Profile, which can be set in the &quot;Profile&quot; tab.', 'Upload a unique User Photo that will be used in your User Account. Note that this photo is different than the photo used in your Profile, which can be set in the &quot;Profile&quot; tab.'),
(565, 'jrUser', 'en-US', 'utf-8', 'ltr', '94', 'All notification emails have been disabled', 'All notification emails have been disabled'),
(566, 'jrUser', 'en-US', 'utf-8', 'ltr', '95', 'All notifications are currently disabled - you will not receive any notifications!', 'All notifications are currently disabled - you will not receive any notifications!'),
(567, 'jrUser', 'en-US', 'utf-8', 'ltr', '96', 'The email address you entered is already being used by another account', 'The email address you entered is already being used by another account'),
(568, 'jrUser', 'en-US', 'utf-8', 'ltr', '97', 'If you would prefer to no longer receive event notifications, you can adjust', 'If you would prefer to no longer receive event notifications, you can adjust'),
(569, 'jrUser', 'en-US', 'utf-8', 'ltr', '98', 'your notification preferences in your User Account:', 'your notification preferences in your User Account:'),
(570, 'jrUser', 'en-US', 'utf-8', 'ltr', '99', 'Or you can disable all notifications for all events:', 'Or you can disable all notifications for all events:'),
(571, 'jrUser', 'en-US', 'utf-8', 'ltr', '100', 'The User Name you have entered is already being used by another account', 'The User Name you have entered is already being used by another account'),
(572, 'jrUser', 'en-US', 'utf-8', 'ltr', '101', 'online', 'online'),
(573, 'jrUser', 'en-US', 'utf-8', 'ltr', '102', 'offline', 'offline'),
(574, 'jrUser', 'en-US', 'utf-8', 'ltr', '103', 'email address or user name', 'email address or user name'),
(575, 'jrUser', 'en-US', 'utf-8', 'ltr', '104', 'enter the email address you used to signup, or your user name to start the password reset process', 'enter the email address you used to signup, or your user name to start the password reset process'),
(576, 'jrUser', 'en-US', 'utf-8', 'ltr', '105', 'Your account has been successfully created!<br>An Admin has been notified to approve your account - you will be notified by email when you''re all set.<br>Thanks for signing up!', 'Your account has been successfully created!<br>An Admin has been notified to approve your account - you will be notified by email when you''re all set.<br>Thanks for signing up!'),
(577, 'jrUser', 'en-US', 'utf-8', 'ltr', '106', 'Oops - set my notification preference back to the way they were', 'Oops - set my notification preference back to the way they were'),
(578, 'jrUser', 'en-US', 'utf-8', 'ltr', '107', 'You are no longer blocking all notifications', 'You are no longer blocking all notifications'),
(579, 'jrUser', 'en-US', 'utf-8', 'ltr', '108', 'You must be logged in before you can continue', 'You must be logged in before you can continue'),
(580, 'jrUser', 'en-US', 'utf-8', 'ltr', '109', 'This site is private and only visible to logged in users.', 'This site is private and only visible to logged in users.'),
(581, 'jrUser', 'en-US', 'utf-8', 'ltr', '110', 'Click Here to Log In', 'Click Here to Log In'),
(582, 'jrUser', 'en-US', 'utf-8', 'ltr', '111', 'Click Here to Create an Account', 'Click Here to Create an Account'),
(583, 'jrUser', 'en-US', 'utf-8', 'ltr', '112', 'You must enter your <strong>existing password</strong> to continue', 'You must enter your <strong>existing password</strong> to continue'),
(584, 'jrUser', 'en-US', 'utf-8', 'ltr', '113', 'continue', 'continue'),
(585, 'jrUser', 'en-US', 'utf-8', 'ltr', '114', 'Login box will show here for non-logged in users', 'Login box will show here for non-logged in users'),
(586, 'jrUser', 'en-US', 'utf-8', 'ltr', '115', 'Form submitted successfully - Thank you!', 'Form submitted successfully - Thank you!'),
(587, 'jrUser', 'en-US', 'utf-8', 'ltr', '116', 'account settings', 'account settings'),
(588, 'jrUser', 'en-US', 'utf-8', 'ltr', '117', 'log out', 'log out'),
(589, 'jrUser', 'en-US', 'utf-8', 'ltr', '118', 'Unsubscribe from all email notifications', 'Unsubscribe from all email notifications'),
(590, 'jrUser', 'en-US', 'utf-8', 'ltr', '119', 'Unsubscribe', 'Unsubscribe'),
(591, 'jrUser', 'en-US', 'utf-8', 'ltr', '120', 'Check this option to be removed from all Notifications.', 'Check this option to be removed from all Notifications.'),
(592, 'jrUser', 'en-US', 'utf-8', 'ltr', '121', 'Your Email Address will be removed from all future notifications', 'Your Email Address will be removed from all future notifications'),
(593, 'jrUser', 'en-US', 'utf-8', 'ltr', '122', 'disable all notifications', 'disable all notifications'),
(594, 'jrUser', 'en-US', 'utf-8', 'ltr', '123', 'An email with an unsubscribe confirm link has been sent to ', 'An email with an unsubscribe confirm link has been sent to '),
(595, 'jrUser', 'en-US', 'utf-8', 'ltr', '124', 'Please open that email and confirm you wish to unsubscribe or login and change your notifications from the notifications tab.', 'Please open that email and confirm you wish to unsubscribe or login and change your notifications from the notifications tab.'),
(596, 'jrUser', 'en-US', 'utf-8', 'ltr', '125', 'Enter the email address or username you used to signup with.', 'Enter the email address or username you used to signup with.'),
(597, 'jrUser', 'en-US', 'utf-8', 'ltr', '126', 'has signed up', 'has signed up'),
(598, 'jrUser', 'en-US', 'utf-8', 'ltr', '127', 'has logged in', 'has logged in'),
(599, 'jrUser', 'en-US', 'utf-8', 'ltr', '128', 'Users', 'Users'),
(600, 'jrUser', 'en-US', 'utf-8', 'ltr', '129', 'You have entered an invalid or reserved User Name', 'You have entered an invalid or reserved User Name'),
(601, 'jrUser', 'en-US', 'utf-8', 'ltr', '130', 'Select Account Type', 'Select Account Type'),
(602, 'jrUser', 'en-US', 'utf-8', 'ltr', '131', 'Already Have an Account?', 'Already Have an Account?'),
(603, 'jrUser', 'en-US', 'utf-8', 'ltr', '132', 'Forgot Password?', 'Forgot Password?'),
(604, 'jrUser', 'en-US', 'utf-8', 'ltr', '133', 'Create New Password', 'Create New Password'),
(605, 'jrUser', 'en-US', 'utf-8', 'ltr', '134', 'Delete Account', 'Delete Account'),
(606, 'jrUser', 'en-US', 'utf-8', 'ltr', '135', 'Are you sure you want to delete your Account?', 'Are you sure you want to delete your Account?'),
(607, 'jrUser', 'en-US', 'utf-8', 'ltr', '136', 'Maximum Password length is 80 characters', 'Maximum Password length is 80 characters'),
(608, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '1', 'Home', 'Home'),
(609, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '2', 'create', 'create'),
(610, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '3', 'account', 'account'),
(611, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '4', 'Top 10 Tracks', 'Top 10 Tracks'),
(612, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '5', 'Logout', 'Logout'),
(613, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '6', 'Forum Topics', 'Forum Topics'),
(614, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '7', 'Welcome To Elastic', 'Welcome To Elastic'),
(615, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '8', 'New Members', 'New Members'),
(616, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '9', 'by', 'by'),
(617, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '10', 'Upcoming Events', 'Upcoming Events'),
(618, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '11', 'Latest Gallery Images', 'Latest Gallery Images'),
(619, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '12', 'Highly Configurable', 'Highly Configurable'),
(620, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '13', 'Responsive Design', 'Responsive Design'),
(621, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '14', 'Site Builder', 'Site Builder'),
(622, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '15', 'Template Editor', 'Template Editor'),
(623, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '16', 'ACP', 'ACP'),
(624, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '17', 'dashboard', 'dashboard'),
(625, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '18', 'Scalable', 'Scalable'),
(626, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '19', 'Expandable', 'Expandable'),
(627, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '20', 'Updates', 'Updates'),
(628, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '21', 'Birthday', 'Birthday'),
(629, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '22', 'login', 'login'),
(630, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '23', 'Update Cover Image', 'Update Cover Image'),
(631, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '24', 'Search', 'Search'),
(632, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '25', 'Account Settings', 'Account Settings'),
(633, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '26', 'Hot Videos', 'Hot Videos'),
(634, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '27', 'Help', 'Help'),
(635, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '28', 'Documentation', 'Documentation'),
(636, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '29', 'Community Forum', 'Community Forum'),
(637, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '30', 'VIP Support', 'VIP Support'),
(638, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '31', 'Marketplace', 'Marketplace'),
(639, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '32', 'User Chat', 'User Chat'),
(640, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '33', 'View Skin Demo', 'View Skin Demo'),
(641, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '34', 'Skin Language', 'Skin Language'),
(642, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '35', 'skin settings', 'skin settings'),
(643, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '36', 'skin notes', 'skin notes'),
(644, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '37', 'skin images', 'skin images'),
(645, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '38', 'skin style', 'skin style'),
(646, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '39', 'skin templates', 'skin templates'),
(647, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '40', 'Forum Topics', 'Forum Topics'),
(648, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '41', 'Hot Videos', 'Hot Videos'),
(649, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '42', 'Admin Blog', 'Admin Blog'),
(650, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '43', 'Followers', 'Followers'),
(651, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '44', 'About', 'About'),
(652, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '45', 'Profile Stats', 'Profile Stats'),
(653, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '46', 'Recently Rated', 'Recently Rated'),
(654, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '47', 'Influences', 'Influences'),
(655, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '48', 'Latest Comments', 'Latest Comments'),
(656, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '49', 'users', 'users'),
(657, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '50', 'quota browser', 'quota browser'),
(658, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '51', 'profile browser', 'profile browser'),
(659, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '52', 'user accounts', 'user accounts'),
(660, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '53', 'users online', 'users online'),
(661, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '54', 'image caches', 'image caches'),
(662, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '55', 'ACP', 'ACP'),
(663, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '56', 'system tools', 'system tools'),
(664, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '57', 'activity logs', 'activity logs'),
(665, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '58', 'reset image caches', 'reset image caches'),
(666, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '59', 'integrity check', 'integrity check'),
(667, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '60', 'system updates', 'system updates'),
(668, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '61', 'system check', 'system check'),
(669, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '62', 'Follow', 'Follow'),
(670, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '63', 'Bio', 'Bio'),
(671, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '64', 'more', 'more'),
(672, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '65', 'Joined', 'Joined'),
(673, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '66', 'Edit', 'Edit'),
(674, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '67', 'Cart', 'Cart'),
(675, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '68', 'Following', 'Following'),
(676, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '69', 'Click to see full image', 'Click to see full image'),
(677, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '70', 'View Profile', 'View Profile'),
(678, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '71', 'Watch Video', 'Watch Video'),
(679, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '72', 'View Gallery', 'View Gallery'),
(680, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '73', 'user name or email', 'user name or email'),
(681, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '74', 'password', 'password'),
(682, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '75', 'remember me', 'remember me'),
(683, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '76', 'No items found', 'No items found'),
(684, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '77', 'Banner Image', 'Banner Image'),
(685, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '78', 'This is your profile banner background at the top of your profile', 'This is your profile banner background at the top of your profile'),
(686, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '79', 'Website', 'Website'),
(687, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '80', 'must include http://', 'must include http://'),
(688, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '81', 'Enter the home website for this profile', 'Enter the home website for this profile'),
(689, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '82', 'Location', 'Location'),
(690, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '83', 'City, State', 'City, State'),
(691, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '84', 'Enter the home location for this profile', 'Enter the home location for this profile'),
(692, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '85', 'The page you requested was not found', 'The page you requested was not found'),
(693, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '86', 'user menu editor', 'user menu editor'),
(694, 'jrElastic2', 'en-US', 'utf-8', 'ltr', '87', 'NOT FOUND', 'NOT FOUND');

-- --------------------------------------------------------

--
-- Table structure for table `jr_jruser_pw_attempt`
--

CREATE TABLE `jr_jruser_pw_attempt` (
  `a_ip` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `a_time` int(11) unsigned NOT NULL DEFAULT '0',
  `a_count` smallint(5) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `a_ip` (`a_ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jruser_session`
--

CREATE TABLE `jr_jruser_session` (
  `session_id` varchar(128) COLLATE utf8_unicode_ci NOT NULL,
  `session_updated` int(10) unsigned NOT NULL DEFAULT '0',
  `session_user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `session_user_name` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `session_user_group` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `session_profile_id` int(11) unsigned NOT NULL DEFAULT '0',
  `session_quota_id` int(11) unsigned NOT NULL DEFAULT '0',
  `session_user_ip` varchar(45) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `session_user_action` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `session_sync` int(11) unsigned NOT NULL DEFAULT '0',
  `session_data` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`session_id`),
  KEY `session_updated` (`session_updated`),
  KEY `session_user_id` (`session_user_id`),
  KEY `session_user_name` (`session_user_name`(8)),
  KEY `session_profile_id` (`session_profile_id`),
  KEY `session_user_ip` (`session_user_ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `jr_jruser_session`
--

-- --------------------------------------------------------

--
-- Table structure for table `jr_jruser_stat`
--

CREATE TABLE `jr_jruser_stat` (
  `stat_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `stat_date` int(11) unsigned NOT NULL DEFAULT '0',
  `stat_key` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `stat_value` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`stat_id`),
  UNIQUE KEY `stat_unique` (`stat_date`,`stat_key`),
  KEY `stat_key` (`stat_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jr_jruser_suppressed`
--

CREATE TABLE `jr_jruser_suppressed` (
  `email_address` varchar(128) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  UNIQUE KEY `email_address` (`email_address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
