<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: admin
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_admin($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();

    // Reset any saved location
    if (function_exists('jrUser_delete_saved_url_location')) {
        jrUser_delete_saved_url_location();
    }

    $admin = '';
    $title = '';
    // See if we are getting an INDEX page for this module.  The Index
    // Page will tell us what "view" for the module config they are showing.
    // This can be either a config page for the module (i.e. global settings,
    // quota settings, language, etc.) OR it can be a tool.
    // Our URL will be like:
    // http://www.site.com/core/config/global
    // http://www.site.com/core/config/quota
    // http://www.site.com/core/config/language
    // http://www.site.com/core/config/tools
    if (!isset($_post['_1'])) {
        $_post['_1'] = 'global';
    }
    switch ($_post['_1']) {

        //------------------------------
        // GLOBAL SETTINGS
        //------------------------------
        case 'global':
            if (is_file(APP_DIR . "/repair.php")) {
                jrCore_set_form_notice('error', "Delete the <strong>repair.php</strong> script from your root directory or rename it to <strong>repair.php.html</strong>!", false);
            }
            $title = 'Global Config';
            $admin = jrCore_show_global_settings('module', $_post['module'], $_post, $_user, $_conf);
            break;

        //------------------------------
        // QUOTA SETTINGS
        //------------------------------
        case 'quota':
            $title = 'Quota Config';
            $admin = jrProfile_show_module_quota_settings($_post['module'], $_post, $_user, $_conf);
            break;

        //------------------------------
        // TOOLS
        //------------------------------
        case 'tools':
            $title = 'Tools';
            $admin = jrCore_show_module_tools($_post['module'], $_post, $_user, $_conf);
            break;

        //------------------------------
        // LANGUAGE STRINGS
        //------------------------------
        case 'language':
            $title = 'Language Strings';
            $admin = jrUser_show_module_lang_strings('module', $_post['module'], $_post, $_user, $_conf);
            break;

        //------------------------------
        // TEMPLATES
        //------------------------------
        case 'templates':
            $title = 'Templates';
            $admin = jrCore_show_module_templates($_post['module'], $_post, $_user, $_conf);
            break;

        //------------------------------
        // IMAGES
        //------------------------------
        case 'images':
            $title = 'Images';
            $admin = jrCore_show_skin_images('module', $_post['module'], $_post, $_user, $_conf);
            break;

        //------------------------------
        // INFO
        //------------------------------
        case 'info':
            $title = 'Info';
            $admin = jrCore_show_module_info($_post['module'], $_post, $_user, $_conf);
            break;

    }

    // Process view
    $_rep = array(
        'modules'            => array(),
        'active_tab'         => 'modules',
        'admin_page_content' => $admin
    );

    $_tmp = array();
    $_ina = array();
    foreach ($_mods as $mod_dir => $_inf) {
        if (file_exists(APP_DIR . "/modules/{$mod_dir}/include.php")) {
            if ($_inf['module_active'] == '1') {
                $_tmp[$mod_dir] = $_inf['module_name'];
            }
            else {
                $_ina[$mod_dir] = $_inf['module_name'];
            }
        }
    }
    natcasesort($_tmp);
    natcasesort($_ina);
    $_tmp = array_merge($_tmp, $_ina);

    $_out = array();
    foreach ($_tmp as $mod_dir => $ignored) {
        if (!isset($_mods[$mod_dir]['module_category'])) {
            $_mods[$mod_dir]['module_category'] = 'tools';
        }
        $cat = $_mods[$mod_dir]['module_category'];
        if (!isset($_out[$cat])) {
            $_out[$cat] = array();
        }
        $_out[$cat][$mod_dir] = $_mods[$mod_dir];
    }
    $_rep['_modules']['core'] = $_out['core'];
    unset($_out['core']);
    $_rep['_modules'] = $_rep['_modules'] + $_out;
    ksort($_rep['_modules']);
    unset($_out);

    $_rep['default_category'] = 'core';
    if (!empty($_mods["{$_post['module']}"]['module_category'])) {
        $_rep['default_category'] = $_mods["{$_post['module']}"]['module_category'];
    }

    // See if our skin is overriding our core admin template
    jrCore_install_new_modules();
    $html = jrCore_parse_template('admin.tpl', $_rep, 'jrCore');

    // Output
    $_mta = jrCore_module_meta_data($_post['module']);
    jrCore_page_title("{$title} - {$_mta['name']}");
    jrCore_admin_menu_accordion_js($_rep['default_category']);
    jrCore_page_custom($html);
    jrCore_page_display();
}
