<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: empty_recycle_bin
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_empty_recycle_bin($_post, $_user, $_conf)
{
    jrUser_admin_only();
    jrCore_validate_location_url();

    // Make sure we have not blocked RB empty
    $del = (int) jrCore_get_config_value('jrCore', 'enable_rb_delete', 1);
    if ($del !== 1) {
        jrCore_set_form_notice('error', 'Unable to empty recycle bin');
        jrCore_location('referrer');
    }

    // Get all RB modules => item_ids for trigger
    $tbl = jrCore_db_table_name('jrCore', 'recycle');
    $req = "SELECT r_module AS module, r_item_id AS iid, r_profile_id AS pid, r_data FROM {$tbl}";
    $_rt = jrCore_db_query($req, 'NUMERIC');
    if ($_rt && is_array($_rt)) {
        $_tm = array();
        foreach ($_rt as $_rb) {
            $mod = $_rb['module'];
            if (!isset($_tm[$mod])) {
                $_tm[$mod] = array();
            }
            $_tm[$mod][] = (int) $_rb['iid'];
        }
    }
    else {
        $_tm = array();
    }

    // Trigger
    jrCore_trigger_event('jrCore', 'empty_recycle_bin', $_tm);

    // Empty everything
    $tbl = jrCore_db_table_name('jrCore', 'recycle');
    jrCore_db_query("TRUNCATE TABLE {$tbl}");

    // Cleanup attached media - split into chunks for our worker
    $cnt = 0;
    if ($_rt && is_array($_rt)) {
        $cnt = count($_rt);
        $_rt = array_chunk($_rt, 100);
        foreach ($_rt as $_ch) {
            jrCore_queue_create('jrCore', 'empty_recycle_bin_files', array('_items' => $_ch));
        }
    }

    if ($cnt > 0) {
        jrCore_logger('INF', 'core: the recycle bin has been emptied (' . jrCore_number_format($cnt) . ' items)');
    }
    jrCore_set_form_notice('success', 'The Recycle Bin has been emptied');
    jrCore_location('referrer');
}
