<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: item_action_button_modify_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_item_action_button_modify_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);

    if (!isset($_post['t']) || strlen($_post['t']) === 0) {
        jrCore_set_form_notice('error', 'Error - missing button type');
        jrCore_location('referrer');
    }
    $type = '';
    switch ($_post['t']) {
        case 'index':
        case 'list':
        case 'detail':
        case 'bundle_index':
        case 'bundle_list':
        case 'bundle_detail':
            $type = $_post['t'];
            break;
        default:
            jrCore_set_form_notice('error', 'Invalid button type');
            jrCore_location('referrer');
            break;
    }
    if (!isset($_post['m']) || !jrCore_module_is_active($_post['m'])) {
        jrCore_set_form_notice('error', 'invalid module');
        jrCore_location('referrer');
    }
    $mod = $_post['m'];
    if (!isset($_post['o']) || !jrCore_checktype($_post['o'], 'number_nn')) {
        jrCore_set_form_notice('error', 'invalid button offset');
        jrCore_location('referrer');
    }
    $idx = (int) $_post['o'];

    // See if we have customized this button
    $_rs = false;
    $_rt = false;
    $opt = "{$mod}_item_{$type}_buttons";
    if (isset($_conf[$opt])) {
        $_rs = json_decode($_conf[$opt], true);
        if (isset($_rs[$idx])) {
            $_rt = $_rs[$idx];
        }
    }
    else {
        // We've never set order for this module - create conf entry
        $_tmp = array(
            'name'     => "item_{$type}_buttons",
            'default'  => '',
            'type'     => 'hidden',
            'required' => 'off',
            'validate' => 'not_empty',
            'label'    => "item {$type} buttons",
            'help'     => "this hidden field keeps track of the item {$type} button information for {$_post['m']}/{$_post['t']} - do not modify"
        );
        jrCore_register_setting($mod, $_tmp);
    }

    // See if we fall through
    if (!$_rt) {
        // Get our existing (default) order
        $_rs = array();
        $_rf = jrCore_get_registered_module_features('jrCore', "item_{$type}_button");
        if ($_rf && is_array($_rf)) {
            foreach ($_rf as $bmod => $_ft) {
                foreach ($_ft as $func => $_inf) {
                    $_inf['module']   = $bmod;
                    $_inf['function'] = $func;
                    $_rs[]            = $_inf;
                }
            }
        }
        else {
            jrCore_set_form_notice('error', "no registered {$type} buttons found");
            jrCore_location('referrer');
        }
        if (!isset($_rs[$idx])) {
            jrCore_set_form_notice('error', "invalid button offset");
            jrCore_location('referrer');
        }
    }

    // See if they are active for this view
    foreach ($_rs as $k => $_inf) {
        if (isset($_inf['function'])) {
            $func = $_inf['function'];
            if (function_exists($func)) {
                if (!$func($mod, false, false, false, true)) {
                    unset($_rs[$k]);
                }
            }
        }
    }
    $_rs = array_values($_rs);

    // Update with new settings
    $_rs[$idx]['active'] = $_post['active'];
    $_rs[$idx]['quota']  = trim($_post['quota']);
    if ($_post['group'] != '0') {
        $_rs[$idx]['group'] = trim($_post['group']);
    }
    else {
        unset($_rs[$idx]['group']);
    }

    jrCore_form_delete_session();
    jrCore_set_setting_value($mod, "item_{$type}_buttons", json_encode($_rs));

    // Reset caches
    jrCore_delete_config_cache();
    jrCore_delete_all_cache_entries($mod);

    if (jrCore_checktype($_conf['jrCore_default_cache_seconds'], 'number_nz')) {
        jrCore_set_form_notice('success', 'The button settings have been updated.<br>Make sure and <a href="' . $_conf['jrCore_base_url'] . '/' . $_post['module_url'] . '/cache_reset"><u>Reset Caches</u></a> when complete for your changes to take effect', false);
    }
    else {
        jrCore_set_form_notice('success', 'The button settings have been updated');
    }
    jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/item_action_buttons/{$type}/m={$mod}");
}
