{jrCore_lang module="jrGeo" id=5 default="Zip Search Results" assign="zr"}
{jrCore_page_title title=$zr}
{jrCore_include template="header.tpl"}
{jrCore_module_url module="jrGeo" assign="murl"}
{jrCore_module_url module=$module assign="surl"}

<div class="block">
    <div class="block_content">
        <div class="item">
            <div class="row">
                <div class="col12 last">
                    <div class="p10">

                        {jrCore_lang module="jrGeo" id=1 default="Zip Code" assign="zc"}
                        {jrCore_lang module="jrGeo" id=3 default="Search" assign="sc"}
                        {if $_conf.jrGeo_zip_display == 'miles'}
                            {jrCore_lang module="jrGeo" id=2 default="Miles" assign="ml"}
                        {else}
                            {jrCore_lang module="jrGeo" id=6 default="Kilometers" assign="ml"}
                        {/if}

                        {$zc}:<br>
                        <form method="GET">
                        <input id="zip-code-url" type="hidden" name="zip_url" value="{$surl}">
                        <input id="zip-code-key" type="hidden" name="zip_key" value="{$ds_key}">
                        <input id="zip-code-input" type="text" name="zip_code" class="form_text" value="{$_zip.zip_code}" onkeypress="if (event && event.keyCode == 13 && this.value.length > 0) { jrGeo_zip_search(); return false }">
                        <select id="zip-code-radius" name="zip_radius" class="form_select" onchange="jrGeo_zip_search()">
                            {foreach array(5,10,15,20,25,50) as $miles}
                                {if $miles == $radius}
                                    <option value="{$miles}" selected="selected">{$miles} {$ml}</option>
                                {else}
                                    <option value="{$miles}">{$miles} {$ml}</option>
                                {/if}
                            {/foreach}
                        </select>
                        &nbsp;<input type="submit" class="form_button" value="{$sc|jrCore_entity_string}" onclick="jrGeo_zip_search(); return false">
                        </form>
                    </div>
                </div>
            </div>
            <div class="row">

                <div class="col8">
                    <script>
                    function geo_init() {
                        var op = {
                            zoom: {$zoom},
                            mapTypeId: 'roadmap',
                            gestureHandling: 'greedy',
                            center: { lat: {$_zip.zip_lat}, lng: {$_zip.zip_lon} }
                        };
                        var ge = new google.maps.Geocoder();
                        var mp = new google.maps.Map($('#zip_code_map')[0], op);
                        {foreach $_items as $k => $v}

                            ge.geocode( { 'address': '{$v.address}' }, function(r,s) {
                                if (s == google.maps.GeocoderStatus.OK) {
                                    new google.maps.Marker({
                                        animation: google.maps.Animation.DROP,
                                        position: r[0].geometry.location,
                                        label: "{$k+1}",
                                        title: "{$v.title}",
                                        map: mp
                                    });
                                }
                            } );

                        {/foreach}
                    }
                    </script>
                    <script async defer src="https://maps.googleapis.com/maps/api/js?key={$api_key}&callback=geo_init"></script>

                    {if jrCore_is_mobile_device() && !jrCore_is_tablet_device()}
                        <div id="zip_code_map" style="width:100%;height:280px"></div>
                    {else}
                        <div id="zip_code_map" style="width:100%;height:400px"></div>
                    {/if}

                </div>
                <div class="col4 last">

                    {* listed items *}
                    {if !empty($_items)}
                    {foreach $_items as $k => $v}
                        <div class="row">
                            <div class="col1">
                                &nbsp;
                            </div>
                            <div class="col1">
                                <div class="p10 center" style="display:table;height:48px">
                                    <div style="display:table-cell;vertical-align:middle">
                                        <h1>{$k+1}</h1>
                                    </div>
                                </div>
                            </div>
                            <div class="col2">
                                <div class="p10 center">
                                    <a href="{$v.item_url}">{jrCore_module_function function="jrImage_display" module=$module type=$v.image_field item_id=$v._item_id size="large" crop="auto" class="iloutline img_scale" alt=$v.title title=$v.title width=48 height=48}</a>

                                </div>
                            </div>
                            <div class="col8 last">
                                <div class="p10">
                                    <h2><a href="{$v.item_url}">{$v.title|stripslashes}</a></h2><br>
                                    {$v.address}
                                </div>
                            </div>
                        </div>
                    {/foreach}


                    {else}

                        <div class="p10 center">
                            <h2>{jrCore_lang module="jrGeo" id=4 default="No Results Found"}</h2>
                        </div>

                    {/if}

                </div>
            </div>
        </div>
    </div>

</div>

{* for Find a Location *}
<div id="geo-zip-modal" style="display:none">
    {jrCore_lang module="jrGeo" id=7 default="Updating Search Results"}
    <br><br>
    {jrCore_image image="zip_searching.gif" width="66" height="auto" module="jrGeo" _v=$smarty.now}
</div>

{jrCore_include template="footer.tpl"}