<?php
 /**
 * Jamroom Marketplace module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: browse
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrMarket_browse($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrMarket', 'browse');
    $_skins = jrCore_get_skins();

    // Make sure we have a good release system
    if (!$_mkt = jrMarket_get_active_release_system()) {
        jrCore_set_form_notice('error', 'There are no active Marketplace Systems configured where you can download items or get system updates!<br>Enter a new Marketplace System below to enable the Marketplace.', false);
        jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/systems");
    }

    // delete any old update tmp info
    jrCore_delete_temp_value('jrMarket', 'jrupdate_results');

    // Make sure we are subscribed to at least 1 channel
    $tbl = jrCore_db_table_name('jrMarket', 'channel');
    $req = "SELECT * FROM {$tbl} WHERE channel_system_id = '{$_mkt['system_id']}' AND channel_active = '1'";
    $_rt = jrCore_db_query($req, 'channel_id');
    if (!$_rt || !is_array($_rt)) {
        jrCore_set_form_notice('error', 'You have not subscribed to any Release Channels - no updates or installs can be provided.<br><br>You can activate a Release Channel from the <a href="' . $_conf['jrCore_base_url'] . '/' . $_post['module_url'] . '/release_channels"><b><u>Release Channels</u></b></a> tool.', false);
        jrCore_page_banner('Marketplace');
        jrCore_get_form_notice();
        jrCore_page_display();
        exit;
    }
    $sec = jrMarket_system_jumper() . '&nbsp' . '<img src="' . $_conf['jrCore_base_url'] . '/image/img/module/jrMarket/secure.png?v=' . $_mods['jrMarket']['module_version'] . '" alt="Your purchase is secured via SSL - click for info" title="Your purchase is secured via SSL - click for info" width="32" height="32" style="cursor:pointer" onclick="$(\'#secure_notice\').slideToggle(300);">';

    // Send out our call to get modules and skins
    // The TYPE we are browsing will come in as _1
    // i.e. market/browse/modules
    if (!isset($_post['_1'])) {
        $_post['_1'] = 'module';
    }
    switch ($_post['_1']) {
        case 'skin':
        case 'module':
        case 'bundle':
        case 'installed':
            break;
        default:
            $_post['_1'] = 'module';
            break;
    }

    // Subscribed Channels
    $_ch = array();
    foreach ($_rt as $_chan) {
        switch ($_chan['channel_name']) {
            case 'stable':
            case 'beta':
                $_ch[] = "c[]={$_chan['channel_name']}";
                break;
            default:
                if (!empty($_chan['channel_code'])) {
                    $_ch[] = "c[]={$_chan['channel_code']}";
                }
                break;
        }
    }

    // System Info
    $_si      = jrMarket_get_active_system_info();
    $_si['p'] = 1;

    // Page number
    if (isset($_post['p']) && jrCore_checktype($_post['p'], 'number_nz') && $_post['p'] > 1) {
        $_si['p'] = (int) $_post['p'];
    }
    // Search string
    if (isset($_post['search_string']) && strlen($_post['search_string']) > 0) {
        $_si['ss'] = jrCore_url_encode_string($_post['search_string']);
    }
    // Search Name
    if (isset($_post['sn']) && strlen($_post['sn']) > 0) {
        $_si['sn'] = $_post['sn'];
    }
    // Installed
    $_ins = array_keys($_mods);
    // See if we are searching for a specific module directory name
    if (isset($_post['search_string']) && strlen($_post['search_string']) > 0 && isset($_mods["{$_post['search_string']}"])) {
        foreach ($_ins as $k => $v) {
            if ($v == $_post['search_string']) {
                unset($_ins[$k]);
            }
        }
    }
    foreach ($_ins as $k => $mod_dir) {
        if (!is_dir(APP_DIR . "/modules/{$mod_dir}") && !is_link(APP_DIR . "/modules/{$mod_dir}")) {
            unset($_ins[$k]);
        }
    }
    foreach ($_skins as $skin) {
        if (is_dir(APP_DIR . "/skins/{$skin}") || is_link(APP_DIR . "/skins/{$skin}")) {
            $_ins[] = $skin;
        }
    }

    $_si['installed'] = jrCore_url_encode_string(implode(',', $_ins));

    // Get marketplace items
    $_rs = jrCore_load_url("{$_mkt['system_url']}/networkmarket/browse?type={$_post['_1']}&" . implode('&', $_ch), $_si, 'POST', jrMarket_get_port(), null, null, true, 12);
    if ($_rs && strpos($_rs, '{') === 0) {
        $_rs = json_decode($_rs, true);
        if (isset($_rs['error'])) {
            jrCore_set_form_notice('error', $_rs['error'], false);
        }
    }
    else {
        jrCore_page_banner('Marketplace', $sec);
        if (strpos($_rs, 'system maintenance') || strpos($_rs, 'jrLaunch')) {
            jrCore_set_form_notice('notice', 'The Active Marketplace is currently down for maintenance - please try again shortly');
        }
        else {
            $button = jrCore_page_button('config', 'Update Marketplace Configuration', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/get_active_release_system')");
            jrCore_set_form_notice('error', 'An error was encountered trying to communicate with the Active Marketplace<br>make sure the Marketplace URL is set correctly in Tools -> Marketplace Systems.<br><br>' . $button, false);
        }
        jrCore_get_form_notice();
        jrCore_page_display();
        exit;
    }

    $_ds = jrCore_get_disk_usage();
    if ($_ds['percent_used'] > 90 && $_ds['disk_free'] < 100000000) {
        jrCore_set_form_notice('warning', "Your site is low on disk space (currently using {$_ds['percent_used']}%)<br>Try to free up disk space before installing or updating modules or skins.", false);
    }

    if ($_rs && isset($_rs['_items']) && is_array($_rs['_items']) && $_post['_1'] != 'bundle') {
        foreach ($_rs['_items'] as $k => $_v) {
            if (isset($_v['market_name'])) {
                // Is this a module? and is it actually installed?
                if (isset($_mods["{$_v['market_name']}"]) && (is_dir(APP_DIR . "/modules/{$_v['market_name']}") || is_link(APP_DIR . "/modules/{$_v['market_name']}"))) {
                    $_rs['_items'][$k]['market_already_installed'] = 1;
                }
                // Is this a skin? and is it actually installed?
                elseif (in_array($_v['market_name'], $_skins) && (is_dir(APP_DIR . "/skins/{$_v['market_name']}") || is_link(APP_DIR . "/skins/{$_v['market_name']}"))) {
                    $_rs['_items'][$k]['market_already_installed'] = 1;
                }
                else {
                    // Bad install
                    $_rs['_items'][$k]['market_already_installed'] = 0;
                }
            }
            else {
                $_rs['_items'][$k]['market_already_installed'] = 0;
            }
            // Does this require a module that is not installed?
            if (!empty($_v['market_requires'])) {
                // [market_requires] => jrCore:6.1.6b5
                // [market_requires] => jrPayment,jrCore,jrUser
                foreach (explode(',', $_v['market_requires']) as $mod) {
                    $mod = trim($mod);
                    if (strpos($mod, ':')) {
                        list($mod, $ver) = explode(':', $mod);
                        $mod = trim($mod);
                        $ver = trim($ver);
                        if (!isset($_mods[$mod])) {
                            $_rs['_items'][$k]['market_missing_required_mod']   = $mod;
                            $_rs['_items'][$k]['market_missing_required_title'] = $_v['market_require_titles'][$mod];
                            break;
                        }
                        else {
                            if (version_compare($ver, $_mods[$mod]['module_version']) == 1) {
                                $_rs['_items'][$k]['market_missing_required_mod']   = $mod;
                                $_rs['_items'][$k]['market_missing_required_title'] = $_v['market_require_titles'][$mod];
                                break;
                            }
                        }
                    }
                    else {
                        if (!isset($_mods[$mod])) {
                            $_rs['_items'][$k]['market_missing_required_mod']   = $mod;
                            $_rs['_items'][$k]['market_missing_required_title'] = $_v['market_require_titles'][$mod];
                            break;
                        }
                    }
                }

            }
        }
    }

    $active = 'module';
    switch ($_post['_1']) {
        case 'module':
        case 'skin':
        case 'bundle':
        case 'installed':
            $active = $_post['_1'];
            break;
    }
    jrCore_page_banner('Marketplace', $sec);
    jrCore_get_form_notice();

    // Our security note
    $_inf = jrMarket_get_market_info();
    $note = '<div id="secure_notice" style="padding:0 18px;display:none"><div class="item success rounded">Your Purchase is <b>100% secure</b>.  ' . $_inf['system_name'] . ' uses <a href="https://stripe.com/" target="_blank" rel="noreferrer noopener"><b>Stripe</b></a> for all Marketplace purchases - your Credit Card information is never sent or stored anywhere on the ' . $_inf['system_name'] . ' servers. Your payment information is encrypted and sent directly to Stripe (and in turn Stripe lets our server know if your purchase was successful, and what you purchased).</div></div>';
    jrCore_page_custom($note);

    jrMarket_browse_tabs($active);

    if (isset($_rs['success']) && $_rs['success'] == 'no results') {
        if (isset($_post['search_string']) && strlen($_post['search_string']) > 0) {
            jrCore_set_form_notice('notice', "There are no items in the Marketplace that match your search condition");
        }
        else {
            jrCore_set_form_notice('notice', "There are no new {$_post['_1']}s in the Marketplace that you have not already installed");
        }
    }
    jrCore_page_search('search', "{$_conf['jrCore_base_url']}/{$_post['module_url']}/browse/{$_post['_1']}");
    jrCore_get_form_notice();

    $_rs['type']             = ucfirst($_post['_1']);
    $_rs['show_item_status'] = 0;
    if (is_array($_rt) && count($_rt) > 1) {
        $_rs['show_item_status'] = 1;
    }
    $_rs['browse_base_url'] = jrCore_strip_url_params(jrCore_get_current_url(), array('p'));

    // If we are showing bundles, figure out the savings
    if ($_post['_1'] == 'bundle') {
        if (isset($_rs['_items']) && is_array($_rs['_items'])) {
            foreach ($_rs['_items'] as $k => $_v) {
                if (isset($_v['bundle_items']) && is_array($_v['bundle_items'])) {
                    $tot = 0;
                    foreach ($_v['bundle_items'] as $bv) {
                        if (isset($bv['market_file_item_price']) && strlen($bv['market_file_item_price']) > 0 && $bv['market_file_item_price'] > 0) {
                            $tot += $bv['market_file_item_price'];
                        }
                    }
                    if ($tot > 0 && $tot > $_v['bundle_item_price']) {
                        $_rs['_items'][$k]['bundle_savings'] = ($tot - $_v['bundle_item_price']);
                    }
                }
            }
        }
    }
    elseif ($_post['_1'] == 'module' || $_post['_1'] == 'installed') {
        if (isset($_rs['_items']) && is_array($_rs['_items'])) {
            // See if any of these are paid and if we have a license
            foreach ($_rs['_items'] as $k => $_v) {
                if (isset($_v['market_file_item_price']) && $_v['market_file_item_price'] > 0 && (!isset($_v['market_allow_license_install']) || $_v['market_allow_license_install'] != '1') && (!isset($_mods["{$_v['market_name']}"]['module_license']) || strlen($_mods["{$_v['market_name']}"]['module_license']) === 0)) {
                    $_rs['_items'][$k]['market_allow_license_install'] = '0';
                    $_rs['_items'][$k]['market_already_installed']     = '0';
                }
            }
        }
    }

    $_rs['active_market'] = $_mkt;

    // Page Jumper
    $_rs['pages'] = array(1);
    if (isset($_rs['info'])) {
        $i = 1;
        while ($i < $_rs['info']['total_pages']) {
            $_rs['pages'][] = ++$i;
        }
    }
    if (isset($_rs['marketplace_message']) && strlen($_rs['marketplace_message']) > 0) {
        jrCore_page_custom($_rs['marketplace_message']);
    }
    $out = jrCore_parse_template('browse.tpl', $_rs, 'jrMarket');
    jrCore_page_custom($out);
    jrCore_page_display();
}
