<?php
 /**
 * Jamroom Marketplace module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: verify_item
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrMarket_verify_item($_post, $_user, $_conf)
{
    global $_mods;
    if (!isset($_post['_1']) || ($_post['_1'] != 'module' && $_post['_1'] != 'skin')) {
        jrCore_logger('CRI', 'invalid type received in verify_item', $_post);
        echo "error: invalid type received in verify_item";
        exit;
    }
    if (empty($_post['_2'])) {
        jrCore_logger('CRI', 'empty module or skin received in verify_item', $_post);
        echo "error: empty module or skin received in verify_item";
        exit;
    }
    $key = "{$_post['_1']}_{$_post['_2']}_verify";
    if (!jrCore_get_temp_value('jrMarket', $key)) {
        jrCore_logger('CRI', 'invalid verify_item request - temp key not found', $_post);
        echo "error: invalid verify_item request - temp key not found";
        exit;
    }
    jrCore_delete_temp_value('jrMarket', $key);
    switch ($_post['_1']) {
        case 'module':
            $mod = $_post['_2'];
            if (!isset($_mods[$mod])) {
                jrCore_logger('CRI', "invalid module received in verify_item: {$mod}", $_post);
                echo "error: invalid module received in verify_item";
                exit;
            }
            jrMarket_reset_opcode_caches();
            jrCore_verify_module($mod);

            // Update with new version in module table
            $ver = jrMarket_get_latest_version('module', $mod);

            if (substr_count("{$ver}", '.') === 2) {
                $tbl = jrCore_db_table_name('jrCore', 'module');
                $req = "UPDATE {$tbl} SET module_version = '" . jrCore_db_escape($ver) . "' WHERE module_directory = '" . jrCore_db_escape($mod) . "' LIMIT 1";
                jrCore_db_query($req);
            }
            break;

        case 'skin':
            jrCore_verify_skin($_post['_2']);
            break;
    }
    echo "success: 1";
}
