<?php
 /**
 * Jamroom Profiles module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: disk_usage_report
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrProfile_disk_usage_report($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_admin_only();
    jrCore_page_set_meta_header_only();

    $button = jrCore_page_button('close', 'close', 'self.close();');
    if (!isset($_post['_1']) || !jrCore_checktype($_post['_1'], 'number_nz')) {
        jrCore_page_banner('disk usage report', $button);
        jrCore_notice_page('error', 'Invalid Profile ID');
    }

    $pid = (int) $_post['_1'];
    $_pr = jrCore_db_get_item('jrProfile', $pid, true);
    $nam = $_pr['profile_url'];
    if (strpos(' ' . $nam, '%')) {
        $nam = rawurldecode($nam);
    }
    if (mb_strlen($nam) > 50) {
        $nam = mb_substr($nam, 0, 47) . '...';
    }
    jrCore_page_banner("disk usage report: <span style=\"text-transform:none\">@{$nam}</span>", $button);
    if (!isset($_pr['profile_disk_usage']) || $_pr['profile_disk_usage'] == 0) {
        $usage = jrProfile_get_disk_usage($pid);
        if ($usage > 0) {
            $_up = array(
                'profile_disk_usage' => $usage
            );
            jrCore_db_update_item('jrProfile', $pid, $_up);
        }
    }

    $dat             = array();
    $dat[0]['title'] = 'icon';
    $dat[0]['width'] = '1%';
    $dat[1]['title'] = 'module';
    $dat[1]['width'] = '59%';
    $dat[2]['title'] = 'file count';
    $dat[2]['width'] = '20%';
    $dat[3]['title'] = 'total size';
    $dat[3]['width'] = '20%';
    jrCore_page_table_header($dat);

    // Get files
    $_fl = jrCore_get_media_files($pid);
    if (is_array($_fl)) {
        $_tt = array('jrCore' => array(0, 0));
        foreach ($_fl as $_file) {
            if (!strpos($_file['name'], '/rb_')) {
                $name = basename($_file['name']);
                list($mod,) = explode('_', $name, 2);
                if (!isset($_tt[$mod])) {
                    $_tt[$mod] = array(0, 0);
                }
                $_tt[$mod][0] += $_file['size'];
                $_tt[$mod][1]++;
            }
            else {
                $_tt['jrCore'][0] += $_file['size'];
                $_tt['jrCore'][1]++;
            }
        }
        if (count($_tt) > 0) {
            arsort($_tt);
            foreach ($_tt as $mod => $_s) {
                if ($_s[0] > 0) {
                    $dat             = array();
                    $dat[0]['title'] = jrCore_get_module_icon_html($mod, 32);
                    if (isset($_mods[$mod]) && $_s[1] > 0) {
                        $dat[1]['title'] = $_mods[$mod]['module_name'];
                    }
                    else {
                        $dat[1]['title'] = $mod;
                    }
                    $dat[2]['title'] = jrCore_number_format($_s[1]);
                    $dat[2]['class'] = 'center';
                    $dat[3]['title'] = jrCore_format_size($_s[0]);
                    $dat[3]['class'] = 'center';
                    jrCore_page_table_row($dat);
                }
            }
        }
    }
    else {
        $dat             = array();
        $dat[1]['title'] = 'No files found for profile';
        $dat[1]['class'] = 'p10 center';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();
    jrCore_page_close_button();
    jrCore_page_display();
}
