<?php
 /**
 * Jamroom Profiles module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: quota_compare
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrProfile_quota_compare($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    $btn = jrCore_page_button('tools', 'Tools', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools');");
    jrCore_page_banner('Quota Compare', $btn);

    $_adm = array();
    $_tmp = array();
    $_ina = array();
    foreach ($_mods as $mod_dir => $_inf) {
        if ($_inf['module_active'] == '1') {
            $_tmp["{$_inf['module_name']}"] = $mod_dir;
        }
        else {
            $_ina["{$_inf['module_name']}"] = $mod_dir;
        }
    }
    ksort($_tmp);
    ksort($_ina);
    $_tmp = array_merge($_tmp, $_ina);

    $_out = array();
    foreach ($_tmp as $mod_dir) {
        if (!isset($_mods[$mod_dir]['module_category'])) {
            $_mods[$mod_dir]['module_category'] = 'tools';
        }
        $cat = $_mods[$mod_dir]['module_category'];
        if (!isset($_out[$cat])) {
            $_out[$cat] = array();
        }
        $_out[$cat][$mod_dir] = $_mods[$mod_dir];
    }
    $_adm['_modules']['core'] = $_out['core'];
    unset($_out['core']);
    $_adm['_modules'] = $_adm['_modules'] + $_out;
    ksort($_adm['_modules']);
    unset($_out);

    $_q      = jrProfile_get_quotas();
    $_quotas = array();
    foreach ($_q as $id => $name) {
        $_quotas[$id]         = jrProfile_get_quota($id);
        $_quotas[$id]['name'] = $name;
    }

    $allowed = jrCore_get_option_image('pass');
    $blocked = jrCore_get_option_image('fail');

    $width           = round(80 / count($_quotas), 2);
    $dat             = array();
    $dat[0]['title'] = '';
    $dat[0]['class'] = 'page_table_header';
    $dat[0]['width'] = "1%";
    $dat[1]['title'] = '';
    $dat[1]['class'] = 'page_table_header';
    $dat[1]['width'] = "19%";
    $i               = 2;
    foreach ($_quotas as $_q) {
        $dat[$i]['title'] = $_q['name'];
        $dat[$i]['class'] = '" style="white-space:normal;width:' . $width . '%';
        $i++;
    }
    jrCore_page_table_header($dat);

    // Signup
    $dat             = array();
    $dat[0]['title'] = jrCore_get_module_icon_html('jrUser', 18);
    $dat[1]['title'] = 'Allows Signup';
    $dat[1]['width'] = "{$width}%";
    $i               = 2;
    $murl            = jrCore_get_module_url('jrUser');
    foreach ($_quotas as $id => $_q) {
        $btn              = ($_q['quota_jrUser_allow_signups'] == 'on') ? $allowed : $blocked;
        $dat[$i]['title'] = '<a href="' . $_conf['jrCore_base_url'] . '/' . $murl . '/admin/quota/id=' . $id . '/hl[]=allow_signups/hl[]=id">' . $btn . '</a>';
        $dat[$i]['class'] = 'center';
        $dat[$i]['width'] = "{$width}%";
        $i++;
    }
    jrCore_page_table_row($dat);

    // Go through installed modules
    foreach ($_adm['_modules'] as $cat => $_mod) {

        $header = false;
        foreach ($_mod as $mod => $_inf) {

            if (!jrCore_module_is_active($mod) || !isset($_q['quota_' . $mod . '_allowed'])) {
                continue;
            }

            // Do category header if we have not done it yet
            if (!$header) {
                // category
                $dat             = array();
                $dat[0]['title'] = '';
                $dat[1]['title'] = $cat;
                $dat[1]['class'] = 'center';
                jrCore_page_table_header($dat, null, true);
                $header = true;
            }

            $dat             = array();
            $dat[0]['title'] = jrCore_get_module_icon_html($mod, 18);
            $dat[1]['title'] = $_inf['module_name'];

            $i = 2;
            foreach ($_quotas as $id => $_q) {
                $btn              = ($_q['quota_' . $mod . '_allowed'] == 'on') ? $allowed : $blocked;
                $dat[$i]['title'] = '<a href="' . $_conf['jrCore_base_url'] . '/' . $_inf['module_url'] . '/admin/quota/id=' . $id . '/hl[]=allowed/hl[]=id">' . $btn . '</a>';
                $dat[$i]['class'] = 'center';
                $i++;
            }
            jrCore_page_table_row($dat);
        }
    }
    jrCore_page_table_footer();
    jrCore_page_cancel_button('referrer');
    jrCore_page_display();
}
