<?php
 /**
 * Jamroom System Tools module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 * @author Brian Johnson <brian [at] jamroom [dot] net>
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * config
 */
function jrSystemTools_config()
{
    // Epeg has been removed
    jrCore_delete_setting('jrSystemTools', 'epeg_binary');

    $idx = 1;
    foreach (jrSystemTools_get_tools() as $name => $_tool) {
        if (!$tool = jrCore_get_config_value('jrSystemTools', "{$name}_binary", false)) {
            $tool = 'auto';
        }
        $_tmp = array(
            'name'     => "{$name}_binary",
            'default'  => $tool,
            'type'     => 'select',
            'options'  => jrSystemTools_get_all_paths_for_tool($name),
            'validate' => 'not_empty',
            'required' => 'on',
            'label'    => "{$name} binary",
            'sublabel' => $_tool['sublabel'],
            'help'     => "{$_tool['help']}<br><br>Set this value to <b>Auto Detect</b> to have the system automatically figure out the correct binary to use on your system, otherwise select the binary to use for this tool.",
            'section'  => 'Tool Locations',
            'order'    => $idx++
        );
        jrCore_register_setting('jrSystemTools', $_tmp);
    }
    return true;
}

/**
 * Advanced Config keys
 */
function jrSystemTools_advanced_config()
{
    foreach (jrSystemTools_get_tools() as $name => $_tool) {
        jrCore_register_advanced_config_key('jrSystemTools', "{$name}_binary", 'auto', "If you need to set a specific parh for the {$name} tool, you can enter it here and it will override the main config.");
    }
    return true;
}
