{assign var="page_template" value="signup"}

{jrCore_include template="header.tpl"}

<div class="row">
    <div class="col12">
        <div class="new_login signup">
            <h2>{$_conf.jrCore_system_name}</h2>
            {jrCore_module_url module="jrUser" assign="uurl"}
            {jrCore_form_create_session module="jrUser" option="signup" assign="token"}

            <div class="page_notice_drop">
                {if !empty($form_message_type)}
                    <div id="jrUser_signup_msg" class="page_notice form_notice {$form_message_type}" style="display:block">{$form_message_text}</div>
                {else}
                    <div id="jrUser_signup_msg" class="page_notice form_notice" style="display:none"></div>
                {/if}
            </div>

            {if isset($_conf.jrUser_signup_note) && strlen($_conf.jrUser_signup_note) > 0}
            <div class="page_notice_drop">
                <div class="page_notice notice">{$_conf.jrUser_signup_note}</div>
            </div>
            {/if}

            <form class="jrform" id="jrUser_signup" name="jrUser_signup" action="{$jamroom_url}/{$uurl}/signup_save" method="post" accept-charset="utf-8" enctype="multipart/form-data">

                <input name="jr_html_form_token" value="{$token}" type="hidden">

                {jrProfile_get_signup_quota assign="quotas"}
                {if is_numeric($quotas)}
                    {* We only have 1 signup quota - no need to show select option *}
                    <input id="quota_id" name="quota_id" value="{$quotas}" type="hidden">
                {/if}

                <div class="form_text_wrap">
                    {jrCore_lang module="jrUser" id="4" default="user name" assign="txt"}
                    <input id="user_name" class="form_text" name="user_name" placeholder="{$txt|jrCore_entity_string}" value="" tabindex="1" autocorrect="off" autocapitalize="off" type="text">
                </div>

                <div class="form_text_wrap">
                    {jrCore_lang module="jrUser" id="18" default="email address" assign="txt"}
                    <input id="user_email" class="form_text" name="user_email" placeholder="{$txt|jrCore_entity_string}" value="" tabindex="2" autocorrect="off" autocapitalize="off" type="text">
                </div>

                <div class="form_text_wrap">
                    {jrCore_lang module="jrUser" id="7" default="password" assign="txt"}
                    <input id="user_passwd1" class="form_text" placeholder="" name="user_passwd1" value="{$txt|jrCore_entity_string}" tabindex="3" type="password">
                </div>

                <div class="form_text_wrap">
                    {jrCore_lang module="jrUser" id="32" default="repeat password" assign="txt"}
                    <input id="user_passwd2" class="form_text" name="user_passwd2" placeholder="" value="{$txt|jrCore_entity_string}" tabindex="4" onkeypress="if (event && event.keyCode === 13 && this.value.length > 0) { jrFormSubmit('#jrUser_signup','{$token}','ajax'); }" type="password">
                </div>

                {if is_array($quotas)}
                {* we have multiple signup quotas - show select *}
                <div class="form_text_wrap">
                    {jrCore_lang module="jrProfile" id=130 default="Select Account Type" assign="txt"}
                    <select id="quota_id" class="form_select" name="quota_id">
                        <optgroup label="{$txt|jrCore_entity_string}">
                        {foreach $quotas as $id => $quota_name}
                            <option value="{$id}">{$quota_name}</option>
                        {/foreach}
                        </optgroup>
                    </select>
                </div>
                {/if}

                <div class="form_text_wrap center">
                    {if jrCore_module_is_active('jrCaptcha')}
                        {jrCore_include module="jrCaptcha" template="hcaptcha.tpl"}
                    {else}
                        {jrUser_signup_human_check tabindex=5} <span class="sb_label" style="text-transform:capitalize">{jrCore_lang module="jrUser" id=90 default="human check"}</span>
                    {/if}
                </div>

                <div class="form_submit_section">
                    <input id="jrUser_signup_submit" class="signup_button" value="{jrCore_lang module="jrUser" id="31" default="Create Account"}" tabindex="6" onclick="jrFormSubmit('#jrUser_signup','{$token}','ajax');" type="button"><br>
                    {jrCore_get_activity_indicator('form_submit_indicator', 30)}
                </div>

            </form>
            <br>
            <div class="login_forgot">
                <a href="{$jamroom_url}/{$uurl}/login">{jrCore_lang module="jrUser" id="131" default="Already Have an Account?"}</a>
            </div>

        </div>
    </div>
</div>

{jrCore_include template="footer.tpl"}
