<?php
 /**
 * Jamroom Users module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: authenticate_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_authenticate_save($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrCore_form_validate($_post);
    if (!$_us = jrCore_db_get_item('jrUser', $_user['_user_id'], true, true)) {
        jrCore_notice_page('error', 36);
    }

    // Make sure our OLD password is correct
    if (!jrUser_verify_password_hash($_post['old_password'], $_us['user_password'])) {
        jrCore_set_form_notice('error', 26);
        jrCore_location('referrer');
    }

    // Is this user DELETING their account?
    if (!empty($_post['delete']) && $_post['delete'] == 1) {

        // Delete User
        jrUser_delete_user_account_by_id($_us['_user_id'], $_us);

        // Delete Profile
        jrProfile_delete_profile($_us['_profile_id'], false, false);

        // Destroy session
        jrUser_end_user_session($_user);

        // Remove all cookies
        if (!empty($_COOKIE)) {
            $uniq = jrUser_unique_install_id();
            foreach ($_COOKIE as $name => $val) {
                if (strpos(' ' . $name, $uniq)) {
                    unset($_COOKIE[$name]);
                }
            }
        }

        // Log
        jrCore_logger('INF', "user: {$_us['user_name']} (user_id: {$_us['_user_id']}) has deleted their account");

        // Redirect to home page
        jrCore_form_result(jrCore_get_base_url());

    }

    // Fall through - changing account info
    $_dt = array();
    if (isset($_us['user_temp_password'])) {
        $_dt['user_password'] = $_us['user_temp_password'];
    }
    if (isset($_us['user_temp_email'])) {
        $_dt['user_email'] = $_us['user_temp_email'];
    }
    if (isset($_us['user_temp_twofactor_enabled'])) {
        $_dt['user_twofactor_enabled'] = $_us['user_temp_twofactor_enabled'];
    }
    if (jrCore_db_update_item('jrUser', $_user['_user_id'], $_dt)) {

        // Send out account updated trigger
        jrCore_trigger_event('jrUser', 'user_updated', $_us, $_dt);

        // Send notification to OLD address if enabled
        if (isset($_conf['jrUser_change_notice']) && $_conf['jrUser_change_notice'] == 'on') {

            // They are changing email or password
            $_rp = array(
                'system_name'     => $_conf['jrCore_system_name'],
                'password_change' => false,
                'email_change'    => false
            );
            if (isset($_us['user_temp_password'])) {
                $_rp['password_change'] = true;
            }
            if (isset($_us['user_temp_email'])) {
                $_rp['email_change'] = true;
                $_rp['new_email']    = $_us['user_temp_email'];
            }
            list($sub, $msg) = jrCore_parse_email_templates('jrUser', 'change', $_rp);
            jrCore_send_email($_user['user_email'], $sub, $msg);
        }

        // Delete temp keys
        $_dl = array(
            'user_temp_password',
            'user_temp_email',
            'user_temp_twofactor_enabled',
            'user_temp_token'
        );
        jrCore_db_delete_multiple_item_keys('jrUser', $_user['_user_id'], $_dl);

        // Success
        jrUser_reset_cache($_user['_user_id']);
        jrUser_session_sync();

        // Log out other sessions and auto login cookies
        jrUser_session_remove_all_other_sessions($_user['_user_id'], session_id());
        if (jrCore_get_cookie('auto')) {
            // This user had a remember me cookie - set new one
            jrUser_session_set_login_cookie($_user['_user_id']);
        }

        // Remove forgot entries
        jrUser_delete_forgot_password_entries($_user['_user_id']);

        jrCore_set_form_notice('success', 43);
        jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/account");
    }
    jrCore_notice_page('error', 36);
}
