<?php
 /**
 * Jamroom Users module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: block_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_block_save($_post, $_user, $_conf)
{
    jrUser_session_require_login();
    jrCore_validate_location_url();
    if (!jrUser_is_admin()) {
        jrUser_not_authorized();
    }

    // Make sure we get a valid ID
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_notice_page('error', 'invalid user id - please try again');
    }
    $_us = jrCore_db_get_item('jrUser', $_post['id'], true);
    if (!$_us || !is_array($_us)) {
        jrCore_notice_page('error', 'invalid user id - no data for user found');
    }
    if ($_us['_user_id'] == $_user['_user_id']) {
        jrCore_notice_page('error', 'you cannot block your own account - contact the master admin');
    }
    // Cannot delete admin and master users..
    if (!jrUser_is_master()) {
        if ($_us['user_group'] == 'admin' || $_us['user_group'] == 'master') {
            jrCore_notice_page('error', 'only a Master Admin can block admin or master accounts');
        }
    }
    $uid = (int) $_post['id'];
    if (!isset($_post['mode']) || ($_post['mode'] != 'b' && $_post['mode'] != 'u')) {
        jrCore_notice_page('error', 'invalid block mode - please try again');
    }

    // Block a User
    if ($_post['mode'] == 'b') {
        jrUser_block($uid);
    }
    else {
        // UN-blocking a user
        jrUser_unblock($uid);
    }

    jrCore_trigger_event('jrUser', 'block_user', $_post);
    jrCore_location('referrer');
}
