<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'sl', version '4.4'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Dejavnosti';
$string['activate'] = 'Omogoči dostop';
$string['activatesuccess'] = 'Dostop do značk je omogočen';
$string['addalignment'] = 'Dodaj kompetence';
$string['addbadge'] = 'Dodaj značke';
$string['addbadge_help'] = 'Izberite vse značke, ki naj bodo dodane k zahtevi za to značko. Držite CTRL da izberete več predmetov.';
$string['addbadgecriteria'] = 'Dodaj kriterije za Značke';
$string['addcohort'] = 'Dodaj kohorto';
$string['addcohort_help'] = 'Izberite vse kohorte, ki naj bodo dodana k zahtevi za to značko. Držite CTRL da izberete več predmetov.';
$string['addcompetency'] = 'Dodaj kompetenco';
$string['addcompetency_help'] = 'Izberite vse kompetence, ki naj bodo dodane k zahtevi za to značko. Držite tipko CTRL, da izberete več elementov.';
$string['addcourse'] = 'Dodaj predmete';
$string['addcourse_help'] = 'Izberite vse predmete, ki naj bodo dodani k zahtevam te značke. Držite tipko CTRL, da izberete več elementov.';
$string['addcriteria'] = 'Dodaj kriterij';
$string['addcriteriatext'] = 'Za začetek dodajanja kriterijev izberite eno od možnosti s spustnega menija.';
$string['addedtobackpack'] = 'Dodano v nahrbtnik';
$string['addrelated'] = 'Dodaj sorodno značko';
$string['addtobackpack'] = 'Dodaj v nahrbtnik';
$string['adminonly'] = 'Ta stran je dostopna samo skrbnikom spletnega mesta.';
$string['after'] = 'po datumu izdaje.';
$string['aggregationmethod'] = 'Metoda združevanja';
$string['alignment'] = 'Uskladitev';
$string['all'] = 'Vse';
$string['allmethod'] = 'Vsi izbrani pogoji so izpolnjeni';
$string['allmethodactivity'] = 'Vse izbrane dejavnosti so zaključene';
$string['allmethodbadges'] = 'Vse izbrane značke so bile dosežene';
$string['allmethodcohort'] = 'Članstvo v vseh izbranih kohortah';
$string['allmethodcompetencies'] = 'Vse izbrane kompetence so bile pridobljene';
$string['allmethodcourseset'] = 'Vsi izbrani predmeti so zaključeni';
$string['allmethodmanual'] = 'Izbrane vloge lahko podeljujejo značke.';
$string['allmethodprofile'] = 'Vsa izbrana polja profila so izpolnjena';
$string['allowcoursebadges'] = 'Omogoči značke v predmetu';
$string['allowcoursebadges_desc'] = 'Omogoči ustvarjanje in osvajanje Značk v kontekstu predmeta.';
$string['allowexternalbackpack'] = 'Omogoči povezavo do zunanjih nahrbtnikov';
$string['allowexternalbackpack_desc'] = 'Dovoli uporabnikom, da ustvarijo povezave in prikažejo značke pri zunanjih ponudnikih nahrbtnikov.

Opomba: Priporočamo, da pustite to možnost onemogočeno, če do spletnega mesta ni mogoče dostopati preko interneta (npr. zaradi požarnega zidu).';
$string['any'] = 'Katerikoli';
$string['anymethod'] = 'Katerikoli izbrani pogoj je izpolnjen';
$string['anymethodactivity'] = 'Katerakoli izbrana dejavnost je zaključena';
$string['anymethodbadges'] = 'Katerakoli značka je bila dosežena';
$string['anymethodcohort'] = 'Članstvo v katerikoli od kohort';
$string['anymethodcompetencies'] = 'Katerakoli od izbranih kompetenc je pridobljena';
$string['anymethodcourseset'] = 'Katerikoli od izbranih predmetov je zaključen';
$string['anymethodmanual'] = 'Izbrane vloge lahko podelijo značke';
$string['anymethodprofile'] = 'Katerokoli od izbranih polj profila je izpolnjeno';
$string['apiversion'] = 'Podprta različica API';
$string['archivebadge'] = 'Ali želite izbrisati značko \'{$a}\' in obdržati obstoječe podeljene značke?';
$string['archiveconfirm'] = 'Izbriši in obdrži že podeljene značke';
$string['archivehelp'] = '<p>Ta možnost pomeni, da bo značka označena kot "potekla" in ne bo več prikazana na seznamu značk. Uporabniki ne bodo več mogli pridobiti te značke. Obstoječi prejemniki jo bodo še vedno lahko prikazali na svoji profilni strani ali v svojih zunanjih nahrbtnikih.</p>
<p>Če želite uporabnikom omogočiti, da obdržijo dostop do pridobljenih značk, morate izbrati to možnost namesto popolnega izbrisa značk.</p>';
$string['attachment'] = 'Pripni značko sporočilu';
$string['attachment_help'] = 'Če je to omogočeno, bo e-poštnemu sporočilu prejemnika značke pripeta podeljena značka za prenos. (Za uporabo te možnosti morajo biti omogočene priponke v zavihku Skrbništvo spletnega mesta > Vtičniki > Izhodi sporočila > Pošlji e-poštno sporočilo.)';
$string['award'] = 'Podeli značko';
$string['awardedto'] = 'Podeljeno {$a}';
$string['awardedtoyou'] = 'Podeljeno meni';
$string['awardoncron'] = 'Dostop do značk je omogočen. To značko lahko v naslednjem trenutku pridobi veliko uporabnikov. Za zagotovitev delovanja spletnega mesta bo za izvedbo tega dejanja potrebnega nekaj časa.';
$string['awards'] = 'Prejemniki';
$string['backpackapiurl'] = 'URL za API nahrbtnika';
$string['backpackavailability'] = 'Zunanje preverjanje značk';
$string['backpackavailability_help'] = 'Če želijo prejemniki značke dokazati, da so jo pridobili pri vas, mora zunanja storitev nahrbtnika imeti dostop do vašega spletnega mesta in preveriti podeljene značke. Vaše spletno mesto zunanjega dostopa trenutno ne omogoča, kar pomeni, da značk, ki ste jih podelili ali jih boste podelili v prihodnosti, ni mogoče preveriti.

**Zakaj sem prejel to sporočilo?**

Morda vaš požarni zid preprečuje dostop uporabnikom izven vašega omrežja; morda je vaše spletno mesto zaščiteno z geslom ali se spletno mesto izvaja na računalniku, ki ni na voljo preko interneta (npr. lokalna razvojna naprava).

**Je to težava?**

Težavo je potrebno odpraviti na vsaki produkcijski strani, kjer se nameravajo podeljevati značke, saj drugače prejemniki ne bodo mogli dokazati, da so jih pridobili pri vas. Če vaša stran še ni produkcijska, potem lahko ustvarjate in podeljujete testne značke, dokler je stran dostopna.

**Kaj storiti, če ne morem nastaviti svojega celotnega spletnega mesta kot javno dostopnega?**

Za preverjanje je potreben samo URL [your-site-url]/badges/assertion.php, zato bo preverjanje značk še vedno delovalo, če boste svoj požarni zid prilagodili tako, da bo dovolil zunanji dostop do te datoteke.';
$string['backpackbadgessettings'] = 'Spremeni nastavitve nahrbtnika';
$string['backpackbadgessummary'] = 'Prikazuje se {$a->totalbadges} značk iz {$a->totalcollections} zbirk.';
$string['backpackcannotsendverification'] = 'Ne morem poslati potrditvenega e-sporočila';
$string['backpackconnected'] = 'Nahrbtnik povezan';
$string['backpackconnection'] = 'Povezava do nahrbtnika';
$string['backpackconnection_connected'] = 'Vaš nahrbtnik';
$string['backpackconnection_help'] = 'Shranite in delite svoj značke s tega spletišča in prikažite javne značke drugih spletišč na svojem uporabniškem profilu.';
$string['backpackconnectioncancelattempt'] = 'Poveži se z drugim e-naslovom';
$string['backpackconnectionconnect'] = 'Poveži z nahrbtnikom';
$string['backpackconnectionok'] = 'Povezava z nahrbtnikom uspešno vzpostavljena';
$string['backpackconnectionresendemail'] = 'Ponovno pošlji potrditveno sporočilo';
$string['backpackconnectionunexpectedmessage'] = 'Nahrbtnik je vrnil napako: "{$a}".';
$string['backpackconnectionunexpectedresult'] = 'Prišlo je do težave pri povezavi z nahrbtnikom. Ponudnik nahrbtnika je poslal naslednje sporočilo: \'{$a}\'.';
$string['backpackdetails'] = 'Nastavitve nahrbtnika';
$string['backpackdisconnected'] = 'Nahrbtnik je odklopljen';
$string['backpackemail'] = 'E-poštni naslov';
$string['backpackemail_help'] = 'E-poštni naslov, ki je povezan z vašim nahrbtnikom. Ko ste povezani, bodo vse značke, pridobljene na tem spletnem mestu, povezane s tem e-poštnim naslovom.';
$string['backpackemail_required'] = 'E-poštni naslov ne more biti prazen.';
$string['backpackemailverificationpending'] = 'Potrditev na čakanju';
$string['backpackemailverifyemailbody'] = 'Pozdravljeni,

stran \'{$a->sitename}\' je zahtevala novo povezavo do vašega Mozzila Nahrbtnika z uporabo vašega e-naslova.

Za potrditev in aktivacijo povezave do nahrbtnika pojdite na {$a->link}.

V večini e-poštnih programov se to prikaže kot aktivna modra povezava, na katero lahko kliknete. Če to ne deluje, potem naslov kopirajte in ga prilepite v brskalnik.

Če potrebujete pomoč, kontaktirajte administratorja, {$a->admin}.';
$string['backpackemailverifyemailsubject'] = '{$a}: Potrditev e-naslova za nahrbtnik';
$string['backpackemailverifypending'] = 'Potrditveno e-pošto smo poslali na <strong>{$a}</strong>. Za aktivacijo povezave z nahrbtnikom kliknite na potrditveno povezavo v sporočilu.';
$string['backpackemailverifysuccess'] = 'Zdaj ste povezani z nahrbtnikom.';
$string['backpackemailverifytokenmismatch'] = 'Žeton v povezavi se ne ujema s shranjenim žetonom. Preverite, ali ste kliknili na povezavo v zadnjem prejetem sporočilu.';
$string['backpackimport'] = 'Nastavitve uvoza priznanj';
$string['backpackimport_help'] = 'Po uspešni vzpostavitvi povezave z albumom lahko prikažete značke iz albuma na vaši strani Značke in na profilni strani. Tu lahko izbirate zbirke značk, ki jih želite prikazati.';
$string['backpacksettings'] = 'Nastavitve nahrbtnika';
$string['backpackweburl'] = 'URL nahrbtnika';
$string['badgedetails'] = 'Podrobnosti značke';
$string['badgeimage'] = 'Slika';
$string['badgeimage_help'] = 'Ta slika bo uporabljena ob podelitvi te značke.

Za dodajanje nove slike prebrskajte in izberite sliko (format JPG ali PNG), nato kliknite "Shrani spremembe". Slika bo obrezana do kvadratne oblike. Velikost bo spremenjena tako, da bo ustrezala zahtevam slike značke.';
$string['badgeprivacysetting'] = 'Nastavitve zasebnosti značke';
$string['badgeprivacysetting_help'] = 'Pridobljene značke so lahko prikazane na profilni strani. Te nastavitve omogočajo samodejni prikaz najnovejših značk.';
$string['badgeprivacysetting_str'] = 'Samodejno prikaži pridobljene značke na moji profilni strani';
$string['badges'] = 'Značke';
$string['badgesalt'] = 'Sol za zgoščevanje prejemnikovega e-naslova';
$string['badgesalt_desc'] = 'Uporaba kodiranja omogoča ponudnikom nahrbtnikov, da potrdijo prejemnika značke, ne da bi morali razkriti njihove e-poštne naslove. Ta nastavitev naj uporablja zgolj številke in črke. Opozorilo: Za namene preverjanja prejemnikov se izogibajte spreminjanju te nastavitve, ko začnete s podeljevanjem značk.';
$string['badgesdisabled'] = 'V tem spletnem mestu značke niso omogočene.';
$string['badgesearned'] = 'Število pridobljenih značk: {$a}';
$string['badgesettings'] = 'Nastavitve za Značke';
$string['badgestatus_0'] = 'Ni na voljo';
$string['badgestatus_1'] = 'Na voljo';
$string['badgestatus_2'] = 'Ni na voljo (kriteriji zaklenjeni)';
$string['badgestatus_3'] = 'Na voljo (kriteriji zaklenjeni)';
$string['badgestatus_4'] = 'Arhivirano';
$string['badgestoearn'] = 'Št. značk na voljo: {$a}';
$string['badgesview'] = 'Značke predmeta';
$string['badgeurl'] = 'Povezava podeljenega priznanja';
$string['balignment'] = 'Uskladitve ({$a})';
$string['bawards'] = 'Prejemniki ({$a})';
$string['bcriteria'] = 'Kriteriji';
$string['bdetails'] = 'Uredi podrobnosti';
$string['bendorsement'] = 'Priporočilo';
$string['bmessage'] = 'Sporočilo';
$string['boverview'] = 'Pregled';
$string['brelated'] = 'Sorodne značke ({$a})';
$string['bydate'] = 'zaključiti do';
$string['claim'] = 'Zahtevek';
$string['claimcomment'] = 'Komentar priporočila';
$string['claimid'] = 'URL';
$string['clearsettings'] = 'Počisti nastavitve';
$string['completioninfo'] = 'To priznanje je bilo podeljeno za zaključek:';
$string['completionnotenabled'] = 'Zaključevanje predmeta ni omogočeno za ta predmet, zato ne more biti vključeno kot kriterij značke. Zaključevanje predmeta lahko omogočite v nastavitvah predmeta.';
$string['configenablebadges'] = 'Ko je to omogočeno, lahko ustvarite značke in jih podelite uporabnikom spletnega mesta.';
$string['configuremessage'] = 'Sporočilo značke';
$string['connect'] = 'Poveži';
$string['connected'] = 'Povezan';
$string['connecting'] = 'Povezovanje ...';
$string['contact'] = 'Kontakt';
$string['contact_help'] = 'E-poštni naslov, povezan z izdajateljem značke.';
$string['copyof'] = 'Kopija {$a}';
$string['coursebadges'] = 'Značke';
$string['coursebadgesdisabled'] = 'Značke niso omogočene v tem spletnem mestu';
$string['coursecompletion'] = 'Uporabniki morajo zaključiti ta predmet.';
$string['create'] = 'Nova značka';
$string['createbutton'] = 'Ustvari značko';
$string['creatorbody'] = '<p>{$a->user} je izpolnil vse zahteve in pridobil značko. Ogled podeljene značke je možen na {$a->link} </p>';
$string['creatorsubject'] = 'Značka \'{$a}\' je podeljena.';
$string['criteria_0'] = 'Značka bo podeljena, ko ...';
$string['criteria_1'] = 'Zaključek aktivnosti';
$string['criteria_1_help'] = 'Udeleženec dobi značko, ko zaključi predpisane dejavnosti v predmetu.';
$string['criteria_2'] = 'Ročna podelitev glede na vlogo';
$string['criteria_2_help'] = 'Značko lahko ročno podelijo uporabniki s posebno vlogo v predmetu.';
$string['criteria_3'] = 'Družbeno udejstvovanje';
$string['criteria_3_help'] = 'Družbeno';
$string['criteria_4'] = 'Zaključek predmeta';
$string['criteria_4_help'] = 'Udeleženec dobi značko, ko zaključi predmet. Kriterij ima lahko dodatne nastavitve, npr.: dosežena minimalna ocena ali datum zaključka predmeta.';
$string['criteria_5'] = 'Zaključek skupine predmetov';
$string['criteria_5_help'] = 'Udeleženec dobi značko, ko zaključi več določenih predmetov. Vsak predmet ima lahko dodatne nastavitve, npr.: minimalna ocena ali datum zaključka.';
$string['criteria_6'] = 'Izpolnitev profila';
$string['criteria_6_help'] = 'Udeleženec dobi značko, ko izpolni predpisana polja v svojem profilu. Izbirate lahko med privzetimi ali prilagojenimi polji, ki so na voljo uporabnikom.';
$string['criteria_7'] = 'Podeljene značke';
$string['criteria_7_help'] = 'Dovoli podeljevanje značk uporabnikom glede na druge prislužene značke.';
$string['criteria_8'] = 'Članstvo v kohorti';
$string['criteria_8_help'] = 'Dovoli podeljevanje značk uporabnikom glede na članstvo v kohorti.';
$string['criteria_9'] = 'Kompetence';
$string['criteria_9_help'] = 'Omogoči podelitev značke uporabnikom glede na pridobljene kompetence.';
$string['criteria_descr'] = 'Značka bo podeljena udeležencem, ki izpolnijo naslednje kriterije:';
$string['criteria_descr_0'] = 'Število navedenih kriterijev, ki jih mora uporabnik izpolniti, da pridobi značko: <strong>{$a}</strong>';
$string['criteria_descr_1'] = 'Pogoj za število navedenih aktivnosti, ki morajo biti zaključene: <strong>{$a}</strong>';
$string['criteria_descr_2'] = 'Pogoj za število vlog uporabnikov, ki podelijo značko: <strong>{$a}</strong>';
$string['criteria_descr_4'] = 'Uporabniki morajo zaključiti predmet';
$string['criteria_descr_5'] = 'Pogoj za število navedenih predmetov, ki morajo biti zaključeni: <strong>{$a}</strong>';
$string['criteria_descr_6'] = 'Pogoj za število navedenih polj uporabnikovega profila, ki jih je potrebno izpolniti: <strong>{$a}</strong>';
$string['criteria_descr_7'] = '<strong>{$a}</strong> od navedenih značk morate prislužiti:';
$string['criteria_descr_8'] = 'Članstvo v <strong>{$a}</strong> od navedenih kohort je zahtevano:';
$string['criteria_descr_9'] = 'Pogoj za število navedenih kompetenc, ki jih mora uporabnik pridobiti: <strong>{$a}</strong>';
$string['criteria_descr_bydate'] = 'do <em>{$a}</em>';
$string['criteria_descr_grade'] = 'z minimalno oceno <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Zaključenih <strong>{$a}</strong> od:';
$string['criteria_descr_short1'] = 'Zaključenih <strong>{$a}</strong> od:';
$string['criteria_descr_short2'] = 'Podelil <strong>{$a}</strong> od:';
$string['criteria_descr_short4'] = 'Zaključi predmet';
$string['criteria_descr_short5'] = 'Zaključiti <strong>{$a}</strong> od:';
$string['criteria_descr_short6'] = 'Zaključiti <strong>{$a}</strong> od:';
$string['criteria_descr_short7'] = 'Zaključiti <strong>{$a}</strong> od:';
$string['criteria_descr_short8'] = 'Članstvo v <strong>{$a}</strong> kohortah od:';
$string['criteria_descr_short9'] = 'Zaključiti <strong>{$a}</strong> od:';
$string['criteria_descr_single_1'] = 'Zaključiti je potrebno naslednjo aktivnost:';
$string['criteria_descr_single_2'] = 'To priznanje mora podeliti uporabnik z naslednjo vlogo:';
$string['criteria_descr_single_4'] = 'Uporabniki morajo zaključiti predmet';
$string['criteria_descr_single_5'] = 'Zaključiti je potrebno naslednji predmet:';
$string['criteria_descr_single_6'] = 'Polja uporabniškega profila, ki jih je potrebno izpolniti:';
$string['criteria_descr_single_7'] = 'Prislužiti morate to značko:';
$string['criteria_descr_single_8'] = 'Zahtevano je članstvo v kohorti:';
$string['criteria_descr_single_9'] = 'Pridobiti je potrebno kompetence:';
$string['criteria_descr_single_short1'] = 'Zahtevan zaključek:';
$string['criteria_descr_single_short2'] = 'Podeli:';
$string['criteria_descr_single_short4'] = 'Zaključi predmet';
$string['criteria_descr_single_short5'] = 'Zahtevan zaključek:';
$string['criteria_descr_single_short6'] = 'Izpolnitev:';
$string['criteria_descr_single_short7'] = 'Pridobitev značk:';
$string['criteria_descr_single_short8'] = 'Članstvo v:';
$string['criteria_descr_single_short9'] = 'Pridobitev kompetenc:';
$string['criteriacreated'] = 'Kriterij za pridobitev značke je bil uspešno ustvarjen.';
$string['criteriadeleted'] = 'Kriterij za pridobitev značke je bil uspešno izbrisan.';
$string['criteriasummary'] = 'Povzetek kriterijev';
$string['criteriaupdated'] = 'Kriteriji za podelitev značke so bili posodobljeni';
$string['criterror'] = 'Trenutne težave parametrov';
$string['criterror_help'] = 'Ta množica polj prikazuje vse parametre, ki so bili sprva dodani kot zahteve za značko, vendar niso več na voljo. Priporočamo, da odstranite te parametre in zagotovite, da bodo uporabniki v prihodnje lahko pridobili to značko.';
$string['currentimage'] = 'Trenutna slika';
$string['currentstatus'] = 'Trenutni status:';
$string['dateawarded'] = 'Datum izdaje';
$string['dateearned'] = 'Datum: {$a}';
$string['day'] = 'Dni';
$string['deactivate'] = 'Onemogoči dostop';
$string['deactivatesuccess'] = 'Dostop do Značk je bil onemogočen.';
$string['defaultissuercontact'] = 'Kontaktni podatki izdajatelja značke';
$string['defaultissuercontact_desc'] = 'E-poštni naslov, povezan z izdajateljem značke.

Za nahrbtnik standarda Open Badges v2.0 se to uporablja za preverjanje pristnosti, ko se objavijo značke v nahrbtniku.';
$string['defaultissuername'] = 'Privzeto ime podeljevalca značke';
$string['defaultissuername_desc'] = 'Ime zastopnika oziroma organa za izdajanje.';
$string['defaultissuerpassword'] = 'Geslo izdajatelja značke';
$string['delbadge'] = 'Ali želite izbrisati značko \'{$a}\' in odstraniti vse obstoječe podeljene značke?';
$string['delconfirm'] = 'Izbriši in odstrani obstoječa podeljena priznanja';
$string['delcritconfirm'] = 'Ali ste prepričani, da želite izbrisati ta kriterij?';
$string['deletehelp'] = '<p>Popoln izbris značke pomeni, da bodo za vedno odstranjeni tudi vsi zapisi informacij in kriterijev. Uporabniki, ki so pridobili to značko, do nje ne bodo več mogli dostopati ali jo prikazati na svoji profilni strani.</p>
<p>Opomba: Uporabniki, ki so pridobili to značko in so jo že shranili v svojem zunanjem nahrbtniku, bodo tam še vedno imeli to značko, vendar ne bodo mogli dostopati do kriterijev in strani z dokazi o tem, tj. s povezavo do tega spletnega mesta.</p>';
$string['delexternalbackpackconfirm'] = 'Izbris nahrbtnika \'{$a}\'?';
$string['delparamconfirm'] = 'Ali ste prepričani, da želite izbrisati ta parameter?';
$string['description'] = 'Opis';
$string['disconnect'] = 'Prekinitev';
$string['donotaward'] = 'Ta značka je trenutno neaktivna. Če jo želite podeliti, jo morate aktivirati.';
$string['enablebadges'] = 'Omogoči značke';
$string['endorsement'] = 'Priporočilo';
$string['error:backpackdatainvalid'] = 'Priklic podatkov iz nahrbtnika je bil neveljaven.';
$string['error:backpackemailnotfound'] = 'E-poštni naslov \'{$a}\' ni povezan z nahrbtnikom. Potrebno je <a href="http://backpack.openbadges.org">ustvariti nahrbtnik</a> za ta račun ali se vpisati z drugim e-poštnim naslovom.';
$string['error:badgeawardnotfound'] = 'Ne morem potrditi podeljene značke. Ta značka je bila morda razveljavljena.';
$string['error:badgenotfound'] = 'Ne najdem značke.';
$string['error:cannotact'] = 'Značke ni bilo mogoče aktivirati.';
$string['error:cannotawardbadge'] = 'Uporabniku ni bilo mogoče podeliti značke.';
$string['error:cannotdeletecriterion'] = 'Tega kriterija ni mogoče izbrisati.';
$string['error:cannotrevokebadge'] = 'Značke ni mogoče razveljaviti.';
$string['error:clone'] = 'Priznanja ni mogoče klonirati.';
$string['error:connectionunknownreason'] = 'Povezava ni bila uspešna, vendar za to ni bilo podanega razloga.';
$string['error:duplicatename'] = 'Značka s tem imenom že obstaja.';
$string['error:externalbadgedoesntexist'] = 'Značke ni bilo mogoče najti.';
$string['error:guestuseraccess'] = 'Uporabljate dostop gosta. Če želite videti značke, se prijavite s svojim računom.';
$string['error:invalidcriteriatype'] = 'Neveljavna vrsta kriterija.';
$string['error:invalidexpiredate'] = 'Datum poteka veljavnosti mora biti v prihodnosti.';
$string['error:invalidexpireperiod'] = 'Obdobje veljavnosti ne sme biti negativno ali enako 0.';
$string['error:invalidparambadge'] = 'Značka ne obstaja.';
$string['error:invalidparamcohort'] = 'Kohorta ne obstaja.';
$string['error:noactivities'] = 'V tem predmetu ni dejavnosti z določenimi kriteriji za zaključek.';
$string['error:nobadges'] = 'Ni značk za omogočene predmete ali strani, ki bi jih lahko dodali kot kriterij.';
$string['error:nocohorts'] = 'Ni kohort';
$string['error:nocourses'] = 'Zaključevanje predmeta ni omogočeno za noben predmet na tem spletnem mestu, zato ta možnost ni prikazana. Zaključevanje predmeta se omogoči v nastavitvah predmeta.';
$string['error:nogroupslink'] = '<p>Prikazane so samo javne zbirke. <a href="{$a}" target="_blank" rel="nofollow">Obiščite svoj nahrbtnik</a> in ustvarite nekaj javnih zbirk.</p>';
$string['error:nogroupssummary'] = '<p>V vašem nahrbtniku ni na voljo javnih zbirk značk.</p>';
$string['error:nopermissiontoview'] = 'Nimate pravic za pregled prejemnikov značk.';
$string['error:nosuchbadge'] = 'Značka z id {$a} ne obstaja.';
$string['error:nosuchcohort'] = 'Opozorilo: Ta kohorta ni več na voljo.';
$string['error:nosuchcourse'] = 'Opozorilo: Ta predmet ni več na voljo.';
$string['error:nosuchfield'] = 'Opozorilo: To polje profila ni več na voljo.';
$string['error:nosuchmod'] = 'Opozorilo: Ta aktivnost ni več na voljo.';
$string['error:nosuchrole'] = 'Opozorilo: Ta vloga ni več na voljo.';
$string['error:nosuchuser'] = 'Uporabnik s tem e-poštnim naslovom nima računa pri trenutnem ponudniku nahrbtnika.';
$string['error:notifycoursedate'] = 'Opozorilo: Priznanja, povezana s predmetom in zaključevanjem dejavnosti, ne bodo podeljena pred začetkom izvajanja predmeta.';
$string['error:parameter'] = 'Opozorilo: Za zagotavljanje pravilnega podeljevanja značk je potrebno izbrati vsaj en parameter.';
$string['error:relatedbadgedoesntexist'] = 'Ni javne značke s tem identifikatorjem';
$string['error:requesterror'] = 'Zahteva za povezavo ni uspela (koda napake {$a}).';
$string['error:requesttimeout'] = 'Zahteva za povezavo je potekla, preden je bila lahko zaključena.';
$string['error:save'] = 'Značke ni bilo mogoče shraniti.';
$string['error:userdeleted'] = '{$a->user} (Ta uporabnik ne obstaja več v {$a->site})';
$string['eventbadgearchived'] = 'Značka arhivirana';
$string['eventbadgeawarded'] = 'Značka podeljena';
$string['eventbadgecreated'] = 'Značka ustvarjena';
$string['eventbadgecriteriacreated'] = 'Kriterij za značko ustvarjen';
$string['eventbadgecriteriadeleted'] = 'Kriterij za značko izbrisan';
$string['eventbadgecriteriaupdated'] = 'Kriterij za značko posodobljen';
$string['eventbadgedeleted'] = 'Značka izbrisana';
$string['eventbadgedisabled'] = 'Značka onemogočena';
$string['eventbadgeduplicated'] = 'Značka podvojena';
$string['eventbadgeenabled'] = 'Značka omogočena';
$string['eventbadgelistingviewed'] = 'Seznam značk ogledan';
$string['eventbadgerevoked'] = 'Značka razveljavljena';
$string['eventbadgeupdated'] = 'Značka posodobljena';
$string['eventbadgeviewed'] = 'Značka ogledana';
$string['existingrecipients'] = 'Obstoječi prejemniki priznanj';
$string['existsinbackpack'] = 'Značka je že v nahrbtniku';
$string['expired'] = 'Poteklo';
$string['expiredate'] = 'Značka poteče {$a}.';
$string['expireddate'] = 'Značka je potekla {$a}.';
$string['expireperiod'] = 'Ta značka poteče toliko dni po podelitvi: {$a}.';
$string['expireperiodh'] = 'Ta značka poteče toliko ur po podelitvi: {$a}.';
$string['expireperiodm'] = 'Ta značka poteče toliko minut po podelitvi: {$a}.';
$string['expireperiods'] = 'Ta značka poteče toliko sekund po podelitvi: {$a}.';
$string['expirydate'] = 'Datum poteka veljavnosti';
$string['expirydate_help'] = 'Če želimo, lahko nastavimo, da značka poteče na določen datum ali pa se lahko datum poteka veljavnosti izračuna glede na datum podelitve značke uporabniku.';
$string['externalbadges'] = 'Moje značke z drugih spletnih mest';
$string['externalbadges_help'] = 'To področje prikazuje značke z zunanjih spletnih mest.';
$string['externalbadgesp'] = 'Značke z drugih spletnih mest:';
$string['externalconnectto'] = 'Za prikaz zunanjih značk se morate <a href="{$a}">povezati z nahrbtnikom</a>.';
$string['fixed'] = 'Fiksni rok';
$string['hidden'] = 'Skrito';
$string['hiddenbadge'] = 'Lastnik značke te informacije ni dal na voljo.';
$string['imageauthoremail'] = 'E-poštni naslov avtorja slike';
$string['imageauthoremail_help'] = 'Če je določen, je e-poštni naslov avtorja slike značke prikazan na strani značke.';
$string['imageauthorname'] = 'Ime avtorja slike';
$string['imageauthorname_help'] = 'Če je določeno, je ime avtorja slike značke prikazano na strani značke.';
$string['imageauthorurl'] = 'URL avtorja slike';
$string['imageauthorurl_help'] = 'Če je določena, je povezava do spletne strani avtorja slike značke prikazana na strani značke. URL mora imeti predpono http:// ali https://.';
$string['imagecaption'] = 'Opis slike';
$string['imagecaption_help'] = 'Če je določen, je opis slike prikazan na strani značke.';
$string['invalidurl'] = 'Neveljaven URL';
$string['issuancedetails'] = 'Pretek značke';
$string['issuedbadge'] = 'Informacije izdane značke';
$string['issuerdetails'] = 'Podrobnosti izdajatelja';
$string['issueremail'] = 'E-poštni naslov';
$string['issueremail_help'] = 'Kontaktni e-poštni naslov organizacije, ki je izdala priporočilo.';
$string['issuername'] = 'Ime izdajatelja';
$string['issuername_endorsement'] = 'Ime izdajatelja priporočila';
$string['issuername_endorsement_help'] = 'Ime izdajatelja priporočila.';
$string['issuername_help'] = 'Ime osebe ali organa za podeljevanje.';
$string['issuerurl'] = 'URL izdajatelja';
$string['issuerurl_help'] = 'Spletna stran organizacije, ki je izdala priporočilo. URL mora imeti predpono http:// ali https://.';
$string['language'] = 'Jezik';
$string['language_help'] = 'Jezik na strani značk.';
$string['listbackpacks'] = 'Seznam nahrbtnikov';
$string['localbadges'] = 'Moje značke s spletnega mesta {$a}';
$string['localbadgesh'] = 'Moje značke s tega spletnega mesta';
$string['localbadgesh_help'] = 'Vse značke, pridobljene za zaključene predmete, dejavnosti ali po drugih kriterijih.

Značke lahko upravljate tako, da jih označite kot javne ali zasebne.

Lahko si prenesete vse značke in jih shranite na svoj računalnik.';
$string['localbadgesp'] = 'Značke od {$a}:';
$string['localconnectto'] = 'Če želite deliti te značke zunaj tega spletnega mesta, se morate <a href="{$a}"> povezati z nahrbtnikom</a>.';
$string['makeprivate'] = 'Nastavi zasebno';
$string['makepublic'] = 'Nastavi javno';
$string['managebackpacks'] = 'Upravljaj nahrbtnike';
$string['managebadges'] = 'Upravljanje Značk';
$string['message'] = 'Telo besedila';
$string['messagebody'] = '<p>Pridobili ste značko "%badgename%"!</p>
<p>Več informacij o tej znački lahko najdete na %badgelink% strani z informacijami o znački.</p> <p>Značke lahko upravljate in prenesete z vaše strani {$a}.</p>';
$string['messagesubject'] = 'Čestitke! Pridobili ste značko.';
$string['method'] = 'Kriterij bo izpolnjen, ko ...';
$string['mingrade'] = 'Najnižja zahtevana ocena';
$string['month'] = 'Mesec';
$string['mybackpack'] = 'Nastavitve mojega nahrbtnika';
$string['mybadges'] = 'Moje značke';
$string['never'] = 'Nikoli';
$string['newbadge'] = 'Dodaj značko';
$string['newimage'] = 'Nova slika';
$string['noalignment'] = 'Ta značka nima določenih zunanjih veščin ali standardov.';
$string['noawards'] = 'Te značke si še niste pridobili.';
$string['nobackpack'] = 'S tem računom ni povezane storitve zunanjega nahrbtnika.<br/>';
$string['nobackpackbadgessummary'] = 'V izbranih zbirkah ni značk.';
$string['nobackpackcollectionssummary'] = 'Ni izbranih zbirk značk.';
$string['nobackpacks'] = 'Nahrbtniki niso na voljo';
$string['nobadges'] = 'Trenutno uporabnikom ni na voljo nobena značka.';
$string['nocompetencies'] = 'Ni izbranih kompetenc.';
$string['nocriteria'] = 'Kriterij za to značko še ni bil določen.';
$string['noendorsement'] = 'Ta značka nima priporočila.';
$string['noexpiry'] = 'Ta značka ne poteče.';
$string['noparamstoadd'] = 'Tej zahtevi priznanja ni mogoče dodati dodatnih parametrov.';
$string['norelated'] = 'Ta značka nima sorodnih značk.';
$string['notacceptedrole'] = 'Vaša trenutna vloga ni med vlogami, ki lahko ročno podelijo to značko.<br/>
Če želite videti uporabnike, ki so že pridobili to značko, obiščite stran {$a}.';
$string['notconnected'] = 'Ni povezave';
$string['notealignment'] = 'Značka se lahko uskladi z zunanjimi veščinami ali standardi, ki jih tukaj navedemo. Vse zunanje veščine ali standardi so prikazani na strani značke.';
$string['noteendorsement'] = 'Priporočila tretjih oseb lahko uporabite, da dodate vrednost k značkam. Na primer značko, ki ga je izdal učitelj, lahko priporoči šola, ali značko, ki ga je izdal lokalni dodeljevalni organ, lahko prirporoči državni dodeljevalni organ.';
$string['noterelated'] = 'Značke s povezavo lahko označite kot sorodne. Na primer značke z enakimi kriteriji, ki so prikazana v različnih jezikih, lahko označite kot sorodna. Sorodne značke so prikazana na strani značk.';
$string['nothingtoadd'] = 'Kriteriji za dodajanje niso na voljo.';
$string['notification'] = 'Obvestite ustvarjalca priznanja';
$string['notification_help'] = 'Ta nastavitev ureja obvestila o podeljenih značkah, ki so poslana ustvarjalcu značke.

Na voljo so naslednje možnosti:

* **NIKOLI** – Ne pošiljaj obvestil.

* **VSAKIČ** – Pošlji obvestilo ob vsaki podelitvi značke.

* **DNEVNO** – Pošlji obvestila enkrat na dan.

* **TEDENSKO** – Pošlji obvestila enkrat na teden.

* **MESEČNO** – Pošlji obvestila enkrat na mesec.';
$string['notifydaily'] = 'Dnevno';
$string['notifyevery'] = 'Vsakič';
$string['notifymonthly'] = 'Mesečno';
$string['notifyweekly'] = 'Tedensko';
$string['numawards'] = 'Število uporabnikov, katerim je bila ta značka podeljena: <a href="{$a->link}">{$a->count}</a>';
$string['numawardstat'] = 'Število uporabnikov, katerim je bila ta značka podeljena: {$a}';
$string['overallcrit'] = 'izbranih kriterijev je izpolnjenih.';
$string['potentialrecipients'] = 'Možni prejemniki značke';
$string['preferences'] = 'Nastavitve značk';
$string['privacy:metadata:backpack'] = 'Seznam uporabnikovih nahrbtnikov';
$string['privacy:metadata:backpack:backpackuid'] = 'Enolični identifikator nahrbtnika';
$string['privacy:metadata:backpack:email'] = 'E-naslov, povezan z nahrbtnikom';
$string['privacy:metadata:backpack:externalbackpackid'] = 'ID nahrbtnika';
$string['privacy:metadata:backpack:userid'] = 'ID uporabnika, ki je lastnik nahrbtnika';
$string['privacy:metadata:badge'] = 'Zbirka značk';
$string['privacy:metadata:badge:timecreated'] = 'Čas ustvarjanja značke';
$string['privacy:metadata:badge:timemodified'] = 'Čas zadnje spremembe značke';
$string['privacy:metadata:badge:usercreated'] = 'ID uporabnika, ki je ustvaril značko';
$string['privacy:metadata:badge:usermodified'] = 'ID uporabnika, ki je spremenil značko';
$string['privacy:metadata:criteriamet'] = 'Nabor doseženih kriterijev';
$string['privacy:metadata:criteriamet:datemet'] = 'Datum, ko je bil kriterij dosežen';
$string['privacy:metadata:criteriamet:userid'] = 'ID uporabnika, ki je dosegel kriterij';
$string['privacy:metadata:external:backpacks'] = 'Podatki, ki se delijo, ko uporabnik objavi značke na zunanji album';
$string['privacy:metadata:external:backpacks:badge'] = 'Ime značke';
$string['privacy:metadata:external:backpacks:description'] = 'Opis značke';
$string['privacy:metadata:external:backpacks:image'] = 'Slika značke';
$string['privacy:metadata:external:backpacks:issuer'] = 'Nekaj informacij o izdajatelju';
$string['privacy:metadata:external:backpacks:url'] = 'Moodle URL, kjer so vidne informacije o izdani znački';
$string['privacy:metadata:issued'] = 'Seznam dodeljenih značk';
$string['privacy:metadata:issued:dateexpire'] = 'Datum poteka veljavnosti značke';
$string['privacy:metadata:issued:dateissued'] = 'Datum podelitve';
$string['privacy:metadata:issued:userid'] = 'ID uporabnika, ki je pridobil značko';
$string['privacy:metadata:manualaward'] = 'Seznam ročnih podelitev';
$string['privacy:metadata:manualaward:datemet'] = 'Datum podelitve značke uporabniku';
$string['privacy:metadata:manualaward:issuerid'] = 'ID uporabnika, ki je podelil značko';
$string['privacy:metadata:manualaward:issuerrole'] = 'Vloga uporabnika, ki je podelil značko';
$string['privacy:metadata:manualaward:recipientid'] = 'ID uporabnika, ki mu je ročno podeljena značka';
$string['recipients'] = 'Prejemniki značk';
$string['recipientvalidationproblem'] = 'Tega uporabnika ni mogoče preveriti kot prejemnika te značke.';
$string['relatedbages'] = 'Sorodne značke';
$string['relative'] = 'Relativen rok';
$string['requiredbadge'] = 'Vsaj ena značka bi morala biti dodana h kriterijem.';
$string['requiredcohort'] = 'Vsaj ena kohorta bi morala biti dodana h kriteriju.';
$string['requiredcompetency'] = 'Vsaj ena kompetenca bi morala biti dodana h kriteriju.';
$string['requiredcourse'] = 'Vsaj en predmet bi moral biti dodan h kriteriju.';
$string['reviewbadge'] = 'Spremembe v dostopu do značke';
$string['reviewconfirm'] = '<p>S tem bo vaša značka postala vidna uporabnikom, kar jim bo omogočilo, da jo pridobijo.</p>

<p>Možno je, da izbrani uporabniki že izpolnjujejo kriterije značke, zato jo bodo lahko pridobili takoj, ko jo omogočite.</p>

<p>Takoj ko je značka prvič izdana, bo <strong>zaklenjena</strong> – nekaterih nastavitev, vključno s kriteriji in nastavitvami poteka veljavnosti, ne bo več mogoče spremeniti.</p>

<p>Ste prepričani, da želite omogočiti dostop do značke \'{$a}\'?</p>';
$string['revoke'] = 'Razveljavi značko';
$string['save'] = 'Shrani';
$string['searchname'] = 'Išči po imenu';
$string['selectaward'] = 'Izberite vlogo, ki jo želite uporabiti za podelitev tega priznanja:';
$string['selectgroup_end'] = 'Prikazane so samo javne zbirke. <a href="{$a}">Obiščite svoj nahrbtnik</a>, da ustvarite več javnih zbirk.';
$string['selectgroup_start'] = 'Izberite zbirke iz svojega nahrbtnika za prikaz na tem spletnem mestu:';
$string['selecting'] = 'Z izbranimi znački ...';
$string['setup'] = 'Nastavitev povezave';
$string['sitebadges'] = 'Značke spletnega mesta';
$string['sitebadges_help'] = 'Značke spletnega mesta je mogoče podeliti uporabnikom zgolj za aktivnosti, povezane s spletnim mestom. To vključuje zaključek sklopa predmetov ali delov uporabniških profilov. Značke spletnega mesta lahko tudi ročno podeli uporabnik z izbrano vlogo. Značke za aktivnosti, povezane s predmetom, morajo biti ustvarjene na ravni predmeta. Značke predmeta je mogoče najti v bloku Nastavitve > Značke.';
$string['status'] = 'Stanje priznanja';
$string['status_help'] = 'Stanje značke določa njeno vedenje v sistemu:

* **NA VOLJO** – Pomeni, da uporabniki lahko pridobijo to značko. Ko je značka na voljo uporabnikom, njenih kriterijev ni mogoče spreminjati. *

**NI NA VOLJO** – Pomeni, da značka ni na voljo uporabnikom in da je uporabniki ne morejo pridobiti oz. je ni mogoče ročno podeliti. Če taka značka še ni bila podeljena, je še mogoče spremeniti njene kriterije.

Ko je značka podeljena vsaj enemu uporabniku, je samodejno **ZAKLENJENA** – Zaklenjeno značko lahko uporabniki še vedno pridobijo, vendar kriterijev ni več mogoče spremeniti. Če želite spremeniti podrobnosti ali kriterije zaklenjene značke, lahko kopirate značko in vnesete želene spremembe.

*Zakaj se značka zaklene?*

Tako se zagotovi, da imajo vsi uporabniki iste kriterije za pridobitev določene značke. Trenutno ni mogoče odvzeti značke. Če bi omogočili prosto spreminjanje značk, bi najverjetneje skupina uporabnikov za isto značko lahko izpolnjevala povsem različne zahteve.';
$string['statusmessage_0'] = 'Ta značka trenutno ni na voljo uporabnikom. Omogočite dostop, če želite uporabnikom dovoliti pridobitev značke.';
$string['statusmessage_1'] = 'Ta značka je trenutno na voljo uporabnikom. Za vnašanje sprememb najprej onemogočite dostop.';
$string['statusmessage_2'] = 'To priznanje trenutno ni na voljo uporabnikom, njeni kriteriji pa so zaklenjeni. Omogočite dostop, če želite uporabnikom dovoliti pridobitev tega priznanja.';
$string['statusmessage_3'] = 'To priznanje je trenutno na voljo uporabnikom, njegovi kriteriji pa so zaklenjeni.';
$string['statusmessage_4'] = 'To priznanje je trenutno arhivirano.';
$string['subject'] = 'Zadeva sporočila';
$string['targetcode'] = 'Koda';
$string['targetcode_help'] = 'Enoličen identifikator reference zunanje veščine ali standarda v okviru.';
$string['targetdescription'] = 'Opis';
$string['targetdescription_help'] = 'Kratek opis zunanje veščine ali standarda.';
$string['targetframework'] = 'Okvir';
$string['targetframework_help'] = 'Ime okvira zunanje veščine ali standarda.';
$string['targetname'] = 'Ime';
$string['targetname_help'] = 'Zunanja veščina ali standard, s katerim je značka usklajena.';
$string['targeturl'] = 'URL';
$string['targeturl_help'] = 'Povezava do strani, ki opisuje zunanjo veščino ali standard. URL mora imeti predpono http:// ali https://.';
$string['type'] = 'Vrsta';
$string['variablesubstitution'] = 'Nadomestitev spremenljivk v sporočilu.';
$string['variablesubstitution_help'] = 'V sporočilu značke je mogoče v zadevi oz. vsebini sporočila vstaviti spremenljivke, ki se nato pri pošiljanju sporočila nadomestijo z resničnimi vrednostmi. Spremenljivke je treba v besedilo vstaviti natanko tako, kot je prikazano spodaj. Na voljo so naslednje spremenljivke:

%badgename%
: Ta bo nadomeščena s polnim imenom značke.

%username%
: Ta bo nadomeščena s polnim imenom prejemnika.

%badgelink%
: Ta bo nadomeščena z javnim URL s podatki o podeljeni znački.';
$string['version'] = 'Različica';
$string['version_help'] = 'Polje različice se lahko uporabi za sledenje napredka značke. Če je določena, je verzija prikazana na strani značk.';
$string['viewbadge'] = 'Prikaži izdano značko';
$string['visible'] = 'Vidno';
$string['warnexpired'] = '(Ta značka je potekla.)';
$string['year'] = 'Leta';
