<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_oauth2', language 'sl', version '4.4'.
 *
 * @package     tool_oauth2
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['authconfirm'] = 'To dejanje bo računu s preverjeno pristnostjo odobrilo trajen dostop aplikacijskega programskega vmesnika do Moodla. Dejanje bomo uporabljali kot sistemski račun za opravljanje datotek, ki so v lasti Moodla.';
$string['authconnected'] = 'Sistemski račun je sedaj povezan z omrežjem brez povezave.';
$string['authnotconnected'] = 'Sistemski račun ni bil povezan z omrežjem brez povezave.';
$string['configured'] = 'Konfigurirano';
$string['configuredstatus'] = 'Konfigurirano';
$string['connectsystemaccount'] = 'Poveži s sistemskim računom';
$string['createfromtemplate'] = 'Ustvari storitev Oauth 2 iz predloge';
$string['createfromtemplatedesc'] = 'Če želite za eno izmed znanih vrst storitev ustvariti storitev OAuth z veljavno konfiguracijo, izberite eno izmed spodnjih predlog za storitev Oauth 2. S tem boste ustvarili storitev Oauth 2 s pravilnimi končnimi točkami in parametri, ki so potrebni za preverjanje pristnosti, pred uporabo nove storitve pa boste vseeno morali vnesti ID odjemalca in skrivni ključ.';
$string['createnewendpoint'] = 'Ustvari novo končno točko za izdajatelja »{$a}«.';
$string['createnewuserfieldmapping'] = 'Ustvari novo preslikavo uporabniškega polja za izdajatelja »{$a}«.';
$string['deleteconfirm'] = 'Ali ste prepričani, da želite izbrisati izdajatelja identitete »{$a}«? Vsi vtičniki, ki delujejo s pomočjo tega izdajatelja, bodo prenehali delovati.';
$string['deleteendpointconfirm'] = 'Ali ste prepričani, da želite izbrisati končno točko »{$a->endpoint}« za izdajatelja »{$a->issuer}«? Vsi vtičniki, ki delujejo s pomočjo te končne točke, bodo prenehali delovati.';
$string['deleteuserfieldmappingconfirm'] = 'Ali ste prepričani, da želite izbrisati preslikavo uporabniškega polja za izdajatelja »{$a}«?';
$string['discovered'] = 'Odkrivanje storitve je neuspešno';
$string['discovered_help'] = 'Odkrivanje pomeni, da  so končne točke samodejno določijo iz baze URL za storitev OAuth 2. »Odkritje« vseh storitev ni nujno, a če se to ne bo zgodilo boste morali končne točke in informacije o preslikavah vnesti ročno.';
$string['discoverystatus'] = 'Odkritje';
$string['editendpoint'] = 'Uredi končno točko: {$a->endpoint} za izdajatelja {$a->issuer}';
$string['editendpoints'] = 'Konfiguriraj končne točke';
$string['editissuer'] = 'Uredi izdajatelja identitete';
$string['edituserfieldmapping'] = 'Ustvari novo preslikavo uporabniškega polja za izdajatelja »{$a}«.';
$string['edituserfieldmappings'] = 'Konfiguriraj preslikavo uporabniškega polja';
$string['endpointdeleted'] = 'Končna točka izbrisana';
$string['endpointname'] = 'Ime';
$string['endpointname_help'] = 'Ključ, ki se uporablja za iskanje te končne točke. Končati se mora z »_endpoint«.';
$string['endpointsforissuer'] = 'Končna točka za izdajatelja: »{$a}«';
$string['endpointurl'] = 'URL';
$string['endpointurl_help'] = 'URL za to končno točko. Mora uporabljati protokol https:// .';
$string['issueralloweddomains'] = 'Prijavne domene';
$string['issueralloweddomains_help'] = 'Če jo nastavite, se bo ta nastavitev spreemenila v seznam domen v obliki CSV, na katerega bodo omejene prijave, ko bodo uporabljale storitve ponudnika.';
$string['issueralloweddomains_link'] = 'OAuth_2_login_domains';
$string['issuerbaseurl'] = 'Storitvena baza URL';
$string['issuerbaseurl_help'] = 'Baza URL za dostop do storitve';
$string['issuerclientid'] = 'ID odjemalca';
$string['issuerclientid_help'] = 'OAuth ID odjemalca za izdajatelja';
$string['issuerclientsecret'] = 'Skrivni ključ uporabnika';
$string['issuerclientsecret_help'] = 'OAuth Skrivni ključ odjemalca za izdajatelja';
$string['issuerdeleted'] = 'Izdajatelj identitete izbrisan';
$string['issuerdisabled'] = 'Izdajatelj identitete onemogočen';
$string['issuerenabled'] = 'Izdajatelj identitete omogočen';
$string['issuerimage'] = 'URL logotipa';
$string['issuerimage_help'] = 'Slikovni URL, ki se uporablja za prikaz loga izdajatelja. Lahko se prikaže na prijavni strani.';
$string['issuerloginparams'] = 'Dodatni parametri, ki so vključeni v prošnjo za prijavo';
$string['issuerloginparams_help'] = 'Za branje osnovnega uporabnikovega profila nekateri sistemi zahtevajo dodatne parametre za prošnjo za prijavo.';
$string['issuerloginparamsoffline'] = 'Dodatni parametri, ki so vključeni v prošnjo za prijavo za dostop do omrežja brez povezave.';
$string['issuerloginparamsoffline_help'] = 'Vsak sistem Oauth način, na katerega lahko dostopamo do omrežja brez povezave, opredeli drugače. Primer: Google zahteva dodatne parametre: »access_type=offline&prompt=consent«. Ti parametri morajo biti v formatu poizvedbenega parametra URL-a.';
$string['issuerloginscopes'] = 'Možnosti, ki so vključene v prošnjo za prijavo.';
$string['issuerloginscopes_help'] = 'Za branje osnovnega uporabnikovega profila nekateri sistemi zahtevajo dodatne možnosti za prošnjo za prijavo. Običajne možnosti za sistem, ki je skladen z OpenID Connect so »openid profile email«.';
$string['issuerloginscopesoffline'] = 'Možnosti, ki so vključene v prošnjo za prijavo za dostop do omrežja brez povezave.';
$string['issuerloginscopesoffline_help'] = 'Vsak sistem Oauth način, na katerega lahko dostopamo do omrežja brez povezave, opredeli drugače. Primer: Microsoft zahteva dodatno možnost »offline_access«.';
$string['issuername'] = 'Ime';
$string['issuername_help'] = 'Ime izdajatelja identitete. Lahko se prikaže na prijavni strani.';
$string['issuerrequireconfirmation'] = 'Zahtevaj prevejanje elektronskega naslova';
$string['issuerrequireconfirmation_help'] = 'Zahtevajte, da pred prijavo z Oauthom vsi uporabniki preverjijo svoj elektronski naslov. To je del vpisnega proces za nedavno ustvarjene račune, velja pa tudi v primeru, ko je obstoječ račun na Moodlu preko ustreznega elektronskega naslova povezan z vpisom v Oauth.';
$string['issuers'] = 'Izdajatelji';
$string['issuersetup'] = 'Podrobna navodila za konfiguriranje skupnih storitev OAuth 2';
$string['issuersetuptype'] = 'Podrobna navodila za vzpostavitev ponudnika {$a} OAuth 2';
$string['issuershowonloginpage'] = 'Prikaži na prijavni strani';
$string['issuershowonloginpage_help'] = 'Če je vtičnik za preverjanje pristnosti Oauth 2 omogočen, izdajatelj prijave naveden na prijavni strani, uporabniki pa se bodo lahko vpisali z računi izdajatelja.';
$string['loginissuer'] = 'Dovoli prijavo';
$string['notconfigured'] = 'Ni konfigurirano';
$string['notdiscovered'] = 'Odkrivanje storitve je neuspešno';
$string['notloginissuer'] = 'Ne dovoli prijave';
$string['pluginname'] = 'Storitve OAuth 2';
$string['privacy:metadata'] = 'Vtičnik storitev OAuth 2 ne shranjuje osebnih podatkov.';
$string['savechanges'] = 'Shrani spremembe';
$string['serviceshelp'] = 'Navodila za namestitev ponudnika storitve';
$string['systemaccountconnected'] = 'Sistemski račun je povezan';
$string['systemaccountconnected_help'] = 'Sistemske račune uporabljamo za zagotavljanje napredne funkcionalnosti za vtičnike. Ne zahteva se jih zgolj za funkcionalnost prijave, vendar se lahko zgodi, da drugi vtičniki, ki uporabljajo storitev Oauth, ne bodo vsebovali vseh lastnosti, če sistemski račun ne bo povezan. Na primer, skladišča brez sistemskega računa, ki izvaja operacije nad datotekami, ne morejo podpirati »nadzorovanih povezav«.';
$string['systemaccountnotconnected'] = 'Sistemski račun ni povezan';
$string['systemauthstatus'] = 'Sistemski račun je povezan';
$string['usebasicauth'] = 'Zahtevani so žetoni za glave HTTP';
$string['usebasicauth_help'] = 'Ko pošiljate ID odjemalca in geslo z osveženo zahtevo po žetonu, uporabljajte osnovno HTTP shemo za preverjanje pristnosti. To priporoča standard OAuth 2, vendar se lahko zgodi, da nekateri izdajatelji te možnosti ne ponujajo.';
$string['userfieldexternalfield'] = 'Ime zunanjega polja';
$string['userfieldexternalfield_error'] = 'To polje ne more vsebovati HTML-ja.';
$string['userfieldexternalfield_help'] = 'Ime polja, ki ga ponuja zunanji sistem OAuth.';
$string['userfieldinternalfield'] = 'Ime notranjega polja';
$string['userfieldinternalfield_help'] = 'Ime uporabniškega polja v Moodlo, ki se ga mora preslikati iz zunanjega polja.';
$string['userfieldmappingdeleted'] = 'Preslikava uporabniškega polja je izbrisana';
$string['userfieldmappingsforissuer'] = 'Preslikava uporabniškega polja za izdajatelja »{$a}«';
